/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rssinput;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rssinput.Messages;
import org.pentaho.di.trans.steps.rssinput.RssInput;
import org.pentaho.di.trans.steps.rssinput.RssInputData;
import org.pentaho.di.trans.steps.rssinput.RssInputField;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private boolean includeRowNumber;
    private String rowNumberField;
    private boolean includeUrl;
    private String urlField;
    private long rowLimit;
    private RssInputField[] inputFields;
    private String[] url;
    private String readfrom;
    private boolean urlInField;
    private String urlFieldname;

    public RssInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(RssInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public boolean urlInField() {
        return this.urlInField;
    }

    public void seturlInField(boolean urlInFieldin) {
        this.urlInField = urlInFieldin;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setReadFrom(String readfrom) {
        this.readfrom = readfrom;
    }

    public String getReadFrom() {
        return this.readfrom;
    }

    public String getRealReadFrom() {
        return this.getReadFrom();
    }

    public boolean includeUrl() {
        return this.includeUrl;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public void setIncludeUrl(boolean includeUrl) {
        this.includeUrl = includeUrl;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public String geturlField() {
        return this.urlField;
    }

    public void seturlField(String urlField) {
        this.urlField = urlField;
    }

    public void setUrlFieldname(String urlFieldname) {
        this.urlFieldname = urlFieldname;
    }

    public String getUrlFieldname() {
        return this.urlFieldname;
    }

    public void setUrl(String[] url) {
        this.url = url;
    }

    public String[] getUrl() {
        return this.url;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        int i;
        RssInputMeta retval = (RssInputMeta)super.clone();
        int nrFields = this.inputFields.length;
        int nrUrl = this.url.length;
        retval.allocate(nrUrl, nrFields);
        for (i = 0; i < nrUrl; ++i) {
            retval.url[i] = this.url[i];
        }
        for (i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (RssInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"url_in_field", (boolean)this.urlInField));
        retval.append("    " + XMLHandler.addTagValue((String)"url_field_name", (String)this.urlFieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    " + XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    " + XMLHandler.addTagValue((String)"include_url", (boolean)this.includeUrl));
        retval.append("    " + XMLHandler.addTagValue((String)"url_Field", (String)this.urlField));
        retval.append("    " + XMLHandler.addTagValue((String)"read_from", (String)this.readfrom));
        retval.append("    <urls>" + Const.CR);
        for (i = 0; i < this.url.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)"url", (String)this.url[i]));
        }
        retval.append("    </urls>" + Const.CR);
        retval.append("    <fields>" + Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            RssInputField field = this.inputFields[i];
            retval.append(field.getXML());
        }
        retval.append("      </fields>" + Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            this.urlInField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"url_in_field"));
            this.urlFieldname = XMLHandler.getTagValue((Node)stepnode, (String)"url_field_name");
            this.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.includeUrl = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_url"));
            this.urlField = XMLHandler.getTagValue((Node)stepnode, (String)"url_Field");
            this.readfrom = XMLHandler.getTagValue((Node)stepnode, (String)"read_from");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            Node urlnode = XMLHandler.getSubNode((Node)stepnode, (String)"urls");
            int nrUrls = XMLHandler.countNodes((Node)urlnode, (String)"url");
            this.allocate(nrUrls, nrFields);
            for (i = 0; i < nrUrls; ++i) {
                Node urlnamenode = XMLHandler.getSubNodeByNr((Node)urlnode, (String)"url", (int)i);
                this.url[i] = XMLHandler.getNodeValue((Node)urlnamenode);
            }
            for (i = 0; i < nrFields; ++i) {
                RssInputField field;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new RssInputField(fnode);
            }
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrUrl, int nrfields) {
        this.inputFields = new RssInputField[nrfields];
        this.url = new String[nrUrl];
    }

    @Override
    public void setDefault() {
        int i;
        this.urlInField = false;
        this.urlFieldname = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.includeUrl = false;
        this.urlField = "";
        this.readfrom = "";
        int nrFields = 0;
        int nrUrl = 0;
        this.allocate(nrUrl, nrFields);
        for (i = 0; i < nrUrl; ++i) {
            this.url[i] = "";
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new RssInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta v;
        for (int i = 0; i < this.inputFields.length; ++i) {
            RssInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            ValueMeta v2 = new ValueMeta(space.environmentSubstitute(field.getName()), type);
            v2.setLength(field.getLength(), field.getPrecision());
            v2.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v2);
        }
        if (this.includeUrl) {
            v = new ValueMeta(space.environmentSubstitute(this.urlField), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber) {
            v = new ValueMeta(space.environmentSubstitute(this.rowNumberField), 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            this.urlInField = rep.getStepAttributeBoolean(id_step, "url_in_field");
            this.urlFieldname = rep.getStepAttributeString(id_step, "url_field_name");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.includeUrl = rep.getStepAttributeBoolean(id_step, "include_url");
            this.urlField = rep.getStepAttributeString(id_step, "url_Field");
            this.readfrom = rep.getStepAttributeString(id_step, "read_from");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            int nrUrls = rep.countNrStepAttributes(id_step, "url_name");
            this.allocate(nrUrls, nrFields);
            for (i = 0; i < nrUrls; ++i) {
                this.url[i] = rep.getStepAttributeString(id_step, i, "url_name");
            }
            for (i = 0; i < nrFields; ++i) {
                RssInputField field = new RssInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setColumn(RssInputField.getColumnByCode(rep.getStepAttributeString(id_step, i, "field_column")));
                field.setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(RssInputField.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("RssInputMeta.Exception.ErrorReadingRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "url_in_field", this.urlInField);
            rep.saveStepAttribute(id_transformation, id_step, "url_field_name", this.urlFieldname);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "include_url", this.includeUrl);
            rep.saveStepAttribute(id_transformation, id_step, "url_Field", this.urlField);
            rep.saveStepAttribute(id_transformation, id_step, "read_from", this.readfrom);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            for (i = 0; i < this.url.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "url_name", this.url[i]);
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                RssInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_column", field.getColumnCode());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_repeat", field.isRepeated());
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("RssInputMeta.Exception.ErrorSavingToRepository", "" + id_step), (Throwable)e);
        }
    }

    @Override
    public StepDataInterface getStepData() {
        return new RssInputData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (this.urlInField) {
            if (Const.isEmpty((String)this.getUrlFieldname())) {
                CheckResult cr = new CheckResult(4, Messages.getString("RssInputMeta.CheckResult.NoField"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                CheckResult cr = new CheckResult(1, Messages.getString("RssInputMeta.CheckResult.FieldOk"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else if (this.getUrl() == null || this.getUrl().length == 0) {
            CheckResult cr = new CheckResult(4, Messages.getString("RssInputMeta.CheckResult.NoUrl"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(1, Messages.getString("RssInputMeta.CheckResult.UrlOk", "" + this.getUrl().length), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new RssInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }
}

