/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mergerows;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleRowException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mergerows.MergeRowsData;
import org.pentaho.di.trans.steps.mergerows.MergeRowsMeta;
import org.pentaho.di.trans.steps.mergerows.Messages;

public class MergeRows
extends BaseStep
implements StepInterface {
    private static final String VALUE_IDENTICAL = "identical";
    private static final String VALUE_CHANGED = "changed";
    private static final String VALUE_NEW = "new";
    private static final String VALUE_DELETED = "deleted";
    private MergeRowsMeta meta;
    private MergeRowsData data;

    public MergeRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        int outputIndex;
        Object[] outputRow;
        this.meta = (MergeRowsMeta)smi;
        this.data = (MergeRowsData)sdi;
        if (this.first) {
            int i;
            this.first = false;
            this.data.oneRowSet = this.findInputRowSet(this.meta.getReferenceStepName());
            this.data.twoRowSet = this.findInputRowSet(this.meta.getCompareStepName());
            this.data.one = this.getRowFrom(this.data.oneRowSet);
            this.data.two = this.getRowFrom(this.data.twoRowSet);
            try {
                this.checkInputLayoutValid(this.data.oneRowSet.getRowMeta(), this.data.twoRowSet.getRowMeta());
            }
            catch (KettleRowException e) {
                throw new KettleException(Messages.getString("MergeRows.Exception.InvalidLayoutDetected"), (Throwable)e);
            }
            if (this.data.one != null) {
                this.data.keyNrs = new int[this.meta.getKeyFields().length];
                for (i = 0; i < this.data.keyNrs.length; ++i) {
                    this.data.keyNrs[i] = this.data.oneRowSet.getRowMeta().indexOfValue(this.meta.getKeyFields()[i]);
                    if (this.data.keyNrs[i] >= 0) continue;
                    String message = Messages.getString("MergeRows.Exception.UnableToFindFieldInReferenceStream", this.meta.getKeyFields()[i]);
                    this.logError(message);
                    throw new KettleStepException(message);
                }
            }
            if (this.data.two != null) {
                this.data.valueNrs = new int[this.meta.getValueFields().length];
                for (i = 0; i < this.data.valueNrs.length; ++i) {
                    this.data.valueNrs[i] = this.data.twoRowSet.getRowMeta().indexOfValue(this.meta.getValueFields()[i]);
                    if (this.data.valueNrs[i] >= 0) continue;
                    String message = Messages.getString("MergeRows.Exception.UnableToFindFieldInReferenceStream", this.meta.getValueFields()[i]);
                    this.logError(message);
                    throw new KettleStepException(message);
                }
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(Messages.getString("MergeRows.Log.DataInfo", this.data.one + "") + this.data.two);
        }
        if (this.data.one == null && this.data.two == null) {
            this.setOutputDone();
            return false;
        }
        if (this.data.outputRowMeta == null) {
            this.data.outputRowMeta = new RowMeta();
            if (this.data.one != null) {
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), new RowMetaInterface[]{this.data.oneRowSet.getRowMeta()}, null, this);
            } else {
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), new RowMetaInterface[]{this.data.twoRowSet.getRowMeta()}, null, this);
            }
        }
        String flagField = null;
        if (this.data.one == null && this.data.two != null) {
            outputRow = this.data.two;
            outputIndex = this.data.twoRowSet.getRowMeta().size();
            flagField = VALUE_NEW;
            this.data.two = this.getRowFrom(this.data.twoRowSet);
        } else if (this.data.one != null && this.data.two == null) {
            outputRow = this.data.one;
            outputIndex = this.data.oneRowSet.getRowMeta().size();
            flagField = VALUE_DELETED;
            this.data.one = this.getRowFrom(this.data.oneRowSet);
        } else {
            int compare = this.data.oneRowSet.getRowMeta().compare(this.data.one, this.data.two, this.data.keyNrs);
            if (compare == 0) {
                int compareValues = this.data.oneRowSet.getRowMeta().compare(this.data.one, this.data.two, this.data.valueNrs);
                if (compareValues == 0) {
                    outputRow = this.data.one;
                    outputIndex = this.data.oneRowSet.getRowMeta().size();
                    flagField = VALUE_IDENTICAL;
                } else {
                    outputRow = this.data.two;
                    outputIndex = this.data.twoRowSet.getRowMeta().size();
                    flagField = VALUE_CHANGED;
                }
                this.data.one = this.getRowFrom(this.data.oneRowSet);
                this.data.two = this.getRowFrom(this.data.twoRowSet);
            } else if (compare < 0) {
                outputRow = this.data.one;
                outputIndex = this.data.oneRowSet.getRowMeta().size();
                flagField = VALUE_DELETED;
                this.data.one = this.getRowFrom(this.data.oneRowSet);
            } else {
                outputRow = this.data.two;
                outputIndex = this.data.twoRowSet.getRowMeta().size();
                flagField = VALUE_NEW;
                this.data.two = this.getRowFrom(this.data.twoRowSet);
            }
        }
        this.putRow(this.data.outputRowMeta, RowDataUtil.addValueData((Object[])outputRow, (int)outputIndex, (Object)flagField));
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("MergeRows.LineNumber") + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MergeRowsMeta)smi;
        this.data = (MergeRowsData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.getReferenceStepName() != null ^ this.meta.getCompareStepName() != null) {
                this.logError(Messages.getString("MergeRows.Log.BothTrueAndFalseNeeded"));
            } else {
                return true;
            }
        }
        return false;
    }

    protected void checkInputLayoutValid(RowMetaInterface referenceRowMeta, RowMetaInterface compareRowMeta) throws KettleRowException {
        if (referenceRowMeta != null && compareRowMeta != null) {
            BaseStep.safeModeChecking(referenceRowMeta, compareRowMeta);
        }
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

