/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.shell;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.log4j.Appender;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.Log4jFileAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.StreamLogger;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.shell.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryShell
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String filename;
    private String workDirectory;
    public String[] arguments;
    public boolean argFromPrevious;
    public boolean setLogfile;
    public String logfile;
    public String logext;
    public boolean addDate;
    public boolean addTime;
    public int loglevel;
    public boolean execPerRow;
    public boolean setAppendLogfile;
    public boolean insertScript;
    public String script;

    public JobEntryShell(String name) {
        super(name, "");
        this.setJobEntryType(JobEntryType.SHELL);
    }

    public JobEntryShell() {
        this("");
        this.clear();
    }

    public JobEntryShell(JobEntryBase jeb) {
        super(jeb);
        this.setJobEntryType(JobEntryType.SHELL);
    }

    @Override
    public Object clone() {
        JobEntryShell je = (JobEntryShell)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"work_directory", (String)this.workDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"exec_per_row", (boolean)this.execPerRow));
        retval.append("      ").append(XMLHandler.addTagValue((String)"set_logfile", (boolean)this.setLogfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logfile", (String)this.logfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"set_append_logfile", (boolean)this.setAppendLogfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logext", (String)this.logext));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.addDate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.addTime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"insertScript", (boolean)this.insertScript));
        retval.append("      ").append(XMLHandler.addTagValue((String)"script", (String)this.script));
        retval.append("      ").append(XMLHandler.addTagValue((String)"loglevel", (String)LogWriter.getLogLevelDesc((int)this.loglevel)));
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("      ").append(XMLHandler.addTagValue((String)("argument" + i), (String)this.arguments[i]));
            }
        }
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.setFileName(XMLHandler.getTagValue((Node)entrynode, (String)"filename"));
            this.setWorkDirectory(XMLHandler.getTagValue((Node)entrynode, (String)"work_directory"));
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.execPerRow = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"exec_per_row"));
            this.setLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"set_logfile"));
            this.setAppendLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"set_append_logfile"));
            this.addDate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.addTime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.logfile = XMLHandler.getTagValue((Node)entrynode, (String)"logfile");
            this.logext = XMLHandler.getTagValue((Node)entrynode, (String)"logext");
            this.loglevel = LogWriter.getLogLevel((String)XMLHandler.getTagValue((Node)entrynode, (String)"loglevel"));
            this.insertScript = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"insertScript"));
            this.script = XMLHandler.getTagValue((Node)entrynode, (String)"script");
            int argnr = 0;
            while (XMLHandler.getTagValue((Node)entrynode, (String)("argument" + argnr)) != null) {
                ++argnr;
            }
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = XMLHandler.getTagValue((Node)entrynode, (String)("argument" + a));
            }
        }
        catch (KettleException e) {
            throw new KettleXMLException("Unable to load job entry of type 'shell' from XML node", (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.setFileName(rep.getJobEntryAttributeString(id_jobentry, "file_name"));
            this.setWorkDirectory(rep.getJobEntryAttributeString(id_jobentry, "work_directory"));
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.execPerRow = rep.getJobEntryAttributeBoolean(id_jobentry, "exec_per_row");
            this.setLogfile = rep.getJobEntryAttributeBoolean(id_jobentry, "set_logfile");
            this.setAppendLogfile = rep.getJobEntryAttributeBoolean(id_jobentry, "set_append_logfile");
            this.addDate = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.addTime = rep.getJobEntryAttributeBoolean(id_jobentry, "add_time");
            this.logfile = rep.getJobEntryAttributeString(id_jobentry, "logfile");
            this.logext = rep.getJobEntryAttributeString(id_jobentry, "logext");
            this.loglevel = LogWriter.getLogLevel((String)rep.getJobEntryAttributeString(id_jobentry, "loglevel"));
            this.insertScript = rep.getJobEntryAttributeBoolean(id_jobentry, "insertScript");
            this.script = rep.getJobEntryAttributeString(id_jobentry, "script");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "argument");
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "argument");
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'shell' from the repository with id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "file_name", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "work_directory", this.workDirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getID(), "exec_per_row", this.execPerRow);
            rep.saveJobEntryAttribute(id_job, this.getID(), "set_logfile", this.setLogfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "set_append_logfile", this.setAppendLogfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_date", this.addDate);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_time", this.addTime);
            rep.saveJobEntryAttribute(id_job, this.getID(), "logfile", this.logfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "logext", this.logext);
            rep.saveJobEntryAttribute(id_job, this.getID(), "loglevel", LogWriter.getLogLevelDesc((int)this.loglevel));
            rep.saveJobEntryAttribute(id_job, this.getID(), "insertScript", this.insertScript);
            rep.saveJobEntryAttribute(id_job, this.getID(), "script", this.script);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "argument", this.arguments[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'shell' to the repository", (Throwable)dbe);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.filename = null;
        this.workDirectory = null;
        this.arguments = null;
        this.argFromPrevious = false;
        this.addDate = false;
        this.addTime = false;
        this.logfile = null;
        this.logext = null;
        this.setLogfile = false;
        this.execPerRow = false;
        this.setAppendLogfile = false;
        this.insertScript = false;
        this.script = null;
    }

    public void setFileName(String n) {
        this.filename = n;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    public void setWorkDirectory(String n) {
        this.workDirectory = n;
    }

    public String getWorkDirectory() {
        return this.workDirectory;
    }

    public void setScript(String scriptin) {
        this.script = scriptin;
    }

    public String getScript() {
        return this.script;
    }

    public String getLogFilename() {
        String retval = "";
        if (this.setLogfile) {
            SimpleDateFormat sdf;
            retval = retval + this.logfile;
            Calendar cal = Calendar.getInstance();
            if (this.addDate) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.addTime) {
                sdf = new SimpleDateFormat("HHmmss");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.logext != null && this.logext.length() > 0) {
                retval = retval + "." + this.logext;
            }
        }
        return retval;
    }

    @Override
    public Result execute(Result result, int nr, Repository rep, Job parentJob) throws KettleException {
        LogWriter log = LogWriter.getInstance();
        Log4jFileAppender appender = null;
        int backupLogLevel = log.getLogLevel();
        if (this.setLogfile) {
            try {
                appender = LogWriter.createFileAppender((String)this.environmentSubstitute(this.getLogFilename()), (boolean)true, (boolean)this.setAppendLogfile);
            }
            catch (KettleException e) {
                log.logError(this.toString(), Messages.getString("JobEntryShell.Error.UnableopenAppenderFile", this.getLogFilename(), e.toString()), new Object[0]);
                log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            log.addAppender((Appender)appender);
            log.setLogLevel(this.loglevel);
        }
        result.setEntryNr((long)nr);
        String[] substArgs = null;
        if (this.arguments != null) {
            substArgs = new String[this.arguments.length];
            for (int idx = 0; idx < this.arguments.length; ++idx) {
                substArgs[idx] = this.environmentSubstitute(this.arguments[idx]);
            }
        }
        int iteration = 0;
        String[] args = substArgs;
        RowMetaAndData resultRow = null;
        boolean first = true;
        ArrayList<RowMetaAndData> rows = result.getRows();
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobEntryShell.Log.FoundPreviousRows", "" + (rows != null ? rows.size() : 0)), new Object[0]);
        }
        while (first && !this.execPerRow || this.execPerRow && rows != null && iteration < rows.size() && result.getNrErrors() == 0L) {
            int i;
            first = false;
            resultRow = rows != null && this.execPerRow ? (RowMetaAndData)rows.get(iteration) : null;
            ArrayList<RowMetaAndData> cmdRows = null;
            if (this.execPerRow) {
                if (this.argFromPrevious) {
                    if (resultRow != null) {
                        args = new String[resultRow.size()];
                        for (i = 0; i < resultRow.size(); ++i) {
                            args[i] = resultRow.getString(i, null);
                        }
                    }
                } else {
                    ArrayList<RowMetaAndData> newList = new ArrayList<RowMetaAndData>();
                    newList.add(resultRow);
                    cmdRows = newList;
                }
            } else if (this.argFromPrevious) {
                args = null;
                if (resultRow != null) {
                    args = new String[resultRow.size()];
                    for (i = 0; i < resultRow.size(); ++i) {
                        args[i] = resultRow.getString(i, null);
                    }
                } else {
                    cmdRows = rows;
                }
            } else {
                cmdRows = rows;
            }
            this.executeShell(result, (List<RowMetaAndData>)cmdRows, args);
            ++iteration;
        }
        if (this.setLogfile) {
            if (appender != null) {
                log.removeAppender((Appender)appender);
                appender.close();
            }
            log.setLogLevel(backupLogLevel);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void executeShell(Result result, List<RowMetaAndData> cmdRows, String[] args) {
        block58: {
            log = LogWriter.getInstance();
            fileObject = null;
            realScript = null;
            tempFile = null;
            try {
                base = null;
                cmds = new ArrayList<String>();
                if (log.isBasic()) {
                    log.logBasic(this.toString(), Messages.getString("JobShell.RunningOn", Const.getOS()), new Object[0]);
                }
                if (this.insertScript) {
                    realScript = this.environmentSubstitute(this.script);
                } else {
                    realFilename = this.environmentSubstitute(this.getFilename());
                    fileObject = KettleVFS.getFileObject((String)realFilename);
                }
                if (Const.getOS().equals("Windows 95")) {
                    base = new String[]{"command.com", "/C"};
                } else if (Const.getOS().startsWith("Windows")) {
                    base = new String[]{"cmd.exe", "/C"};
                } else if (!this.insertScript) {
                    base = new String[]{KettleVFS.getFilename((FileObject)fileObject)};
                } else {
                    try {
                        tempFile = KettleVFS.createTempFile((String)"kettle", (String)"shell", (String)this.workDirectory);
                        tempFile.createFile();
                        outputStream = tempFile.getContent().getOutputStream();
                        outputStream.write(realScript.getBytes());
                        outputStream.close();
                        tempFilename = KettleVFS.getFilename((FileObject)tempFile);
                        procBuilder = new ProcessBuilder(new String[]{"chmod", "+x", tempFilename});
                        proc = procBuilder.start();
                        errorLogger = new StreamLogger(proc.getErrorStream(), this.toString() + " (stderr)");
                        outputLogger = new StreamLogger(proc.getInputStream(), this.toString() + " (stdout)");
                        new Thread((Runnable)errorLogger).start();
                        new Thread((Runnable)outputLogger).start();
                        proc.waitFor();
                        base = new String[]{tempFilename};
                    }
                    catch (Exception e) {
                        throw new Exception("Unable to create temporary file to execute script", e);
                    }
                }
                if (this.argFromPrevious && cmdRows != null) {
                    for (i = 0; i < base.length; ++i) {
                        cmds.add(base[i]);
                    }
                    if (Const.getOS().equals("Windows 95") || Const.getOS().startsWith("Windows")) {
                        cmdline = new StringBuffer(300);
                        cmdline.append('\"');
                        if (this.insertScript) {
                            cmdline.append(realScript);
                        } else {
                            cmdline.append(this.optionallyQuoteField(KettleVFS.getFilename((FileObject)fileObject), "\""));
                        }
                        for (i = 0; i < cmdRows.size(); ++i) {
                            r = cmdRows.get(i);
                            for (j = 0; j < r.size(); ++j) {
                                cmdline.append(' ');
                                cmdline.append(this.optionallyQuoteField(r.getString(j, null), "\""));
                            }
                        }
                        cmdline.append('\"');
                        cmds.add(cmdline.toString());
                    } else {
                        for (i = 0; i < cmdRows.size(); ++i) {
                            r = cmdRows.get(i);
                            for (j = 0; j < r.size(); ++j) {
                                cmds.add(this.optionallyQuoteField(r.getString(j, null), "\""));
                            }
                        }
                    }
                } else if (args != null) {
                    for (i = 0; i < base.length; ++i) {
                        cmds.add(base[i]);
                    }
                    if (Const.getOS().equals("Windows 95") || Const.getOS().startsWith("Windows")) {
                        cmdline = new StringBuffer(300);
                        cmdline.append('\"');
                        if (this.insertScript) {
                            cmdline.append(realScript);
                        } else {
                            cmdline.append(this.optionallyQuoteField(KettleVFS.getFilename((FileObject)fileObject), "\""));
                        }
                        for (i = 0; i < args.length; ++i) {
                            cmdline.append(' ');
                            cmdline.append(this.optionallyQuoteField(args[i], "\""));
                        }
                        cmdline.append('\"');
                        cmds.add(cmdline.toString());
                    } else {
                        for (i = 0; i < args.length; ++i) {
                            cmds.add(args[i]);
                        }
                    }
                }
                command = new StringBuffer();
                it = cmds.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        command.append(' ');
                    } else {
                        first = false;
                    }
                    command.append((String)it.next());
                }
                if (log.isBasic()) {
                    log.logBasic(this.toString(), Messages.getString("JobShell.ExecCommand", command.toString()), new Object[0]);
                }
                procBuilder = new ProcessBuilder(cmds);
                env = procBuilder.environment();
                variables = this.listVariables();
                for (i = 0; i < variables.length; ++i) {
                    env.put(variables[i], this.getVariable(variables[i]));
                }
                if (this.getWorkDirectory() != null && !Const.isEmpty((String)Const.rtrim((String)this.getWorkDirectory()))) {
                    vfsFilename = this.environmentSubstitute(this.getWorkDirectory());
                    file = new File(KettleVFS.getFilename((FileObject)KettleVFS.getFileObject((String)vfsFilename)));
                    procBuilder.directory(file);
                }
                proc = procBuilder.start();
                errorLogger = new StreamLogger(proc.getErrorStream(), this.toString() + " (stderr)");
                outputLogger = new StreamLogger(proc.getInputStream(), this.toString() + " (stdout)");
                new Thread((Runnable)errorLogger).start();
                new Thread((Runnable)outputLogger).start();
                proc.waitFor();
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobShell.CommandFinished", command.toString()), new Object[0]);
                }
                result.setExitStatus(proc.exitValue());
                if (result.getExitStatus() != 0) {
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobShell.ExitStatus", this.environmentSubstitute(this.getFilename()), "" + result.getExitStatus()), new Object[0]);
                    }
                    result.setNrErrors(1L);
                }
                proc.getErrorStream().close();
                proc.getOutputStream().close();
                var20_36 = null;
                ** if (tempFile == null) goto lbl-1000
            }
            catch (Throwable var19_46) {
                var20_40 = null;
                if (tempFile != null) {
                    try {
                        tempFile.delete();
                    }
                    catch (Exception e) {
                        Messages.getString("JobShell.UnexpectedError", tempFile.toString(), e.toString());
                    }
                }
                throw var19_46;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    tempFile.delete();
                }
                catch (Exception e) {
                    Messages.getString("JobShell.UnexpectedError", tempFile.toString(), e.toString());
                }
            }
lbl-1000:
            // 2 sources

            {
                break block58;
                catch (IOException ioe) {
                    log.logError(this.toString(), Messages.getString("JobShell.ErrorRunningShell", this.environmentSubstitute(this.getFilename()), ioe.toString()), new Object[0]);
                    result.setNrErrors(1L);
                    var20_37 = null;
                    if (tempFile != null) {
                        try {
                            tempFile.delete();
                        }
                        catch (Exception e) {
                            Messages.getString("JobShell.UnexpectedError", tempFile.toString(), e.toString());
                        }
                    }
                    break block58;
                }
                catch (InterruptedException ie) {
                    log.logError(this.toString(), Messages.getString("JobShell.Shellinterupted", this.environmentSubstitute(this.getFilename()), ie.toString()), new Object[0]);
                    result.setNrErrors(1L);
                    var20_38 = null;
                    if (tempFile != null) {
                        try {
                            tempFile.delete();
                        }
                        catch (Exception e) {
                            Messages.getString("JobShell.UnexpectedError", tempFile.toString(), e.toString());
                        }
                    }
                    break block58;
                }
                catch (Exception e) {
                    log.logError(this.toString(), Messages.getString("JobShell.UnexpectedError", this.environmentSubstitute(this.getFilename()), e.toString()), new Object[0]);
                    result.setNrErrors(1L);
                    var20_39 = null;
                    if (tempFile != null) {
                        try {
                            tempFile.delete();
                        }
                        catch (Exception e) {
                            Messages.getString("JobShell.UnexpectedError", tempFile.toString(), e.toString());
                        }
                    }
                }
            }
        }
        if (result.getNrErrors() > 0L) {
            result.setResult(false);
        } else {
            result.setResult(true);
        }
    }

    private String optionallyQuoteField(String field, String quote) {
        if (Const.isEmpty((String)field)) {
            return "\"\"";
        }
        if (field.indexOf(quote) >= 0 || field.indexOf(32) < 0 && field.indexOf(61) < 0) {
            return field;
        }
        return quote + field + quote;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.filename)) {
            String realFileName = jobMeta.environmentSubstitute(this.filename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "workDirectory", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        if (this.setLogfile) {
            JobEntryValidatorUtils.andValidator().validate(this, "logfile", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        }
    }

    protected String getLogfile() {
        return this.logfile;
    }
}

