/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.testutil;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.DatabaseListChangeListener;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.UndoableEditListener;

public class StubDataSourceCollection<T extends SPDataSource>
implements DataSourceCollection<T> {
    private final List<T> dataSources = new ArrayList<T>();
    private final List<JDBCDataSourceType> dsTypes = new ArrayList<JDBCDataSourceType>();
    private final List<UndoableEditListener> undoableEdits = new ArrayList<UndoableEditListener>();
    private final List<DatabaseListChangeListener> dbListChangeListeners = new ArrayList<DatabaseListChangeListener>();
    private URI serverBaseURI;

    @Override
    public void addDataSource(T dbcs) {
        this.dataSources.add(dbcs);
    }

    @Override
    public void addDataSourceType(JDBCDataSourceType dataSourceType) {
        this.dsTypes.add(dataSourceType);
    }

    @Override
    public void addDatabaseListChangeListener(DatabaseListChangeListener l) {
        this.dbListChangeListeners.add(l);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener l) {
        this.undoableEdits.add(l);
    }

    @Override
    public List<T> getConnections() {
        return Collections.unmodifiableList(this.dataSources);
    }

    @Override
    public <C extends T> C getDataSource(String name, Class<C> classType) {
        for (SPDataSource ds : this.dataSources) {
            if (!ds.getName().equals(name) || !classType.isInstance(ds)) continue;
            return (C)((SPDataSource)classType.cast(ds));
        }
        return null;
    }

    @Override
    public List<JDBCDataSourceType> getDataSourceTypes() {
        return Collections.unmodifiableList(this.dsTypes);
    }

    @Override
    public void mergeDataSource(T dbcs) {
        this.dataSources.add(dbcs);
    }

    @Override
    public void mergeDataSourceType(JDBCDataSourceType dst) {
        this.dsTypes.add(dst);
    }

    @Override
    public void read(File location) throws IOException {
        throw new UnsupportedOperationException("Unsupported in the current stub implementation");
    }

    @Override
    public void read(InputStream in) throws IOException {
        throw new UnsupportedOperationException("Unsupported in the current stub implementation");
    }

    @Override
    public void removeDataSource(SPDataSource dbcs) {
        this.dataSources.remove(dbcs);
    }

    @Override
    public boolean removeDataSourceType(JDBCDataSourceType dataSourceType) {
        return this.dsTypes.remove(dataSourceType);
    }

    @Override
    public void removeDatabaseListChangeListener(DatabaseListChangeListener l) {
        this.dbListChangeListeners.remove(l);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener l) {
        this.undoableEdits.remove(l);
    }

    @Override
    public void write() throws IOException {
        throw new UnsupportedOperationException("Unsupported in the current stub implementation");
    }

    @Override
    public void write(File location) throws IOException {
        throw new UnsupportedOperationException("Unsupported in the current stub implementation");
    }

    @Override
    public void write(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Unsupported in the current stub implementation");
    }

    @Override
    public URI getServerBaseURI() {
        return this.serverBaseURI;
    }

    public void setServerBaseURI(URI serverBaseURI) {
        this.serverBaseURI = serverBaseURI;
    }

    @Override
    public <C extends T> List<C> getConnections(Class<C> classType) {
        ArrayList<C> matchingDataSources = new ArrayList<C>();
        for (SPDataSource ds : this.dataSources) {
            if (!classType.isInstance(ds)) continue;
            matchingDataSources.add(classType.cast(ds));
        }
        return matchingDataSources;
    }

    @Override
    public T getDataSource(String name) {
        for (SPDataSource ds : this.dataSources) {
            if (!ds.getName().equals(name)) continue;
            return (T)ds;
        }
        return null;
    }

    @Override
    public URI getMondrianServerBaseURI() {
        return null;
    }

    @Override
    public UserDefinedSQLType getSQLType(String name) {
        return null;
    }

    @Override
    public List<UserDefinedSQLType> getSQLTypes() {
        return null;
    }

    @Override
    public UserDefinedSQLType getNewSQLType(String name, int jdbcCode) {
        return null;
    }
}

