/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.table;

import ca.sqlpower.swingui.table.CleanupTableModel;
import ca.sqlpower.swingui.table.TableModelWrapper;
import ca.sqlpower.swingui.table.TableTextConverter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

public class TableModelSearchDecorator
extends AbstractTableModel
implements CleanupTableModel,
TableModelWrapper {
    private static final Logger logger = Logger.getLogger(TableModelSearchDecorator.class);
    private TableTextConverter tableTextConverter;
    private TableModel tableModel;
    private List<Integer> rowMapping = null;
    private Document doc;
    private String searchText = null;
    private TimedDocumentListener docListener = null;
    final TableModelListener tableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            TableModelSearchDecorator.this.search(TableModelSearchDecorator.this.searchText);
            TableModelSearchDecorator.this.fireTableChanged(e);
        }
    };

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.tableModel.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.tableModel.setValueAt(aValue, rowIndex, columnIndex);
    }

    public TableModelSearchDecorator(TableModel model) {
        this.setWrappedModel(model);
        this.setDoc(new DefaultStyledDocument());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(String searchText) {
        this.rowMapping = null;
        this.fireTableDataChanged();
        ArrayList<Integer> newRowMap = new ArrayList<Integer>();
        String[] searchWords = searchText == null ? null : searchText.split(" ");
        TableModel tableModel = this.tableModel;
        synchronized (tableModel) {
            for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
                boolean match = false;
                if (searchWords == null) {
                    match = true;
                } else {
                    int i;
                    for (i = 0; i < searchWords.length; ++i) {
                        match = false;
                        for (int column = 0; column < this.tableModel.getColumnCount(); ++column) {
                            Object val = this.tableModel.getValueAt(row, column);
                            String value = this.tableTextConverter.getTextForCell(val);
                            if (value.toLowerCase().indexOf(searchWords[i].toLowerCase()) < 0) continue;
                            match = true;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("Match: " + value.toLowerCase() + " contains " + searchWords[i] + "     " + value.toLowerCase().indexOf(searchWords[i].toLowerCase())));
                            break;
                        }
                        if (!match) break;
                    }
                    if (i < searchWords.length) {
                        match = false;
                    }
                }
                if (!match) continue;
                newRowMap.add(row);
            }
        }
        this.setSearchText(searchText);
        this.rowMapping = newRowMap;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("new row mapping after search: " + this.rowMapping));
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.rowMapping == null) {
            return this.tableModel.getRowCount();
        }
        return this.rowMapping.size();
    }

    @Override
    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.tableModel.getValueAt(this.rowToModel(rowIndex), columnIndex);
    }

    private int rowToModel(int rowIndex) {
        int modelRow = this.rowMapping == null ? rowIndex : this.rowMapping.get(rowIndex);
        return modelRow;
    }

    @Override
    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.tableModel.getColumnClass(columnIndex);
    }

    @Override
    public TableModel getWrappedModel() {
        return this.tableModel;
    }

    @Override
    public void setWrappedModel(TableModel newModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = newModel;
        newModel.addTableModelListener(this.tableModelListener);
        this.fireTableStructureChanged();
    }

    public Document getDoc() {
        return this.doc;
    }

    public void setDoc(Document doc) {
        if (this.doc != null && this.docListener != null) {
            this.docListener.cleanup();
        }
        this.doc = doc;
        if (doc != null) {
            this.docListener = new TimedDocumentListener(doc);
        }
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public TableTextConverter getTableTextConverter() {
        return this.tableTextConverter;
    }

    public void setTableTextConverter(TableTextConverter tableTextConverter) {
        this.tableTextConverter = tableTextConverter;
    }

    @Override
    public void cleanup() {
        this.docListener.cleanup();
        if (this.tableModel instanceof CleanupTableModel) {
            ((CleanupTableModel)((Object)this.tableModel)).cleanup();
        }
    }

    private class TimedDocumentListener
    implements DocumentListener {
        private AtomicBoolean hasUpdates = new AtomicBoolean(false);
        private final Timer timer;
        private final Document d;

        public TimedDocumentListener(Document d) {
            this.d = d;
            this.timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TimedDocumentListener.this.hasUpdates.get()) {
                        TimedDocumentListener.this.hasUpdates.set(false);
                        TableModelSearchDecorator.this.search(TimedDocumentListener.this.getSearchText(TimedDocumentListener.this.d));
                    }
                }
            });
            d.addDocumentListener(this);
            this.timer.setInitialDelay(0);
            this.timer.setCoalesce(true);
            this.timer.setRepeats(true);
            this.timer.start();
        }

        public void cleanup() {
            this.timer.stop();
            this.d.removeDocumentListener(this);
        }

        private String getSearchText(Document e) {
            String searchText = null;
            try {
                searchText = e.getText(0, e.getLength());
            }
            catch (BadLocationException e1) {
                throw new RuntimeException(e1);
            }
            return searchText;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.hasUpdates.set(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.hasUpdates.set(true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.hasUpdates.set(true);
        }
    }
}

