/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject.undo;

import ca.sqlpower.object.SPObject;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.log4j.Logger;

public class SPObjectPropertyChangeUndoableEdit
extends AbstractUndoableEdit {
    private static final Logger logger = Logger.getLogger(SPObjectPropertyChangeUndoableEdit.class);
    private PropertyChangeEvent event;
    private String toolTip;

    public SPObjectPropertyChangeUndoableEdit(PropertyChangeEvent e) {
        if (e == null) {
            throw new NullPointerException("Null event is not allowed");
        }
        this.event = e;
        this.toolTip = this.createToolTip();
    }

    private String createToolTip() {
        return "Set " + this.event.getPropertyName() + " to " + this.event.getNewValue();
    }

    @Override
    public void redo() throws CannotRedoException {
        try {
            ((SPObject)this.event.getSource()).setMagicEnabled(false);
            this.modifyProperty(this.event.getNewValue());
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("Couldn't access setter for " + this.event.getPropertyName()), (Throwable)e);
            throw new CannotRedoException();
        }
        catch (InvocationTargetException e) {
            logger.error((Object)("Setter for " + this.event.getPropertyName() + " on " + this.event.getSource() + " threw exception"), (Throwable)e);
            throw new CannotRedoException();
        }
        catch (IntrospectionException e) {
            logger.error((Object)("Couldn't introspect source object " + this.event.getSource()), (Throwable)e);
            throw new CannotRedoException();
        }
        finally {
            ((SPObject)this.event.getSource()).setMagicEnabled(true);
        }
        super.redo();
    }

    @Override
    public void undo() throws CannotUndoException {
        try {
            ((SPObject)this.event.getSource()).setMagicEnabled(false);
            this.modifyProperty(this.event.getOldValue());
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("Couldn't access setter for " + this.event.getPropertyName()), (Throwable)e);
            throw (CannotUndoException)new CannotUndoException().initCause(e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)("Setter for " + this.event.getPropertyName() + " on " + this.event.getSource() + " threw exception"), (Throwable)e);
            throw (CannotUndoException)new CannotUndoException().initCause(e);
        }
        catch (IntrospectionException e) {
            logger.error((Object)("Couldn't introspect source object " + this.event.getSource()), (Throwable)e);
            throw (CannotUndoException)new CannotUndoException().initCause(e);
        }
        finally {
            ((SPObject)this.event.getSource()).setMagicEnabled(true);
        }
        super.undo();
    }

    private void modifyProperty(Object value) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        BeanInfo info = Introspector.getBeanInfo(this.event.getSource().getClass());
        PropertyDescriptor[] props = info.getPropertyDescriptors();
        for (PropertyDescriptor prop : Arrays.asList(props)) {
            Method writeMethod;
            if (!prop.getName().equals(this.event.getPropertyName()) || (writeMethod = prop.getWriteMethod()) == null) continue;
            writeMethod.invoke(this.event.getSource(), value);
        }
    }

    @Override
    public String getPresentationName() {
        return this.toolTip;
    }

    @Override
    public String toString() {
        return this.event.getSource() + "." + this.event.getPropertyName() + " changed from [" + this.event.getOldValue() + "] to [" + this.event.getNewValue() + "]";
    }
}

