/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sql.jdbcwrapper.ConnectionDecorator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class JDBCDataSource
extends SPDataSource {
    public static final Logger logger = Logger.getLogger(JDBCDataSource.class);
    public static final String DBCS_DRIVER_CLASS = "JDBC Driver Class";
    public static final String DBCS_URL = "JDBC URL";
    public static final String DBCS_JAR = "JAR File";
    public static final String DBCS_CONNECTION_TYPE = "Connection Type";
    public static final String PL_TYPE = "Type";
    public static final String PL_DSN = "DSN";
    public static final String PL_SCHEMA_OWNER = "PL Schema Owner";
    public static final String PL_UID = "UID";
    public static final String PL_PWD = "PWD";
    public static final String PL_TNS = "TNS Name";
    public static final String PL_DATABASE_NAME = "Database Name";
    public static final String PL_IP = "IP";
    public static final String PL_PORT = "PORT";
    private final ParentTypeNameSynchronizer parentTypeUpdater = new ParentTypeNameSynchronizer();
    private JDBCDataSourceType parentType;
    private boolean parentSet = false;

    public static URL jarSpecToFile(String jarFileName, ClassLoader classLoader, URI serverBaseURI) {
        URL location;
        try {
            if (jarFileName.startsWith("builtin:")) {
                String jarName = jarFileName.substring("builtin:".length());
                location = classLoader.getResource(jarName);
                if (location == null) {
                    logger.warn((Object)("Couldn't find built-in system resource \"" + jarName + "\". Skipping it."));
                }
            } else if (jarFileName.startsWith("server:")) {
                if (serverBaseURI == null) {
                    throw new IllegalArgumentException("The JDBC driver at " + jarFileName + " can't" + " be located because no server base URI was specified");
                }
                String jarFilePath = jarFileName.substring("server:".length());
                location = new URL(URLDecoder.decode(serverBaseURI.toString(), "UTF-8"));
                location = new URL(location, jarFilePath);
            } else {
                location = jarFileName.startsWith("file:") ? new URI(jarFileName).toURL() : new File(jarFileName).toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConnectionInfoString(JDBCDataSource ds, boolean testConnection) {
        StringBuilder summary = new StringBuilder("");
        Connection con = null;
        try {
            con = ds.createConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            if (!testConnection) {
                summary.append(ds.getDisplayName() + ": \n");
            }
            summary.append("Database Product Name: ").append(dbmd.getDatabaseProductName() + "\n");
            summary.append("Database Product Version: ").append(dbmd.getDatabaseProductVersion() + "\n");
            summary.append("Database Driver Name: ").append(dbmd.getDriverName() + "\n");
            summary.append("Database Driver Version: ").append(dbmd.getDriverVersion() + "\n");
        }
        catch (SQLException e) {
            logger.error((Object)"Couldn't get database metadata!", (Throwable)e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.warn((Object)"Couldn't close connection", (Throwable)ex);
            }
        }
        return summary.toString();
    }

    public JDBCDataSource(DataSourceCollection parentCollection) {
        super(parentCollection);
        this.setParentType(new JDBCDataSourceType(parentCollection.getServerBaseURI()));
        this.parentSet = false;
    }

    public JDBCDataSource(SPDataSource copy) {
        super(copy);
        if (copy instanceof JDBCDataSource) {
            this.setParentType(((JDBCDataSource)copy).parentType);
        }
    }

    public Connection createConnection() throws SQLException {
        try {
            Connection realConnection;
            if (this.getParentType() == null) {
                throw new SQLException("Data Source \"" + this.getName() + "\" has no database type.");
            }
            this.getParentType().checkConnectPrereqs();
            if (this.getUrl() == null || this.getUrl().trim().length() == 0) {
                throw new SQLException("Data Source \"" + this.getName() + "\" has no JDBC URL.");
            }
            if (logger.isDebugEnabled()) {
                StringBuffer loaders = new StringBuffer();
                loaders.append("Local Classloader chain: ");
                for (ClassLoader cl = this.getClass().getClassLoader(); cl != null; cl = cl.getParent()) {
                    loaders.append(cl).append(", ");
                }
                logger.debug((Object)loaders);
            }
            Driver driver = (Driver)Class.forName(this.getDriverClass(), true, this.getParentType().getJdbcClassLoader()).newInstance();
            logger.info((Object)("Driver Class " + this.getDriverClass() + " loaded without exception"));
            if (!driver.acceptsURL(this.getUrl())) {
                throw new SQLException("Couldn't connect to database \"" + this.getName() + "\":\n" + "JDBC Driver " + this.getDriverClass() + "\n" + "does not accept the URL " + this.getUrl());
            }
            Properties connectionProps = new Properties();
            connectionProps.setProperty("user", this.getUser());
            connectionProps.setProperty("password", this.getPass());
            if (this.getDriverClass().endsWith("OracleDriver")) {
                connectionProps.setProperty("remarksReporting", "true");
            }
            if ((realConnection = driver.connect(this.getUrl(), connectionProps)) == null) {
                throw new SQLException("JDBC Driver returned a null connection!");
            }
            Connection connection = ConnectionDecorator.createFacade(realConnection);
            logger.debug((Object)("Connection class is: " + connection.getClass().getName()));
            return connection;
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)"Driver Class not found", (Throwable)e);
            SQLException sqlException = new SQLException("JDBC Driver \"" + this.getDriverClass() + "\" not found.");
            sqlException.initCause(e);
            throw sqlException;
        }
        catch (InstantiationException e) {
            logger.error((Object)"Creating SQL Exception to conform to interface.  Real exception is: ", (Throwable)e);
            throw new SQLException("Couldn't create an instance of the JDBC driver '" + this.getDriverClass() + "'. " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"Creating SQL Exception to conform to interface.  Real exception is: ", (Throwable)e);
            throw new SQLException("Couldn't connect to database because the JDBC driver has no public constructor (this is bad). " + e.getMessage());
        }
    }

    public void copyFrom(JDBCDataSource dbcs) {
        super.copyFrom(dbcs);
        this.setParentType(dbcs.getParentType());
    }

    public String getUrl() {
        return this.get(DBCS_URL);
    }

    public void setUrl(String argUrl) {
        this.putImpl(DBCS_URL, argUrl, "url");
    }

    public String getDriverClass() {
        if (this.getParentType() == null) {
            return null;
        }
        return this.getParentType().getJdbcDriver();
    }

    public String getUser() {
        return this.get(PL_UID);
    }

    public void setUser(String argUser) {
        this.putImpl(PL_UID, argUser, "user");
    }

    public String getPass() {
        return this.get(PL_PWD);
    }

    public void setPass(String argPass) {
        this.putImpl(PL_PWD, argPass, "pass");
    }

    public String getPlSchema() {
        return this.get(PL_SCHEMA_OWNER);
    }

    public void setPlSchema(String schema) {
        this.putImpl(PL_SCHEMA_OWNER, schema, "plSchema");
    }

    public String getPlDbType() {
        return this.get(PL_TYPE);
    }

    public void setPlDbType(String type) {
        this.putImpl(PL_TYPE, type, "plDbType");
    }

    public String getOdbcDsn() {
        return this.get(PL_DSN);
    }

    public void setOdbcDsn(String dsn) {
        this.putImpl(PL_DSN, dsn, "odbcDsn");
    }

    public JDBCDataSourceType getParentType() {
        return this.parentType;
    }

    public void setParentType(JDBCDataSourceType type) {
        if (this.parentType != null) {
            this.parentType.removePropertyChangeListener(this.parentTypeUpdater);
        }
        this.parentType = type;
        if (this.parentType != null) {
            this.parentType.addPropertyChangeListener(this.parentTypeUpdater);
        }
        this.parentSet = true;
        this.putImpl(DBCS_CONNECTION_TYPE, type.getName(), "parentType");
    }

    public boolean isParentSet() {
        return this.parentSet;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private class ParentTypeNameSynchronizer
    implements PropertyChangeListener {
        private ParentTypeNameSynchronizer() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == JDBCDataSource.this.parentType && "name".equals(evt.getPropertyName())) {
                JDBCDataSource.this.put(JDBCDataSource.DBCS_CONNECTION_TYPE, (String)evt.getNewValue());
            }
        }
    }
}

