/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.MondrianXMLWriter;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.action.ProgressAction;
import ca.sqlpower.architect.swingui.olap.OSUtils;
import ca.sqlpower.swingui.RecentMenu;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.MonitorableImpl;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ExportSchemaAction
extends ProgressAction {
    private static final Logger logger = Logger.getLogger(ExportSchemaAction.class);
    private static final String FILE_KEY = "FILE_KEY";
    private ArchitectSwingSession session;
    private MondrianModel.Schema schema;
    private RecentMenu recent;

    public ExportSchemaAction(ArchitectSwingSession session, MondrianModel.Schema schema) {
        super(session, "Export Schema...", "Export Schema to xml", (Icon)OSUtils.SCHEMA_EXPORT_ICON);
        this.session = session;
        this.schema = schema;
        this.recent = session.getRecentMenu();
    }

    @Override
    public void cleanUp(MonitorableImpl monitor) {
    }

    @Override
    public void doStuff(MonitorableImpl monitor, Map<String, Object> properties) {
        File f = (File)properties.get(FILE_KEY);
        try {
            MondrianXMLWriter.exportXML(f, this.schema);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to save " + f.getName() + " for schema: " + (Object)((Object)this.schema)));
            ASUtils.showExceptionDialog(this.session, "Could not save xml schema file.", e);
        }
    }

    @Override
    public String getButtonText() {
        return "Run in Background";
    }

    @Override
    public String getDialogMessage() {
        return "Creating XML";
    }

    @Override
    public boolean setup(MonitorableImpl monitor, Map<String, Object> properties) {
        int response;
        monitor.setStarted(true);
        JFileChooser chooser = new JFileChooser(this.recent.getMostRecentFile());
        chooser.addChoosableFileFilter(SPSUtils.XML_FILE_FILTER);
        File file = null;
        do {
            if ((response = chooser.showSaveDialog(this.session.getArchitectFrame())) != 0) {
                return false;
            }
            file = chooser.getSelectedFile();
            String fileName = file.getName();
            if (fileName.endsWith(".xml")) continue;
            file = new File(file.getPath() + ".xml");
        } while (file.exists() && (response = JOptionPane.showConfirmDialog(null, "The file " + file.getPath() + " already exists. Do you want to overwrite it?", "File Exists", 0)) != 0);
        logger.debug((Object)("Saving to file: " + file.getName() + "(" + file.getPath() + ")"));
        this.recent.putRecentFileName(file.getAbsolutePath());
        properties.put(FILE_KEY, file);
        return true;
    }
}

