/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.profile.output.ProfileCSVFormat;
import ca.sqlpower.architect.profile.output.ProfileFormat;
import ca.sqlpower.architect.profile.output.ProfileHTMLFormat;
import ca.sqlpower.architect.profile.output.ProfilePDFFormat;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.architect.swingui.table.ProfileJTable;
import ca.sqlpower.swingui.SPSUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class SaveProfileAction
extends AbstractAction {
    private Component dialogOwner;
    private ProfileJTable viewTable;
    private final SaveableFileType[] fileTypes;

    public SaveProfileAction(Component dialogOwner, String name, ProfileJTable viewTable, SaveableFileType ... fileTypes) {
        super(name);
        this.dialogOwner = dialogOwner;
        this.viewTable = viewTable;
        this.fileTypes = fileTypes;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SaveableFileType type;
        int response;
        final ProfileResultsTree objectToSave = new ProfileResultsTree();
        if (this.viewTable.getSelectedRowCount() > 1) {
            int[] selectedRows = this.viewTable.getSelectedRows();
            HashSet<TableProfileResult> selectedTable = new HashSet<TableProfileResult>();
            HashSet<ColumnProfileResult> selectedColumn = new HashSet<ColumnProfileResult>();
            for (int i = 0; i < selectedRows.length; ++i) {
                int rowid = selectedRows[i];
                ColumnProfileResult result = this.viewTable.getColumnProfileResultForRow(rowid);
                selectedTable.add(result.getParent());
                selectedColumn.add(result);
            }
            boolean fullSelection = true;
            block3: for (TableProfileResult tpr : selectedTable) {
                for (ColumnProfileResult cpr : tpr.getColumnProfileResults()) {
                    if (selectedColumn.contains(cpr)) continue;
                    fullSelection = false;
                    continue block3;
                }
            }
            int response2 = 0;
            if (!fullSelection) {
                response2 = JOptionPane.showOptionDialog(this.dialogOwner, Messages.getString("SaveProfileAction.saveOnlySelectedPortion"), Messages.getString("SaveProfileAction.saveOnlySelectedPortionDialogTitle"), 0, 3, null, new String[]{Messages.getString("SaveProfileAction.savePartialOption"), Messages.getString("SaveProfileAction.saveEntireTableOption")}, Messages.getString("SaveProfileAction.saveEntireTableOption"));
            }
            if (response2 == 1) {
                for (TableProfileResult tpr : selectedTable) {
                    for (ColumnProfileResult cpr : tpr.getColumnProfileResults()) {
                        objectToSave.addColumnProfileResult(cpr);
                    }
                }
            } else {
                for (int i = 0; i < selectedRows.length; ++i) {
                    int rowid = selectedRows[i];
                    ColumnProfileResult result = this.viewTable.getColumnProfileResultForRow(rowid);
                    objectToSave.addColumnProfileResult(result);
                }
            }
        } else {
            for (int i = 0; i < this.viewTable.getRowCount(); ++i) {
                ColumnProfileResult result = this.viewTable.getColumnProfileResultForRow(i);
                objectToSave.addColumnProfileResult(result);
            }
        }
        JFileChooser chooser = new JFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        for (SaveableFileType type2 : this.fileTypes) {
            chooser.addChoosableFileFilter(type2.getFilter());
        }
        File file = null;
        do {
            if ((response = chooser.showSaveDialog(this.dialogOwner)) != 0) {
                return;
            }
            file = chooser.getSelectedFile();
            FileFilter fileFilter = chooser.getFileFilter();
            String fileName = file.getName();
            int x = fileName.lastIndexOf(46);
            boolean gotType = false;
            SaveableFileType ntype = null;
            if (x != -1) {
                String ext = fileName.substring(x + 1);
                try {
                    ntype = SaveableFileType.valueOf(ext.toUpperCase());
                    gotType = true;
                }
                catch (IllegalArgumentException iex) {
                    gotType = false;
                }
            }
            if (gotType) {
                type = ntype;
                continue;
            }
            if (fileFilter == SPSUtils.HTML_FILE_FILTER) {
                if (!fileName.endsWith(".html")) {
                    file = new File(file.getPath() + ".html");
                }
                type = SaveableFileType.HTML;
                continue;
            }
            if (fileFilter == SPSUtils.PDF_FILE_FILTER) {
                if (!fileName.endsWith(".pdf")) {
                    file = new File(file.getPath() + ".pdf");
                }
                type = SaveableFileType.PDF;
                continue;
            }
            if (fileFilter == SPSUtils.CSV_FILE_FILTER) {
                if (!fileName.endsWith(".csv")) {
                    file = new File(file.getPath() + ".csv");
                }
                type = SaveableFileType.CSV;
                continue;
            }
            throw new IllegalStateException(Messages.getString("SaveProfileAction.unexpectedFileFilter"));
        } while (file.exists() && (response = JOptionPane.showConfirmDialog(this.dialogOwner, Messages.getString("SaveProfileAction.fileAlreadyExists", file.getPath()), Messages.getString("SaveProfileAction.fileAlreadyExistsDialogTitle"), 0)) == 1);
        final File file2 = new File(file.getPath());
        final SaveableFileType type2 = type;
        Runnable saveTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutputStream out = null;
                try {
                    ProfileFormat prf = null;
                    out = new BufferedOutputStream(new FileOutputStream(file2));
                    switch (type2) {
                        case HTML: {
                            String encoding = "utf-8";
                            prf = new ProfileHTMLFormat("utf-8");
                            break;
                        }
                        case PDF: {
                            prf = new ProfilePDFFormat();
                            break;
                        }
                        case CSV: {
                            prf = new ProfileCSVFormat();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(Messages.getString("SaveProfileAction.unknownType"));
                        }
                    }
                    prf.format(out, objectToSave.getDepthFirstList());
                }
                catch (Exception ex) {
                    ASUtils.showExceptionDialogNoReport(SaveProfileAction.this.dialogOwner, Messages.getString("SaveProfileAction.couldNotSaveReport"), ex);
                }
                finally {
                    if (out != null) {
                        try {
                            out.flush();
                            out.close();
                        }
                        catch (IOException ex) {
                            ASUtils.showExceptionDialogNoReport(SaveProfileAction.this.dialogOwner, Messages.getString("SaveProfileAction.couldNotCloseReport"), ex);
                        }
                    }
                }
            }
        };
        new Thread(saveTask).start();
    }

    public static enum SaveableFileType {
        HTML(SPSUtils.HTML_FILE_FILTER),
        PDF(SPSUtils.PDF_FILE_FILTER),
        CSV(SPSUtils.CSV_FILE_FILTER);

        private final FileFilter filter;

        private SaveableFileType(FileFilter filter) {
            this.filter = filter;
        }

        public FileFilter getFilter() {
            return this.filter;
        }
    }

    public class ProfileResultsTree {
        Map<TableProfileResult, Set<ColumnProfileResult>> resultTree = new TreeMap<TableProfileResult, Set<ColumnProfileResult>>();

        public void addTableProfileResult(TableProfileResult tpr) {
            if (!this.resultTree.containsKey(tpr)) {
                this.resultTree.put(tpr, new HashSet());
            }
        }

        public void addColumnProfileResult(ColumnProfileResult cpr) {
            TableProfileResult tpr = cpr.getParent();
            if (!this.resultTree.containsKey(tpr)) {
                this.resultTree.put(tpr, new TreeSet());
            }
            this.resultTree.get(tpr).add(cpr);
        }

        public List<ProfileResult> getDepthFirstList() {
            ArrayList<ProfileResult> depthFirstList = new ArrayList<ProfileResult>();
            for (TableProfileResult tpr : this.resultTree.keySet()) {
                depthFirstList.add(tpr);
                for (ColumnProfileResult cpr : this.resultTree.get(tpr)) {
                    depthFirstList.add(cpr);
                }
            }
            return depthFirstList;
        }
    }
}

