import * as fromZigbee from "./converters/fromZigbee";
import * as toZigbee from "./converters/toZigbee";
import { Binary, Climate, Composite, Cover, Enum, Fan, Feature, Light, List, Lock, Numeric, Switch, Text, access } from "./lib/exposes";
import { Definition, DefinitionWithExtend, Expose, ExternalDefinitionWithExtend, type KeyValue, type OnEventData, type OnEventMeta, OnEventType, Option, Tz, type Zh } from "./lib/types";
export type { Ota } from "./lib/types";
export { DefinitionWithExtend, ExternalDefinitionWithExtend, access, Definition, OnEventType, Feature, Expose, Option, Numeric, Binary, Enum, Text, Composite, List, Light, Climate, Switch, Lock, Cover, Fan, toZigbee, fromZigbee, Tz, };
export * as ota from "./lib/ota";
export { setLogger } from "./lib/logger";
export { getConfigureKey } from "./lib/configureKey";
export { clear as clearGlobalStore } from "./lib/store";
export declare const externalDefinitions: DefinitionWithExtend[];
export declare function removeExternalDefinitions(converterName?: string): void;
export declare function addExternalDefinition(definition: ExternalDefinitionWithExtend): void;
export declare function prepareDefinition(definition: DefinitionWithExtend): Definition;
export declare function postProcessConvertedFromZigbeeMessage(definition: Definition, payload: KeyValue, options: KeyValue): void;
export declare function findByDevice(device: Zh.Device, generateForUnknown?: boolean): Promise<Definition | undefined>;
export declare function findDefinition(device: Zh.Device, generateForUnknown?: boolean): Promise<DefinitionWithExtend | undefined>;
export declare function generateExternalDefinitionSource(device: Zh.Device): Promise<string>;
export declare function generateExternalDefinition(device: Zh.Device): Promise<Definition>;
export declare function onEvent(type: OnEventType, data: OnEventData, device: Zh.Device, meta: OnEventMeta): Promise<void>;
//# sourceMappingURL=index.d.ts.map