/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.internal.HighestRankingOSGi;
import org.apache.aries.component.dsl.internal.OnlyLastPublisher;

public interface Utils {
    public static <T> OSGi<List<T>> accumulate(OSGi<T> program) {
        return OSGi.just(ArrayList::new).flatMap(list -> {
            OSGi[] oSGiArray = new OSGi[2];
            oSGiArray[0] = OSGi.just(ArrayList::new);
            oSGiArray[1] = program.effects(list::add, __ -> {}, list::remove, __ -> {}).then(OSGi.just(() -> new ArrayList(list)));
            return OSGi.all(oSGiArray).transform(op -> new OnlyLastPublisher<Object>(op, () -> new ArrayList(list)));
        });
    }

    public static <K, V, T extends Comparable<T>> OSGi<Map<K, V>> accumulateInMap(OSGi<T> program, Function<T, OSGi<K>> keyFun, Function<T, OSGi<V>> valueFun) {
        return OSGi.just(HashMap::new).flatMap(map -> OSGi.all(OSGi.just(HashMap::new), program.splitBy(keyFun, (k, p) -> Utils.highest(p, Comparator.naturalOrder(), q -> OSGi.nothing()).flatMap(t -> ((OSGi)valueFun.apply(t)).effects(v -> map.put(k, v), __ -> {}, __ -> map.remove(k), __ -> {}))).then(OSGi.just(() -> new HashMap(map)))).transform(op -> new OnlyLastPublisher<Object>(op, () -> new HashMap(map))));
    }

    public static <T> OSGi<T> onlyLast(OSGi<T> program) {
        return program.transform(o -> new OnlyLastPublisher(o));
    }

    public static <T> OSGi<T> highest(OSGi<T> program, Comparator<? super T> comparator) {
        return Utils.highest(program, comparator, __ -> OSGi.nothing());
    }

    public static <T> OSGi<T> highest(OSGi<T> program, Comparator<? super T> comparator, Function<OSGi<T>, OSGi<T>> notHighest) {
        return new HighestRankingOSGi<T>(program, comparator, notHighest);
    }

    public static <T extends Comparable<? super T>> OSGi<T> highest(OSGi<T> program) {
        return Utils.highest(program, Comparator.naturalOrder());
    }
}

