/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.header;

import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.util.io.HexBin;

public class InterfaceMacHeader
extends UpnpHeader<byte[]> {
    public InterfaceMacHeader() {
    }

    public InterfaceMacHeader(byte[] value) {
        this.setValue(value);
    }

    public InterfaceMacHeader(String s) {
        this.setString(s);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        byte[] bytes = HexBin.stringToBytes(s, ":");
        this.setValue(bytes);
        if (bytes.length != 6) {
            throw new InvalidHeaderException("Invalid MAC address: " + s);
        }
    }

    @Override
    public String getString() {
        return HexBin.bytesToString((byte[])this.getValue(), ":");
    }

    @Override
    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") '" + this.getString() + "'";
    }
}

