/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class DependencyUtil {

    public static interface NodeValueListener<T> {
        public void evaluating(T var1);
    }

    private static class GraphNode<T> {
        public T value;
        private List<GraphNode<T>> comingInNodes;
        private List<GraphNode<T>> goingOutNodes;

        private GraphNode() {
        }

        public void addComingInNode(GraphNode<T> node) {
            if (this.comingInNodes == null) {
                this.comingInNodes = new ArrayList<GraphNode<T>>();
            }
            this.comingInNodes.add(node);
        }

        public void addGoingOutNode(GraphNode<T> node) {
            if (this.goingOutNodes == null) {
                this.goingOutNodes = new ArrayList<GraphNode<T>>();
            }
            this.goingOutNodes.add(node);
        }

        public List<GraphNode<T>> getComingInNodes() {
            return this.comingInNodes;
        }

        public List<GraphNode<T>> getGoingOutNodes() {
            return this.goingOutNodes;
        }
    }

    public static class DependencyGraph<T> {
        private HashMap<T, GraphNode<T>> nodes = new HashMap();
        private NodeValueListener<T> listener;
        private List<GraphNode<T>> evaluatedNodes = new ArrayList<GraphNode<T>>();

        public DependencyGraph(NodeValueListener<T> listener) {
            this.listener = listener;
        }

        public void add(T evalFirstValue, T evalAfterValue) {
            GraphNode<T> firstNode = null;
            GraphNode<T> afterNode = null;
            if (this.nodes.containsKey(evalFirstValue)) {
                firstNode = this.nodes.get(evalFirstValue);
            } else {
                firstNode = this.createNode(evalFirstValue);
                this.nodes.put(evalFirstValue, firstNode);
            }
            if (this.nodes.containsKey(evalAfterValue)) {
                afterNode = this.nodes.get(evalAfterValue);
            } else {
                afterNode = this.createNode(evalAfterValue);
                this.nodes.put(evalAfterValue, afterNode);
            }
            firstNode.addGoingOutNode(afterNode);
            afterNode.addComingInNode(firstNode);
        }

        private GraphNode<T> createNode(T value) {
            GraphNode node = new GraphNode();
            node.value = value;
            return node;
        }

        public void computeDependencies() {
            List<GraphNode<T>> orphanNodes = this.getOrphanNodes();
            ArrayList<GraphNode<T>> nextNodesToDisplay = new ArrayList<GraphNode<T>>();
            if (orphanNodes != null) {
                for (GraphNode<T> node : orphanNodes) {
                    this.listener.evaluating(node.value);
                    this.evaluatedNodes.add(node);
                    nextNodesToDisplay.addAll(node.getGoingOutNodes());
                }
                this.computeDependencies(nextNodesToDisplay);
            }
        }

        private void computeDependencies(List<GraphNode<T>> nodes) {
            ArrayList<GraphNode<T>> nextNodesToDisplay = null;
            for (GraphNode<T> node : nodes) {
                if (this.isAlreadyEvaluated(node)) continue;
                List<GraphNode<T>> comingInNodes = node.getComingInNodes();
                if (this.areAlreadyEvaluated(comingInNodes)) {
                    this.listener.evaluating(node.value);
                    this.evaluatedNodes.add(node);
                    List<GraphNode<T>> goingOutNodes = node.getGoingOutNodes();
                    if (goingOutNodes == null) continue;
                    if (nextNodesToDisplay == null) {
                        nextNodesToDisplay = new ArrayList();
                    }
                    nextNodesToDisplay.addAll(goingOutNodes);
                    continue;
                }
                if (nextNodesToDisplay == null) {
                    nextNodesToDisplay = new ArrayList<GraphNode<T>>();
                }
                nextNodesToDisplay.add(node);
            }
            if (nextNodesToDisplay != null) {
                this.computeDependencies(nextNodesToDisplay);
            }
        }

        private boolean isAlreadyEvaluated(GraphNode<T> node) {
            return this.evaluatedNodes.contains(node);
        }

        private boolean areAlreadyEvaluated(List<GraphNode<T>> nodes) {
            return this.evaluatedNodes.containsAll(nodes);
        }

        private List<GraphNode<T>> getOrphanNodes() {
            ArrayList<GraphNode<T>> orphanNodes = null;
            Set<T> keys = this.nodes.keySet();
            for (T key : keys) {
                GraphNode<T> node = this.nodes.get(key);
                if (node.getComingInNodes() != null) continue;
                if (orphanNodes == null) {
                    orphanNodes = new ArrayList<GraphNode<T>>();
                }
                orphanNodes.add(node);
            }
            return orphanNodes;
        }
    }
}

