/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.actions.AddImageryLayerAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.io.imagery.WMSImagery;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class MapRectifierWMSmenuAction
extends JosmAction {
    private final transient List<RectifierService> services = new ArrayList<RectifierService>();

    public MapRectifierWMSmenuAction() {
        super(I18n.tr("Rectified Image...", new Object[0]), "OLmarker", I18n.tr("Download Rectified Images From Various Services", new Object[0]), Shortcut.registerShortcut("imagery:rectimg", I18n.tr("Imagery: {0}", I18n.tr("Rectified Image...", new Object[0])), 65535, 5000), true);
        this.setHelpId(HelpUtil.ht("/Menu/Imagery"));
        this.services.add(new RectifierService("Metacarta Map Rectifier", "http://labs.metacarta.com/rectifier/", "http://labs.metacarta.com/rectifier/wms.cgi?id=__s__&srs=EPSG:4326&Service=WMS&Version=1.1.0&Request=GetMap&format=image/png&", "labs\\.metacarta\\.com/(?:.*?)(?:/|=)([0-9]+)(?:\\?|/|\\.|$)", "^[0-9]+$"));
        this.services.add(new RectifierService("Map Warper", "http://mapwarper.net/", "http://mapwarper.net/maps/wms/__s__?request=GetMap&version=1.1.1&styles=&format=image/png&srs=epsg:4326&exceptions=application/vnd.ogc.se_inimage&", "(?:mapwarper\\.net|warper\\.geothings\\.net)/(?:.*?)/([0-9]+)(?:\\?|/|\\.|$)", "^[0-9]+$"));
        this.services.add(new RectifierService(I18n.tr("Custom WMS Link", new Object[0]), "", "", "^\\s+$", ""));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(I18n.tr("Supported Rectifier Services:", new Object[0])), GBC.eol());
        JosmTextField tfWmsUrl = new JosmTextField(30);
        String clip = ClipboardUtils.getClipboardStringContent();
        clip = clip == null ? "" : clip.trim();
        ButtonGroup group = new ButtonGroup();
        AbstractButton firstBtn = null;
        for (RectifierService s : this.services) {
            JRadioButton serviceBtn = new JRadioButton(s.name);
            if (firstBtn == null) {
                firstBtn = serviceBtn;
            }
            if (!clip.isEmpty() && tfWmsUrl.getText().isEmpty() && (s.urlRegEx.matcher(clip).find() || s.idValidator.matcher(clip).matches())) {
                serviceBtn.setSelected(true);
                tfWmsUrl.setText(clip);
            }
            s.btn = serviceBtn;
            group.add(serviceBtn);
            if (!s.url.isEmpty()) {
                panel.add((Component)serviceBtn, GBC.std());
                panel.add((Component)new UrlLabel(s.url, I18n.tr("Visit Homepage", new Object[0])), GBC.eol().anchor(13));
                continue;
            }
            panel.add((Component)serviceBtn, GBC.eol().anchor(17));
        }
        if (tfWmsUrl.getText().isEmpty() && firstBtn != null) {
            firstBtn.setSelected(true);
        }
        panel.add((Component)new JLabel(I18n.tr("WMS URL or Image ID:", new Object[0])), GBC.eol());
        panel.add((Component)tfWmsUrl, GBC.eol().fill(2));
        ExtendedDialog diag = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Add Rectified Image", new Object[0]), I18n.tr("Add Rectified Image", new Object[0]), I18n.tr("Cancel", new Object[0])).setContent(panel).configureContextsensitiveHelp(HelpUtil.ht("/Menu/Imagery"), true).setButtonIcons("OLmarker", "cancel");
        block3: while (true) {
            diag.showDialog();
            int answer = diag.getValue();
            if (answer != 1) break;
            String text = tfWmsUrl.getText().trim();
            for (RectifierService s : this.services) {
                Matcher m;
                if (!s.isSelected()) continue;
                if (s.wmsUrl.isEmpty()) {
                    try {
                        MapRectifierWMSmenuAction.addWMSLayer(s.name + " (" + text + ')', text);
                        break block3;
                    }
                    catch (IllegalStateException ex) {
                        Logging.log(Logging.LEVEL_ERROR, ex);
                    }
                }
                if ((m = s.urlRegEx.matcher(text)).find()) {
                    String id = m.group(1);
                    String newURL = s.wmsUrl.replaceAll("__s__", id);
                    String title = s.name + " (" + id + ')';
                    MapRectifierWMSmenuAction.addWMSLayer(title, newURL);
                    break block3;
                }
                if (!s.idValidator.matcher(text).matches()) break;
                String newURL = s.wmsUrl.replaceAll("__s__", text);
                String title = s.name + " (" + text + ')';
                MapRectifierWMSmenuAction.addWMSLayer(title, newURL);
                break block3;
            }
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Couldn''t match the entered link or id to the selected service. Please try again.", new Object[0]), I18n.tr("No valid WMS URL or id", new Object[0]), 0);
            diag.setVisible(true);
        }
    }

    private static void addWMSLayer(String title, String url) {
        ImageryInfo info = new ImageryInfo(title, url);
        if (info.getImageryType() == ImageryInfo.ImageryType.WMS_ENDPOINT) {
            try {
                info = AddImageryLayerAction.getWMSLayerInfo(info);
            }
            catch (IOException | WMSImagery.WMSGetCapabilitiesException e) {
                MapRectifierWMSmenuAction.handleException(e);
                return;
            }
        }
        try {
            MainApplication.getLayerManager().addLayer(ImageryLayer.create(info));
        }
        catch (IllegalArgumentException e) {
            MapRectifierWMSmenuAction.handleException(e);
        }
    }

    private static void handleException(Exception e) {
        Logging.error(e);
        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), e.getMessage(), I18n.tr("No valid WMS URL or id", new Object[0]), 0);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!this.getLayerManager().getLayers().isEmpty());
    }

    public static class RectifierService {
        private final String name;
        private final String url;
        private final String wmsUrl;
        private final Pattern urlRegEx;
        private final Pattern idValidator;
        private JRadioButton btn;

        public RectifierService(String name, String url, String wmsUrl, String urlRegEx, String idValidator) {
            this.name = name;
            this.url = url;
            this.wmsUrl = wmsUrl;
            this.urlRegEx = Pattern.compile(urlRegEx);
            this.idValidator = Pattern.compile(idValidator);
        }

        private boolean isSelected() {
            return this.btn.isSelected();
        }
    }
}

