/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.internal.InternalTransformer;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestExecutionException;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.TestSpecs;
import org.gradle.tooling.events.test.TestOperationDescriptor;
import org.gradle.tooling.events.test.internal.DefaultDebugOptions;
import org.gradle.tooling.internal.consumer.AbstractLongRunningOperation;
import org.gradle.tooling.internal.consumer.BlockingResultHandler;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultInternalJvmTestRequest;
import org.gradle.tooling.internal.consumer.DefaultTaskSpec;
import org.gradle.tooling.internal.consumer.DefaultTestSpecs;
import org.gradle.tooling.internal.consumer.ExceptionTransformer;
import org.gradle.tooling.internal.consumer.TestExecutionRequest;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.tooling.internal.protocol.test.InternalTaskSpec;
import org.gradle.util.internal.CollectionUtils;

public class DefaultTestLauncher
extends AbstractLongRunningOperation<DefaultTestLauncher>
implements TestLauncher {
    private final AsyncConsumerActionExecutor connection;
    private final Set<TestOperationDescriptor> operationDescriptors = new LinkedHashSet<TestOperationDescriptor>();
    private final Set<String> testClassNames = new LinkedHashSet<String>();
    private final Set<InternalJvmTestRequest> internalJvmTestRequests = new LinkedHashSet<InternalJvmTestRequest>();
    private final DefaultDebugOptions debugOptions = new DefaultDebugOptions();
    private final Map<String, List<InternalJvmTestRequest>> tasksAndTests = new HashMap<String, List<InternalJvmTestRequest>>();
    private boolean isRunDefaultTasks = false;
    private final List<InternalTaskSpec> taskSpecs = new ArrayList<InternalTaskSpec>();

    public DefaultTestLauncher(AsyncConsumerActionExecutor connection, ConnectionParameters parameters) {
        super(parameters);
        this.operationParamsBuilder.setTasks(Collections.emptyList());
        this.operationParamsBuilder.setEntryPoint("TestLauncher API");
        this.connection = connection;
    }

    @Override
    protected DefaultTestLauncher getThis() {
        return this;
    }

    @Override
    public TestLauncher withTests(TestOperationDescriptor ... testDescriptors) {
        this.withTests(Arrays.asList(testDescriptors));
        return this;
    }

    @Override
    public TestLauncher withTests(Iterable<? extends TestOperationDescriptor> descriptors) {
        this.operationDescriptors.addAll(CollectionUtils.toList(descriptors));
        return this;
    }

    @Override
    public TestLauncher withJvmTestClasses(String ... classNames) {
        this.withJvmTestClasses(Arrays.asList(classNames));
        return this;
    }

    @Override
    public TestLauncher withJvmTestClasses(Iterable<String> testClasses) {
        List newRequests = CollectionUtils.collect(testClasses, (InternalTransformer)new InternalTransformer<InternalJvmTestRequest, String>(){

            public InternalJvmTestRequest transform(String testClass) {
                return new DefaultInternalJvmTestRequest(testClass, null, null);
            }
        });
        this.internalJvmTestRequests.addAll(newRequests);
        this.testClassNames.addAll(CollectionUtils.toList(testClasses));
        return this;
    }

    @Override
    public TestLauncher withJvmTestMethods(String testClass, String ... methods) {
        this.withJvmTestMethods(testClass, Arrays.asList(methods));
        return this;
    }

    @Override
    public TestLauncher withJvmTestMethods(final String testClass, Iterable<String> methods) {
        List newRequests = CollectionUtils.collect(methods, (InternalTransformer)new InternalTransformer<InternalJvmTestRequest, String>(){

            public InternalJvmTestRequest transform(String methodName) {
                return new DefaultInternalJvmTestRequest(testClass, methodName, null);
            }
        });
        this.internalJvmTestRequests.addAll(newRequests);
        this.testClassNames.add(testClass);
        return this;
    }

    @Override
    public TestLauncher withTaskAndTestClasses(String task, Iterable<String> testClasses) {
        List tests = CollectionUtils.collect(testClasses, (InternalTransformer)new InternalTransformer<InternalJvmTestRequest, String>(){

            public InternalJvmTestRequest transform(String testClass) {
                return new DefaultInternalJvmTestRequest(testClass, null, null);
            }
        });
        this.addTests(task, tests);
        return this;
    }

    @Override
    public TestLauncher withTaskAndTestMethods(String task, final String testClass, Iterable<String> methods) {
        List tests = CollectionUtils.collect(methods, (InternalTransformer)new InternalTransformer<InternalJvmTestRequest, String>(){

            public InternalJvmTestRequest transform(String methodName) {
                return new DefaultInternalJvmTestRequest(testClass, methodName, null);
            }
        });
        this.addTests(task, tests);
        return this;
    }

    private void addTests(String task, List<InternalJvmTestRequest> tests) {
        List<InternalJvmTestRequest> existing = this.tasksAndTests.get(task);
        if (existing == null) {
            this.tasksAndTests.put(task, tests);
        } else {
            existing.addAll(tests);
            this.tasksAndTests.put(task, existing);
        }
    }

    @Override
    public TestLauncher debugTestsOn(int port) {
        this.debugOptions.setPort(port);
        return this;
    }

    @Override
    public TestLauncher forTasks(String ... tasks) {
        this.isRunDefaultTasks = tasks.length == 0;
        for (String task : tasks) {
            this.taskSpecs.add(new DefaultTaskSpec(task));
        }
        return this;
    }

    @Override
    public void run() {
        BlockingResultHandler<Void> handler = new BlockingResultHandler<Void>(Void.class);
        this.run(handler);
        handler.getResult();
    }

    @Override
    public void run(ResultHandler<? super Void> handler) {
        if (this.operationDescriptors.isEmpty() && this.internalJvmTestRequests.isEmpty() && this.tasksAndTests.isEmpty() && this.taskSpecs.isEmpty()) {
            throw new TestExecutionException("No test declared for execution.");
        }
        for (Map.Entry<String, List<InternalJvmTestRequest>> entry : this.tasksAndTests.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            throw new TestExecutionException("No test for task " + entry.getKey() + " declared for execution.");
        }
        final ConsumerOperationParameters operationParameters = this.getConsumerOperationParameters();
        final TestExecutionRequest testExecutionRequest = new TestExecutionRequest(this.operationDescriptors, (Collection<String>)ImmutableList.copyOf(this.testClassNames), (Set<InternalJvmTestRequest>)ImmutableSet.copyOf(this.internalJvmTestRequests), this.debugOptions, (Map<String, List<InternalJvmTestRequest>>)ImmutableMap.copyOf(this.tasksAndTests), this.isRunDefaultTasks, this.taskSpecs);
        this.connection.run(new ConsumerAction<Void>(){

            @Override
            public ConsumerOperationParameters getParameters() {
                return operationParameters;
            }

            @Override
            public Void run(ConsumerConnection connection) {
                connection.runTests(testExecutionRequest, this.getParameters());
                return null;
            }
        }, new ResultHandlerAdapter(handler));
    }

    @Override
    public TestLauncher withTestsFor(Action<TestSpecs> testSpec) {
        DefaultTestSpecs testSpecs = new DefaultTestSpecs();
        testSpec.execute((Object)testSpecs);
        this.taskSpecs.addAll(testSpecs.getTestSpecs());
        return this;
    }

    private class ResultHandlerAdapter
    extends org.gradle.tooling.internal.consumer.ResultHandlerAdapter<Void> {
        public ResultHandlerAdapter(ResultHandler<? super Void> handler) {
            super(handler, new ExceptionTransformer(new Transformer<String, Throwable>(){

                public String transform(Throwable throwable) {
                    return String.format("Could not execute tests using %s.", DefaultTestLauncher.this.connection.getDisplayName());
                }
            }));
        }
    }
}

