/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.insertupdate;

import java.sql.SQLException;
import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.insertupdate.InsertUpdateData;
import org.pentaho.di.trans.steps.insertupdate.InsertUpdateMeta;
import org.pentaho.di.trans.steps.insertupdate.Messages;

public class InsertUpdate
extends BaseStep
implements StepInterface {
    private InsertUpdateMeta meta;
    private InsertUpdateData data;

    public InsertUpdate(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized void lookupValues(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        Object[] lookupRow = new Object[this.data.lookupParameterRowMeta.size()];
        int lookupIndex = 0;
        for (int i = 0; i < this.meta.getKeyStream().length; ++i) {
            if (this.data.keynrs[i] >= 0) {
                lookupRow[lookupIndex] = row[this.data.keynrs[i]];
                ++lookupIndex;
            }
            if (this.data.keynrs2[i] < 0) continue;
            lookupRow[lookupIndex] = row[this.data.keynrs2[i]];
            ++lookupIndex;
        }
        this.data.db.setValues(this.data.lookupParameterRowMeta, lookupRow, this.data.prepStatementLookup);
        if (this.log.isDebug()) {
            this.logDebug(Messages.getString("InsertUpdate.Log.ValuesSetForLookup") + this.data.lookupParameterRowMeta.getString(lookupRow));
        }
        Object[] add = this.data.db.getLookup(this.data.prepStatementLookup);
        this.incrementLinesInput();
        if (add == null) {
            if (this.log.isRowLevel()) {
                this.logRowlevel(Messages.getString("InsertUpdate.InsertRow") + rowMeta.getString(row));
            }
            Object[] insertRow = new Object[this.data.valuenrs.length];
            for (int i = 0; i < this.data.valuenrs.length; ++i) {
                insertRow[i] = row[this.data.valuenrs[i]];
            }
            this.data.db.setValuesInsert(this.data.insertRowMeta, insertRow);
            this.data.db.insertRow();
            this.incrementLinesOutput();
        } else if (!this.meta.isUpdateBypassed()) {
            if (this.log.isRowLevel()) {
                this.logRowlevel(Messages.getString("InsertUpdate.Log.FoundRowForUpdate") + rowMeta.getString(row));
            }
            boolean update = false;
            for (int i = 0; i < this.data.valuenrs.length; ++i) {
                Object retvalue;
                ValueMetaInterface retMeta;
                Object rowvalue;
                ValueMetaInterface valueMeta;
                if (!this.meta.getUpdate()[i].booleanValue() || (valueMeta = rowMeta.getValueMeta(this.data.valuenrs[i])).compare(rowvalue = row[this.data.valuenrs[i]], retMeta = this.data.db.getReturnRowMeta().getValueMeta(i), retvalue = add[i]) == 0) continue;
                update = true;
            }
            if (update) {
                int i;
                Object[] updateRow = new Object[this.data.updateParameterRowMeta.size()];
                int j = 0;
                for (i = 0; i < this.data.valuenrs.length; ++i) {
                    if (!this.meta.getUpdate()[i].booleanValue()) continue;
                    updateRow[j] = row[this.data.valuenrs[i]];
                    ++j;
                }
                for (i = 0; i < lookupRow.length; ++i) {
                    updateRow[j + i] = lookupRow[i];
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(Messages.getString("InsertUpdate.Log.UpdateRow") + this.data.lookupParameterRowMeta.getString(lookupRow));
                }
                this.data.db.setValues(this.data.updateParameterRowMeta, updateRow, this.data.prepStatementUpdate);
                this.data.db.insertRow(this.data.prepStatementUpdate);
                this.incrementLinesUpdated();
            } else {
                this.incrementLinesSkipped();
            }
        } else {
            if (this.log.isRowLevel()) {
                this.logRowlevel(Messages.getString("InsertUpdate.Log.UpdateBypassed") + rowMeta.getString(row));
            }
            this.incrementLinesSkipped();
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block16: {
            this.meta = (InsertUpdateMeta)smi;
            this.data = (InsertUpdateData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                this.data.schemaTable = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
                if (this.log.isDebug()) {
                    this.logDebug(Messages.getString("InsertUpdate.Log.CheckingRow") + this.getInputRowMeta().getString(r));
                }
                this.data.keynrs = new int[this.meta.getKeyStream().length];
                this.data.keynrs2 = new int[this.meta.getKeyStream().length];
                for (i = 0; i < this.meta.getKeyStream().length; ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getKeyStream()[i]);
                    if (this.data.keynrs[i] < 0 && !"IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) && !"IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                        throw new KettleStepException(Messages.getString("InsertUpdate.Exception.FieldRequired", this.meta.getKeyStream()[i]));
                    }
                    this.data.keynrs2[i] = this.getInputRowMeta().indexOfValue(this.meta.getKeyStream2()[i]);
                    if (this.data.keynrs2[i] < 0 && "BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                        throw new KettleStepException(Messages.getString("InsertUpdate.Exception.FieldRequired", this.meta.getKeyStream2()[i]));
                    }
                    if (!this.log.isDebug()) continue;
                    this.logDebug(Messages.getString("InsertUpdate.Log.FieldHasDataNumbers", this.meta.getKeyStream()[i]) + this.data.keynrs[i]);
                }
                this.data.valuenrs = new int[this.meta.getUpdateLookup().length];
                for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
                    this.data.valuenrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getUpdateStream()[i]);
                    if (this.data.valuenrs[i] < 0) {
                        throw new KettleStepException(Messages.getString("InsertUpdate.Exception.FieldRequired", this.meta.getUpdateStream()[i]));
                    }
                    if (!this.log.isDebug()) continue;
                    this.logDebug(Messages.getString("InsertUpdate.Log.FieldHasDataNumbers", this.meta.getUpdateStream()[i]) + this.data.valuenrs[i]);
                }
                this.setLookup(this.getInputRowMeta());
                this.data.insertRowMeta = new RowMeta();
                for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
                    ValueMetaInterface insValue = this.data.insertRowMeta.searchValueMeta(this.meta.getUpdateLookup()[i]);
                    if (insValue != null) {
                        throw new KettleStepException("The same column can't be inserted into the target row twice: " + insValue.getName());
                    }
                    ValueMetaInterface insertValue = this.getInputRowMeta().searchValueMeta(this.meta.getUpdateStream()[i]).clone();
                    insertValue.setName(this.meta.getUpdateLookup()[i]);
                    this.data.insertRowMeta.addValueMeta(insertValue);
                }
                this.data.db.prepareInsert(this.data.insertRowMeta, this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
                if (!this.meta.isUpdateBypassed()) {
                    ArrayList<String> updateColumns = new ArrayList<String>();
                    for (int i2 = 0; i2 < this.meta.getUpdate().length; ++i2) {
                        if (!this.meta.getUpdate()[i2].booleanValue()) continue;
                        updateColumns.add(this.meta.getUpdateLookup()[i2]);
                    }
                    this.prepareUpdate(this.getInputRowMeta());
                }
            }
            try {
                this.lookupValues(this.getInputRowMeta(), r);
                this.putRow(this.data.outputRowMeta, r);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(Messages.getString("InsertUpdate.Log.LineNumber") + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    throw new KettleStepException(Messages.getString("InsertUpdate.Log.ErrorInStep"), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block16;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "ISU001");
            }
        }
        return true;
    }

    public void setLookup(RowMetaInterface rowMeta) throws KettleDatabaseException {
        int i;
        this.data.lookupParameterRowMeta = new RowMeta();
        this.data.lookupReturnRowMeta = new RowMeta();
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        String sql = "SELECT ";
        for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
            if (i != 0) {
                sql = sql + ", ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getUpdateLookup()[i]);
            this.data.lookupReturnRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getUpdateStream()[i]).clone());
        }
        sql = sql + " FROM " + this.data.schemaTable + " WHERE ";
        for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + " AND ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
                continue;
            }
            if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ";
                continue;
            }
            sql = sql + " " + this.meta.getKeyCondition()[i] + " ? ";
            this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
        }
        try {
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Setting preparedStatement to [" + sql + "]", new Object[0]);
            }
            this.data.prepStatementLookup = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]", (Throwable)ex);
        }
    }

    public void prepareUpdate(RowMetaInterface rowMeta) throws KettleDatabaseException {
        int i;
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        this.data.updateParameterRowMeta = new RowMeta();
        String sql = "UPDATE " + this.data.schemaTable + Const.CR;
        sql = sql + "SET ";
        boolean comma = false;
        for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
            if (!this.meta.getUpdate()[i].booleanValue()) continue;
            if (comma) {
                sql = sql + ",   ";
            } else {
                comma = true;
            }
            sql = sql + databaseMeta.quoteField(this.meta.getUpdateLookup()[i]);
            sql = sql + " = ?" + Const.CR;
            this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getUpdateStream()[i]).clone());
        }
        sql = sql + "WHERE ";
        for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
                continue;
            }
            if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ";
                continue;
            }
            sql = sql + " " + this.meta.getKeyCondition()[i] + " ? ";
            this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]).clone());
        }
        try {
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Setting update preparedStatement to [" + sql + "]", new Object[0]);
            }
            this.data.prepStatementUpdate = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (InsertUpdateMeta)smi;
        this.data = (InsertUpdateData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.db = new Database(this.meta.getDatabaseMeta());
                this.data.db.shareVariablesWith((VariableSpace)this);
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                this.data.db.setCommit(this.meta.getCommitSize());
                return true;
            }
            catch (KettleException ke) {
                this.logError(Messages.getString("InsertUpdate.Log.ErrorOccurredDuringStepInitialize") + ke.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        block9: {
            this.meta = (InsertUpdateMeta)smi;
            this.data = (InsertUpdateData)sdi;
            try {
                try {
                    if (!this.data.db.isAutoCommit()) {
                        if (this.getErrors() == 0L) {
                            this.data.db.commit();
                        } else {
                            this.data.db.rollback();
                        }
                    }
                    this.data.db.closeUpdate();
                    this.data.db.closeInsert();
                }
                catch (KettleDatabaseException e) {
                    this.log.logError(this.toString(), Messages.getString("InsertUpdate.Log.UnableToCommitConnection") + e.toString(), new Object[0]);
                    this.setErrors(1L);
                    Object var5_4 = null;
                    if (this.data.db != null) {
                        this.data.db.disconnect();
                    }
                    break block9;
                }
                Object var5_3 = null;
                if (this.data.db == null) break block9;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.data.db != null) {
                    this.data.db.disconnect();
                }
                throw throwable;
            }
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

