untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQxbWNVpFYTNrLrAxKx17f7US9vawpLjjUiY/E++5Z13yS6jCAZAKPsFjKXn1g5Hdfu/D347DoZDC/bU076KczAc=

OpenBSD 6.0 errata 033, August 3, 2017:

With an invalid address family, tcp_usrreq() may take an unintended code path.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 033_tcp_usrreq.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/netinet/tcp_usrreq.c
===================================================================
RCS file: /cvs/src/sys/netinet/tcp_usrreq.c,v
--- sys/netinet/tcp_usrreq.c	20 Jul 2016 19:57:53 -0000	1.134
+++ sys/netinet/tcp_usrreq.c	2 Aug 2017 16:37:39 -0000
@@ -258,9 +258,9 @@ tcp_usrreq(so, req, m, nam, control, p)
 			}
 
 			error = in6_pcbconnect(inp, nam);
-		} else if (sin->sin_family == AF_INET)
+		} else
 #endif /* INET6 */
-		{
+		if (sin->sin_family == AF_INET) {
 			if ((sin->sin_addr.s_addr == INADDR_ANY) ||
 			    (sin->sin_addr.s_addr == INADDR_BROADCAST) ||
 			    IN_MULTICAST(sin->sin_addr.s_addr) ||
@@ -270,6 +270,8 @@ tcp_usrreq(so, req, m, nam, control, p)
 			}
 
 			error = in_pcbconnect(inp, nam);
+		} else {
+			error = EAFNOSUPPORT;
 		}
 
 		if (error)
