untrusted comment: signature from openbsd 5.6 base private key
RWR0EANmo9nqhvXkW6wx7c6sxsPMnVwvuPZx77inMe50GBWlyvEGH4nVwPSBovwqbLy79DVjf2va3ZvjRrZ3gUEzUNH/EPuEjQo=

OpenBSD 5.6 errata 11, Dec 5, 2014:

An incorrect memcpy call would result in corrupted MAC addresses when
using PPPOE.

Apply patch using:

    signify -Vep /etc/signify/openbsd-56-base.pub -x 011_pppoe.patch.sig \
        -m - | (cd /usr/src && patch -p0)

Then build and install a new kernel.

Index: sys/net/if_ethersubr.c
===================================================================
RCS file: /cvs/src/sys/net/if_ethersubr.c,v
retrieving revision 1.174
diff -u -p -r1.174 if_ethersubr.c
--- sys/net/if_ethersubr.c	12 Jul 2014 18:44:22 -0000	1.174
+++ sys/net/if_ethersubr.c	1 Dec 2014 17:48:55 -0000
@@ -673,7 +673,12 @@ decapsulate:
 			goto done;
 
 		eh_tmp = mtod(m, struct ether_header *);
-		memcpy(eh_tmp, eh, sizeof(struct ether_header));
+		/*
+		 * danger!
+		 * eh_tmp and eh may overlap because eh
+		 * is stolen from the mbuf above.
+		 */
+		memmove(eh_tmp, eh, sizeof(struct ether_header));
 #ifdef PIPEX
 		if (pipex_enable) {
 			struct pipex_session *session;
