
/*  A Bison parser, made from /Users/ahunter/prog/zoom/obj/src/../../src/rc_parse.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	DEFAULT	257
#define	INTERPRETER	258
#define	REVISION	259
#define	FONT	260
#define	COLOURS	261
#define	GAME	262
#define	ROMAN	263
#define	BOLD	264
#define	ITALIC	265
#define	FIXED	266
#define	SYMBOLIC	267
#define	GAMEDIR	268
#define	SAVEDIR	269
#define	SOUNDS	270
#define	GRAPHICS	271
#define	SIZE	272
#define	ANTIALIAS	273
#define	YES	274
#define	NO	275
#define	GAMEID	276
#define	NUMBER	277
#define	STRING	278
#define	CHARACTER	279

#line 1 "rc_parse.y"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../config.h"
#include "zmachine.h"
#include "rc.h"
#include "rcp.h"
#include "hash.h"

#define YYERROR_VERBOSE 1

extern int _rc_line;
extern hash rc_hash;

extern void rc_error(char*);
extern int  rc_lex(void);

int rc_merging = 0;

#define EMPTY_GAME(x) x.fg_col = -1; x.bg_col = -1; x.interpreter = -1; x.revision = -1; x.name = NULL; x.fonts = NULL; x.n_fonts = -1; x.colours = NULL; x.n_colours = -1; x.gamedir = x.savedir = x.sounds = x.graphics = NULL; x.xsize = x.ysize = -1; x.antialias = -1;

static inline rc_game merge_games(const rc_game* a, const rc_game* b)
{
  rc_game r;

  if (a->fg_col == -1)
	r.fg_col = b->fg_col;
  else
    r.fg_col = a->fg_col;
  if (a->bg_col == -1)
	r.bg_col = b->bg_col;
  else
    r.bg_col = a->bg_col;

  if (a->interpreter == -1)
    r.interpreter = b->interpreter;
  else
    r.interpreter = a->interpreter;

  if (a->antialias == -1)
    r.antialias = b->antialias;
  else
    r.antialias = a->antialias;

  if (a->revision == -1)
    r.revision = b->revision;
  else
    r.revision = a->revision;

  if (a->name == NULL)
    r.name = b->name;
  else
    r.name = a->name;

  if (a->fonts == NULL)
    {
      r.fonts = b->fonts;
      r.n_fonts = b->n_fonts;
    }
  else if (b->fonts == NULL)
    {
      r.fonts = a->fonts;
      r.n_fonts = a->n_fonts;
    }
  else
    {
      int x;

      r.n_fonts = a->n_fonts + b->n_fonts;
      r.fonts = malloc(r.n_fonts*sizeof(rc_font));
      
      for (x=0; x<a->n_fonts; x++)
      	r.fonts[x] = a->fonts[x];
      for (x=0; x<b->n_fonts; x++)
        r.fonts[x+a->n_fonts] = b->fonts[x];

      free(a->fonts);
      free(b->fonts);
    }

  if (a->colours == NULL)
    {
      r.colours   = b->colours;
      r.n_colours = b->n_colours;
    }
  else if (b->colours == NULL)
    {
      r.colours   = a->colours;
      r.n_colours = a->n_colours;      
    }
  else
    rc_error("Can only have one set of colours per block");

  if (a->gamedir == NULL)
    r.gamedir = b->gamedir;
  else
    r.gamedir = a->gamedir;

  if (a->savedir == NULL)
    r.savedir = b->savedir;
  else
    r.savedir = a->savedir;

  if (a->sounds == NULL)
    r.sounds = b->sounds;
  else
    r.sounds = a->sounds;
  if (a->graphics == NULL)
    r.graphics = b->graphics;
  else
    r.graphics = a->graphics;

  if (a->xsize == -1)
    r.xsize = b->xsize;
  else
    r.xsize = a->xsize;
  if (a->ysize == -1)
    r.ysize = b->ysize;
  else
    r.ysize = a->ysize;
  
  return r;
}

#line 128 "rc_parse.y"
typedef union {
  char*       str;
  int         num;
  char        chr;

  rc_font     font;
  rc_game     game;
  rc_colour   col;
  stringlist* slist;
} YYSTYPE;
#line 176 "rc_parse.y"

static int check_collision(char* ourid, char* name)
{
  rc_game* game;

  game = hash_get(rc_hash, ourid, strlen(ourid));
  if (game != NULL && strcmp(name, game->name) != 0)
    {
      if (!rc_merging)
	zmachine_info("Namespace collision: identifier '%s' (for game '%s') already used for game '%s'", ourid, name, game->name);
      return 0;
    }

  return 1;
}
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		76
#define	YYFLAG		-32768
#define	YYNTBASE	32

#define YYTRANSLATE(x) ((unsigned)(x) <= 279 ? yytranslate[x] : 47)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    30,
    31,     2,     2,    28,    29,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    26,     2,    27,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     5,     9,    12,    16,    21,    25,    28,    31,
    35,    37,    40,    42,    44,    47,    50,    53,    58,    61,
    64,    67,    70,    73,    78,    80,    84,    86,    90,    92,
    94,    96,    98,   100,   102,   106,   114,   116,   118,   120,
   122,   126
};

static const short yyrhs[] = {    33,
     0,    32,    33,     0,     3,    24,    34,     0,     3,    34,
     0,     8,    24,    43,     0,     8,    24,    43,    34,     0,
    26,    35,    27,     0,    26,    27,     0,    26,    46,     0,
    26,    35,    46,     0,    37,     0,    35,    37,     0,    20,
     0,    21,     0,     4,    23,     0,    19,    36,     0,     5,
    25,     0,     6,    23,    24,    38,     0,     7,    41,     0,
    14,    24,     0,    15,    24,     0,    16,    24,     0,    17,
    24,     0,    18,    23,    28,    23,     0,    39,     0,    38,
    28,    39,     0,    40,     0,    39,    29,    40,     0,     9,
     0,    10,     0,    11,     0,    12,     0,    13,     0,    42,
     0,    41,    28,    42,     0,    30,    23,    28,    23,    28,
    23,    31,     0,    45,     0,    44,     0,    46,     0,    22,
     0,    43,    28,    22,     0,     1,    27,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   195,   196,   199,   214,   230,   259,   290,   294,   298,   304,
   313,   314,   320,   321,   324,   329,   334,   339,   349,   353,
   358,   363,   368,   373,   381,   388,   396,   400,   406,   407,
   408,   409,   410,   413,   420,   430,   438,   439,   443,   447,
   453,   468
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","DEFAULT",
"INTERPRETER","REVISION","FONT","COLOURS","GAME","ROMAN","BOLD","ITALIC","FIXED",
"SYMBOLIC","GAMEDIR","SAVEDIR","SOUNDS","GRAPHICS","SIZE","ANTIALIAS","YES",
"NO","GAMEID","NUMBER","STRING","CHARACTER","'{'","'}'","','","'-'","'('","')'",
"RCFile","RCDefn","RCBlock","RCOptionList","YesOrNo","RCOption","FontType","FontDefn",
"FontQual","ColourList","ColourDefn","RevisionList","BadRevisionList","GoodRevisionList",
"ErrorList", NULL
};
#endif

static const short yyr1[] = {     0,
    32,    32,    33,    33,    33,    33,    34,    34,    34,    34,
    35,    35,    36,    36,    37,    37,    37,    37,    37,    37,
    37,    37,    37,    37,    38,    38,    39,    39,    40,    40,
    40,    40,    40,    41,    41,    42,    43,    43,    44,    45,
    45,    46
};

static const short yyr2[] = {     0,
     1,     2,     3,     2,     3,     4,     3,     2,     2,     3,
     1,     2,     1,     1,     2,     2,     2,     4,     2,     2,
     2,     2,     2,     4,     1,     3,     1,     3,     1,     1,
     1,     1,     1,     1,     3,     7,     1,     1,     1,     1,
     3,     2
};

static const short yydefact[] = {     0,
     0,     0,     0,     1,     0,     0,     4,     0,     2,     3,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     8,     0,    11,     9,    40,     5,    38,    37,    39,
    42,    15,    17,     0,     0,    19,    34,    20,    21,    22,
    23,     0,    13,    14,    16,     7,    12,    10,     0,     6,
     0,     0,     0,     0,    41,    29,    30,    31,    32,    33,
    18,    25,    27,     0,    35,    24,     0,     0,     0,    26,
    28,     0,     0,    36,     0,     0
};

static const short yydefgoto[] = {     3,
     4,     7,    23,    45,    24,    61,    62,    63,    36,    37,
    27,    28,    29,    25
};

static const short yypact[] = {    36,
   -16,   -13,    38,-32768,    -6,    -1,-32768,     8,-32768,-32768,
     1,    -2,     6,    20,    17,    29,    30,    31,    32,    34,
   -19,-32768,    18,-32768,-32768,-32768,    14,-32768,-32768,-32768,
-32768,-32768,-32768,    35,    37,    33,-32768,-32768,-32768,-32768,
-32768,    40,-32768,-32768,-32768,-32768,-32768,-32768,    41,-32768,
    39,    42,    17,    43,-32768,-32768,-32768,-32768,-32768,-32768,
    44,    45,-32768,    46,-32768,-32768,    39,    39,    47,    45,
-32768,    48,    27,-32768,    62,-32768
};

static const short yypgoto[] = {-32768,
    61,     2,-32768,-32768,    50,-32768,     0,    -3,-32768,    23,
-32768,-32768,-32768,     4
};


#define	YYLAST		76


static const short yytable[] = {    11,
    43,    44,    12,    13,    14,    15,    10,     5,    11,     6,
     8,    30,    16,    17,    18,    19,    20,    21,    11,     6,
    32,    12,    13,    14,    15,    22,    48,    31,    50,    26,
    33,    16,    17,    18,    19,    20,    21,    75,     1,     6,
     1,    49,    34,     2,    46,     2,    35,    56,    57,    58,
    59,    60,    38,    39,    40,    41,    42,    74,    51,    52,
    53,    76,    55,     9,    71,    66,    70,    54,    69,    64,
    73,    67,    47,    68,    72,    65
};

static const short yycheck[] = {     1,
    20,    21,     4,     5,     6,     7,     5,    24,     1,    26,
    24,     8,    14,    15,    16,    17,    18,    19,     1,    26,
    23,     4,     5,     6,     7,    27,    23,    27,    27,    22,
    25,    14,    15,    16,    17,    18,    19,     0,     3,    26,
     3,    28,    23,     8,    27,     8,    30,     9,    10,    11,
    12,    13,    24,    24,    24,    24,    23,    31,    24,    23,
    28,     0,    22,     3,    68,    23,    67,    28,    23,    28,
    23,    28,    23,    29,    28,    53
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 3:
#line 200 "rc_parse.y"
{
		      rc_game* game;

		      if (!rc_merging)
			{
			  game = malloc(sizeof(rc_game));
			  *game = yyvsp[0].game;
			  game->name = yyvsp[-1].str;
			  hash_store(rc_hash,
				     (unsigned char*)"default",
				     7,
				     game);
			}
		    ;
    break;}
case 4:
#line 215 "rc_parse.y"
{
		      rc_game* game;

		      if (!rc_merging)
			{
			  game = malloc(sizeof(rc_game));
			  *game = yyvsp[0].game;
			  game->name = "%s";
			  hash_store(rc_hash,
				     (unsigned char*)"default",
				     7,
				     game);
			}

		    ;
    break;}
case 5:
#line 231 "rc_parse.y"
{
		      if (yyvsp[0].slist != NULL)
		        {
		          rc_game* game;
		          stringlist* next;

		          game = malloc(sizeof(rc_game));
		          EMPTY_GAME((*game));
		          game->name = yyvsp[-1].str;

		          next = yyvsp[0].slist;
		          while (next != NULL)
		            {
			      if (check_collision(next->string, game->name))
			        {
			          hash_store(rc_hash,
					     (unsigned char*)next->string,
					     strlen(next->string),
					     game);
			        }
			      next = next->next;
	                    }
			}
		      else
		        {
		          zmachine_info(".zoomrc has erroneous entry for game '%s' (line %i)", yyvsp[-1].str, _rc_line);
			}
		    ;
    break;}
case 6:
#line 260 "rc_parse.y"
{
		      if (yyvsp[-1].slist != NULL)
		        {
		          rc_game* game;
		          stringlist* next;

		          game = malloc(sizeof(rc_game));
		          *game = yyvsp[0].game;
		          game->name = yyvsp[-2].str;

		          next = yyvsp[-1].slist;
		          while (next != NULL)
		            {
			      if (check_collision(next->string, game->name))
			        {
			          hash_store(rc_hash,
					     (unsigned char*)next->string,
					     strlen(next->string),
					     game);
			        }
			      next = next->next;
	                    }
		        }
		      else
		        {
		          zmachine_info(".zoomrc has erroneous entry for game '%s' (line %i)", yyvsp[-2].str, _rc_line);
			}
		    ;
    break;}
case 7:
#line 291 "rc_parse.y"
{
		      yyval.game = yyvsp[-1].game;
		    ;
    break;}
case 8:
#line 295 "rc_parse.y"
{
		      EMPTY_GAME(yyval.game);
                    ;
    break;}
case 9:
#line 299 "rc_parse.y"
{
		      yyerrok;
		      zmachine_info(".zoomrc options block ending at line %i makes no sense", _rc_line);
		      EMPTY_GAME(yyval.game);
		    ;
    break;}
case 10:
#line 305 "rc_parse.y"
{
		      yyerrok;
		      yyval.game = yyvsp[-1].game;

		      zmachine_info(".zoomrc options block at line %i has syntax errors", _rc_line);
		    ;
    break;}
case 12:
#line 315 "rc_parse.y"
{
		      yyval.game = merge_games(&yyvsp[-1].game, &yyvsp[0].game);
		    ;
    break;}
case 13:
#line 320 "rc_parse.y"
{ yyval.num = 1; ;
    break;}
case 14:
#line 321 "rc_parse.y"
{ yyval.num = 0; ;
    break;}
case 15:
#line 325 "rc_parse.y"
{
		      EMPTY_GAME(yyval.game);
		      yyval.game.interpreter = yyvsp[0].num;
		    ;
    break;}
case 16:
#line 330 "rc_parse.y"
{
		      EMPTY_GAME(yyval.game);
		      yyval.game.antialias = yyvsp[0].num;
		    ;
    break;}
case 17:
#line 335 "rc_parse.y"
{
		      EMPTY_GAME(yyval.game);
		      yyval.game.revision = yyvsp[0].chr;
		    ;
    break;}
case 18:
#line 340 "rc_parse.y"
{
		      EMPTY_GAME(yyval.game);
		      yyval.game.fonts = malloc(sizeof(rc_font));
		      yyval.game.n_fonts = 1;
		      yyval.game.fonts[0] = yyvsp[0].font;

		      yyval.game.fonts[0].name = yyvsp[-1].str;
		      yyval.game.fonts[0].num  = yyvsp[-2].num;
		    ;
    break;}
case 19:
#line 350 "rc_parse.y"
{
		      yyval.game = yyvsp[0].game;
		    ;
    break;}
case 20:
#line 354 "rc_parse.y"
{
		      EMPTY_GAME(yyval.game);
		      yyval.game.gamedir = yyvsp[0].str;
		    ;
    break;}
case 21:
#line 359 "rc_parse.y"
{
		      EMPTY_GAME(yyval.game);
		      yyval.game.savedir = yyvsp[0].str;
		    ;
    break;}
case 22:
#line 364 "rc_parse.y"
{
		      EMPTY_GAME(yyval.game);
		      yyval.game.sounds = yyvsp[0].str;
		    ;
    break;}
case 23:
#line 369 "rc_parse.y"
{
		      EMPTY_GAME(yyval.game);
		      yyval.game.graphics = yyvsp[0].str;
		    ;
    break;}
case 24:
#line 374 "rc_parse.y"
{
		      EMPTY_GAME(yyval.game);
		      yyval.game.xsize = yyvsp[-2].num;
		      yyval.game.ysize = yyvsp[0].num;
		    ;
    break;}
case 25:
#line 382 "rc_parse.y"
{
		      yyval.font.name = NULL;
		      yyval.font.attributes[0] = yyvsp[0].num;
		      yyval.font.n_attr = 1;
		      yyval.font.num = 0;
		    ;
    break;}
case 26:
#line 389 "rc_parse.y"
{
		      yyval.font = yyvsp[-2].font;
		      yyval.font.n_attr++;
		      yyval.font.attributes[yyval.font.n_attr-1] = yyvsp[0].num;
		    ;
    break;}
case 27:
#line 397 "rc_parse.y"
{
		      yyval.num = yyvsp[0].num;
		    ;
    break;}
case 28:
#line 401 "rc_parse.y"
{
		      yyval.num = yyvsp[-2].num|yyvsp[0].num;
		    ;
    break;}
case 29:
#line 406 "rc_parse.y"
{ yyval.num = 0; ;
    break;}
case 30:
#line 407 "rc_parse.y"
{ yyval.num = 1; ;
    break;}
case 31:
#line 408 "rc_parse.y"
{ yyval.num = 2; ;
    break;}
case 32:
#line 409 "rc_parse.y"
{ yyval.num = 4; ;
    break;}
case 33:
#line 410 "rc_parse.y"
{ yyval.num = 8; ;
    break;}
case 34:
#line 414 "rc_parse.y"
{
		      EMPTY_GAME(yyval.game);
		      yyval.game.colours = malloc(sizeof(rc_colour));
		      yyval.game.colours[0] = yyvsp[0].col;
		      yyval.game.n_colours = 1;
		    ;
    break;}
case 35:
#line 421 "rc_parse.y"
{
		      yyval.game = yyvsp[-2].game;
		      yyval.game.n_colours++;
		      yyval.game.colours = realloc(yyval.game.colours, 
				           sizeof(rc_colour)*yyval.game.n_colours);
		      yyval.game.colours[yyval.game.n_colours-1]=yyvsp[0].col;
		    ;
    break;}
case 36:
#line 431 "rc_parse.y"
{
		      yyval.col.r = yyvsp[-5].num&0xff;
		      yyval.col.g = yyvsp[-3].num&0xff;
		      yyval.col.b = yyvsp[-1].num&0xff;
		    ;
    break;}
case 38:
#line 440 "rc_parse.y"
{ yyval.slist = NULL; ;
    break;}
case 39:
#line 444 "rc_parse.y"
{ yyerrok; ;
    break;}
case 40:
#line 448 "rc_parse.y"
{
		      yyval.slist = malloc(sizeof(stringlist));
		      yyval.slist->next = NULL;
		      yyval.slist->string = yyvsp[0].str;
		    ;
    break;}
case 41:
#line 454 "rc_parse.y"
{
		      if (yyvsp[-2].slist == NULL)
		        {
		          yyval.slist = NULL;
			}
	              else
		        {
		          yyval.slist = malloc(sizeof(stringlist));
		          yyval.slist->next = yyvsp[-2].slist;
		          yyval.slist->string = yyvsp[0].str;
			}
		    ;
    break;}
case 42:
#line 468 "rc_parse.y"
{ yyerrok; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 471 "rc_parse.y"

