/* (c) Copyright 2001, 2002, 2003, 2004, 2005, 2006 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdarg.h>

#include "key.h"
#include "dict.h"
#include "sink.h"
#include "read.h"
#include "util.h"

#include "util/ting.h"
#include "util/io.h"
#include "util/minmax.h"
#include "util/types.h"
#include "util/array.h"
#include "util/hash.h"

/*
,  __$args__
,  __$xargs__

!  __sysval__
!  __zoemput__
!  __zoemstat__
*/

const char *strSession[]
=
{  "\\$__args__       (local to env) key/value pairs given to \\begin#2"
,  "\\$__xargs__      (local to env) key/value pairs given to \\begin#2, expanded"
,  "\\__device__     name of device (given by -d)"
,  "\\__fnbase__     base name of entry file (given by -i/-I)"
,  "\\__fnentry__    name of entry file (given by -i/-I)"
,  "\\__fnin__       name of current input file"
,  "\\__fnout__      name of current output file"
,  "\\__fnpath__     path component of entry file (given by -i/-I)"
,  "\\__fnwrite__    arg1 to \\write#3, accessible in arg3 scope"
,  "\\__lc__         expands to a left curly (only for magic)"
,  "\\__line__       index of current input line"
,  "\\__parmode__    paragraph slurping mode for interactive sessions"
,  "\\__rc__         expands to a right curly (only for magic)"
,  "\\__searchpath__ search path for macro packages (e.g. man.zmm)"
,  "\\__split__      user space toggle for chapter mode indicator"
,  "\\__sysval__     exit status of last system command"
,  "\\__version__    version of zoem, formatted as e.g. 2003, 2004-010"
,  "\\__zoemput__    result text of last \\try#1 key"
,  "\\__zoemstat__   status of last \\try#1 key"

,  NULL
}  ;


dictStack* usrstack = NULL;


mcxstatus usrDictPop
(  const char* label
)
   {  return dictStackPop(usrstack, "user", label)
;  }

mcxstatus usrDictPush
(  const char* label
)
   {  return dictStackPush(usrstack, 16, label)
;  }


void yamKeyList
(  const char* mode
)
   {  mcxbool listAll = strstr(mode, "all") != NULL
   ;  if (listAll || strstr(mode, "session"))  
      {  int m
      ;  fputs("\nPredefined session variables\n", stdout)
      ;  for (m=0;strSession[m];m++)
         fprintf(stdout, "%s\n", strSession[m])
   ;  }
;  }


void  yamKeySet
(  const char* key
,  const char* val
)
   {  mcxTing*  keytxt   =  mcxTingNew(key)

   ;  if (yamKeyInsert(keytxt, val) != keytxt)
      mcxTingFree(&keytxt)
;  }


void  yamKeyDef
(  const char* key
,  const char* val
)
   {  mcxTing*  keytxt   =  mcxTingNew(key)

   ;  if (yamKeyInsert(keytxt, val) != keytxt)
      {  yamErr("yamKeyDef", "overwriting key <%s>", keytxt->str)
      ;  mcxTingFree(&keytxt)
   ;  }
   }


mcxTing* yamKeyInsert
(  mcxTing*        key
,  const char*    valstr
)
   {  keyDict *dict  = key->str[0] == '$' ? sinkGetDLRtop() : usrstack->top
   ;  mcxKV* kv   =  mcxHashSearch
                     (  key
                     ,  dict->table
                     ,  MCX_DATUM_INSERT
                     )
   ;  if (!kv)
         yamErr("yamKeyInsert", "panic&|PBD cannot insert key")
      ,  mcxExit(1)

   ;  else
      {  if (kv->val)
         mcxTingWrite((mcxTing*) (kv->val), valstr)
      ;  else
         kv->val     =  mcxTingNew(valstr)
   ;  }

      return (mcxTing*) kv->key
;  }


mcxbool yamKeyDeletex
(  const char* key
)
   {  mcxTing* tg = mcxTingNew(key)
   ;  mcxTing* deletee = yamKeyDelete(tg)
   ;  mcxbool  found = deletee ? TRUE : FALSE
   ;  mcxTingFree(&tg)
   ;  mcxTingFree(&deletee)
   ;  return found
;  }


mcxTing* yamKeyDelete
(  mcxTing*  key
)
   {  keyDict *dict  = key->str[0] == '$' ? sinkGetDLRtop() : usrstack->top
   ;  mcxKV*   kv
            =  (mcxKV*) mcxHashSearch
               (  key
               ,  dict->table
               ,  MCX_DATUM_DELETE
               )
   ;  if (kv)
      {  mcxTing* val = (mcxTing*) kv->val
      ;  mcxTing* key = (mcxTing*) kv->key
      ;  mcxTingFree(&key)
      ;  return val
   ;  }
      return NULL
;  }


mcxTing* yamKeyGetLocal
(  mcxTing*  key
)
   {  keyDict *dict  = *(key->str) == '$' ? sinkGetDLRtop() : usrstack->top
   ;  mcxKV*   kv
      =  (mcxKV*) mcxHashSearch
         (  key
         ,  dict->table
         ,  MCX_DATUM_FIND
         )
   ;  if (kv)
      return (mcxTing*) kv->val
   ;  return NULL
;  }


mcxTing* yamKeyGet
(  mcxTing*  key
)
   {  keyDict *dict =      (unsigned char) key->str[0] == '$'
                        ?  sinkGetDLRtop()
                        :  usrstack->top
   ;  mcxKV* kv

   ;  while (dict)
      {  if ((kv = mcxHashSearch(key, dict->table, MCX_DATUM_FIND)))
         return (mcxTing*) kv->val
      ;  dict = dict->down
   ;  }

      if ((unsigned char) key->str[0] == '$')
      {  dict = sinkGetDLRdefault()
      ;  while (dict)
         {  if ((kv = mcxHashSearch(key, dict->table, MCX_DATUM_FIND)))
            return (mcxTing*) kv->val
         ;  dict = dict->down
      ;  }
      }

      return NULL
;  }


void mod_key_exit
(  void
)
   {  dictStackFree(&usrstack)
;  }


void mod_key_init
(  int dict_size
)
   {  usrstack = dictStackNew(dict_size, 100)
;  }


void yamKeyStats
(  void
)
   {  mcxHashStats(stdout, usrstack->bottom->table)
;  }



void keyULimit
(  int   user
,  int   dollar
)
   {  if (user >= 0)
      usrstack->N_dict = user
;  }

