/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#include <stdarg.h>

#include "segment.h"
#include "key.h"
#include "ops.h"
#include "file.h"
#include "digest.h"
#include "parse.h"

#include "util/ting.h"
#include "util/err.h"
#include "util/hash.h"
#include "util/types.h"
#include "util/io.h"


static FILE* fperr = NULL;
static u32 (*tinghash_g)(const void* str) = mcxTingDPhash;

mcxstatus yamHashFie
(  const char* id
)
   {  if (!(tinghash_g = mcxTingHFieByName(id)))
      return STATUS_FAIL
   ;  return STATUS_OK
;  }


mcxHash* yamHashNew
(  int n
)
   {  return mcxHashNew(n, tinghash_g, mcxTingCmp)
;  }


void yamErrorFile
(  FILE* fp
)
   {  fperr = fp
;  }


void yamStats
(  void
)
   {  fprintf(stdout, "Zoem user table stats\n")
   ;  yamKeyStats()
   ;  fprintf(stdout, "Zoem primitive table stats\n")
   ;  yamOpsStats()
   ;  fprintf(stdout, "Scratch lengths\n")
   ;  yamScratchStats()
;  }


void  yam_err_
(  const char  *caller
,  const char  *fmt
,  va_list     *args
)
   {  const char* fname = yamInputGetName()
   ;  if (*fname)
      mcxErrf
      (  stderr
      ,  "zoem"
      ,  "error around input line <%d> in <%s>"
      ,  yamInputGetLc()
      ,  fname
      )
   ;  else
      mcxErrf
      (  stderr
      ,  "zoem"
      ,  "error occurred"
      )
   ;  if (key_g->str)
      mcxErrf(stderr, NULL, "last key seen is <%s>", key_g->str)

   ;  fprintf(stderr, "___ [%s] ", caller)
   ;  vfprintf(stderr, fmt, *args)
   ;  fprintf(stderr, "\n")
;  }


void  yamExit
(  const char  *caller
,  const char  *fmt
,  ...
)
   {  va_list  args
   ;  mcxTing* txt

   ;  if (caller)
      {  va_start(args, fmt)
      ;  yam_err_(caller, fmt, &args)
      ;  va_end(args)
   ;  }
      else
      {  txt = mcxTingNew("\\zinsert{stdia}")
      ;  fprintf(stdout, "\n")
      ;  yamOutput(txt, ZOEM_FILTER_DEFAULT, NULL)  
   ;  }

      mcxExit(1)
;  }


void  yamErr
(  const char  *caller
,  const char  *fmt
,  ...
)
   {  va_list  args

   ;  va_start(args, fmt)
   ;  yam_err_(caller, fmt, &args)
   ;  va_end(args)
;  }



