/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_read_h__
#define zoem_read_h__

#include "util/io.h"
#include "util/hash.h"

#define READ_MASKING 1
#define READ_ESCAPE 2

mcxTing*  yamReadData
(  mcxIO          *xf
,  mcxTing        *filetxt
)  ;

mcxTing* yamProtect
(  mcxTing* data
)  ;
void  yamUnprotect
(  mcxTing* data
)  ;

mcxbool yamInlineFile
(  mcxTing* fname
,  mcxTing* filetxt
)  ;


mcxTing* yamSystem
(  char* cmd
,  char* argv[]
,  mcxTing* data
)  ;


/*
 *    if file can not be opened, sets filetxt->str to empty string
 *    and return STATUS_FAIL
*/

mcxstatus yamReadFile
(  mcxTing*  fname
,  mcxTing*  filetxt
,  mcxbool   useSearchPath
)  ;


void yamReadExit
(  void
)  ;

#endif

