/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>

#include "filter.h"
#include "util.h"
#include "entry.h"
#include "key.h"
#include "file.h"

#include "util/hash.h"
#include "util/ting.h"
#include "util/types.h"
#include "util/io.h"


typedef struct
{
   mcxTing*          fname
;  const mcxTing*    txt
;  int               linect
;
}  inputHook          ;


#define MAX_FILES_NEST 10

inputHook inputHookDir[MAX_FILES_NEST]
=   
{  {  NULL, NULL, 1 }
,  {  NULL, NULL, 1 }
,  {  NULL, NULL, 1 }
,  {  NULL, NULL, 1 }
,  {  NULL, NULL, 1 }
,  {  NULL, NULL, 1 }
,  {  NULL, NULL, 1 }
,  {  NULL, NULL, 1 }
,  {  NULL, NULL, 1 }
,  {  NULL, NULL, 1 }
}  ;

#define hd inputHookDir

static mcxHash*   wrtTable_g     =  NULL;    /* open output files */
static int        hdidx_g        =  -1;
static mcxTing*   fntxt_g        =  NULL;


void yamFileInitialize
(  int   n
)
   {  wrtTable_g  =  yamHashNew(n)
   ;  fntxt_g = mcxTingNew("__fnin__")
   ;  yamKeyInsert(fntxt_g, "_nil_")
;  }


void yamIOfree_v
(  void*    xfpp
)
   {  mcxIO* xf         =  *((mcxIO**) xfpp)
   ;  yamFilterData *fd = (yamFilterData*) xf->ufo
   ;  yamFilterDataFree(fd)
   ;  if (1)
      mcxIOfree(&xf)
;  }


void yamFileExit
(  void
)
   {  int i
   ;  mcxHashFree(&wrtTable_g, mcxTingFree_v, yamIOfree_v)
   ;  for (i=0;i<MAX_FILES_NEST;i++)
      {  mcxTing* t = hd[i].fname
      ;  if (t)
         mcxTingFree(&t)
   ;  }
;  }


mcxstatus yamInputPop
(  void
)
   {  hdidx_g--

   ;  if (hdidx_g >= 0)
      yamKeyInsert(fntxt_g, hd[hdidx_g].fname->str)

   ;  return STATUS_OK
;  }


mcxstatus yamInputPush
(  const char*       str
,  const mcxTing*    txt
)
   {  hdidx_g++

   ;  if (hdidx_g >= MAX_FILES_NEST)
      return STATUS_FAIL

   ;  hd[hdidx_g].linect   =  1
   ;  hd[hdidx_g].txt      =  txt

   ;  if (hd[hdidx_g].fname)
      mcxTingWrite(hd[hdidx_g].fname, str)
   ;  else
      hd[hdidx_g].fname    =   mcxTingNew(str)

   ;  yamKeyInsert(fntxt_g, str)

   ;  return STATUS_OK
;  }


mcxbool yamInputCanPush
(  void
)  {  return hdidx_g+1 < MAX_FILES_NEST ? TRUE : FALSE
;  }


int yamInputGetLc
(  void
)
   {  return hd[hdidx_g].linect
;  }


const char* yamInputGetName
(  void
)
   {  return hdidx_g >= 0 ? hd[hdidx_g].fname->str : ""
;  }


mcxTing* yamInputGetPath
(  void
)
   {  char* s
   ;  char* a = hdidx_g < 0 ? NULL : hd[hdidx_g].fname->str
   ;  if (!a)
      return NULL
   ;  if (!(s = strrchr(a, '/')))
      return NULL
   ;  return mcxTingNNew(a, s-a+1)
;  }


void yamInputIncrLc
(  const mcxTing* txt
,  int d
)
   {  if (!txt || hd[hdidx_g].txt == txt)
      hd[hdidx_g].linect += d
   /* case !txt is used for inline file ___jump_lc___ hack */
;  }


/* this was part of attempt to solve system#3 problems,
 * but the problem was pbb entirely due to unflushed buffers.
 * fsync does not seem totally portable.
*/
#if 0
void yamOutputFDSync
(  void
)
   {  mcxHashWalk* walk    =  mcxHashWalkNew(wrtTable_g)
   ;  mcxKV* kv
   ;  while((kv = mcxHashWalkStep(walk)))
      {  mcxIO *xf = (mcxIO*) kv->val
      ;  fsync(fileno(xf->fp))
   ;  }
   }

void yamOutputFDClose
(  void
)
   {  mcxHashWalk* walk    =  mcxHashWalkNew(wrtTable_g)
   ;  mcxKV* kv
   ;  while((kv = mcxHashWalkStep(walk)))
      {  mcxIO *xf = (mcxIO*) kv->val
      ;  close(fileno(xf->fp))
   ;  }
   }
#endif


void yamOutputClose
(  const char*  s
)
   {  mcxTing* fname = mcxTingNew(s)
   ;  mcxKV* kv = mcxHashSearch(fname, wrtTable_g, MCX_DATUM_DELETE)
   ;  mcxIO* xf = kv ? (mcxIO*) kv->val : NULL
   ;  mcxTing* fn = kv ? (mcxTing*) kv->key : NULL
   ;  if (kv)
      {  yamFilterDataFree((yamFilterData*) xf->ufo)
      ;  mcxIOfree(&xf)
      ;  mcxTingFree(&fn)
      ;  mcxKVfree(&kv)
   ;  }
      mcxTingFree(&fname)
;  }


mcxIO* yamOutputNew
(  const char*  s
)
   {  mcxIO *xf            =  NULL
   ;  mcxTing *fname       =  mcxTingNew(s)
   ;  mcxKV *kv

   ;  if (fname->len > 1024)
      {  yamErr
         (  "yamOutputNew"
         ,  "output file name expansion too <%d> long"
         ,  fname->len
         )
      ;  mcxTingFree(&fname)
      ;  return NULL
   ;  }

      kv = mcxHashSearch(fname, wrtTable_g, MCX_DATUM_FIND)

   ;  if (!kv)
      {  xf = mcxIOnew(fname->str, "w")
      ;  if (mcxIOopen(xf, RETURN_ON_FAIL) != STATUS_OK)
         {  mcxIOfree(&xf)
         ;  yamErr
            (  "yamOutputNew"
            ,  "can not open file <%s> for writing\n"
            ,  fname->str
            )
         ;  mcxTingFree(&fname)
         ;  return NULL
      ;  }

#if 0
         if (fcntl(fileno(xf->fp), F_SETFD, FD_CLOEXEC)<0)
         fprintf(stderr, "___ no cntl\n")
     /*  The above was at  one point tried to remedy system#3.
      *  That problem was pbb entirely due to unflushed buffers though.
     */
#endif

      ;  xf->ufo = yamFilterDataNew(xf->fp)
      ;  kv      = mcxHashSearch(fname, wrtTable_g, MCX_DATUM_INSERT)
      ;  kv->val = xf
   ;  }
      else
      {  xf = (mcxIO*) kv->val
      ;  mcxTingFree(&fname)
   ;  }

      yamKeySet("__fnout__", xf->fn->str)
   ;  return xf
;  }

