/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_env_h__
#define zoem_env_h__

#include "segment.h"

#include "util/ting.h"

mcxstatus yamEnvNew
(  const char* tag
,  const char* openstr
,  const char* closestr
)  ;

const char* yamEnvOpen
(  mcxTing* key
,  yamSeg*  seg
)  ;

const char* yamEnvEnd
(  const char* str
,  yamSeg*  seg
)  ;

mcxstatus yamEnvClose
(  const char* str
)  ;

void yamEnvInitialize
(  int n
)  ;

void yamEnvExit
(  void
)  ;

#endif

