/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#include "env.h"
#include "util.h"
#include "segment.h"
#include "parse.h"
#include "key.h"
#include "digest.h"

#include "util/ting.h"
#include "util/hash.h"


/* Note: the whole scopeStack thing is now disabled,
 * (in order to enable \${html}{\begin{vbt}}
 * so maybe it should be thrown away.
*/


static   mcxHash*    envTable_g        =  NULL;    /* environment keys  */

static   const char* openTags_g[10]    =  {  "__",  "$1",  "$2",  "$3"
                                          ,  "$4",  "$5",  "$6"
                                          ,  "$7",  "$8",  "$9"
                                          }  ;

static const char* n_openTags_g        =  "$0";

static const char* digits_g[10]        =  {  "0", "1", "2", "3", "4"
                                          ,  "5", "6", "7", "8", "9"
                                          }  ;

typedef struct
{
   mcxTing           *key
;  yamSeg            *seg
;
}  envScope          ;

#define     SCOPE_STACK_SIZE  32
static      envScope    scopeStack[SCOPE_STACK_SIZE];
static      int         scopeCount_g     =  0;


mcxstatus yamEnvNew
(  const char* tag
,  const char* openstr
,  const char* closestr
)
   {  mcxTing*  opentag    =  mcxTingNew(tag)
   ;  mcxTing*  closetag   =  mcxTingNew(tag)
   ;  mcxKV*   kv
   ;  mcxbool ok           =  FALSE

   ;  mcxTingAppend(closetag, "!_")

  /*
   *  scopeStack contains mcxTing key member, which is also stored
   *  in the envTable_g. First thought I could not redefine it,
   *  right now I think it is possible, because overwriting key
   *  does not change the key pointer.
  */
   ;  while(1)
      {  if (scopeCount_g)
         {  yamErr
            ("\\env#3"
            ,  "(re)define not allowed within environment\n"
               "  now within environment <%s>"
            ,  scopeStack[scopeCount_g-1].key->str
            )
         ;  break
      ;  }

         kv =  mcxHashSearch(opentag, envTable_g, MCX_DATUM_INSERT)
      ;  if (kv->key != opentag)
         {  yamErr("\\env#3", "overwriting key <%s>",opentag->str)
         ;  mcxTingFree(&opentag)
      ;  }
         if (kv->val)
         mcxTingWrite((mcxTing*) (kv->val), openstr)
      ;  else
         kv->val = mcxTingNew(openstr)

      ;  kv =  mcxHashSearch(closetag, envTable_g, MCX_DATUM_INSERT)
      ;  if (kv->key != closetag)
         mcxTingFree(&closetag)
      ;  if (kv->val)
         mcxTingWrite((mcxTing*) (kv->val), closestr)
      ;  else
         kv->val = mcxTingNew(closestr)
      ;  ok = TRUE
      ;  break
   ;  }
      return ok ? STATUS_OK : STATUS_FAIL
;  }


const char* yamEnvOpen
(  mcxTing* open
,  yamSeg*  seg
)
   {  char*    curly    =  strchr(open->str, '{')
   ;  int      lblen    =  curly ? curly - open->str : open->len
   ;  mcxTing* label    =  mcxTingNNew(open->str, lblen)

  /*  done with open  from here; open could be arg1_g
   *  this is actually quite ugly
   *  fixme
   */

   ;  mcxTing* data     =  curly ? mcxTingNew(curly) : NULL

   ;  mcxKV* kv = mcxHashSearch(label, envTable_g, MCX_DATUM_FIND)

   ;  if (data)
      {  int i, n_args
      ;  yamSeg*  argseg
      ;  if (yamDigest(data,data))
         {  mcxTingFree(&data)
         ;  yamErr
            ("\\begin#1", "arguments in env <%s> did not parse", label->str)
         ;  mcxTingFree(&label)
         ;  return NULL
      ;  }
         argseg = yamSegPush(NULL, data)
      ;  n_args = yamParseScopes(argseg, 9, 0)

      ;  for (i=1;i<=n_args;i++)
         yamKeyDef(openTags_g[i], key_and_args_g[i].str)

      ;  yamSegFree(&argseg)
      ;  mcxTingFree(&data)
      ;  yamKeyDef(n_openTags_g, digits_g[n_args])
   ;  }
      else
      yamKeyDef(n_openTags_g, digits_g[0])

   ;  if (kv)
      {  if (scopeCount_g < SCOPE_STACK_SIZE)
         {  scopeStack[scopeCount_g].seg = seg
         ;  scopeStack[scopeCount_g].key = (mcxTing*) kv->key
         ;  scopeCount_g++
         ;  mcxTingFree(&label)
         ;  return ((mcxTing*) kv->val)->str
      ;  }
         else
         {  yamErr
            (  "\\begin#1"
            ,  "no more than %d nested scopes allowed (at open request for <%s>)"
            ,  SCOPE_STACK_SIZE
            ,  label->str
            )
         ;  mcxTingFree(&label)
         ;  return NULL
      ;  }
      }
      else
      yamErr("\\begin#1", "env <%s> does not exist", label->str)

   ;  mcxTingFree(&label)
   ;  return NULL
;  }


mcxstatus yamEnvClose
(  const char* close
)
   {  char*    curly    =  strchr(close, '{')
   ;  int      lblen    =  curly ? curly - close : strlen(close)
   ;  mcxTing *label    =  mcxTingNNew(close, lblen)

   ;  if (scopeCount_g == 0)
      {  yamErr
         (  "\\end#1"
         ,  "close request for <%s> scope while at bottom"
         ,  label->str
         )
      ;  mcxTingFree(&label)
      ;  return STATUS_FAIL
   ;  }

      if
      (  scopeCount_g < SCOPE_STACK_SIZE
      && (strcmp(label->str, scopeStack[scopeCount_g-1].key->str))
      )
         /* || seg != scopeStack[scopeCount_g-1].seg
          * disabled this condition in order to allow \${html}{\begin{vbt}}
         */
      {  yamErr
         (  "\\end#1"
         ,  "close request for <%s> scope while inner scope <%s> still open"
         ,  label->str
         ,  scopeStack[scopeCount_g-1].key->str
         )
      ;  mcxTingFree(&label)
      ;  return STATUS_FAIL
   ;  }

      mcxTingFree(&label)
   ;  scopeCount_g--
   ;  return STATUS_OK
;  }


const char* yamEnvEnd
(  const char* close
,  yamSeg*  seg
)
   {  mcxTing* label =  mcxTingPrint(NULL, "%s!_", close)
   ;  mcxKV* kv      =  mcxHashSearch(label, envTable_g, MCX_DATUM_FIND)
   ;  mcxTingFree(&label)  
   ;  return kv ? ((mcxTing*) kv->val)->str : NULL
;  }


void yamEnvInitialize
(  int n
)
   {  envTable_g           =  yamHashNew(n)
;  }



void yamEnvExit
(  void
)
   {  if (scopeCount_g)
         yamErr("env", "I have <%d> open scopes", scopeCount_g)
      ,  yamErr
         (  "env"
         ,  "last opened scope <%s>"
         ,  scopeStack[scopeCount_g-1].key->str
         )
   ;  if (envTable_g)
      mcxHashFree(&envTable_g, mcxTingFree_v, mcxTingFree_v)
;  }

