/*            Copyright (C) 2001, 2002, 2003 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <unistd.h>

#include "counter.h"

#include "key.h"
#include "env.h"
#include "counter.h"
#include "ref.h"
#include "ops.h"
#include "file.h"
#include "read.h"
#include "constant.h"
#include "bind.h"
#include "iface.h"
#include "filter.h"
#include "key.h"
#include "digest.h"
#include "parse.h"
#include "util.h"
#include "version.h"
#include "../config.h"

#include "util/ting.h"
#include "util/io.h"
#include "util/types.h"
#include "util/ding.h"
#include "util/err.h"

#define STRING_h(x) #x
#define STRING(x) STRING_h(x)

int buckets_user = 400;
int buckets_zoem = 200;


/*
 *    
*/

void enter_interactive
(  void
)
   {  mcxTing* txt = mcxTingNew("\\zinsert{stdia}")
   ;  yamOutput(txt, ZOEM_FILTER_DEFAULT, NULL)
   ;  mcxTingFree(&txt)
;  }


mcxTing* make_searchpath
(  const char* zip
)
   {  mcxTing* sp   =  mcxTingNew(zip)
   ;  mcxTing* zsp  =   NULL
   ;  char *q = NULL, *p = sp->str
   ;  mcxTingTr(sp, ": \n\t\f\r", "      ", TR_SQUASH)
   ;  while (p && p<sp->str+sp->len)
      {  while (isspace(*p))
         p++
      ;  q = mcxStrChrIs(p, isspace, -1)
      ;  if (q)
         *q = '\0'
      ;  zsp = mcxTingPrintAfter(zsp, "{%s}", p)
      ;  if (q)
         *q = ' '
      ;  p = q
   ;  }
      mcxTingFree(&sp)
   ;  return zsp
;  }


/*
 *    The file IO init stuff is still slightly kludgy and ad hoc
 *    (it used to be worse) - it is somewhat split over zoem.c and entry.c
 *    The reason is that it's a bit of if-else spaghetti for deciding
 *    what to do in the presence of various combinations of (mainly)
 *    -i, -o, -e, and -E, and whether stdin/stdout arguments are present. 
 *    Remember that when none of -i, -I, -o is specified, we do
 *    interactive mode.
 *    The rest of zoem is a lot cleaner, even if zoem is a dirty language :)
*/

mcxstatus yamEntry
(  const char* sfnentry
,  const char* sfnbase
,  const char* sfnout
,  const char* sdevice
,  int         fltidx
,  mcxbits     trace_flags
,  mcxbits     entry_flags
,  mcxTing*    vars
,  mcxTing*    expr
)
   {  mcxTing*  fnentry    =  mcxTingNew(sfnentry)
   ;  mcxTing*  fnout      =  mcxTingNew(sfnout)
   ;  mcxTing*  fnbase     =  mcxTingNew(sfnbase)
   ;  const char* zip      =  STRING(ZOEMINCLUDEPATH)
   ;  mcxTing*  zsp

   ;  mcxIO *xfout
   ;  mcxTing *filetxt     =  NULL /* involved in interactive hackery */
   ;  const char* me       =  "zoem main"


   ;  if (entry_flags & ENTRY_STDIA)
      filetxt = mcxTingNew("\\zinsert{stdia}")
     /* 
      * zinsert will write something about interactive session
     */

   ;  else
      {  if (entry_flags & ENTRY_STDIN)
         fprintf(stderr, "=== reading from stdin\n")
      ;  if (entry_flags & ENTRY_STDOUT)
         fprintf(stderr, "=== writing to stdout\n")
   ;  }

      yamKeyInitialize     ( buckets_user )
   ;  yamEnvInitialize     (  20 )
   ;  yamCounterInitialize (  50 )
   ;  yamRefInitialize     (  50 )
   ;  yamOpsInitialize     ( buckets_zoem )
   ;  yamFileInitialize    (  10 )           /* sets \__fnin__ */
   ;  yamConstantInitialize(  50 )
   ;  yamFilterInitialize  (  10 )

   ;  yamParseInitialize(trace_flags)

   ;  if (trace_flags & ZOEM_TRACE_OUTPUT && (strcmp(fnout->str, "-")))
      {  FILE* fp = isatty(fileno(stdout)) ? stdout : stderr
      ;  fprintf
         (  fp
         ,  "[zoem]"
            " tracing output best done with output directed to stdout (-o -)\n"
         )
      ;  fflush(fp)
      ;  sleep(3)
   ;  }    
      else if
      (  trace_flags
      && !(trace_flags & ZOEM_TRACE_OUTPUT)
      && (!strcmp(fnout->str, "-"))
      )
      {  FILE* fp = isatty(fileno(stdout)) ? stdout : stderr
      ;  fprintf
         (  fp
         ,  "[zoem]"
            " tracing and stdout output best combined with tracing output"
            " (bit %ld)\n"
         ,  (long) ZOEM_TRACE_OUTPUT
         )
      ;  fflush(fp)
      ;  sleep(3)
   ;  }

      {  int prev = yamTracingSet(0)
      ;  yamOpsMakeComposites()
      ;  yamTracingSet(prev)
   ;  }

      yamKeyDef("__device__", *sdevice ? sdevice : "__none__")
   ;  yamKeyDef("__fnbase__", fnbase->str)
   ;  yamKeyDef("__fnentry__", fnentry->str)
   ;  yamKeyDef("__version__", zoemDateTag)
   ;  yamKeyDef("__sysval__", "0")
   ;  yamKeyDef("__lc__", "{")
   ;  yamKeyDef("__split__",  (entry_flags & ENTRY_SPLIT) ? "1" : "0")
   ;  yamKeyDef("__rc__", "}")
   ;  yamKeyDef("__parmode__", "16")

   ;  zsp = make_searchpath(zip)
   ;  yamKeyDef("__searchpath__", zsp->str)

   ;  if (vars && vars->len)
      {  char *p  = vars->str
      ;  char *r, *q
      ;  while ((q = strchr(p, '\036')))
         {  *q = '\0'
         ;  if (!(r = strchr(p, '=')))
               yamErr("init", "no <key=val> match in <%s>", p)
            ,  mcxExit(1)
         ;  *r = '\0'  
         ;  yamKeySet(p, r+1)  
         /* fixme, this could well err */
         ;  p  = q+1
      ;  }
      }

     /* this works for -e and -E (expression) options,
      * because those arguments are embedded in \write#3,
      * which issues yamOutputNew also - so \__fnout__ is always set.
     */
      if (!(entry_flags & ENTRY_EXXIT))
      {  if (!(xfout = yamOutputNew(fnout->str)))
            yamErr("init", "no output stream")
         ,  mcxExit(1)
     /*  
      *  xfout now owned by yamOutPutNew module (yamFileExit())
     */
      ;  yamFilterSetDefaults(xfout, fltidx)
   ;  }

      if (expr && (entry_flags & ENTRY_EXXIT))
      {  if (yamOutput(expr, ZOEM_FILTER_DEFAULT, NULL))
         {  mcxErr(me, "Expression: unwound on error")
         ;  if (entry_flags & ENTRY_DEBUG)
            enter_interactive()
      ;  }
      }
      else
      {  mcxstatus stat = STATUS_OK
      ;  if (expr && (stat = yamOutput(expr, ZOEM_FILTER_DEFAULT, NULL)))
         {  mcxErr(me, "Expression: unwound on error")
         ;  if (entry_flags & ENTRY_DEBUG)
            enter_interactive()
      ;  }
         if (!stat)
         {  mcxIO *xfin = mcxIOnew(fnentry->str, "r")

           /*
            *  if e.g. zoem -i - -E foo,
            *  foo gets printed only after <control D> is pressed.
            *  the reason is we are hanging out here below.
           */
         ;  if (!(entry_flags & ENTRY_EXXIT) && !filetxt)
            {  filetxt = mcxTingEmpty(NULL, 1000)
            ;  if (yamReadFile(xfin->fn, filetxt, 0) != STATUS_OK)
               {  yamErr("zoem", "Failure reading file <%s>", xfin->fn->str)
               ;  mcxExit(1)
            ;  }
               mcxIOclose(xfin)
         ;  }

         ;  yamInputPush(xfin->fn->str, filetxt)
         ;  if (yamOutput(filetxt, ZOEM_FILTER_DEFAULT, NULL))
            {  mcxErr(me, "unwound on error")
            ;  if (entry_flags & ENTRY_DEBUG)
               enter_interactive()
         ;  }
            yamInputPop()
         ;  mcxIOfree(&xfin)
      ;  }
      }

      if (trace_flags & ZOEM_TRACE_HASH)
      yamStats()

   ;  if (yamRefDangles())
      fprintf
      (stderr, ">>> There were %d undefined references\n", yamRefDangles())

   ;  yamEnvExit()
   ;  yamOpsExit()
   ;  yamKeyExit()
   ;  yamFilterExit()
   ;  yamReadExit()
   ;  yamCounterExit()
   ;  yamRefExit()
   ;  yamFileExit()
   ;  yamConstantExit()
   ;  yamParseExit()
   ;  yamDataExit()

   ;  mcxTingFree(&filetxt)
   ;  mcxTingFree(&fnbase)
   ;  mcxTingFree(&fnentry)
   ;  mcxTingFree(&fnout)
   ;  mcxTingFree(&zsp)
   ;  return 0
;  }

