/*
 * OSPFv3 Redistribute
 * Copyright (C) 1999 Yasuhiro Ohara
 *
 * This file is part of GNU Zebra.
 *
 * GNU Zebra is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * GNU Zebra is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Zebra; see the file COPYING.  If not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 * Boston, MA 02111-1307, USA.  
 */

#ifndef OSPF6_REDISTRIBUTE_H
#define OSPF6_REDISTRIBUTE_H

#include "prefix.h"

#include "ospf6_top.h"

struct ospf6_redistribute_info
{
  /* protocol type */
  int type;

  /* if index */
  int ifindex;

  /* LS ID */
  u_int32_t ls_id;
};

/* prototypes */
void ospf6_redistribute_route_add (int, int, struct prefix_ipv6 *);
void ospf6_redistribute_route_remove (int, int, struct prefix_ipv6 *);
void ospf6_redistribute_init (struct ospf6 *);
void ospf6_redistribute_finish (struct ospf6 *);

#endif /* OSPF6_REDISTRIBUTE_H */

