/*
 * zap -- fast kill by name using /proc
 * Based on an earlier program of the same name
 * by Kernighan & Pike, in their classic book
 * The UNIX Programming Environment, 1984.
 */

#ident "$Id: zap-sp.c,v 1.8 1999/08/11 22:11:24 ian Exp $"

#include <stdio.h>
#include <dirent.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/fault.h>
#include <sys/syscall.h>
#include <sys/procfs.h>

#include "zap.h"

#define STREQ(s,t) (*(s)==*(t) && strcmp(s, t)==0)

char *progname;
int debug;
int signum = SIGTERM;
extern int errno;
int permis = 0;

/*
 * main - parse arguments and handle options
 */
main(argc, argv)
int argc;
char *argv[];
{
	int c;
	FILE *in;
	extern int optind;
	extern char *optarg;
	int errors = 0;

	progname = argv[0];

	while ((c = getopt(argc, argv, "ds:")) != EOF)
		switch (c) {
		case 's':
			if ((signum = signame(optind)) < 0)
				signum = atoi(argv[optind]);
			break;
		case 'd':
			++debug;
			break;
		case '?':
		default:
			errors++;
			break;
		}
	if (errors) {
		(void) fprintf(stderr, "usage: %s [-s signum] procname ...\n", progname);
		exit(2);
	}

	if (chdir("/proc") < 0) {
		perror("chdir: /proc");
		exit(1);
	}

	if (optind >= argc)
		die("Must provide a process name", "");
	else
		for (; optind < argc; optind++)
			process(argv[optind]);
	if (permis) {
		warn("One or more process files unreadable");
		++errors;
	}
	exit(errors);
}


/*
 * process - process one process
 */
process(name)
char *name;
{
	int fd;
	DIR *dirp = opendir(".");
	struct dirent *dp;
	prpsinfo_t procbuf;

	while ((dp = readdir(dirp)) != NULL)
		if (dp->d_name[0] != '.') {
			if ((fd = open(dp->d_name, 0)) < 0) {
				if (errno == EACCES)
					++permis;
				continue;	/* it just exited */
			}
			if (ioctl(fd, PIOCPSINFO, &procbuf) < 0)
				continue;	/* exited, or permission denied */
			if (strstr(procbuf.pr_fname, name) != 0)
				if (kill(procbuf.pr_pid, signum) < 0) {
					char msgbuf[128];
					sprintf(msgbuf, "kill: process %d",
						procbuf.pr_pid);
					perror(msgbuf);
				}
			(void) close(fd);
		}
	(void)closedir( dirp );
	return 0;
}
