/* $Id: errutils.c,v 1.3 2002/03/06 00:37:52 ian Exp $ */

#include <stdio.h>
#include <errno.h>
#include "zap.h"

extern int errno;

FILE *efopen(char *file, char *mode)	/* fopen file, die if can't */
{
	FILE *fp, *fopen();
	extern char *progname;

	if ((fp = fopen(file, mode)) != NULL)
		return fp;
	fprintf(stderr, "%s: can't open file %s mode %s\n",
		progname, file, mode);
	exit(1);
}

/*
 * warn - print best error message possible and clear errno
 */
void
warn(char *fmt, void *arg)
{
	char *cmdname;
	extern int sys_nerr;
	extern char *sys_errlist[];
	extern char *progname;
	extern char *getenv();

	cmdname = getenv("CMDNAME");
	if (cmdname != NULL && *cmdname != '\0')
		(void) fprintf(stderr, "%s:", cmdname);	/* No space after :. */
	if (progname != NULL)
		(void) fprintf(stderr, "%s: ", progname);
	(void) fprintf(stderr, fmt, arg);
	if (errno > 0) {
		if (errno < sys_nerr) {
			(void) fprintf(stderr, " (%s)", sys_errlist[errno]);
		} else {
			(void) fprintf(stderr, " (errno=%d)", errno);
		}
	}
	(void) fputc('\n', stderr);
	errno = 0;
}

/*
 * die - print best error message possible and exit
 */
void
die(char *fmt, void *arg)
{
	warn(fmt, arg);
	exit(1);
}
