/*	$Id: YSM_Win32.c,v 1.10 2002/08/14 04:58:39 rad2k Exp $	*/
/*
-======================== You Sick Me v7 ===========================-

                                   |                                           
           - ----------------------                                          
    _      |                       |             _________________/_     _    
   _\____________   ______         _ __________  |               /             
     \           | _)    /                     \ |              /              
      \          |_\_  _/_______________/_      \|            _/               
                 |) /______________    /         \            |pix.imp         
                   /   \         )/___/         \  /          |                
  _    _\______   /    /__  ____/       - -------\/___________|               
         ` |  /__/        \/                                                   
           |          _      _           _                  __ ________ _      
           |                  )) y( O u  (s(i  C k    m.( E))                  
           |                                                                  
          -- ---------------- ---- -----                                     
                                  |                                            
                                  |                                            
-========================== YSM_Win32.c ============================-


YSM (YouSickMe) ICQ Client. An Original Multi-Platform ICQ client.
Copyright (C) 2002 rad2k Argentina.

YSM is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

For Contact information read the AUTHORS file.

*/

#ifndef WIN32	/* UNIX */

#include <sys/types.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <unistd.h>

#else		/* WINDOWS BEOS WHATEVER*/

#include <sys/types.h>
#include <errno.h>
#include <stdarg.h>
#include <string.h>
#include <conio.h> 

#endif	/* WIN32 */

#include "YSM.h"

#if defined (WIN32) /* WINDOWS */
#include <windows.h>

extern	struct		YSM_MODEL YSM_USER;

/*	Port of the WinNT GetConsoleWindow function		*/
/*	This should work pretty well with YSM.			*/
/*	It sets the console's Title to a unique YSM title	*/

HWND
getConsoleWindow(void) 
{ 
 
HWND	hwndFound; 
char	pszNewWindowTitle[1024]; 
                      
	/* Format a "unique" NewWindowTitle. */
	(void)wsprintf(pszNewWindowTitle,"YSM ICQ [%d]",
					GetCurrentProcessId());
 
	/* Change current window title. */
	SetConsoleTitle(pszNewWindowTitle); 
 
 
	/* Ensure window title has been updated. */
	Sleep(40); 
 
	/* Look for NewWindowTitle. */
	hwndFound=FindWindow(NULL, pszNewWindowTitle); 
 
	return(hwndFound); 
} 


int
getkey()
{
#ifndef YSM_WITH_THREADS

	static HANDLE handle;
	int read;
	INPUT_RECORD r;
			
	if (!handle)
		handle = GetStdHandle(STD_INPUT_HANDLE);

	do {
		if (!GetNumberOfConsoleInputEvents(handle, &read) || !read)
			return (0);
		if (!ReadConsoleInput(handle,&r,1,&read) || !read)
			return (0);
	} while (r.EventType != KEY_EVENT || !r.Event.KeyEvent.bKeyDown);


	return (r.Event.KeyEvent.uChar.AsciiChar);

#else		/* we need it to be blocking */

	return _getch();

#endif
}


int
getxy(int *x, int *y)
{
	/* XXX sorry, no getxy() on windoze yet */
	return (0);
}


void
do_backspace()
{
	putchar(0x08);
	putchar(0x20);
	putch(0x08);
}


char *
YSM_fgets(char *str, int size)
{
	/* XXX sorry, no cool fgets on windoze yet */
	return (fgets(str, size, stdin));
}


int
PRINTF(int verbose_level, char *fmt,...)
{
	static HANDLE handle;
	int written;
	char ibuf[4096], *p, *q;
	va_list argptr;

	if ( verbose_level > YSM_SETTING_VERBOSE ) 
			return -1;

	if (!handle)
		handle = GetStdHandle(STD_OUTPUT_HANDLE);

	va_start(argptr, fmt);
	vsprintf(ibuf, fmt, argptr);
	va_end(argptr);

	p = ibuf;
	while ((q = strchr(p, 0x1b)) != NULL) {
		WriteConsole(handle, p, q-p, &written, 0);
		p = q;
		while (*p && *p != ';')
			p++;
		if (*p) {
			short color;
			p++;
			color = atoi(p);
			while (*p && *p != 'm')
				p++;
			if (*p)
				p++;

			switch (color) {
			case 30:
				color = 0;
				break;
			case 31:
				color = FOREGROUND_RED | FOREGROUND_INTENSITY;
				break;
			case 32:
				color = FOREGROUND_GREEN;
				break;
			case 33:
				color = FOREGROUND_RED | FOREGROUND_GREEN;
				break;
			case 34:
				color = FOREGROUND_RED | FOREGROUND_GREEN;
				break;
			case 35:
				color = FOREGROUND_RED | FOREGROUND_BLUE;
				break;
			case 36:
				color = FOREGROUND_GREEN | FOREGROUND_BLUE |
				    FOREGROUND_INTENSITY;
				break;
			case 37:
			default:
				color = FOREGROUND_RED | FOREGROUND_GREEN |
				    FOREGROUND_BLUE | FOREGROUND_INTENSITY;
				break;
			}
			SetConsoleTextAttribute(handle, color);
		}
	}

	if (*p)
		WriteConsole(handle, p, strlen(p), &written, 0);

	return 0;
}


int
YSM_ReadWindowsProxy (void)
{

DWORD	dwType;
DWORD	dwSize = 1024;
long	res;
HKEY	hKey;
/* Don't worry in case its longer than 1024 (duh!) it won't overflow */
char	Proxy_buf[1024], *aux = NULL;


	res = RegOpenKeyEx( HKEY_CURRENT_USER, YSM_PROXYKEY,
						0, KEY_QUERY_VALUE,
						&hKey );

	if( res == ERROR_SUCCESS )
	{
		memset(Proxy_buf, 0, sizeof(Proxy_buf));

		res = RegQueryValueEx( hKey, YSM_PROXYVALUE, 0, &dwType,
								&Proxy_buf[0],
								&dwSize );
		if( res == ERROR_SUCCESS )
		{
			aux = strtok(Proxy_buf, ":");
			if(aux != NULL)
			{
				strncpy(YSM_USER.Proxy_host, aux, MAX_PATH-1);
				aux = strtok(NULL, "");
				if(aux != NULL)
					YSM_USER.Proxy_port = atoi(aux);

				RegCloseKey( hKey );
				return 1;
			}
		}
	
		RegCloseKey( hKey );
	}

	return 0;
}

void
YSM_WindowAlert(void)
{
	HWND YSM_HWND = getConsoleWindow();

	/* Probably because its a Win95/98/ME	*/
	if( YSM_HWND == NULL ) return;

	switch( YSM_SETTING_WINALERT )
	{
		case 0x1:
			ShowWindow( YSM_HWND, SW_SHOWNORMAL );
			break;
		case 0x3:
			ShowWindow( YSM_HWND, SW_SHOWNORMAL );
		case 0x2:
			FlashWindow( YSM_HWND, TRUE );	
			break;
		
		default:
			break;
	}

	return;
}

void
YSM_WindowHide(void)
{
	HWND YSM_HWND = getConsoleWindow();

	if( YSM_HWND == NULL ) return;

	ShowWindow( YSM_HWND, SW_MINIMIZE );

	return;
}

void
YSM_WindowShow(void)
{
	HWND YSM_HWND = getConsoleWindow();

	if( YSM_HWND == NULL ) return;

	ShowWindow( YSM_HWND, SW_SHOW );

	return;
}


void
YSM_WindowRegisterHotKey(void)
{
	HWND YSM_HWND = getConsoleWindow();
	
	if(RegisterHotKey(
		YSM_HWND,
		0x1337,
		MOD_ALT,
		VkKeyScan((char)YSM_SETTING_HOT_KEY_MAXIMIZE)) != TRUE)
			return;
	
	return;
}


#else		/* UNIX */

int
getkey()
{
	unsigned char c;

	if (read(STDIN_FILENO, &c, sizeof(unsigned char)) <= 0) {
		fprintf(stderr, "Can't read: %s.\n", strerror(errno));
		YSM_Error(ERROR_CRITICAL);
		/* NOTREACHED */
	}
	return ((int)c);
}


int
putch(int c)
{
	putchar(c);
	fflush(stdout);
	return (0);
}


int
getxy(int *x, int *y)
{
	char buf[20], *p, *q;
	ssize_t r, i;

	fprintf(stdout, "\x1B[6n");
	fflush(stdout);

#ifndef BEOS
	usleep(50000);
#endif
	if ((r = read(STDIN_FILENO, buf, sizeof(buf) - 1)) < 0)
		return (0);

	buf[r] = '\0';

	for (--r, i = 0; i < r && buf[i] != '\x1B' && buf[i+1] != '['; i++);
	if (i >= r)
		return (0);

	for (p = &buf[i]; *p != '\0' && *p != 'R'; p++);
	for (q = &buf[i]; *q != '\0' && *q != ';'; q++);
	if (*p == '\0' || *q == '\0')
		return (0);

	*p = '\0';
	*q = '\0';
	*x = atoi(q + 1);
	*y = atoi(&buf[i+2]);

	return (1);
}


void
do_backspace()
{
	struct winsize w;
	int x, y, x2, y2;
	char *p;

	p = "\x1B[1D\x1B[K";

	if (ioctl(STDOUT_FILENO, TIOCGWINSZ, &w) != -1 && getxy(&x, &y)) {
		if (x == w.ws_col) {
			putchar(0x20);
			if (getxy(&x2, &y2)) {
				if (x2 == x)
					x--;

				if (y2 == y && x > x2 && x == w.ws_col)
					y--;

				fprintf(stdout, "\x1B[%d;%df\x1B[K", y, x);
				p = "";

			} else
				p = "\x1B[2D\x1B[K";

		} else if (x == 1) {
			if (y > 1) {
				y--;
				x = w.ws_col;
			}

			fprintf(stdout, "\x1B[%d;%df", y, x);
			p = "";
		}
	}

	if (*p != '\0')
		fprintf(stdout, p);

	fflush(stdout);
}


char *
YSM_fgets(char *str, int size)
{
	unsigned char c;
	int i;

	if (size <= 0) {
		errno = EINVAL;
		return (NULL);
	}

	i = 0;
	str[i] = '\0';
	while (i < size) {
		c = getkey();
		switch (c) {
		case 0x08:
		case 0x7F:
			if (i) {
				str[--i] = '\0';
				do_backspace();
			}
			break;

		case '\n':
			putch(c);
			str[i++] = '\n';

		case '\0':
			str[i] = '\0';
			return (str);

		default:
			str[i++] = c;
			str[i] = '\0';
			putch(c);
		}
	}

	return (str);
}


int
PRINTF(int verbose_level, char *fmt, ...)
{
	va_list argptr;
	int st;

	if ( verbose_level > YSM_SETTING_VERBOSE ) 
		return -1;

	va_start(argptr, fmt);
	st = vprintf(fmt, argptr);
	va_end(argptr);

	fflush(stdout);

	return (st);
}

#endif	/* WIN32 */


/*
 * port for the getpass(3) function used in *nix.
 */

#if defined (WIN32) || defined (BEOS)

char *
getpass (const char *prompt)
{

static char password[MAX_PWD_LEN+1];
int n = 0;

	memset(password,'\0',sizeof(password));

	fputs(prompt, stderr);

#ifndef BEOS
	while ( ((password[n] = _getch()) != '\r') && n <= MAX_PWD_LEN )
#else
	while ( ((password[n] = getchar()) != '\r') && n <= MAX_PWD_LEN )
#endif
	{
		if( password[n] >= ' ' && password[n] <= '~' )
		{
			n++;
			PRINTF (YSM_VERBOSE_BASE,"*");
		}
		else
		{
			if( (password[n] == 0x08) && (n > 0) )
			{
				do_backspace();
				n--;
			}
	
			else
			{
				PRINTF (YSM_VERBOSE_BASE,"\n");
				fputs(prompt, stderr);
				n = 0;
			}
		}
	}

	if( password[n] == '\r' || password[n] == '\n' ) password[n] = '\0';
	password[n+1] = '\0';

	PRINTF(YSM_VERBOSE_BASE,"\n");

	return (char *) &password;
}

#endif /* WIN32 || BEOS */
