/*	$Id: YSM_ToolBox.c,v 1.10 2002/08/20 05:30:40 rad2k Exp $	*/
/*
-======================== You Sick Me v7 ===========================-

                                   |                                           
           - ----------------------                                          
    _      |                       |             _________________/_     _    
   _\____________   ______         _ __________  |               /             
     \           | _)    /                     \ |              /              
      \          |_\_  _/_______________/_      \|            _/               
                 |) /______________    /         \            |pix.imp         
                   /   \         )/___/         \  /          |                
  _    _\______   /    /__  ____/       - -------\/___________|               
         ` |  /__/        \/                                                   
           |          _      _           _                  __ ________ _      
           |                  )) y( O u  (s(i  C k    m.( E))                  
           |                                                                  
          -- ---------------- ---- -----                                     
                                  |                                            
                                  |                                            
-======================== YSM_ToolBox.c ============================-


YSM (YouSickMe) ICQ Client. An Original Multi-Platform ICQ client.
Copyright (C) 2002 rad2k Argentina.

YSM is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

For Contact information read the AUTHORS file.

*/

#include "YSM.h"
/* International Languages Charset Convertion! */
#include "YSM_Iconv.h"


static struct timeval tv;
static fd_set readfds;
static int max_fd;

extern char *YSM_GroupID_List;
extern char *YSM_GroupID_Users;

extern UBYTE YSM_ConfigDir[MAX_PATH];

#ifdef WIN32
HWND
getConsoleWindow (
	void
	);
#endif

void YSM_Error(int LEVEL) {
	
	switch(LEVEL) {

		case ERROR_CODE:
			PRINTF(YSM_VERBOSE_BASE, "%s",ERROR_CODE_M);
			exit(-1);
			break;

		case ERROR_NETWORK:
			PRINTF(YSM_VERBOSE_BASE, "%s",ERROR_NETWORK_M);
			exit(-1);
			break;

		case ERROR_CRITICAL:
			PRINTF(YSM_VERBOSE_BASE, "%s",ERROR_CRITICAL_M);
			exit(-1);
			break;
	}

}



void DumpFLAP (FLAP_Head *incoming)
{
        FILE *archivo;

                PRINTF(YSM_VERBOSE_BASE, "\n- about to write log dump - ");

                archivo = fopen(YSM_DUMP_FILE,"a");

                fprintf(archivo,"Command Start: %d\n",incoming->cmd);
                fprintf(archivo,"Channel ID: %d\n",incoming->channelID);
                fprintf(archivo,"Sequence Number: %d\n", Chars_2_Word(incoming->seq));
                fprintf(archivo,"Data Length: %d\n", Chars_2_Wordb(incoming->dlen));
                PRINTF(YSM_VERBOSE_BASE, "- Dump Complete -");
                fclose(archivo);

        return;
}


void DumpSNAC (SNAC_Head incoming)
{
        FILE *archivo;

                archivo = fopen(YSM_DUMP_FILE,"a");

                fprintf(archivo,"Family ID: %.2x\n",Chars_2_Wordb(incoming.familyID));
                fprintf(archivo,"SubType ID: %.2x\n",Chars_2_Wordb(incoming.SubTypeID));
                fprintf(archivo,"Flags A: %.2x\n",incoming.Flags_a);
                fprintf(archivo,"Flags B: %.2x\n",incoming.Flags_b);
                fprintf(archivo,"Req ID: %x\n",incoming.ReqID);
                PRINTF(YSM_VERBOSE_BASE, "- Dump Complete -\n");
                fclose(archivo);

        return;
}

int InsertTLV (void *string, int type, void *memplace, int len)
{
	TLV thetlv;
	int ret;

		Word_2_Charsb(thetlv.type,type);
		Word_2_Charsb(thetlv.len,len);

		memcpy(memplace,&thetlv,sizeof(thetlv));
		memcpy((char *)memplace+sizeof(thetlv),string,len);

		ret = sizeof(thetlv) + len;

		return ret;
}


int YSM_LookupStatus (char *name)
{
	unsigned int x;

	for(x=0;x<strlen(name);x++)
		name[x] = toupper(name[x]);

	if(strstr("ONLINE",name)) return YSM_ONLINE;
	if(strstr("OFFLINE",name)) return YSM_OFFLINE;
	if(strstr("INVISIBLE",name)) return YSM_INVISIBLE;
	if(strstr("NA",name)) return YSM_NA;
	if(strstr("DND",name)) return YSM_DND;
	if(strstr("OCCUPIED",name)) return YSM_OCCUPIED;
	if(strstr("FREECHAT",name)) return YSM_FREE_CHAT;
	if(strstr("AWAY",name)) return YSM_AWAY;

	return -2;
}


void YSM_WriteFingerPrint(int client, char *buf)
{

	switch(client)
	{
		case FINGERPRINT_YSM_CLIENT:
			strncpy(buf," YSM client.", MAX_CMD_LEN-1);
			break;
		
		case FINGERPRINT_YSM_CLIENT_CRYPT:
			strncpy(buf," YSM client w/Encryption.", MAX_CMD_LEN-1);
			break;
		
		case FINGERPRINT_MIRANDA_CLIENT:
			strncpy(buf," Miranda client.", MAX_CMD_LEN-1);
			break;

		case FINGERPRINT_TRILLIAN_CLIENT:
			strncpy(buf," Trillian client.", MAX_CMD_LEN-1);
			break;

		case FINGERPRINT_LIB2K_CLIENT:
			strncpy(buf," centerICQ/Ickle client. (libicq2000)",
							 MAX_CMD_LEN-1);
			break;

		case FINGERPRINT_M2000_CLIENT:
			strncpy(buf," Mirabilis ICQ 2000 client.",
							MAX_CMD_LEN-1);
			break;

		case FINGERPRINT_M20012_CLIENT:
			strncpy(buf," Mirabilis ICQ 2001/2002 client.",
							MAX_CMD_LEN-1);
			break;

		case FINGERPRINT_M2002_CLIENT:
			strncpy(buf," Mirabilis ICQ 2002 client.",
							 MAX_CMD_LEN-1);
			break;


		case FINGERPRINT_MICQ_CLIENT:
			strncpy(buf," mICQ client.", MAX_CMD_LEN-1);
			break;

		case FINGERPRINT_STRICQ_CLIENT:
			strncpy(buf," StrICQ client.", MAX_CMD_LEN-1);

			break;

		case FINGERPRINT_LICQ_CLIENT:
			strncpy(buf," Licq client.", MAX_CMD_LEN-1);

			break;

		case FINGERPRINT_MISC_CLIENT:
		default:
			strncpy(buf, " Client unmatched. (Mirabilis?)",
							MAX_CMD_LEN-1);
			break;
			
	}



	return;
}

void YSM_WriteStatus(int STATUS,char *buf)
{

	switch(STATUS)
	{
		case YSM_ONLINE :
			strncpy(buf,"ONLINE",MAX_STATUS_LEN);
			break;

		case YSM_OFFLINE :
			strncpy(buf,"OFFLINE",MAX_STATUS_LEN);
			break;

		case YSM_INVISIBLE :
			strncpy(buf,"INVISIBLE",MAX_STATUS_LEN);
			break;

		case YSM_NA :
			strncpy(buf,"NA",MAX_STATUS_LEN);
			break;

		case YSM_DND :
			strncpy(buf,"DND",MAX_STATUS_LEN);
			break;

		case YSM_OCCUPIED :
			strncpy(buf,"OCCUPIED",MAX_STATUS_LEN);
			break;

		case YSM_FREE_CHAT :
			strncpy(buf,"FREE4CHAT",MAX_STATUS_LEN);
			break;

		case YSM_AWAY :
			strncpy(buf,"AWAY",MAX_STATUS_LEN);
			break;

		default:
			strncpy(buf,"UNK",MAX_STATUS_LEN);
			break;

	}

	return;
}

char *
YSM_GetColorStatus(char *status)
{

	if(!strcmp(status, "ONLINE"))		return GREEN;
	if(!strcmp(status, "OFFLINE"))		return WHITE;
	if(!strcmp(status, "NA"))		return BRIGHT_BLACK;
	if(!strcmp(status, "AWAY"))		return CYAN;
	if(!strcmp(status, "INVISIBLE"))	return BRIGHT_BLUE;	
	if(!strcmp(status, "DND"))		return RED;
	if(!strcmp(status, "OCCUPIED"))		return RED;
	if(!strcmp(status, "FREE4CHAT"))	return GREEN;
	
	return BLUE;
}

int YSM_DumpLogFile (char *fname,char *data)
{
	FILE *log;
	int size=0;
	char *slavelog;

		/* 1 byte for / and another for the ending 0! */
		size = strlen(fname)+strlen(YSM_ConfigDir)+2;
		slavelog = YSM_Malloc(size, __FILE__, __LINE__);
		memset(slavelog,'\0',size);
		snprintf(slavelog,size,"%s/%s",YSM_ConfigDir,fname);

		if ( (log = fopen(slavelog,"a")) == NULL)
			return -1;

		fprintf(log,"%s",data);

		fclose(log);
		YSM_Free(slavelog, __FILE__, __LINE__);

	return 0;
}

#ifndef WIN32 

void YSM_CheckSecurity (void)
{

	if (!getuid())
	{
		PRINTF(YSM_VERBOSE_BASE, "%sHOLD IT!%s I'm sorry, but i WONT let you run YSM\n",
							RED,NORMAL);
		PRINTF(YSM_VERBOSE_BASE, "with uid 0. Don't run Ysm as root!. ..fag.\n");
		exit (-1);
	}

	return;
}

#endif


/* Thanks a lot to mICQ for these convertion Functions. 
		I made some Big Endian ones out of them */

UDWORD Chars_2_DW (UBYTE * buf)
{
    UDWORD i;

    i = buf[3];
    i <<= 8;
    i += buf[2];
    i <<= 8;
    i += buf[1];
    i <<= 8;
    i += buf[0];

    return i;
}

UWORD Chars_2_Word (UBYTE * buf)
{
    UWORD i;

    i = buf[1];
    i <<= 8;
    i += buf[0];

    return i;
}

/* nuevo big endian */
UWORD Chars_2_Wordb (UBYTE * buf)
{
    UWORD i;

    i = buf[0];
    i <<= 8;
    i += buf[1];

    return i;
}

void DW_2_Chars (UBYTE * buf, UDWORD num)
{
    buf[3] = (UBYTE) ((num) >> 24) & 0x000000FF;
    buf[2] = (UBYTE) ((num) >> 16) & 0x000000FF;
    buf[1] = (UBYTE) ((num) >> 8) & 0x000000FF;
    buf[0] = (UBYTE) (num) & 0x000000FF;
}

/* intel little endian */
void Word_2_Chars (UBYTE * buf, const int num)
{
    buf[1] = (UBYTE) (((unsigned) num) >> 8) & 0x00FF;
    buf[0] = (UBYTE) ((unsigned) num) & 0x00FF;
}

/* big endian code */
void Word_2_Charsb (UBYTE * buf, const int num)
{
    buf[0] = (UBYTE) (((unsigned) num) >> 8) & 0x00FF;
    buf[1] = (UBYTE) ((unsigned) num) & 0x00FF;
}


void EncryptPassword (char *Password, char *output)
{

	unsigned int x;
	static const UBYTE tablilla[] = 
	{
    		0xF3, 0x26, 0x81, 0xC4, 0x39, 0x86, 0xDB, 0x92, 0x71, 0xA3, 0xB9, 0xE6,
    		0x53, 0x7A, 0x95, 0x7C,
	};

	for(x=0;x<strlen(Password);x++)
		*(output+x) =  Password[x] ^ tablilla[x];

	return;
}

void YSM_FDSelect_init (void)
{
    FD_ZERO (&readfds);
    max_fd = 0;
}

void YSM_FDSet_timeout (UDWORD sec, UDWORD usec)
{
    tv.tv_sec = sec;
    tv.tv_usec = usec;
}

void YSM_FDAdd_rsocket (int sok)
{
    FD_SET (sok, &readfds);
    if (sok > max_fd)
        max_fd = sok;
}

int YSM_FDIs_Set (int sok)
{
    return (FD_ISSET(sok, &readfds));
}

int YSM_FDSelect (void)
{
    int res;

    /* don't care about writefds and exceptfds: */
    res = select (max_fd + 1, &readfds, NULL, NULL, &tv);
    if (res == -1)
        FD_ZERO (&readfds);
    return res;
}

#ifdef YSM_USE_ICONV

int
YSM_Iconv (char *charset_from, char *charset_to, char *buf_from, char **buf_to, size_t maxlen)
{

char	*inptr   = buf_from;
char	*outptr  = 0;

size_t	bytes_in, bytes_out, bytes_res;

iconv_t conv_d;

	PRINTF(YSM_VERBOSE_DEBUG_4, "DEBUG: FROM CHARSET: %s\n", charset_from);
	PRINTF(YSM_VERBOSE_DEBUG_4, "DEBUG: TO CHARSET: %s\n",   charset_to);

	if (!charset_from || !charset_to || !buf_from || !buf_to) return -1;

	if (strlen(charset_from) <= 1)
		return -1;


	if (strlen(charset_to) <= 1)
		return -1;

	if (!(*buf_to = calloc(1, maxlen)))
	       return -1;

	outptr    = *buf_to;
	bytes_in  = strlen(buf_from) + 1;
	bytes_out = maxlen - 1;
	conv_d    = iconv_open(charset_to, charset_from);

	if ((iconv_t)conv_d == (iconv_t) -1)
	{
		perror("iconv_open");
		return 1;
	}

	bytes_res = iconv(conv_d, &inptr,
					 &bytes_in, &outptr, &bytes_out);
	iconv_close(conv_d);

	return 0;
}

#endif


#if defined(WIN32) || defined(BEOS)
int
gettimeofday(struct timeval *_tval)
{
struct _timeb local_t;

	if(!_tval) return -1;

	_ftime(&local_t);

	_tval->tv_sec = local_t.time + local_t.timezone;
	_tval->tv_usec = local_t.millitm * 1000;

	return 0;
}
#endif

/* Get Time in MicroSeconds, and if value is smaller than the MicroSeconds
 * at the very moment, then return -1  
 */

long
YSM_GetMicroTime (long input)
{

struct timeval rtimeout;

#if defined(WIN32) || defined(BEOS)
	if(!gettimeofday (&rtimeout))
#else
	if(!gettimeofday (&rtimeout, NULL))
#endif
	{
		if(!input || rtimeout.tv_usec < input)
			return rtimeout.tv_usec;
	}
	return -1;
}


#ifdef YSM_WITH_THREADS

void
YSM_Thread_Sleep (int seconds)
{


#ifdef WIN32		/* Thanks god Sleep in Win32 sleeps the thread :) */
	Sleep(seconds*1000);
#else

struct timeval	now, expected;
pthread_mutex_t	condition_mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t	condition_cond  = PTHREAD_COND_INITIALIZER;

	/* Unix function */
	gettimeofday (&now, NULL);

	expected.tv_sec = now.tv_sec + seconds;
	expected.tv_usec = now.tv_usec;

	pthread_mutex_lock( &condition_mutex );

	/* Now! Go to sleep for a second, y0 arent paid for nuthn boy */
	pthread_cond_timedwait( &condition_cond,
				&condition_mutex,
				(struct timespec *)&expected );

	pthread_mutex_unlock( &condition_mutex );

#endif



	return;
}

#endif

void
YSM_Destructor (void)
{
#ifdef WIN32
	HWND	YSM_HWND = NULL;
#endif
	if(YSM_GroupID_List != NULL) YSM_Free (YSM_GroupID_List,
							__FILE__,
							__LINE__);
	if(YSM_GroupID_Users != NULL) YSM_Free(YSM_GroupID_Users,
							__FILE__,
							__LINE__); 
#ifdef WIN32
	YSM_HWND = getConsoleWindow();
	UnregisterHotKey(
			YSM_HWND,
			0x1337);
#endif

	return;
}
