/*	$Id: YSM_Setup.c,v 1.19 2002/08/21 00:37:46 rad2k Exp $	*/
/*
-======================== You Sick Me v7 ===========================-

                                   |                                           
           - ----------------------                                          
    _      |                       |             _________________/_     _    
   _\____________   ______         _ __________  |               /             
     \           | _)    /                     \ |              /              
      \          |_\_  _/_______________/_      \|            _/               
                 |) /______________    /         \            |pix.imp         
                   /   \         )/___/         \  /          |                
  _    _\______   /    /__  ____/       - -------\/___________|               
         ` |  /__/        \/                                                   
           |          _      _           _                  __ ________ _      
           |                  )) y( O u  (s(i  C k    m.( E))                  
           |                                                                  
          -- ---------------- ---- -----                                     
                                  |                                            
                                  |                                            
-========================== YSM_Setup.c ============================-


YSM (YouSickMe) ICQ Client. An Original Multi-Platform ICQ client.
Copyright (C) 2002 rad2k Argentina.

YSM is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

For Contact information read the AUTHORS file.

*/

#include "YSM.h"
/* International Languages Charset Convertion! */
#include "YSM_Iconv.h"

#if defined(WIN32)
int
mkdir (
	const char	*path,
	short		mode
	);
#endif



int
YSM_PreSetup (
	int	COMMAND
	);

void
YSM_ReadConfig (
	FILE	*YSM_CFGFD
	);

void
YSM_CreateConfig (
	void
	);

void
YSM_SaveConfig (
	void
	);

void
YSM_CFGStatus (
	char	*validate
	);

void
YSM_DeleteSlavefromList (
	YSM_SLAVE	**SlavesList,
	char		*Nick,
	int		Uin
	);

void
YSM_ReadSlaves (
	FILE	*YSM_CFGFD
	);

FILE *
YSM_OpenCFG (
	void
	);

int
YSM_ReadWindowsProxy (
	void
	);

void
YSM_AskProxyConfiguration (
	void
	);



char	YSM_ConfigFile[MAX_PATH];
char	YSM_ConfigDir[MAX_PATH];
char	YSM_AFKMessage[MAX_DATA_LEN];
char	YSM_BrowserPath[MAX_DATA_LEN];

unsigned int	AmountSlaves = 0; 

extern	char		YSM_KEYMAP_HELP;
extern	char		YSM_KEYMAP_WHOSON;
extern	char		YSM_KEYMAP_SLAVES;
extern	unsigned short	YSM_SeqNum;
extern	short		YSM_Display_Busy;
extern	int		YSM_TCPSock;
extern	short		YSM_AFK_Count;
extern	time_t		YSM_AFK_Time;
extern	YSM_SLAVE	*YSMSlavesList,*YSMSlaves_First;
extern	struct		YSM_MODEL YSM_USER;

void
YSM_Setup(void) 
{
        /* Setup the config and dir path only if -c was not used before */
        if(YSM_ConfigFile[0] == '\0' || YSM_ConfigDir[0] == '\0')
        {
                PRINTF(YSM_VERBOSE_DEBUG_2, "Setting up Config. file Path.");   
                YSM_PreSetup(SETUP_HOME);
        }

	PRINTF(YSM_VERBOSE_DEBUG_2, "Reading or Creating Config file.");
	YSM_PreSetup(SETUP_CONFIG);
	PRINTF(YSM_VERBOSE_DEBUG_2, "Retrieving Slave DATA from Config.");
	YSM_PreSetup(SETUP_SLAVES);

	return;
}

int
YSM_PreSetup(int COMMAND)
{

FILE	*YSM_CFGFD;	
char	*homep=0;
char	*homep2=0;

	switch(COMMAND) {

		case SETUP_HOME:
			homep = YSM_Malloc(MAX_PATH, __FILE__, __LINE__);
			memset(homep,'\0',MAX_PATH);

#ifdef WIN32
			if(getenv("USERPROFILE") != NULL)
				strncpy(homep,getenv("USERPROFILE"),MAX_PATH);
			else
				strcpy(homep,"C:");
#else
			strncpy(homep,getenv("HOME"),MAX_PATH);
#endif

			homep2 = YSM_Malloc(strlen(homep)+2,
						__FILE__,
						__LINE__);

			strncpy(homep2,homep,strlen(homep)+2);
			strcat(homep2,"/");
			strncpy(YSM_ConfigFile,homep2,MAX_PATH);
			strcat(YSM_ConfigFile,YSM_CFGDIRECTORY);
			strncpy(YSM_ConfigDir,YSM_ConfigFile,MAX_PATH);
			strcat(YSM_ConfigFile,"/");
			strcat(YSM_ConfigFile,YSM_CFGFILENAME);
			YSM_Free(homep, __FILE__, __LINE__);
			YSM_Free(homep2, __FILE__, __LINE__);

		break;

		case SETUP_CONFIG:

			if ((YSM_CFGFD = fopen(YSM_ConfigFile,"r")) != NULL) {

					YSM_ReadConfig(YSM_CFGFD);
					fclose(YSM_CFGFD);
			}

			else {

		        PRINTF(YSM_VERBOSE_BASE,
	"\n%sWelcome to the Configuration Wizard!%s <<.\n",BROWN,NORMAL);
                        PRINTF(YSM_VERBOSE_BASE,
	"As this is your first time running YSM, you will be\n");
			PRINTF(YSM_VERBOSE_BASE,
	"prompted to fill some information required to create your\n");
			PRINTF(YSM_VERBOSE_BASE,
	"configuration file. This file will be stored in your home\n");
			PRINTF(YSM_VERBOSE_BASE,
	"directory at %s[%s]%s\n",BROWN,YSM_ConfigFile,NORMAL);
			PRINTF(YSM_VERBOSE_BASE,
	"In case you may want to change/update any of this information\n");
			PRINTF(YSM_VERBOSE_BASE,
	"just do it directly in the Configuration file.\n\n");

			PRINTF(YSM_VERBOSE_BASE,
				"So, lets start!:\n");

			YSM_CreateConfig();
			
			}
			
		break;

		case SETUP_SLAVES:

			if ((YSM_CFGFD = fopen(YSM_ConfigFile,"r")) != NULL) {
	
				YSM_ReadSlaves(YSM_CFGFD);
				fclose(YSM_CFGFD);

			}

			else {
		
			PRINTF (YSM_VERBOSE_BASE,
			"Contact list couldn't be read!. File not found.\n");
			YSM_Error (ERROR_CRITICAL);

			}
		break;

		default:
		
		YSM_Error(ERROR_CRITICAL);
		break;
	}

	return 0;
}

void
YSM_ReadConfig (FILE *YSM_CFGFD) 
{

int	YSM_CFGEND = FALSE;
char	YSM_Buff[MAX_PATH];
char	*aux,*auxb;


		memset(&YSM_AFKMessage,0,MAX_DATA_LEN);
		memset(&YSM_BrowserPath,0,MAX_DATA_LEN);
#ifdef YSM_USE_ICONV
		memset(YSM_SETTING_CHARSET_TRANS,0,MAX_CHARSET+4);
		memset(YSM_SETTING_CHARSET_LOCAL,0,MAX_CHARSET+4);
#endif

		while(!YSM_CFGEND) {
		
			memset(YSM_Buff,'\0',MAX_PATH);
			fgets(YSM_Buff,sizeof(YSM_Buff),YSM_CFGFD);

			if ((YSM_Buff[0] != '#') && (YSM_Buff[0] != 0)) {

				aux = strtok(YSM_Buff,">");
				if ((auxb = strchr(aux,'\n'))) *auxb = '\0';
				
				if(!strcmp(aux,"SERVER"))
	                        strncpy(YSM_USER.SRV_HostName,
						strtok(NULL," \n\t"),MAX_PATH);

				else if(!strcmp(aux,"SERVERPORT"))
                       		YSM_USER.SRV_Port=atoi(strtok(NULL," \n\t"));

               	else if(!strcmp(aux,"PASSWORD"))
                        	strncpy(YSM_USER.YSM_Password,
						strtok(NULL,"\n\t"),MAX_PWD_LEN);

                else if(!strcmp(aux,"STATUS"))
					YSM_CFGStatus (strtok (NULL," \n\t"));

                else if(!strcmp(aux,"UIN"))
                       	YSM_USER.YSM_Uin = atoi(strtok(NULL," \n\t"));

	       		else if(!strcmp(aux,"PARANOID"))
                       	YSM_USER.YSM_Paranoid = atoi(strtok(NULL," \n\t"));	

				else if(!strcmp(aux,"VERBOSE"))
				YSM_SETTING_VERBOSE = atoi(strtok(NULL," \n\t"));

				else if(!strcmp(aux,"BEEP"))
				YSM_SETTING_BEEP = atoi(strtok(NULL," \n\t"));

				else if(!strcmp(aux,"BEEPAMOUNT"))
				YSM_SETTING_BEEPAMOUNT = atoi(strtok(NULL," \n\t"));

				else if(!strcmp(aux,"LOGALL"))
				YSM_SETTING_LOGALL = atoi(strtok(NULL," \n\t"));

				else if(!strcmp(aux,"WINALERT"))
				YSM_SETTING_WINALERT = atoi(strtok(NULL," \n\t"));

				else if(!strcmp(aux,"WINHOTKEY"))
				YSM_SETTING_HOT_KEY_MAXIMIZE = atoi(strtok(NULL," \n\t"));

				else if(!strcmp(aux,"IDLETIME"))
				YSM_SETTING_IDLETIME = atoi(strtok(NULL," \n\t"));				

				else if(!strcmp(aux,"AFKMESSAGE"))
				strncpy(YSM_AFKMessage,strtok(NULL,"\n\t"),
							MAX_DATA_LEN);

				else if(!strcmp(aux,"AFKMAXSHOWN"))
				YSM_SETTING_AFKMAXSHOWN = atoi(strtok(NULL," \n\t"));

				else if(!strcmp(aux,"PROXY"))
	                        strncpy(YSM_USER.Proxy_host,strtok(NULL," \n\t"),MAX_PATH);
                       		
				else if(!strcmp(aux,"PROXY_PORT"))
				YSM_USER.Proxy_port=atoi(strtok(NULL," \n\t"));

				else if(!strcmp(aux,"PROXY_HTTPS"))
				YSM_USER.Proxy_https=atoi(strtok(NULL," \n\t"));
				

				else if(!strcmp(aux,"ASK_KEYMAP"))
				YSM_SETTING_ASK_KEYMAP = atoi(strtok(NULL," \n\t"));
		
				else if(!strcmp(aux,"ASK_DOWNLOAD"))
				YSM_SETTING_ASK_DOWNLOAD = atoi(strtok(NULL," \n\t"));

				else if(!strcmp(aux,"MSG_KIND"))
				YSM_SETTING_MSG_KIND = atoi(strtok(NULL," \n\t"));

				else if(!strcmp(aux,"VERBOSE"))
				YSM_SETTING_VERBOSE = atoi(strtok(NULL," \n\t"));

				else if(!strcmp(aux,"VERSION_CHECK"))
				YSM_SETTING_VERSION_CHECK = atoi(strtok(NULL," \n\t"));

	
#ifdef YSM_USE_ICONV
				else if(!strcmp(aux,"CHARSET_TRANS"))
				strncpy(YSM_SETTING_CHARSET_TRANS,
						strtok(NULL," \n\t"),
						MAX_CHARSET);

				else if(!strcmp(aux,"CHARSET_LOCAL"))
				strncpy(YSM_SETTING_CHARSET_LOCAL,
						strtok(NULL," \n\t"),
						MAX_CHARSET);
#endif


/* TheXBrowser feature should launch a browser for a bookmarked url */
/* or a specified url */
				else if(!strcmp(aux,"BROWSER"))
				strncpy(YSM_BrowserPath,strtok(NULL,"\n\t"),
							MAX_DATA_LEN);



                		else if(!strcmp(aux,SLAVES_TAG))
                        	YSM_CFGEND=TRUE;

				else if( *aux )
				PRINTF(YSM_VERBOSE_BASE,
		RED "UNKNOWN cfg directive '%s' , ignoring...\n" NORMAL,aux);
				
			}

		}	


	/*	Before leaving check there's at least the	*/
	/*	minimum required fields */

	if( !YSM_USER.YSM_Uin )
	{
		PRINTF(YSM_VERBOSE_BASE,
		"\nMissing UIN in config. Can't continue.\n"
		"If you want a new account, remove the cfg file.\n");

		exit (0);
	}

	else if( strlen(YSM_USER.YSM_Password) < 1 )
	{
		PRINTF(YSM_VERBOSE_BASE,
			"\nMissing Password in config. Can't continue.\n");

		exit (0);
	}
	else if( strlen(YSM_USER.SRV_HostName) < 1 )
	{

		PRINTF(YSM_VERBOSE_BASE,
			"\nMissing ICQ Server in config. Can't continue.\n");

		exit (0);
	}
	else if( !YSM_USER.SRV_Port )
	{
		PRINTF(YSM_VERBOSE_BASE,
		"\nMissing ICQ Server port in config. Can't continue.\n");
		
		exit (0);
	}
	

}



void
YSM_CreateConfig(void) 
{


	char YSM_tmpa[MAX_PWD_LEN+1],YSM_tmpb[MAX_UIN_LEN+1];
	char *p_passwd;
	
		strncpy (YSM_USER.SRV_HostName,YSM_DEFAULTSRV,MAX_PATH);
		YSM_USER.SRV_Port = YSM_DEFAULTPORT;
		YSM_USER.YSM_Uin = 0;

	        PRINTF(YSM_VERBOSE_BASE,
			"\nYour %sUIN%s [use 0 for new]#: ",RED,NORMAL);
     		YSM_fgets(YSM_tmpb, MAX_UIN_LEN);

		YSM_USER.YSM_Uin = atoi(YSM_tmpb);


		/* Ask proxy configuration once */

		YSM_AskProxyConfiguration();

		if( YSM_USER.YSM_Uin == 0 )
		{

		PRINTF(YSM_VERBOSE_BASE,
		"\nRegister a new ICQ Number.\n");
		PRINTF(YSM_VERBOSE_BASE,
		"You will be asked for your desired password twice.\n");
		PRINTF(YSM_VERBOSE_BASE,
		"The Password must be 8 chars max.\n");

		}
		else	
		{
		PRINTF(YSM_VERBOSE_BASE,
			"\nMaximum Password Len is set to %d.\n",MAX_PWD_LEN);

		PRINTF(YSM_VERBOSE_BASE,
		"You may use 'SECURE' as your password (uppercase)\n");
		PRINTF(YSM_VERBOSE_BASE,
		"to be prompted for your password everytime you start YSM.\n");
		}


		p_passwd = getpass("Password: ");
        	strncpy(YSM_USER.YSM_Password,p_passwd,MAX_PWD_LEN-1);

		p_passwd = getpass("Again?[verify]: ");
        	strncpy(YSM_tmpa,p_passwd,MAX_PWD_LEN-1);
       
		if( !strcmp( YSM_USER.YSM_Password , YSM_tmpa ) ) 
		{
			if( YSM_USER.YSM_Uin == 0 )
				YSM_Registration_UIN (YSM_USER.YSM_Password);

                	YSM_SaveConfig();
                	PRINTF(YSM_VERBOSE_BASE,
				"\nConfiguration file created.\n");
                	return;
        	}

		PRINTF(YSM_VERBOSE_BASE,
		"\n%s<WRONG>%s - Passwords did not match.\n",RED,NORMAL);
		YSM_Error(ERROR_CRITICAL);
        	exit(-1);
}


void
YSM_SaveConfig(void) 
{

time_t	YSM_tmpdate;
FILE	*YSM_CFGFD;

	/* mkdir returns 0 if success */
	if (mkdir(YSM_ConfigDir,0700))
	{
		if (errno != EEXIST)
		{
			PRINTF(YSM_VERBOSE_BASE,
				"\nmkdir() directory %s error",YSM_ConfigDir);
			YSM_Error(ERROR_CRITICAL);
		}
	}

        if( ( YSM_CFGFD = fopen(YSM_ConfigFile,"w") ) != NULL) {

                YSM_tmpdate=time(NULL);

                fprintf(YSM_CFGFD,"# %s%s . \n",
					YSM_INFORMATION,YSM_INFORMATION2);

                fprintf(YSM_CFGFD,
		"# YSM <Configuration file> Created-> %s\n",
						 ctime(&YSM_tmpdate));

                fprintf(YSM_CFGFD,
		"# Critical Consequences might show up if you make any\n");

                fprintf(YSM_CFGFD,"# mistakes in this file. \n");
                fprintf(YSM_CFGFD,"\n");
		fprintf(YSM_CFGFD, "# This Status specifies the status you will have by default\n");
		fprintf(YSM_CFGFD,"# once you log in. Options are ONLINE, AWAY, DND, FREECHAT, NA,\n");
		fprintf(YSM_CFGFD,"# OCCUPIED and INVISIBLE.\n");
                fprintf(YSM_CFGFD,"STATUS>ONLINE\n");
                fprintf(YSM_CFGFD,"\nUIN>%d\n",YSM_USER.YSM_Uin);
                fprintf(YSM_CFGFD,"# You may replace your password with the word \"SECURE\"\n");
                fprintf(YSM_CFGFD,"# in order to be prompted for a password when logging in.\n");
                fprintf(YSM_CFGFD,"PASSWORD>%s\n",YSM_USER.YSM_Password);
                fprintf(YSM_CFGFD,"\nSERVER>%s\n",YSM_USER.SRV_HostName);
                fprintf(YSM_CFGFD,"SERVERPORT>%i\n",YSM_USER.SRV_Port);
		fprintf(YSM_CFGFD,"# Amount of minutes to wait with no keyboard input before going\n# automatically into AFK mode. Use '0' for disabling auto AFK.");
		fprintf(YSM_CFGFD,"\nIDLETIME>%d\n",YSM_SETTING_IDLETIME);
		fprintf(YSM_CFGFD,"\n# The Auto-Reply Message of the AFK mode");
		fprintf(YSM_CFGFD,"\nAFKMESSAGE>%s\n",YSM_AFK_MESSAGE);
		fprintf(YSM_CFGFD,"\n# Amount of messages to show each time in 'readafk'");
		fprintf(YSM_CFGFD,"\nAFKMAXSHOWN>%d\n",YSM_SETTING_AFKMAXSHOWN);

/* Proxy Stuff */
		fprintf(YSM_CFGFD,
		"\n# Proxy Configuration. For HTTPS use 1 on PROXY_HTTPS.");

		fprintf(YSM_CFGFD,"\nPROXY>%s\n", 
			!(YSM_USER.Proxy_host[0]) ? "0" : (char *)YSM_USER.Proxy_host);

		fprintf(YSM_CFGFD,"PROXY_PORT>%d\n", YSM_USER.Proxy_port);
		fprintf(YSM_CFGFD,"PROXY_HTTPS>%d\n", YSM_USER.Proxy_https);

/* end of Proxy Stuff */

		fprintf(YSM_CFGFD,"\n# Set to 0 or 1 the following FLAGS to avoid");
		fprintf(YSM_CFGFD," being prompted everytime or not\n# when starting ysm");
		fprintf(YSM_CFGFD,"\nASK_KEYMAP>%d\n",
					YSM_SETTING_ASK_KEYMAP);
		fprintf(YSM_CFGFD,"ASK_DOWNLOAD>%d\n",
					YSM_SETTING_ASK_DOWNLOAD);

		fprintf(YSM_CFGFD,"\n# Set BEEPING to ON(1) or OFF(0).\n# It only beeps on incoming messages, not status changes.");
		fprintf(YSM_CFGFD,"\nBEEP>1\n");

		fprintf(YSM_CFGFD,"\n# Set the amount of times to BEEP for beeping events\n# which are messages, alert slaves, etc..");
		fprintf(YSM_CFGFD,"\nBEEPAMOUNT>1\n");

		fprintf(YSM_CFGFD,"\n# Set GLOBAL Logging ON(1) or OFF(0) automatically\n# Use '1' to log messages into a history readable by the 'hist' command.");
		fprintf(YSM_CFGFD,"\nLOGALL>1\n");

		fprintf(YSM_CFGFD,"\n#WINALERT is a Win32 Console setting for incoming messages. \n"
		"# If set to \"1\" it will only popup.\n#If set to \"2\" it will only blink."
		"\n#If set to \"3\" it will popup and blink.");
		fprintf(YSM_CFGFD,"\nWINALERT>%d\n", YSM_SETTING_WINALERT);

#if 0	/* This feature is not yet finished, damn m$ hacks */

		fprintf(YSM_CFGFD,"\n#WINHOTKEY is a CTRL+ALT+key combination in charge of\n"
		"# activating a minimized YSM client. Set WINHOTKEY to the key you desire.");
		fprintf(YSM_CFGFD,"\nWINHOTKEY>%c\n", YSM_SETTING_HOT_KEY_MAXIMIZE);

#endif

		fprintf(YSM_CFGFD,"\n# Msg Kind types are 0(ONELINE) 1(VERBOSE) 2(IRC)");
		fprintf(YSM_CFGFD,"\nMSG_KIND>%d\n",
					YSM_SETTING_MSG_KIND);

		fprintf(YSM_CFGFD,"\n# VERBOSE Level. Default is 2. Higher means more output.");
		fprintf(YSM_CFGFD,"\nVERBOSE>%d\n",
					YSM_SETTING_VERBOSE);

		fprintf(YSM_CFGFD,"\n# VERSION CHECK. Specify 0 if you want to disable it.");
		fprintf(YSM_CFGFD,"\nVERSION_CHECK>%d\n",
					YSM_SETTING_VERSION_CHECK);

		fprintf(YSM_CFGFD,"\n# BROWSER. Specify the path to the browser that will handle urls from the \"burl\" command.\n(Windows users specify full path too)");
		fprintf(YSM_CFGFD,"\nBROWSER>0\n");


#ifdef YSM_USE_ICONV

		fprintf(YSM_CFGFD,"\n# TRANS_CHARSET is charset for transfering/receiving of messages");
		fprintf(YSM_CFGFD,"\n# LOCAL_CHARSET is charset for displaying/inputting of messages");
		fprintf(YSM_CFGFD,"\n# Russian Generic are TRANS: CP1251 LOCAL: KOI8R");
		fprintf(YSM_CFGFD,"\n# FreeBSD users please use those in lowercase.\n");
		fprintf(YSM_CFGFD,"\nCHARSET_TRANS>0");
		fprintf(YSM_CFGFD,"\nCHARSET_LOCAL>0");
#endif

                fprintf(YSM_CFGFD,"\n\n# your ICQ slaves.\n");
                fprintf(YSM_CFGFD,"%s\n",SLAVES_TAG);
                fprintf(YSM_CFGFD,"\n\n\n# <EOF>");

                fclose(YSM_CFGFD);

        }

        else 
	{
                PRINTF(YSM_VERBOSE_BASE,
			"\nERROR creating cfg file.\n");
		YSM_Error(ERROR_CRITICAL);
	}
}	
	


	
void
YSM_ReadSlaves(FILE *YSM_CFGFD) 
{

char	YSM_tmpbuf[MAX_PATH];
char	*auxnick = NULL,*auxuin = NULL,*auxkey = NULL;
short	YSM_MORESLAVES=TRUE;


	while(YSM_MORESLAVES) 
	{

        AmountSlaves = 0;
        memset(YSM_tmpbuf,'\0',MAX_PATH);

	if(fgets(YSM_tmpbuf,sizeof(YSM_tmpbuf)-1,YSM_CFGFD)==NULL) 
	{
		YSM_MORESLAVES = FALSE;
		continue;
        }

	if ((YSM_tmpbuf[0]!='#') && (YSM_tmpbuf[0] != 0) 
	&& (YSM_tmpbuf[0] != '\n')) 
	{

        auxnick = strtok(YSM_tmpbuf,"\n");

        if(!strcmp(auxnick,SLAVES_TAG)) 
	{

                memset(YSM_tmpbuf,'\0',MAX_PATH);

                while(YSM_MORESLAVES) 
		{

                if (fgets(YSM_tmpbuf,sizeof(YSM_tmpbuf)-1,YSM_CFGFD)==NULL) {
                        YSM_MORESLAVES=FALSE;
                        continue;
                        }

                if ((YSM_tmpbuf[0] != '#') && (YSM_tmpbuf[0] != 0) &&
		(YSM_tmpbuf[0] != '\n'))
		{
			
                        auxnick = strtok(YSM_tmpbuf,":");
                        if(auxnick) auxuin = strtok(NULL,":");
			if(auxuin) auxkey = strtok(NULL," \n\t");

			if(auxnick == NULL || auxuin == NULL)
			{
				/* No nick/uin specified, Weird! */
				/* Lucky slave! */
				/* Continue with the next slave */
				continue;
			}

			/* Check we have a valid line here */
			/* 4 number uins must be fake or something. */
			if(strlen(auxnick) < 1 || strlen(auxuin) < 5 )
			{
				/* Go get a new slave, dammit */
				/* Slaves nowadays need new brands */
				continue;
			}
				
			
			/* AddSlavetoList returns FALSE */
			/* if the SLAVE is repeated. */

			if(YSM_AddSlavetoList (&YSMSlavesList,
						auxnick,
						atoi(auxuin),
						auxkey,
						0,
						0,
						0,
						0))
			{
                      		  AmountSlaves++;
			}
			

               	}

                } 
	
	}

        } 


	}

PRINTF(YSM_VERBOSE_EXTRA,"%s%d]%s\n",MSG_READ_SLAVES,AmountSlaves,NORMAL);

}


YSM_SLAVE *
YSM_QuerySlaves ( UWORD TYPE, UBYTE *Extra , UDWORD Uin ) 
{
		
unsigned int	x;

	YSMSlavesList = YSMSlaves_First;

	switch (TYPE) {

		case SLAVE_NAME:

			for (x=0;x<strlen(Extra);x++)
					Extra[x] = tolower(Extra[x]);
			
			for ( x = 0; x < AmountSlaves; x++ ) 
			{
				if(!YSMSlavesList) break;

				if(!strcmp(YSMSlavesList->NickName,Extra))
						return YSMSlavesList;

				YSMSlavesList = YSMSlavesList->next;
			}
						
			return NULL;

			break;

		case SLAVE_UIN:

			for ( x = 0; x < AmountSlaves; x++ ) 
			{

				if (YSMSlavesList->Uin == Uin)
					return YSMSlavesList;

				YSMSlavesList = YSMSlavesList->next;
			}
			
			return NULL;

			break;

		default:

			YSM_Error (ERROR_CODE);
			break;

			}

	return 0;
}

void
YSM_AddSlave ( char *Name, int Uin ) 
{
	if(YSM_AddSlavetoList (&YSMSlavesList,Name,Uin, NULL, 0, 0, 0, 0))
		AmountSlaves++;

	else
	{
		PRINTF(YSM_VERBOSE_FUNCTIONAL,
			"NO! Illegal Slave Clonning detected..perv!.");
		PRINTF(YSM_VERBOSE_FUNCTIONAL,
			"\n%sSLAVE ALREADY%s exists in your list!.\n",
								BRIGHT_CYAN,
								NORMAL);
		return;
	}

	PRINTF(YSM_VERBOSE_FUNCTIONAL,
		"Adding a SLAVE with #%d. Call him %s from now on.\n",Uin,Name);

	YSM_AddSlavetoDisk (Name,Uin,NULL);

        return;
}


void
YSM_AddSlavetoDisk (char *name, int uin, char *c_key)
{

	FILE *YSM_CFGFD,*YSM_tmp;
	char YSMBuff[MAX_PATH];
	unsigned int x;

 	YSM_CFGFD = fopen(YSM_ConfigFile,"r");

	YSM_tmp = tmpfile();

        while(!feof(YSM_CFGFD)) {

            memset(YSMBuff,'\0',MAX_PATH);
            fgets(YSMBuff,sizeof(YSMBuff)-1,YSM_CFGFD);

                if(strstr(YSMBuff,SLAVES_TAG)) 
		{
			fprintf(YSM_tmp,"%s",YSMBuff);	
			fprintf(YSM_tmp,"%s:%d:",name,uin);
			if(c_key != NULL && !YSM_KeyEmpty(c_key)) 
			{
				for( x =0 ; x < strlen(c_key); x++ )
					fprintf(YSM_tmp,"%c",c_key[x]);

				fprintf(YSM_tmp,"\n");
			}
			else fprintf(YSM_tmp,"\n");

 		}

            else fprintf(YSM_tmp,"%s",YSMBuff);

        }

        fclose(YSM_CFGFD);

	rewind(YSM_tmp);

        YSM_CFGFD = fopen(YSM_ConfigFile,"w");

        while(!feof(YSM_tmp)) 
	{
                memset(YSMBuff,'\0',MAX_PATH);
                fgets(YSMBuff,sizeof(YSMBuff),YSM_tmp);
                fprintf(YSM_CFGFD,"%s",YSMBuff);
        }

         fclose(YSM_CFGFD);
         fclose(YSM_tmp);



	return;
}


/* the fl flag determinates wether the slave must be deleted from the
	disk & list (TRUE) or it just needs to be deleted from disk. (FALSE) */

void
YSM_DelSlave ( char *Name , int fl) {

        FILE *YSM_CFGFD,*YSM_tmp;
        char YSMBuff[MAX_PATH],*auxnick=0, *theuin = NULL, *therest=0;
	int YSM_SLAVEDELETED=FALSE;


                YSM_CFGFD = fopen(YSM_ConfigFile,"r");

                YSM_tmp = tmpfile();

                while(!feof(YSM_CFGFD)) 
		{
                        memset(YSMBuff,'\0',MAX_PATH);
                        fgets(YSMBuff,sizeof(YSMBuff),YSM_CFGFD);

			if(strstr(YSMBuff,SLAVES_TAG))
			{
				/* Cant forget about the SLAVES TAG! */
                       		fprintf(YSM_tmp,"%s",YSMBuff);

       				memset(YSMBuff,'\0',MAX_PATH);

				while(!YSM_SLAVEDELETED)
				{
                			if (fgets(YSMBuff,sizeof(YSMBuff)-1,
							YSM_CFGFD)==NULL) 
					{
                        			YSM_SLAVEDELETED = TRUE;
                    				 continue;
                        		}

	
				        if ((YSMBuff[0]!='#') &&
						(YSMBuff[0] != 0) && 
						(YSMBuff[0] != '\n'))
					{ 
					
                        			auxnick = strtok(YSMBuff,":");
					if(auxnick) 
						theuin = strtok(NULL,":");
					if(theuin)
						therest = strtok(NULL,"");


					if(theuin[strlen(theuin)-1] == '\n')
						theuin[strlen(theuin)-1] = '\0';

                        		if(auxnick)
					{
						if(!strcmp(auxnick,Name)) 
						{
						
                        			if(auxnick && fl)
						{
							YSM_DeleteSlavefromList
							(
							&YSMSlavesList,
							auxnick, atoi(theuin)
							);

							AmountSlaves--;
						}
						}
						else
						{
						fprintf(YSM_tmp,"%s:%s:",
							auxnick,theuin);

						if(therest != NULL)
							fprintf(YSM_tmp,"%s",
								therest);
						else
							fprintf(YSM_tmp,"\n");
					

						}
					}
                       			else if(strlen(YSMBuff)>2)
						fprintf(YSM_tmp,"%s",YSMBuff);
				
					}
                       			else if(strlen(YSMBuff)>2)
                       				fprintf(YSM_tmp,"%s",YSMBuff);
				}

			break;


			}
			else fprintf(YSM_tmp,"%s",YSMBuff);

                }

                fclose(YSM_CFGFD);

                YSM_CFGFD = fopen(YSM_ConfigFile,"w");

		rewind(YSM_tmp);
		
                memset(YSMBuff,'\0',MAX_PATH);

                while(!feof(YSM_tmp)) 
		{
                        memset(YSMBuff,'\0',MAX_PATH);
                        fgets(YSMBuff,sizeof(YSMBuff)-1,YSM_tmp);
                        fprintf(YSM_CFGFD,"%s",YSMBuff);

                }

                fclose(YSM_CFGFD);
                fclose(YSM_tmp);
	

	return;
}

void
YSM_SaveKey( YSM_SLAVE *slave )
{

	YSM_DelSlave( slave->NickName, 0);

	YSM_AddSlavetoDisk (slave->NickName,
				slave->Uin,
				slave->EncryptKey);

	return;
}


int
YSM_KeyEmpty( char *key )
{
unsigned int x; 

	for(x = 0; x < MAX_KEY_LEN ; x++)
		if(key[x] != 0x00) return 0;

	return 1;

}

FILE *
YSM_OpenCFG ( void ) 
{
	FILE *YSM_CFGFD;
	
	if ((YSM_CFGFD = fopen(YSM_ConfigFile,"r")) != NULL) 
		return YSM_CFGFD;
	else 
		return NULL;

}

void
YSM_CFGStatus ( char *validate ) 
{

unsigned int x;

	for ( x=0;x<=strlen(validate);x++)
		validate[x] = toupper(validate[x]);

	if (!strcmp(validate,"ONLINE"))
		YSM_USER.YSM_Status = YSM_ONLINE;

	else if (!strcmp(validate,"OFFLINE"))	
		YSM_USER.YSM_Status = YSM_OFFLINE;
	
	else if (!strcmp(validate,"AWAY"))
		YSM_USER.YSM_Status = YSM_AWAY;

	else if (!strcmp(validate,"NA"))
		YSM_USER.YSM_Status = YSM_NA;
	
	else if (!strcmp(validate,"DND"))
		YSM_USER.YSM_Status = YSM_DND;

	else if (!strcmp(validate,"OCCUPIED"))
		YSM_USER.YSM_Status = YSM_OCCUPIED;

	else if (!strcmp(validate,"FREECHAT"))
		YSM_USER.YSM_Status = YSM_FREE_CHAT;
	
	else if (!strcmp(validate,"INVISIBLE"))
		YSM_USER.YSM_Status = YSM_INVISIBLE;

	else
		YSM_USER.YSM_Status = YSM_ONLINE;

	return;

}

void
YSM_KeysSetup (void)
{
	char x;

	PRINTF(YSM_VERBOSE_BASE,
		"\n%s'help': %c 'wo': %c 'w': %c", MSG_ASK_KEYMAP1,
					YSM_KEYMAP_HELP,
					YSM_KEYMAP_WHOSON,
					YSM_KEYMAP_SLAVES);
	PRINTF(YSM_VERBOSE_BASE, "\n%s ",MSG_ASK_KEYMAP2);
	x = getchar();
#ifdef WIN32
	getchar();
#endif

	if (toupper(x) != 'Y')
	{
		PRINTF(YSM_VERBOSE_BASE,"\n");
		return;
	}

	PRINTF(YSM_VERBOSE_BASE,
		"\nWhat shortcut-key for the 'help' command? [usually 1]: "); 
	YSM_KEYMAP_HELP=getchar();
#ifdef WIN32
	getchar();
#endif

	PRINTF(YSM_VERBOSE_BASE,
		"\nWhat shortcut-key for the 'wo' command? [usually 2]: "); 
	YSM_KEYMAP_WHOSON=getchar();
#ifdef WIN32
	getchar();
#endif

	PRINTF(YSM_VERBOSE_BASE,
		"\nWhat shortcut-key for the 'w' command? [usually 3]: "); 
	YSM_KEYMAP_SLAVES=getchar();
#ifdef WIN32
	getchar();
#endif

	PRINTF(YSM_VERBOSE_BASE,
		"\nAll set, thank you.\n");
	
}

void
YSM_AFKMode (int turnon)
{
	time_t time_now;

	if(!turnon)
	{
		time(&time_now);

		PRINTF(YSM_VERBOSE_BASE,
			"%s %s%d%s %s",	MSG_AFK_MODE_OFF1,
					BRIGHT_BLACK,
					((time_now-YSM_AFK_Time)/60), 
					NORMAL,
					MSG_AFK_MODE_OFF2);

		PRINTF(YSM_VERBOSE_BASE,
			"%s%d%s %s %s %s",
					BRIGHT_BLACK,
					YSM_AFK_Count,
					NORMAL,
					MSG_AFK_MODE_OFF3,
					YSM_AFKFILENAME,
					MSG_AFK_MODE_OFF4);

		YSM_SETTING_AFK = FALSE;
	
		/* Only change the status back to online */
		/* if the user was in 'away' status.	 */
		if(YSM_USER.YSM_Status == YSM_AWAY)
			YSM_ChangeStatus (YSM_ONLINE,0x0);

		return;
	}

	PRINTF(YSM_VERBOSE_BASE,"%s\n",MSG_AFK_MODE_ON);

	time(&YSM_AFK_Time);

	YSM_AFK_Count = 0;
	YSM_SETTING_AFK = TRUE;

	if(!(strlen(YSM_AFKMessage)))
		strncpy(YSM_AFKMessage,YSM_AFK_MESSAGE,MAX_DATA_LEN);

	/* Only change the status to AWAY if the user is */
	/* in status ONLINE so we don't mess with their status */

	if( YSM_USER.YSM_Status == YSM_ONLINE
		|| YSM_USER.YSM_Status == YSM_FREE_CHAT )
		YSM_ChangeStatus (YSM_AWAY,0x0);

	return;

}

void
YSM_ReadLog (char *FileName)
{
	FILE *logfile;
	char *rfilename, *rwho = NULL, *rmsg = NULL, *rtime = NULL;
	int mnum = 1, tnum = 1, snum = 0, size;
	char q;
	char buff[ MAX_DATA_LEN+MAX_SLAVE_NICK+MAX_UIN_LEN+2 ];

	size = strlen(FileName)+strlen(YSM_ConfigDir)+2;
	rfilename = YSM_Malloc(size, __FILE__, __LINE__);
	memset(rfilename,'\0',size);
	snprintf(rfilename,size,"%s/%s",YSM_ConfigDir,FileName);

	if( (logfile = fopen(rfilename,"r")) == NULL)
	{
		PRINTF(YSM_VERBOSE_FUNCTIONAL,
			"\nNo Messages Found :: filename not found.\n");

		YSM_Free(rfilename, __FILE__, __LINE__);
		return;
	}

	memset( buff, '\0', sizeof(buff) );

	YSM_Display_Busy = TRUE;

	while( !feof(logfile) )
	{
		/* we use mnum > YSM.. since it starts as 1 already */
		if( (fgets(buff, sizeof(buff), logfile)) == NULL ||
				(mnum > YSM_SETTING_AFKMAXSHOWN && !snum))
		{

		PRINTF(YSM_VERBOSE_BASE,
			"\n" BRIGHT_BLUE "[N]ext %i  "
					 "[S]kip 10  "
					 "[C]lear all  "
					 "[Q]uit\n"
						NORMAL, 
						YSM_SETTING_AFKMAXSHOWN);
				
			q = getchar();
#ifdef WIN32		/* damn new line! */
			getchar();
#endif
			switch(toupper(q))
			{
				case 'C':
					PRINTF(YSM_VERBOSE_FUNCTIONAL,
							"\nClearing..\n");
					fclose(logfile);
					logfile = fopen(rfilename, "w");
					fprintf(logfile,"%s", "");
					fclose(logfile);

					YSM_Free (rfilename,
						__FILE__,
						__LINE__);

					YSM_Display_Busy = FALSE;
					YSM_AFK_Count = 0;
					return;
	
					break;

				case 'N':
					mnum = 1;
					break;

				case 'S':
					snum = 10;
					break;

				default :
					PRINTF(YSM_VERBOSE_BASE,"\n");
					fclose(logfile);

					YSM_Free (rfilename,
						__FILE__,
						__LINE__);

					YSM_Display_Busy = FALSE;
					return;
					break;
			}

		}

		if(strlen(buff) < 2)
			continue;

		rwho = strtok(buff,"<@#>");
		if (rwho)
		{	
			strtok(NULL,"<@#>");
			rmsg = strtok(NULL,"<@#>");

			if (rmsg)
				rtime = strtok(NULL, "");
		}
		else
		{
			PRINTF(YSM_VERBOSE_BASE,"\nreadlog :: parsing error.");
			YSM_Free(rfilename, __FILE__, __LINE__);
			fclose(logfile);
			YSM_Display_Busy = FALSE;
			return;
		}
	
		if(rwho)
		{
			PRINTF(YSM_VERBOSE_BASE,
				"\n"WHITE"Msg #%i:" NORMAL" - From: %s",
							tnum, rwho );
		}
		if(rtime)
			PRINTF(YSM_VERBOSE_BASE, "\nTime: %s", rtime );
		if(rmsg)
			PRINTF(YSM_VERBOSE_BASE, "Data: %s\n", rmsg );

		mnum ++;
		tnum ++;

		if (snum > 0) snum --;

		memset( buff, '\0', sizeof(buff) );

	}

	PRINTF(YSM_VERBOSE_FUNCTIONAL, "\nEnd of Messages\n");

	fclose( logfile );
	YSM_Free(rfilename, __FILE__, __LINE__);

	YSM_Display_Busy = FALSE;
	return;
}

int
YSM_VersionCheck (void)
{

char get_string[512], *aux, *auxb;


	PRINTF(YSM_VERBOSE_BASE,
		"\n" BLUE"YSM UP-TO-DATE Version Checking.."NORMAL);

	if((YSM_TCPSock = YSM_Connect(YSM_VERSIONCHECK_HOST, 0x0, 0x50, 
				atoi(YSM_USER.Proxy_host) ? 0x1 : 0x0, 0)) < 0)
	{
		PRINTF(YSM_VERBOSE_BASE,
			"\nVersion Check failed. Connection refused.\n\n");
		return 0;
	}

	memset(get_string,'\0',sizeof(get_string));

	snprintf(get_string, sizeof(get_string)-1,
			"GET http://%s/%s HTTP/1.0\n\n",
			YSM_VERSIONCHECK_HOST,
			YSM_VERSIONCHECK_FILE );

	SOCK_WRITE (YSM_TCPSock, get_string, sizeof(get_string));
	memset(get_string,'\0',sizeof(get_string));

	SOCK_READ (YSM_TCPSock, &get_string[0], sizeof(get_string)-1);

	if (strstr(get_string,"200 OK"))
	{

	if ( (aux = strstr(get_string,"YSM_LAST_VERSION")) != NULL)
	{
		auxb = strtok(aux, "YSM_LAST_VERSION ");
		if(auxb)
		{
			aux = strchr(auxb,'\n');
			if(aux) *aux = '\0';

			if(!strcmp(auxb, YSM_INFORMATION2))
				PRINTF(YSM_VERBOSE_BASE,
				GREEN"Version is up-to-date!\n\n"NORMAL);
			else
				PRINTF(YSM_VERBOSE_BASE,
				RED "Version isn't last! Go get %s!\n\n"
								NORMAL, auxb);
		}
		else
			PRINTF( YSM_VERBOSE_BASE,
			"\nVersion Check Failed. Data file corrupted.\n\n");
	}

	else
		PRINTF( YSM_VERBOSE_BASE,
			"\nVersion Check Failed. Data file corrupted.\n\n");
	}

	else
		PRINTF( YSM_VERBOSE_BASE,
		"\nVersion Check failed. Data file not found on host!.\n\n");

	close(YSM_TCPSock);
	return 0;
}

void
YSM_AskProxyConfiguration (void)
{

char	buf[MAX_PATH];

	PRINTF(YSM_VERBOSE_BASE,
	"\nIf you need to connect to the Internet through a Proxy.");

	PRINTF(YSM_VERBOSE_BASE,
	"\nPlease specify the address below or type 'no' for no proxy.\n");

	memset(buf,0,sizeof(buf));

#ifdef WIN32
/* Great idea by a co-worker of mine, Riq */
/* Let the user use his default Internet Explorer proxy! */
	if(YSM_ReadWindowsProxy ())
	{
		PRINTF(YSM_VERBOSE_BASE,
		"\nYSM found your Internet Explorer proxy settings.\n");

		PRINTF(YSM_VERBOSE_BASE,
		"Proxy host and port defaults loaded. You must still\n");

		PRINTF(YSM_VERBOSE_BASE,
		"specify a value for HTTPS, either 1 or 0.\n");
	}
#endif

	PRINTF(YSM_VERBOSE_BASE,
			"\nProxy Host/IP [%s]: ", YSM_USER.Proxy_host);

	YSM_fgets(buf,MAX_PATH-1);

	buf[strlen(buf)-1] = '\0';

	if(strlen(buf) >= 2)
	{
		if(!strcmp(buf,"no") || !strcmp(buf,"NO"))
			return;
	
		strncpy(YSM_USER.Proxy_host,buf,MAX_PATH-1);
	}

	PRINTF(YSM_VERBOSE_BASE,
			"\nProxy Port? [%d]: ", YSM_USER.Proxy_port);

	memset(buf,0,sizeof(buf));
	YSM_fgets(buf,MAX_PATH-1);

	if(strlen(buf) >= 2 && buf[0] != 0x00)
		YSM_USER.Proxy_port = atoi(buf);

	PRINTF(YSM_VERBOSE_BASE,
			"\nUse https? [1/0]: ");
	memset(buf,0,sizeof(buf));
	YSM_fgets(buf,MAX_PATH-1);
	YSM_USER.Proxy_https = atoi(&buf[0]);
	
	return;
}

void
YSM_HandleBurl (char *_argone)
{

#ifdef WIN32
char	launch_url[MAX_DATA_LEN];	/* using max data len, bleh */
STARTUPINFO		si;
PROCESS_INFORMATION	pi;
#else
char	*execv_args[3];
#endif


	/* show the bookmarks if no url was specified! */
	if(!_argone)
	{	/* re-using our functions, how sweet :) */
		YSM_ReadLog(YSM_BURLFILENAME);
		return;
	}

	/* launch the damn browser! */

	/* First check we have one configured. 2 bytes long should do hah! */
	if(!strcmp(YSM_BrowserPath,"0") || strlen(YSM_BrowserPath) <= 2)
	{
		PRINTF(YSM_VERBOSE_BASE, "\nNo! Won't launch a browser for"
		" the specified url.\nThere is no browser configured.\n"
		"re-run ysm with a value for the BROWSER> param in your"
		" configuration file.\n");
		return;
	}


#ifdef WIN32

	memset(launch_url, 0, MAX_DATA_LEN);

	snprintf(launch_url, MAX_DATA_LEN, "%s %s", YSM_BrowserPath, _argone);

	/* Now run the browser dammit! */
	/* Should we system? should we not, portability my friend! */

	PRINTF(YSM_VERBOSE_DEBUG_1,"\nRunning %s\n", launch_url); 

	ZeroMemory( &si, sizeof(si) );
	si.cb = sizeof(si);
	ZeroMemory( &pi, sizeof(pi) );

	CreateProcess(NULL,
		&launch_url[0],
		NULL,
		NULL,
		FALSE,
		0,
		NULL,
		NULL,
		&si,
		&pi);
#else
	/* unix exec code */
	if(fork() == 0)	/* child proc */
	{
		execv_args[0] = &YSM_BrowserPath[0];
		execv_args[1] = _argone;
		execv_args[2] = NULL;
		execv(YSM_BrowserPath, execv_args);
		exit(0);
	}
#endif
	
	return;
}

/* The following HandleCommand function makes use */
/* of the system() function. Since its locally user dependent */
/* it does not mean any risk unless the YSM user is drunk and willing */
/* to play with ';' chars :) */


void
YSM_HandleCommand (char *_argone)
{
	/* Sucks huh */
	system(_argone);

	return;
}
