/*	$Id: YSM_Network.c,v 1.29 2002/08/18 08:32:25 rad2k Exp $	*/
/*
-======================== You Sick Me v7 ===========================-

                                   |                                           
           - ----------------------                                          
    _      |                       |             _________________/_     _    
   _\____________   ______         _ __________  |               /             
     \           | _)    /                     \ |              /              
      \          |_\_  _/_______________/_      \|            _/               
                 |) /______________    /         \            |pix.imp         
                   /   \         )/___/         \  /          |                
  _    _\______   /    /__  ____/       - -------\/___________|               
         ` |  /__/        \/                                                   
           |          _      _           _                  __ ________ _      
           |                  )) y( O u  (s(i  C k    m.( E))                  
           |                                                                  
          -- ---------------- ---- -----                                     
                                  |                                            
                                  |                                            
-========================== YSM_Network.c ============================-

YSM (YouSickMe) ICQ Client. An Original Multi-Platform ICQ client.
Copyright (C) 2002 rad2k Argentina.

YSM is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

For Contact information read the AUTHORS file.

*/

#include "YSM.h"
/* International Languages Charset Convertion! */
#include "YSM_Iconv.h"

void
YSM_UpdatePrivacy (
	int	Setting
	);
int
YSM_LookupHN (
	char	*Hostname
	); 

void
EncryptPassword (
	char	*Password,
	char	*output
	);

int
InsertTLV (
	void	*string,
	int	type,	
	void	*memplace,
	int	len
	);

long
YSM_GetMicroTime (
	long	input
	);

void
YSM_Init_LoginA (
	UDWORD	Uin,
	UBYTE	*Password
	);

void
YSM_Init_LoginB (
	FLAP_Head *,
	char *,
	int
	);

void
YSM_Init_LoginC (
	TLV	thetlv,
	char	*buff
	);

void
YSM_SendCapabilities (
	void
	);

void
YSM_RequestContacts (
	void
	);

void
YSM_RequestOffline (
	void
	);

void
YSM_AckOffline (
	void
	);

void
YSM_SendCliReady (
	void
	);

void
YSM_RequestICBMRights (
	void
	);

void
YSM_SendICBM (
	void
	);

void
YSM_RequestBuddyRights (
	void
	);

void
YSM_RequestRates (
	void
	);

void
YSM_IncomingMultiUse (
	FLAP_Head	*head,
	SNAC_Head	*thesnac,
	char		*buf
	);

void
YSM_Incoming_BuddyList (
	FLAP_Head	*head,
	SNAC_Head	thesnac,
	char		*buf,
	int		buf_len
	);

void
YSM_Incoming_BuddyChange (
	FLAP_Head	*head,
	SNAC_Head	thesnac,
	char		*buf
	);

int
YSM_Incoming_SNAC (
	FLAP_Head *,
	char *,
	int
	);

void
YSM_ReceiveMessage (
	FLAP_Head	*,
	SNAC_Head	snac,
	char		*data
	);

void
YSM_Receive_Message_TypeA (
	int		tsize,
	unsigned char	*data,
	char		*RemoteUIN,
	char		*RemoteSTATUS,
	char		*msgid
	);

void
YSM_Receive_Message_TypeB (
	int		tsize,
	unsigned char	*data,
	char		*RemoteUIN,
	char		*RemoteSTATUS
	);


void
YSM_Receive_Message_TypeC (
	int		tsize,
	unsigned char	*data,
	char		*RemoteUIN,
	char		*RemoteSTATUS,
	char		*msgid
	);

void
YSM_Send_ACK_TypeC (
	char		*rUin,
	char		*seq,
	char		MsgType,
	char		*msgid
	);

void
YSM_Registration_Reply (
	FLAP_Head	*head,
	SNAC_Head	*thesnac,
	char		*buf
	);

void
YSM_IncomingPersonal(
	FLAP_Head	*head,
	SNAC_Head	*thesnac,
	char		*buf
	);

void
YSM_RequestPersonal(
	void
	);

void
YSM_Set_Buddy_Status (
	FLAP_Head	*,
	SNAC_Head	*snac,
	char		*data
	);

void
YSM_Set_Buddy_StatusB (
	unsigned int	NewStatus,
	char		*Uin,
	UDWORD		rIP_one,
	UDWORD		rIP_two,
	char		*rPort,
	unsigned int	rVer,
	unsigned int	PVer,
	char		*rdcCookie
	);

void
YSM_CloseDC (
	YSM_SLAVE	*victim
	);

void
YSM_OpenDC (
	YSM_SLAVE	*victim
	);

int
YSM_EncryptDCPacket (
	char *buf,
	int buf_len 
	);

int
YSM_DecryptDCPacket (
	char *buf,
	unsigned int buf_len
	);

DWORD
YSM_Send_SNAC (
	int		Family ,
	int		Subtype,
	BYTE		FlA,
	BYTE		FlB,
	char		*data,
	unsigned int	size,
	int		lseq,
	char		*reqid
	);

void
YSM_IncomingMainInfo (
	char	*buf,
	int	fl,
	int	tsize
	);

void
YSM_IncomingHPInfo (
	char	*buf,
	int	tsize
	);

void
YSM_IncomingWorkInfo (
	char	*buf,
	int	tsize
	);

void
YSM_IncomingSearch (
	char	*buf,
	int	tsize
	);


void
YSM_Buddy_Ack (
	FLAP_Head	*,
	SNAC_Head	thesnac,
	char		*buf
);

void
YSM_Buddy_RequestModify (
	void
	);

void
YSM_Buddy_RequestFinished (
	void
	);

int
YSM_Buddy_ReadSlave (
	char	*buf,
	int	tsize
	);

int
YSM_ParseSlave (
	char	*name
	);

void
YSM_Incoming_Scan (
	SNAC_Head	*thesnac
	);


unsigned int	AmountOnline = 0;

int		YSM_TCPSock = -1, YSM_DCSock = -1;
short		YSM_Logged_In = FALSE;
unsigned short	YSM_SeqNum = 1, YSM_SeqDC = 0xffff;	

/*	GroupID_List will hold a list of the WORD ids of
	every group. GroupID_Users will hold a list of the
	WORD ids of every user in OUR group.  */

char		*YSM_GroupID_List = NULL;
char		*YSM_GroupID_Users = NULL;
int		YSM_GroupID_Amount = 0;
int		YSM_GroupID_Users_Amount = -1;

/*	For making any further changes to our Buddy list, we need to
	increment the counter for what we get in our incoming buddy list ! */

int		YSM_Buddy_ChangeCount = 0;

/* Used for RequestInfo with OUR info */

DWORD		YSM_personal_infoid = 0;
short		DOWNLOADED_CONTACTS = FALSE;

/* Required for storing the reqid for the creation of the YSM group */
/* Since this is C language ;) and it would be the same to add it */
/* in the ysm USER structure. Don't cry! */
DWORD		YSM_Group_ReqID = 0;

/* For our privacy settings */
int		YSM_PrivacyGroupID = 0;

/* amount of scan replies we are waiting for.. */
int			YSM_AwaitingScan = 0;

/* For spoofing if wanted */

int			YSM_SpoofUIN = 0;

extern	short		YSM_Redraw_Console;
extern	short		YSM_Display_Busy;
extern	unsigned int	AmountSlaves;
extern	short		YSM_Message_Arrived;

extern	char		YSM_AFKMessage[MAX_DATA_LEN];

extern	YSM_SLAVE	*YSMSlaves_LastRead;
extern	YSM_SLAVE	*YSMSlavesList,*YSMSlaves_First, *YSMSlaves_TabSlave;

extern	struct		YSM_MODEL YSM_USER;

extern	time_t		YSM_LastKA;

#ifdef YSM_USE_ICONV
extern	char	YSM_SETTING_CHARSET_TRANS[MAX_CHARSET + 4];
extern	char	YSM_SETTING_CHARSET_LOCAL[MAX_CHARSET + 4];
#endif

int
YSM_Connect (char *srv_host, UDWORD srv_ip, WORD srv_port, int USE_PROXY, int v ) 
{
	int YSMtmp, the_sock = 0;
	struct sockaddr_in YSMSRV;
	struct hostent *YSM_tmph = NULL;
	char proxy_string[512], *aux, q;


		the_sock = socket (AF_INET, SOCK_STREAM, 0);
		memset(proxy_string, '\0', sizeof(proxy_string));

		YSM_FDAdd_rsocket(the_sock);

	if(USE_PROXY)
	{
		YSM_LookupHN ( YSM_USER.Proxy_host );
		YSMSRV.sin_addr.s_addr = YSM_USER.SRV_IP;
	}
	else
	{
		if(srv_ip == 0x0)
			YSM_LookupHN ( srv_host );
		else
			YSM_USER.SRV_IP = srv_ip;

		YSMSRV.sin_addr.s_addr = YSM_USER.SRV_IP;
	}
		
		if (YSMSRV.sin_addr.s_addr == -1) 
		{
			if(USE_PROXY)
			YSM_tmph = gethostbyname (YSM_USER.Proxy_host);
			else if(srv_host != NULL)
				YSM_tmph = gethostbyname (srv_host);

			if (YSM_tmph == NULL) return -1;
			YSMSRV.sin_addr = *((struct in_addr *)YSM_tmph->h_addr);
		}

		YSMSRV.sin_family = AF_INET;

	if(USE_PROXY)
		YSMSRV.sin_port = htons (YSM_USER.Proxy_port);
	else
		YSMSRV.sin_port = htons (srv_port);

		if (connect (the_sock, (struct sockaddr *)&YSMSRV,
						sizeof( YSMSRV )) < 0 )
		{
			PRINTF(YSM_VERBOSE_BASE,
				MSG_ERR_CONNECT "\n");

			return -1;
		}


	if(USE_PROXY)
	{
		if(v)
			PRINTF(YSM_VERBOSE_BASE ,
			"\n" MSG_CONN_PROXYOK "\n");

		snprintf(proxy_string, sizeof(proxy_string)-1, 
				"CONNECT %s:%d HTTP/1.0\n\n",
					srv_host,
					YSM_USER.Proxy_https ? 443 : 5190 );

		YSM_WRITE(the_sock, proxy_string,sizeof(proxy_string));

		memset(proxy_string,'\0',sizeof(proxy_string));

		while(strlen(proxy_string) < 10)
			SOCK_READ( the_sock, &proxy_string[0],
						sizeof(proxy_string)-1);


		aux = strtok(proxy_string,"\n");

		if( !strstr(aux,"HTTP/1.0 200") )
		{
			PRINTF(YSM_VERBOSE_BASE,
			"\n" MSG_ERR_PROXY );
			PRINTF(YSM_VERBOSE_BASE,
			"\n" MSG_ERR_PROXY2);

			q = getchar();
			if(toupper(q) == 'Y')
				PRINTF(YSM_VERBOSE_BASE,
				"\n%s",aux);

			exit(0);
		}

	}

		YSMtmp = sizeof (YSMSRV);
		getsockname (the_sock, (struct sockaddr *)&YSMSRV, &YSMtmp);
		
		YSM_USER.YSM_IP = YSMSRV.sin_addr.s_addr;
		YSM_USER.YSM_Port = ntohs ( YSMSRV.sin_port );

		if(v)	
			PRINTF(YSM_VERBOSE_EXTRA,
			"\n" MSG_CONN_SERVEROK "\n");

		if(v)
	        	PRINTF(YSM_VERBOSE_FUNCTIONAL,
			"%s %d].\n",MSG_NETWORK_INFO, YSM_USER.YSM_Port);
		
		return the_sock;
}

int
YSM_LookupHN ( char *Hostname ) 
{

        struct hostent *YSMhalf;

        if ( ( YSM_USER.SRV_IP = inet_addr ( Hostname ) ) == -1 ) 
	{
                if ( ( YSMhalf = gethostbyname ( Hostname ) ) == NULL ) 
				YSM_Error(ERROR_NETWORK);

                memcpy (&YSM_USER.SRV_IP, (YSMhalf->h_addr), 4);
        }
                return 0;
}


void
YSM_SrvResponse( void )
{

char		*buf=0;
FLAP_Head	head;
int		r = 0, index = 0;
char		error_code[2];
TLV		login_tlv;


	memset(&head,0,FLAP_HEAD_SIZE);
	memset(&error_code,0,2);

	r = YSM_READ(YSM_TCPSock,&head,FLAP_HEAD_SIZE);
	if ( r < 1 ) return;

	buf = YSM_Malloc( Chars_2_Wordb(head.dlen)+1, __FILE__, __LINE__);

	memset(buf,'\0', Chars_2_Wordb(head.dlen)+1);
	r = YSM_READ(YSM_TCPSock, buf, Chars_2_Wordb(head.dlen));

	switch(head.channelID)
	{ 

	case YSM_CHANNEL_NEWCON:
		break;

	case YSM_CHANNEL_SNACDATA:
		YSM_Incoming_SNAC(&head,buf,r);
		break;
		
	case YSM_CHANNEL_FLAPERR:
		break;

	case YSM_CHANNEL_CLOSECONN:

		memcpy(&login_tlv, buf, sizeof(TLV));
		index = sizeof(TLV);
		index += Chars_2_Wordb(login_tlv.len);
		/* 0x05 is the TLV saying OK! */
		if (buf[index] != 0 || buf[index+1] != 5)
		{
			if(!buf[index] && buf[index+1] == 0x04)
			{
				memcpy(&login_tlv, &buf[index], sizeof(TLV));
				index += sizeof(TLV);
				index += Chars_2_Wordb(login_tlv.len);
			}	

			index += sizeof(TLV);
	
			memcpy(&error_code, &buf[index], 2);

			switch (Chars_2_Wordb(error_code))
			{
				case 0x0001:
					PRINTF(YSM_VERBOSE_BASE,
						MSG_ERR_INVUIN, "\n");	
					break;

				case 0x0004:
					PRINTF(YSM_VERBOSE_BASE,
						MSG_ERR_INVPASSWD, "\n");	
					break;

				case 0x0005:
					PRINTF(YSM_VERBOSE_BASE,
						MSG_ERR_INVPASSWD, "\n");	
					break;

				case 0x0007:
					PRINTF(YSM_VERBOSE_BASE,
						MSG_ERR_INVUIN, "\n");	
					break;

				case 0x0008:
					PRINTF(YSM_VERBOSE_BASE,
						MSG_ERR_INVUIN, "\n");	
					break;

				case 0x0015:
					PRINTF(YSM_VERBOSE_BASE,
						MSG_ERR_TOOMC, "\n");	
					break;

				case 0x0016:
					PRINTF(YSM_VERBOSE_BASE,
						MSG_ERR_TOOMC, "\n");	
					break;

				case 0x0018:
					PRINTF(YSM_VERBOSE_BASE,
						MSG_ERR_RATE, "\n");	
					break;

			}

			PRINTF(YSM_VERBOSE_BASE,
			"\n" MSG_ERR_DISCONNECTED "\n");
			YSM_Error(ERROR_NETWORK);
		}

		else
		{
			if(!YSM_Logged_In)
				YSM_Init_LoginB(&head, buf, r);
		}

		break;

	default:

		PRINTF(YSM_VERBOSE_DEBUG_2,
				"\nEl channel ID es: %d\n",head.channelID);
		PRINTF (YSM_VERBOSE_DEBUG_2,
				 "[ERR] Inexisting channel ID received");
		PRINTF (YSM_VERBOSE_DEBUG_2,
				 "inside a FLAP structure.\n");
		PRINTF (YSM_VERBOSE_DEBUG_2,
				 "As I'm a paranoid one.. i'll disconnect.\n");

		break;
	}	

	YSM_Free(buf, __FILE__, __LINE__);
	
}


int
YSM_Incoming_SNAC(FLAP_Head *head, char *buf, int buflen)
{
	SNAC_Head	 thesnac;
	int		 a = 0;
	int		 newseq = 0;

	/* copy, and beware of padding of structs */
	memcpy (&thesnac, buf, SNAC_HEAD_SIZE);
	memcpy (&thesnac.ReqID, &buf[6], sizeof(DWORD));

	PRINTF(YSM_VERBOSE_DEBUG_1,
		"\nSNAC id %x and sub %x\n",Chars_2_Wordb(thesnac.familyID),
	Chars_2_Wordb(thesnac.SubTypeID)); 

	switch(Chars_2_Wordb(thesnac.familyID))
	{

		case YSM_BASIC_SERVICE_SNAC:

		PRINTF(YSM_VERBOSE_DEBUG_1, "Basic Service SNAC arrived!\n");

		switch(Chars_2_Wordb(thesnac.SubTypeID))
		{
			case YSM_SERVER_IS_READY:
				PRINTF(YSM_VERBOSE_DEBUG_1,
					"Server Ready. Notifying the\n");
				PRINTF(YSM_VERBOSE_DEBUG_1,
					"server that we are an ICQ client\n");

				a = YSM_Send_SNAC( 
						0x1,
						0x17,
						0x0,
						0x0,
						(char *)icqCloneIdent,
						sizeof(icqCloneIdent),
						Chars_2_Wordb(head->seq), NULL);
				break;

		
			case YSM_ACK_ICQ_CLIENT:

				YSM_SeqNum = Chars_2_Wordb(head->seq);
				YSM_RequestRates ();
			
				break;


			case YSM_RATE_INFO_RESP:
		/* Just an ACK that we received the rates */
				YSM_Send_SNAC(
					0x1,
					0x08,
					0x0,
					0x0,
					(char *)Rates_Acknowledge,
					sizeof(Rates_Acknowledge),
					YSM_SeqNum++, NULL);	
	
			/* ICBM, CAPABILITES, YOU NAME IT! */	
				YSM_RequestICBMRights();
				YSM_RequestBuddyRights();
	
			/* Request Personal */
				YSM_RequestPersonal ();

				break;


			/* This is either a status change Acknowledge	*/
			/* Or a personal information reply.		*/	
			/* We check its request ID to be 0x000E as sent */
			/* in the first request. If so, proceed with	*/
			/* the startup. Else, it's a status change.	*/

			case YSM_STATUS_CHANGE_ACK:
			/*case YSM_SCREEN_INFO_RESP: same thing */
				if(thesnac.ReqID == 0xE000000) 
				{
					YSM_IncomingPersonal ( head, &thesnac,
				   		 &buf[SNAC_HEAD_SIZE]);

					YSM_SendCapabilities();

					 /* If we have no slaves we would
					  * be sending an empty packet. */
					if(AmountSlaves>0)
						YSM_SendContacts();

					YSM_SendICBM();


					if(YSM_USER.YSM_Status != YSM_INVISIBLE)
						YSM_ChangeStatus( YSM_USER.YSM_Status, 0x0020);
					/* SET US AS READY */
					YSM_SendCliReady();
	
					YSM_RequestContacts ();
					YSM_RequestOffline ();

				}
				else
					PRINTF(YSM_VERBOSE_DEBUG_1,
						"Status Changed\n");
				
				break;
	
			default:
				break;

		}

		break;
				

		case YSM_MESSAGING_SNAC:

		switch(Chars_2_Wordb(thesnac.SubTypeID))
		{
			case YSM_MESSAGE_TO_CLIENT:
				YSM_ReceiveMessage (head, thesnac,
				    &buf[SNAC_HEAD_SIZE]);
				break;
		
			case YSM_MESSAGE_FROM_CLIENT:
				break;

			case YSM_HOST_ACK:	/* just a srv ack */
	/* But! We want this for our WAR mode, undocumented of course ;) */
	/* for not wasting time searching in the slaves list, use a global */
	/* flag, yak :( */

				if(0 != YSM_AwaitingScan)
					YSM_Incoming_Scan(&thesnac);

				break;
		
			case YSM_SRV_MISSED_CALLS:
				PRINTF(YSM_VERBOSE_EXTRA,
					"\n" MSG_AOL_WARNING ); 
				break;

			case YSM_CLI_SRV_ERRORMSG:
	/* We used to have lots of 0x1 subtypes printf's on the screen
	big mistake! not all of the error-codes are known and
	they still are useless for us. Plus, no printf's of %s now.*/

	/* Most of these errors are caused by really sucking
	features of the new-era icq clients, such as plugins yuk! */

	/* But! We want this for our WAR mode, undocumented of course ;) */
	/* for not wasting time searching in the slaves list, use a global */
	/* flag, yak :( */

				if(0 != YSM_AwaitingScan)
					YSM_Incoming_Scan(&thesnac);

				break;

			default:
	/* Dont bother the user with new subtypes arriving */
				break;
		}	

		break;


		case YSM_BUDDY_LIST_SNAC:

		switch(Chars_2_Wordb(thesnac.SubTypeID))
		{
			case YSM_SRV_ONCOMING_BUD:
				YSM_Set_Buddy_Status (head, &thesnac,
				    &buf[SNAC_HEAD_SIZE]);
				break;

			case YSM_SRV_OFFGOING_BUD:
				YSM_Set_Buddy_Status (head, &thesnac,
				    &buf[SNAC_HEAD_SIZE]);
				break;
			
			case YSM_SRV_REJECT_NOTICE:
				/* woha this seems serious..mama mia. */
				break;

			case YSM_SRV_RIGHTS_INFO:
				/* reply to rights request, just */
				/* we wont care about the data */
				break;

			default:

				PRINTF(YSM_VERBOSE_DEBUG_1,
				"\n[ERR]:  Unknown subtype");
				PRINTF(YSM_VERBOSE_DEBUG_1,
				": %x - in Buddy List SNAC\n",
				Chars_2_Wordb(thesnac.SubTypeID));

				break;
		}


		break;


		case YSM_MULTIUSE_SNAC:

		switch(Chars_2_Wordb(thesnac.SubTypeID))
		{

			case YSM_SRV_SEND_RESP:
				YSM_IncomingMultiUse(head, &thesnac,
				    &buf[SNAC_HEAD_SIZE]);
				break;

			default:
				break;
		}

		break;

		case YSM_ICQV8FUNC_SNAC:

		switch(Chars_2_Wordb(thesnac.SubTypeID))
		{
			case YSM_SRV_SEND_ROSTER:
				YSM_Incoming_BuddyList(head, thesnac,
				&buf[SNAC_HEAD_SIZE], buflen);
				YSM_SendContacts();
				break;
		
			case YSM_SRV_ROSTER_OK:
				break;

			case YSM_SRV_CHANGE_ACK:
				YSM_Incoming_BuddyChange(head, thesnac,
				&buf[SNAC_HEAD_SIZE]);
				break;
				
			default:
				break;
		}


		break;

		case YSM_REGISTRATION_SNAC:

		switch(Chars_2_Wordb(thesnac.SubTypeID))
		{
			case YSM_SRV_REPLY_REG:
				YSM_Registration_Reply(head, &thesnac,
				&buf[SNAC_HEAD_SIZE]);
				break;

			default:
				break;
		}


		break;



		default:
			break;

	}

	return (Chars_2_Wordb(head->dlen) + FLAP_HEAD_SIZE);
}

void
YSM_Set_Buddy_Status (FLAP_Head *flap, SNAC_Head *snac, char *data)
{
	char *Uin,*buf, *aux, nStat[2], rPort[2], rdcCookie[4], PVer[2];
	int Uinlen,x=0,len,notfound=FALSE;
	unsigned int	 rVer = 0; 
	UDWORD	rIP_one = 0, rIP_two = 0;

	if (data == NULL || data[0] == '\0')
		return;

	Uinlen = data[0];

	Uin = YSM_Malloc( Uinlen+1, __FILE__ , __LINE__ );

	memset(Uin,'\0',Uinlen+1);
	memset(rPort,'\0',2);

	memcpy(Uin,data+1,Uinlen);

/* We will use the variable x for going through all the TLV's */
/* Thats why we've got to start where the first TLV is. */

	x++;		
	x += Uinlen;
	x += 4;			/* Following 2 Words (2+2 = 4 bytes) */
	
	switch(Chars_2_Wordb(snac->SubTypeID))
	{
		case YSM_SRV_ONCOMING_BUD:

		while(x < (Chars_2_Wordb(flap->dlen) - SNAC_HEAD_SIZE))
		{

		/* *data should point to the TLV type field. */

			switch (Chars_2_Wordb(data+x))
			{

				case 0xA:
				{
				len = Chars_2_Wordb(data+x+2);
				x += sizeof(TLV);
				memcpy(&rIP_two, &data[x], 4);

				x += len;
				break;
				}

				case 0xC:	/* Direct Connnection Info */
				len = Chars_2_Wordb(data+x+2);
				if(len != 0)
				{
					x += sizeof(TLV);
					memcpy(&rIP_one, &data[x], 4);
					/* Port where client is listening */
					memcpy(&rPort,&data[x+6],2);
					memcpy(&PVer, &data[x+9], 2);	
					rdcCookie[0] = data[x+14];
					rdcCookie[1] = data[x+13];
					rdcCookie[2] = data[x+12];
					rdcCookie[3] = data[x+11];


					/* Do fingerprinting */
					/* Fist check if theres the YSM */
					/* encryption  identification,  */
					/* else look for common */
					/* YSM clients (old ones) */

					aux = (char *)&rVer;
					aux[0] = data[x+31];
					aux[1] = data[x+32];
					aux[2] = data[x+33];
					aux[3] = data[x+34];
	
					if( rVer != FINGERPRINT_YSM_CLIENT_CRYPT )
					{	
						aux[0] = data[x+26];
						aux[1] = data[x+25];
						aux[2] = data[x+24];
						aux[3] = data[x+23];
					}
				}

				x += len;
	
				break;

				case 0x6:
				{
				len = Chars_2_Wordb(data+x+2);
				buf = YSM_Malloc( len, __FILE__, __LINE__);
				memcpy(buf,data+x+4,len);
				memset(nStat,'\0',sizeof(nStat));	
				nStat[0] = buf[2];
				nStat[1] = buf[3];
				YSM_Free(buf, __FILE__, __LINE__);
				/*
				 * just cheat and quit, we only care
				 * about the STATUS by now.
				 */
				x = Chars_2_Wordb(flap->dlen)-SNAC_HEAD_SIZE;
				break;
				}

				case 0xf:
				{
				/*
				 * we use 0xf as a limit, since 0x6 (the status)
				 * must be before 0xf for sure. 
				 */
				notfound = TRUE;
				x = Chars_2_Wordb(flap->dlen)-sizeof(snac);
				break;
				}
			
				default:
				{
				/*data + 2 should contain
					the TLV len data field. */

				x += Chars_2_Wordb(data+x+2);
				x += sizeof(TLV);
				break;
				}
			
			}

		}					
				
		/*
		 * This is really raro, at a beginning I believe i was
		 * actually receiving the ONLINE status change, but it 
		 * now seems i'm not! Anyways, we know that if its an
		 * ONCOMING bud message and we dont find the status, 
		 * its online, smart, huh? =)
		 */
	
		if(notfound)
			YSM_Set_Buddy_StatusB(YSM_ONLINE,
						Uin,
						rIP_one,
						rIP_two,
						rPort,
						rVer,
						Chars_2_Wordb(PVer),
						rdcCookie);
		else
			YSM_Set_Buddy_StatusB(Chars_2_Wordb(nStat),
						Uin,
						rIP_one,
						rIP_two,
						rPort,
						rVer,
						Chars_2_Wordb(PVer),
						rdcCookie);
		break;

		case YSM_SRV_OFFGOING_BUD:
			YSM_Set_Buddy_StatusB(YSM_OFFLINE,
						Uin,
						rIP_one,
						rIP_two,
						rPort,
						rVer,
						Chars_2_Wordb(PVer),
						rdcCookie);

			AmountOnline--;

		break;
	}

	YSM_Free(Uin, __FILE__, __LINE__);
	return;
}


void
YSM_Set_Buddy_StatusB (unsigned int NewStatus, char *Uin, UDWORD rIP_one, UDWORD rIP_two, char *rPort, unsigned int rVer, unsigned int PVer, char *rdcCookie)
{

char		StatusString[MAX_STATUS_LEN];
time_t		timestamp;
struct tm	*time_stamp;
/* no prob with this array, dont worry */
char		time_string[10];
YSM_SLAVE	*YSM_Query;
int			x = 0;

	YSM_WriteStatus(NewStatus,StatusString);

	YSM_Query = NULL;

	YSM_Query = (YSM_SLAVE *) YSM_QuerySlaves (SLAVE_UIN,NULL,atol(Uin));
	
	timestamp = time(NULL);	

	if(YSM_Query)
	{

		YSM_Query->d_con.rIP_one = rIP_one;
		YSM_Query->d_con.rIP_two = rIP_two;
		YSM_Query->d_con.rPort = Chars_2_Wordb(rPort);
		memcpy(&YSM_Query->d_con.rCookie, rdcCookie, 4);



		time_stamp = localtime( &timestamp );
#ifdef WIN32
		strftime( time_string, 9, "%H:%M:%S", time_stamp );
#else
		strftime( time_string, 9, "%T", time_stamp );
#endif

	
		switch( rVer )
		{
		
			case FINGERPRINT_MIRANDA_CLIENT:
				YSM_Query->fprint = FINGERPRINT_MIRANDA_CLIENT;
				break;

			case FINGERPRINT_STRICQ_CLIENT:
				YSM_Query->fprint = FINGERPRINT_STRICQ_CLIENT;
				break;

			case FINGERPRINT_MICQ_CLIENT:
				YSM_Query->fprint = FINGERPRINT_MICQ_CLIENT;
				break;

			case FINGERPRINT_LIB2K_CLIENT:
				YSM_Query->fprint = FINGERPRINT_LIB2K_CLIENT;
				break;

			case FINGERPRINT_YSM_CLIENT:
				YSM_Query->fprint = FINGERPRINT_YSM_CLIENT;
				break;

			case FINGERPRINT_YSM_CLIENT_CRYPT:
				YSM_Query->fprint = FINGERPRINT_YSM_CLIENT_CRYPT;
				break;	

			default:	/* a Windows Version by default */
				YSM_Query->fprint = PVer;
				break;
		}

		/* increment the global online amount index */
		AmountOnline++;

#ifdef YSM_SILENT_SLAVES_STATUS

	if (YSM_Query->Status != YSM_OFFLINE && NewStatus != YSM_OFFLINE)
	{
		YSM_Query->Status = NewStatus;
		return;
	}

#endif

/* Fix for a known bug where the server keeps re-sending us the status of 
	each slave even though its the very same unchanged */

	if (YSM_Query->Status == NewStatus)
			return;

	YSM_Message_Arrived = TRUE;

#if defined(YSM_WITH_THREADS)
	/* If the display is busy, make the thread sleep for 2 seconds */
	while(YSM_Display_Busy) YSM_Thread_Sleep (2);
#endif

	if(YSM_Query->BudType.AlertMode)
	{
		PRINTF(YSM_VERBOSE_FUNCTIONAL,
			"\r%s<<[%sSLAVE %sA L E R T%s]>>%s\n",
						CYAN,
						WHITE,
						RED,
						CYAN,
						NORMAL);

		for(x = 0; x < YSM_SETTING_BEEPAMOUNT; x++)
			PRINTF(YSM_VERBOSE_FUNCTIONAL,"\a");
	}

	PRINTF(YSM_VERBOSE_FUNCTIONAL,
			"\r%s %s%s%s %s %s %s%s%s]\n",time_string,
						MSG_STATUS_CHANGE1,
						Uin,
						MSG_STATUS_CHANGE2,
						YSM_Query->NickName,
						MSG_STATUS_CHANGE3,
						GREEN,
						StatusString,
						NORMAL);
										
	YSM_Query->Status = NewStatus;
	YSM_Redraw_Console = TRUE;
	
	return;

	}

	PRINTF(YSM_VERBOSE_DEBUG_1,
		"\n[ERR] BudyStatusB Code. Changing STATUS for a slave");
	PRINTF(YSM_VERBOSE_DEBUG_1,
		" that is NOT in our list.");

	PRINTF(YSM_VERBOSE_DEBUG_1,
		"\n\nPorque? el uin q me llego es para: %ld\n",atol(Uin));

	return;

}

void
YSM_TreatMessage (int type, int tsize, char *data, char *uin, char *status, char *msgid)
{

	switch(type)
	{

                case 0x01:      /* Normal Msg. */
				YSM_Receive_Message_TypeA(tsize,
				data,
				uin,
				status,
				msgid);
				break;

		case 0x02:	/* Complex Msg, yack! */

				YSM_Receive_Message_TypeC(tsize,
				data,
				uin,
				status,
				msgid);
				break;

		case 0x04:	/* Utility Msg. */

			YSM_Receive_Message_TypeB(tsize,
				data,
				uin,
				status);
				break;
		default:
			PRINTF(YSM_VERBOSE_DEBUG_1,
			"#### Unsupported Message format Received.\n");
			PRINTF(YSM_VERBOSE_DEBUG_1,
			"### %x #\n",type); 
			break;

	}

	return;
}


void
YSM_ReceiveMessage (FLAP_Head *flap, SNAC_Head snac, char *data)
{

        /* Estos valores estan documentados, por eso estan hardcodeados. */
        BYTE WarnLVL[2],TLVnum[2],RemoteSTATUSFlags[2],RemoteSTATUS[2];
        BYTE MsgID[8];
        BYTE MsgFormat[2];
        int tsize=0,uinsize=0,len=0,Last_Tlv_Found = FALSE;
        char *RemoteUIN;
        TLV thetlv;

        memcpy(&MsgID,data+tsize,sizeof(MsgID));

        tsize += sizeof(MsgID);

        memcpy(&MsgFormat,data+tsize,sizeof(MsgFormat));

        tsize += sizeof(MsgFormat);

        uinsize = data[tsize];

        tsize += 1;

        RemoteUIN = YSM_Malloc( uinsize+1, __FILE__, __LINE__);

        if(!RemoteUIN || uinsize+1 < 1)
                return;

        memset(RemoteUIN,'\0',uinsize+1);
        memcpy(RemoteUIN,data+tsize,uinsize);

        tsize += uinsize;

        memcpy(&WarnLVL,data+tsize,sizeof(WarnLVL));

        tsize += sizeof(WarnLVL);

        memcpy(&TLVnum,data+tsize,sizeof(TLVnum));

        tsize += sizeof(TLVnum);

        /* When there is no data, we just get a single TLV
           to avoid any problems, we analyze the packet right now */

	/* btw, we cant use TreatMessage here since we handle it
	   in a pretty different way. */

        if ( Chars_2_Word(TLVnum) == 1 )
        {
                switch(Chars_2_Wordb(thetlv.type))
                {
                        case 0x3:       
			/* No data Message? No WAY! just break */
                                break;

                        case 0x4:       /* Could be an Auth Reply */
                                tsize += 4; /* skip head */
                                YSM_Receive_Message_TypeB(tsize,
                                                        data,
                                                        RemoteUIN,
                                                        RemoteSTATUS);
                                break;
                        default:
                                break;
                }

                YSM_Free(RemoteUIN, __FILE__, __LINE__);
                return;
        }


        while(!Last_Tlv_Found &&
		tsize <= (Chars_2_Wordb(flap->dlen) - SNAC_HEAD_SIZE))
        {
                memset(&thetlv,'\0',sizeof(TLV));
                memcpy(&thetlv,data+tsize,sizeof(TLV));

                tsize += sizeof(TLV);
                len = Chars_2_Wordb(thetlv.len);

                switch(Chars_2_Wordb(thetlv.type))
                {
                        case 0x03:      /* Last TLV found */
                                tsize += len;
                                tsize += 4;     /* skip next TLV head */
				YSM_TreatMessage(Chars_2_Wordb(MsgFormat),
						tsize,
						data,
						RemoteUIN,
						RemoteSTATUS,
						MsgID);

                                Last_Tlv_Found=TRUE;
                                break;

                        case 0x06:      /* senders status */
                                memcpy(&RemoteSTATUSFlags,data+tsize,2);
                                tsize += 2;
                                memcpy(&RemoteSTATUS,data+tsize,2);
                                tsize += 2;
                                break;

			case 0x05:	/* possibly strange utility msg. */
				YSM_TreatMessage(Chars_2_Wordb(MsgFormat),
							tsize,
							data,
							RemoteUIN,
							RemoteSTATUS,	
							MsgID);
                                Last_Tlv_Found=TRUE;
				break;
				
                        default:
                                tsize += len;
                                break;

                }

        }


        YSM_Free(RemoteUIN, __FILE__, __LINE__);
        return;
}


void
YSM_Receive_Message_TypeA (int tsize, unsigned char *data, char *RemoteUIN, char *RemoteSTATUS, char *msgid)
{

BYTE		MessageLen[2];
int		Msglen=0;
char		*Message = 0, *data_conv = 0;
unsigned int	fprint = 0x0;
YSM_SLAVE	*YSM_Query;

	/* TLV type 2, we skip the TLV Header. */
	/*tsize += 4; */
	/* Estructura : 3 bytes (05 01 00) 1 byte (01) 1 byte (01)  */
	/* 2 bytes (0101) 1 Word (Msg len + 4) 4 bytes (00 00 00 00)  */
	/* 1 String (Msg) */

	/* gaim seems to use 04 after the 05 01 00 sequence, and */
	/* adds 3 bytes after it */

	if (data[tsize+3] == 0x04)
		tsize += 3;


	/* Some clients such as Trillian add 2 more bytes here, weird */
	if (data[tsize+5] == 0x01 && data[tsize+6] == 0x01)
		tsize += 7;		/* go get the MsgLen */
	else
	{
		fprint = FINGERPRINT_TRILLIAN_CLIENT;
		tsize += 9;
	}

	/* El largo del msg tiene 4 bytes de mas.  */
	memcpy(&MessageLen,data+tsize,2);

	Msglen = Chars_2_Wordb(MessageLen) - 4;

	Message = YSM_Malloc(Msglen+1, __FILE__, __LINE__);

	memset(Message,'\0',Msglen+1);	/* so we leave it as a zstring */

	tsize += 6; 		/* Saltamos los siguientes bytes of crap */
	memcpy(Message,data+tsize,Msglen);

	YSM_Query = YSM_QuerySlaves(SLAVE_UIN,NULL,atoi(RemoteUIN));

	if (YSM_Query)
		YSMSlaves_LastRead = YSMSlaves_TabSlave =  YSM_Query;

#ifdef YSM_USE_ICONV

	if( YSM_Iconv(	YSM_SETTING_CHARSET_TRANS,
			YSM_SETTING_CHARSET_LOCAL,
			Message,
			&data_conv,
			YSM_ICONV_MAXLEN) < 0 )
#endif
	{
		data_conv = YSM_Malloc(Msglen+1, __FILE__, __LINE__);
		memcpy(&data_conv[0], Message, Msglen);
		data_conv[Msglen] = 0;
	}

	if (YSM_Query)
		if(!YSM_Query->fprint) YSM_Query->fprint = fprint;

	YSM_DisplayMsg (YSM_MESSAGE_NORMAL, atoi(RemoteUIN),
			Chars_2_Wordb(RemoteSTATUS),Msglen, data_conv,
			YSM_Query->NickName,
			!YSM_Query ? 0x0 : YSM_Query->LogFlag);

	if (YSM_SETTING_AFK)
	{
		if(YSM_Query)
		{
			if ((time(NULL)-YSM_Query->LastAFK) > MINIMUM_AFK_WAIT)
			{ /* using send message here to send encrypted if required */
				YSM_Send_Message(atoi(RemoteUIN),
						YSM_AFKMessage,
						YSM_Query->NickName,
						YSM_Query->LogFlag,
						YSM_Query);
						

				YSM_Query->LastAFK = time(NULL);
			}
		}
		else
			YSM_Send_MessageA(atoi(RemoteUIN),
						YSM_AFKMessage,
						strlen(YSM_AFKMessage),
						YSM_Query->NickName,
						0);
	}

	YSM_Free(Message, __FILE__, __LINE__);	

	YSM_Free(data_conv, __FILE__, __LINE__);

	return;


}



void
YSM_Receive_Message_TypeB (int tsize, unsigned char *data, char *RemoteUIN, char *RemoteSTATUS)
{

BYTE		MsgType,MsgFlags,MsgLength[2];
int		i=0,c=0,Msglen=0;
char		*Message=0, *data_conv = 0,*Reason=0;
YSM_SLAVE	*YSM_Query;


	/* struct: */
	/* 4 byte Integer (UIN) - 1 (msg type) - 1(msg flags) -  1(LNTS) ... */
	tsize += 4;

	/* Msg type */
	memcpy(&MsgType,data+tsize,1);
	tsize ++;
	memcpy(&MsgFlags,data+tsize,1);
	tsize ++;
	memcpy(&MsgLength,data+tsize,2);
	tsize +=2;


	Msglen = Chars_2_Word(MsgLength);

	Message = YSM_Malloc(Msglen+1, __FILE__, __LINE__);

	/* so we leave it as a zstring(aunque ya es creo) */
	memset(Message,'\0',Msglen+1);

	memcpy(Message,data+tsize,Msglen);


	YSM_Query = YSM_QuerySlaves(SLAVE_UIN,NULL,atoi(RemoteUIN));

	/* Message TypeB Can also be Contacts Sending and something else. */

	switch(MsgType)
	{

		case YSM_MESSAGE_NORMAL:

			if (YSM_Query)
			YSMSlaves_LastRead = YSMSlaves_TabSlave = YSM_Query;

#ifdef YSM_USE_ICONV
			if( YSM_Iconv(	YSM_SETTING_CHARSET_TRANS,
					YSM_SETTING_CHARSET_LOCAL,
					Message,
					&data_conv,
					YSM_ICONV_MAXLEN) < 0 )
#endif
			{
				data_conv = YSM_Malloc(Msglen+1, __FILE__, __LINE__);
				memcpy(&data_conv[0], Message, Msglen);
				data_conv[Msglen] = 0;
			}

			YSM_DisplayMsg (YSM_MESSAGE_NORMAL, atoi(RemoteUIN),
				Chars_2_Wordb(RemoteSTATUS),
				Chars_2_Word(MsgLength), data_conv,
				YSM_Query->NickName,
				!YSM_Query ? 0x0 : YSM_Query->LogFlag);

				YSM_Free(data_conv, __FILE__, __LINE__);

				break;

		case YSM_MESSAGE_AUTH:

			for(i=0;i<=Msglen;i++)
			{
				if((unsigned char)Message[i] == 0xfe) 
					c++;

				/* on the 5th 0xfe we have the Reason msg */
				if(c == 5)
				{
					Reason = strchr(Message+i,0xfe);
					Reason++;

				/* Break out of the for loop! */
				break;
				}

			}


			YSM_DisplayMsg(YSM_MESSAGE_AUTH,atoi(RemoteUIN),
			 	Chars_2_Wordb(RemoteSTATUS),Msglen,Reason,
		YSM_Query->NickName,!YSM_Query ? 0x0 : YSM_Query->LogFlag);


			break;

	case YSM_MESSAGE_ADDED:		/* added by user */

			YSM_DisplayMsg(YSM_MESSAGE_ADDED,atoi(RemoteUIN),
				Chars_2_Wordb(RemoteSTATUS),Msglen,NULL,
		YSM_Query->NickName,!YSM_Query ? 0x0 : YSM_Query->LogFlag);

			break;		

	case YSM_MESSAGE_AUTHOK:
	
			YSM_DisplayMsg(YSM_MESSAGE_AUTHOK,atoi(RemoteUIN),
				Chars_2_Wordb(RemoteSTATUS),Msglen,NULL,
		YSM_Query->NickName,!YSM_Query ? 0x0 : YSM_Query->LogFlag);

			break;

	case YSM_MESSAGE_AUTHNOT:
			YSM_DisplayMsg(YSM_MESSAGE_AUTHNOT,atoi(RemoteUIN),
				Chars_2_Wordb(RemoteSTATUS),Msglen,NULL,
		YSM_Query->NickName,!YSM_Query ? 0x0 : YSM_Query->LogFlag);

			break;

	case YSM_MESSAGE_URL:

			YSM_DisplayMsg(YSM_MESSAGE_URL,atoi(RemoteUIN),
				Chars_2_Wordb(RemoteSTATUS),Msglen,data+tsize,
		YSM_Query->NickName,!YSM_Query ? 0x0 : YSM_Query->LogFlag);


			break;

	case YSM_MESSAGE_PAGER:

			YSM_DisplayMsg(YSM_MESSAGE_PAGER,atoi(RemoteUIN),
				Chars_2_Wordb(RemoteSTATUS),Msglen,data+tsize+1,
		YSM_Query->NickName,!YSM_Query ? 0x0 : YSM_Query->LogFlag);
			break;

			
	default:
			PRINTF(YSM_VERBOSE_DEBUG_1,
				"Not supported type message was received.\n");
			PRINTF(YSM_VERBOSE_DEBUG_1,
				"Possible utilfunction not implemented.\n");
			break;

	}



	YSM_Free(Message, __FILE__, __LINE__);	

	return;


}

void
YSM_Receive_Message_TypeC (int tsize, unsigned char *data, char *RemoteUIN, char *RemoteSTATUS, char *msgid)
{

BYTE		MsgType,MsgFlags,MsgLength[2], Msgseq[2];
int		Msglen=0;
char		*Message=0, *data_conv = 0;
YSM_SLAVE	*YSM_Query;


	/* Only text msgs accepted */
	if(data[tsize] != 0 || data[tsize+1] != 0)
		return;

	tsize += 2;		/* if 0000, its a text msg */

	tsize += 8;		/* msg id? */
	tsize += 16;		/* capabilities? */

	tsize += 6;		/* TLV A + 2 bytes of data */
	tsize += 4;		/* TLV F empty in msgs */

	tsize += 4;		/* TLV 2711 header */

				/* Now TLV 2711 DATA */
	tsize += 2;
	tsize ++;
	tsize += 19;
	tsize += 4;
	tsize ++;
	tsize += 2;
	tsize += 2;
	memcpy(&Msgseq,data+tsize,2);
	tsize += 2;
	tsize += 12;
	
	/* Msg type */
	memcpy(&MsgType,data+tsize,1);
	tsize ++;
	memcpy(&MsgFlags,data+tsize,1);
	tsize ++;

	tsize += 4;		/* Status and priority */

	memcpy(&MsgLength,data+tsize,2);
	tsize +=2;


	Msglen = Chars_2_Word(MsgLength);

	Message = YSM_Malloc(Msglen+1, __FILE__, __LINE__);

	/* so we leave it as a zstring(aunque ya es creo) */
	memset(Message,'\0',Msglen+1);

	memcpy(Message,data+tsize,Msglen);


	YSM_Query = YSM_QuerySlaves(SLAVE_UIN,NULL,atoi(RemoteUIN));

	switch(MsgType)
	{

		case YSM_MESSAGE_NORMAL:

			if (YSM_Query)
			YSMSlaves_LastRead = YSMSlaves_TabSlave = YSM_Query;

#ifdef YSM_USE_ICONV
			if( YSM_Iconv(	YSM_SETTING_CHARSET_TRANS,
					YSM_SETTING_CHARSET_LOCAL,
					Message,
					&data_conv,
					YSM_ICONV_MAXLEN) < 0 )
#endif
			{
				data_conv = YSM_Malloc(Msglen+1, __FILE__, __LINE__);
				memcpy(&data_conv[0], Message, Msglen);
				data_conv[Msglen] = 0;
			}

			YSM_DisplayMsg (YSM_MESSAGE_NORMAL, atoi(RemoteUIN),
				Chars_2_Wordb(RemoteSTATUS),
				Chars_2_Word(MsgLength), data_conv,
				YSM_Query->NickName,
				!YSM_Query ? 0x0 : YSM_Query->LogFlag);

				YSM_Free(data_conv, __FILE__, __LINE__);

				break;

			
	default:
			PRINTF(YSM_VERBOSE_DEBUG_1,
				"TypeC: Not supported type message was received.\n");
			PRINTF(YSM_VERBOSE_DEBUG_1,
				"Possible utilfunction not implemented.\n");
			break;

	}



	YSM_Send_ACK_TypeC( RemoteUIN, Msgseq, MsgType, msgid );


	YSM_Free(Message, __FILE__, __LINE__);	

	return;


}

void
YSM_Send_ACK_TypeC( char *rUin, char *seq, char MsgType, char *msgid )
{
	char Format[2], Type[2], reqid[4];
	char *data;
	int dlen =0, index =0, nseq = 0;


		memset(reqid,'\0',4);	
		memset(Type,'\0',2);	
		memset(Format,'\0',2);
		Word_2_Charsb(Format,0x0002);
		
		dlen = 4 + 4;		/* msgid */
		dlen += 2;			/* msg format */
		dlen ++;			/* uin len */
		dlen += strlen(rUin)+1; /* uin + 0 */
		dlen += 2;			/* 0x03 */
		dlen += 2;			/* 0x1B00 */
		dlen += 2;			/* cli version */
		dlen += 4 + 4 + 4 + 4;	/* unk */
		dlen += 2;			/* unk */
		dlen += 4;			/* 0x03000000 */
		dlen ++;			/* unk */
		dlen += 2;			/* cookie? */
		dlen += 2;			/* 0x0E00 */
		dlen += 2;			/* cookie? */
		dlen += 4 + 4 + 4;	/* unk */
		dlen ++;			/* Msg type */
		dlen ++;			/* Msg Flags */
		dlen += 4;			/* unk */
		dlen += 2;			/* 0x0100 */
		dlen ++;			/* 0x00 */
		dlen += 4;			/* 0x00000000 */
		dlen += 4;			/* 0xffffff00 */

		

		data = YSM_Malloc(dlen, __FILE__, __LINE__);
		memset(data,'\0',dlen);

		memcpy(&data[index], msgid, 8);
		index += 8;
		memcpy(&data[index], &Format, 2);
		index += 2;

		data[index] = strlen(rUin);
		index ++;

		memcpy(&data[index], rUin, strlen(rUin));
		index += strlen(rUin);
		index ++;  /* zero */

		data[index] = 0x03;
		data[index+1] = 0x1B;
		index += 2;

		data[index+1] = YSM_PROTOCOL_VERSION;
		index += 2;		/* icq version */

		index += 17;	/* unk */
		index += 2;

		data[index] = 0x03;
		index += 4;

		index ++;

		memcpy(&data[index], seq, 2);
		index += 2;		/* seq? */

		data[index] = 0x0E;
		index += 2;

		memcpy(&data[index], seq, 2);
		index += 2;		/* seq? */

		index += 12;


		data[index] = MsgType;	/* Type + Flags */
		index += 2;
		
		index += 4;

		data[index] = 0x01;
		index += 2;			/* 0x0100 */

		index ++;			/* 0x00 */
		index += 4;			/* 0x00000000 */

		data[index] = (char)0xff;
		data[index+1] = (char)0xff;
		data[index+2] = (char)0xff;
		index += 4;			/* 0xffffff00 */


		reqid[3] = 0x0b;


		YSM_Send_SNAC( 0x04,
				0x0b,
				0x0,
				0x0,
				data,
				index,
				YSM_SeqNum++,
				reqid);

		YSM_Free(data, __FILE__, __LINE__);

	return;
}


DWORD
YSM_Send_SNAC (int Family , int Subtype, BYTE FlA, BYTE FlB, char *data,
    unsigned int size, int lseq, char *reqid)
{
	DWORD		ReqID;
	int		nseq=1,bsize=0,r=0;
	char		*buf=NULL;

	int x=0;

	bsize = SNAC_HEAD_SIZE + FLAP_HEAD_SIZE + size;

	buf = YSM_Malloc(bsize, __FILE__, __LINE__);

	/*
	 * create by hand the headers from definition, to avoid padding
	 * flap is BYTE + BYTE + BYTE[2] + BYTE[2] = 6
	 * snac is BYTE[2] + BYTE[2] + BYTE + BYTE + DWORD = 10
	 */
	memset(buf, 0, bsize);
	srand((unsigned int) time(NULL));
	Word_2_Charsb(&buf[FLAP_HEAD_SIZE], Family);
	Word_2_Charsb(&buf[FLAP_HEAD_SIZE + 2], Subtype);
	buf[FLAP_HEAD_SIZE + 4] = (BYTE) FlA;
	buf[FLAP_HEAD_SIZE + 5] = (BYTE) FlB;
	ReqID = rand() & 0xffffff7f;

	if(reqid == NULL)
		memcpy(&buf[FLAP_HEAD_SIZE + 6], &ReqID, sizeof(DWORD));
	else
		memcpy(&buf[FLAP_HEAD_SIZE + 6], &reqid[0], 4);

	/* copy the data */
	if(data != NULL)
	memcpy(&buf[FLAP_HEAD_SIZE + SNAC_HEAD_SIZE], data, (size_t) size);

	buf[0] = 0x2a;	/*siempre */
	buf[1] = 0x2;	/*los snacs solo van en channel 2 */

	nseq += lseq ; 	/* 1+= last seq == new seq */

	Word_2_Charsb(&buf[2], nseq);

	YSM_SeqNum = nseq;		/* Update the global SEQ trace! */

	Word_2_Charsb(&buf[4], bsize - FLAP_HEAD_SIZE);



	PRINTF(YSM_VERBOSE_DEBUG_2,"\n");
	for(x = 0; x < FLAP_HEAD_SIZE; x++)
		PRINTF(YSM_VERBOSE_DEBUG_2," %x", buf[x]);
	PRINTF(YSM_VERBOSE_DEBUG_2,"\n");
	for(x = FLAP_HEAD_SIZE; x < bsize; x++)
		PRINTF(YSM_VERBOSE_DEBUG_2," %x", buf[x]);

	r = YSM_WRITE(YSM_TCPSock, buf, bsize);

	if (r<1) perror("SOCK_WRITE");

	YSM_Free(buf, __FILE__, __LINE__);

	return ReqID;
}


/* Send first Greeting Packet */
/* Use the global DC Socket */

void
YSM_Init_DCA ( YSM_SLAVE *remote_slave )
{

/* We are sure about this size, dun worry kid :P */
char	buf[50];
int	index = 0;

	memset(&buf[0], 0, sizeof(buf));

	buf[index] = 0x30;
	index += 2;

	buf[index] = (char) 0xff;
	index += 1;

	buf[index] = YSM_PROTOCOL_VERSION;	/* Protocol version (0x0008) */
	index += 2;

	buf[index] = 0x2b;
	index +=2;
	
	memcpy(&buf[index], &remote_slave->Uin, 4);	
	index += 4;

	/* buf[7 && 8] are 0x0000 */
	index += 2;

	/* buf[9 && 10 && 11 && 12] are local port. NONE! */
	buf[index] = (char)0xff;
	buf[index+1] = (char)0xff;
	buf[index+2] = (char)0xff;
	buf[index+3] = (char)0xff;
	index += 4;

	memcpy(&buf[index], &YSM_USER.YSM_Uin, 4);	
	index += 4;

	buf[index] = (char)0xff;
	buf[index+1] = (char)0xff;
	buf[index+2] = (char)0xff;
	buf[index+3] = (char)0xff;
	
	index += 4;	/* Our external IP, who cares? */
	index += 4;	/* Our internal IP, wtf, NO i wont give it out */

	buf[index] = 0x04;		/* TCP Capable flag.0x04 is YES(liE?)*/	
	index += 1;

	index += 4;	/* Our local port again for Chat/Files..fuck out ! */

	/* DC Cookie... */
	memcpy(&buf[index], &remote_slave->d_con.rCookie, 4);
	index += 4;

	buf[index] = 0x50;		/* Extra crap, just in case */
	index += 4;

	buf[index] = 0x03;
	index += 4;

	index += 4;		/* Extra dword , just 0 */

	YSM_WRITE(remote_slave->d_con.rSocket, &buf[0], index);
}

void
YSM_Init_DCB ( YSM_SLAVE *remote_slave )
{

/* We are sure about this size, dun worry kid :P */
char	buf[6];
int	index = 0;

	memset(&buf[0], 0, sizeof(buf));

	buf[index] = 0x04;		/* whole len */
	index += 2;

	buf[index] = 0x01;		/* ACK */
	index += 4;

	YSM_WRITE(remote_slave->d_con.rSocket, &buf[0], index);

	return;
}

void
YSM_Init_DCC ( YSM_SLAVE *remote_slave )
{

/* We are sure about this size, dun worry kid :P */
char	buf[35];
int	index = 0;

	memset(&buf[0], 0, sizeof(buf));

	buf[index] = 0x21;		/* whole len */
	index += 2;

	buf[index] = (char) 0x03;
	index += 1;

	buf[index] = 0x0a;		/* Protocol version (0x0007) */
	index += 4;

	buf[index] = 0x01;	
	index += 4;			/* Let it be 0x00, part of len */

	index += 20;
	
	buf[index] = 0x01;
	index += 2;
	buf[index] = 0x04;
	index += 2;
	
	YSM_WRITE(remote_slave->d_con.rSocket, &buf[0], index);

	return;
}

void
YSM_DC_Message( YSM_SLAVE *victim, char *_msg )
{

char	*buf = NULL;
int	buf_size = 0, index = 0;

	buf_size = 2 + 39 + strlen(_msg) + 1;

	buf = YSM_Malloc( buf_size, __FILE__, __LINE__ );

	memset(buf, 0, buf_size);

	buf[index] = 39 + strlen(_msg) + 1;
	index += 2;

	buf[index] = 0x02;
	index ++;

	index += 4;	/* check_code, filled in crypt */

	buf[index] = 0x07;	/* CMD MESSAGE */
	buf[index+1] = (char)0xEE;
	index += 2;

	buf[index+1] = 0x0E;	/* 2nd UNK CMD */
	index += 2;

	index += 2;		/* Seq (0x0000) start? */

	index += 4;
	index += 4;
	index += 4;

	buf[index] = 0x01;	/* msg type 0x0001 is normal */
	index += 2;


	index += 2;		/* UNK */

	index += 2;		/* local status, ONLINE! by default */

	buf[index] = strlen(_msg)+1;	/* len of msg WORD */
	index += 2;

	memcpy(&buf[index], _msg, strlen(_msg));	/* zero ended msg */
	index += strlen(_msg) + 1;
	
	index += 4;
	index += 4;

	YSM_EncryptDCPacket ( &buf[2], index-2 );	

	YSM_WRITE( victim->d_con.rSocket, &buf[0], index );

	YSM_Free( buf, __FILE__, __LINE__ );

	return;
}


void
YSM_Init_LoginA ( UDWORD Uin, UBYTE *Password ) 
{
	FLAP_Head head;
	int tsize=0,ret;
	char buf[4];
	char UinStr[MAX_ICQNUM_LEN];
#ifdef WIN32
	char PasswdStr[MAX_PWD_LEN+1];
#else
	char PasswdStr[strlen(Password)];
#endif
	char *profile2 = "ICQ Inc. - Product of ICQ (TM).2020b.r.ad.2.k.r.u.la";
	char *profile = "ICQ Inc. - Product of ICQ (TM).2001b.5.15.1.3638.85";
	int dwordver = 0x85000000;
	int unkdata = 0x0A01,majorver= 0x0500,minorver=0x0f00,lesserver=0x0100, paqsize,newseq;
	int buildver = 0x0e36;
	char *paquete;
	

	memset(&head,'\0',sizeof(head));
	memset(buf,'\0',4);

	snprintf(UinStr,MAX_ICQNUM_LEN,"%d",Uin);
	
	if (YSM_READ(YSM_TCPSock, &head, FLAP_HEAD_SIZE) < FLAP_HEAD_SIZE
	|| YSM_READ(YSM_TCPSock, &buf, sizeof(buf)) < sizeof(buf))
		return;

	/* El server nos manda listo para login en la data 0001 */
	if( !buf[0] && !buf[1] && !buf[2] && buf[3] == 1)
	{

		/* En el paquete va el FLAPHead, 4 bytes de data, y 11 TLV's */
		paqsize = strlen(UinStr) + strlen(Password) + strlen(profile) + 18;
		paqsize += 11 * sizeof(TLV); 
		paqsize += FLAP_HEAD_SIZE + 4;

		paquete = YSM_Malloc(paqsize, __FILE__, __LINE__);

		memset(paquete,'\0',paqsize);

		/* We Leave space for the Flap Head */
		tsize += FLAP_HEAD_SIZE;

		/* We copy the 0001 as reply  */
		memcpy(paquete+tsize,&buf,4);
		tsize += 4;
		
		/* TLV type 1  */
		ret = InsertTLV(UinStr,0x1,paquete+tsize,strlen(UinStr));

		tsize += ret;

		memset(PasswdStr,'\0',sizeof(PasswdStr));
		EncryptPassword(Password,PasswdStr);

		/* TLV type 2 */
		ret = InsertTLV(PasswdStr,0x2,paquete+tsize,strlen(Password));
	
		tsize += ret;
	
		/* TLV type 3	 */
		ret = InsertTLV(profile,0x3,paquete+tsize,strlen(profile));

		tsize += ret;
	
		/* TLV type 16 */
		ret = InsertTLV(&unkdata,0x16,paquete+tsize,2);
		
		tsize += ret;

		/* TLV type 17 */
		/* major version 4 icq2000 5 icq2001 */
		ret = InsertTLV(&majorver,0x17,paquete+tsize,2);

		tsize += ret;

		/* Estos que siguen son valores que supongo que no importan  */
		/* que tienen, pero todos son WORD. */
		ret = InsertTLV(&minorver,0x18,paquete+tsize,2);
		tsize += ret;
		ret = InsertTLV(&lesserver,0x19,paquete+tsize,2);
		tsize += ret;
		ret = InsertTLV(&buildver,0x1A,paquete+tsize,2);
		tsize += ret;
		ret = InsertTLV(&dwordver,0x14,paquete+tsize,4);
		tsize += ret;

		/* and the final 4 bytes - Language and Country */

		/* TLV type 0F */
		ret = InsertTLV("en",0x0F,paquete+tsize,2);
		tsize += ret;

		/* TLV type 0E */
		ret = InsertTLV("us",0x0E,paquete+tsize,2);
		tsize += ret;

		/* Flap HEAD -- Replace the first sizeof(FLAP_Head) bytes */
		/* with the new Flap HEADER. */

		newseq = Chars_2_Wordb(head.seq);
		newseq++;
		Word_2_Chars(head.seq,newseq);

		tsize -= sizeof(FLAP_Head);
		/* Data Len means without the header file! */
		Word_2_Charsb(head.dlen,tsize-sizeof(FLAP_Head));
		memcpy(paquete,&head,sizeof(FLAP_Head));


		/* Cruzar dedos y mandar el paquete de Login -A- */
		YSM_WRITE(YSM_TCPSock,paquete,tsize);
	
		PRINTF ( YSM_VERBOSE_DEBUG_1, "Login A Sent to the Server\n" );

		YSM_Free(paquete, __FILE__, __LINE__);

	}	

	else 
	{

		PRINTF (YSM_VERBOSE_DEBUG_1,
			 "Login Init A Failure, bad Server Response.\n" );
		PRINTF (YSM_VERBOSE_DEBUG_1,
			 "The reply should have been 0001. Exiting..\n");
		YSM_Error(ERROR_CRITICAL);
	}	
}

void
YSM_Init_LoginB (FLAP_Head *head, char *buf, int buflen)
{
	TLV	thetlv;
	int	len, x = 0;
	char	*a,*cookie = NULL;

	if (buflen < Chars_2_Wordb(head->dlen) ||
	    buflen <= sizeof(thetlv))
		return;

	while (x < Chars_2_Wordb(head->dlen))
	{
	memcpy(&thetlv, buf+x, sizeof(thetlv));
	x += sizeof(TLV);
	len = Chars_2_Wordb(thetlv.len);
	
		switch(Chars_2_Wordb(thetlv.type)) 
		{

		case 0x1:
			/* reply from srv. */
			break;
	
		case 0x5:
			if ((a = strchr(&buf[x], ':')) == NULL)
				return;
			*a++ = '\0';

			memset(YSM_USER.SRV_HostName, '\0', MAX_PATH);
			strncpy(YSM_USER.SRV_HostName,
			    &buf[x], MAX_PATH);
			/* 5190 is default */
	
			YSM_USER.SRV_Port = (unsigned short)strtol(a, NULL, 10);
			PRINTF(YSM_VERBOSE_EXTRA,
				"\n%s (%s:%d)\n",MSG_NETWORK_INFO2,
						YSM_USER.SRV_HostName,
						YSM_USER.SRV_Port);
			break;
	
		case 0x6:	/* Cookie is here..hmmm ..comida ;) */
			cookie = &buf[x];
			break;
	
		case 0xC:
			YSM_Error(ERROR_NETWORK);
			break;		
		case 0x8:
		case 0x4:
			PRINTF(YSM_VERBOSE_DEBUG_1,
				"\n%s\n",MSG_ERR_DISCONNECTED);
		default:
			PRINTF(YSM_VERBOSE_BASE,
				"Invalid TLV arrived for cookie, quiting.\n");
			YSM_Error(ERROR_CRITICAL);
			break;
		}

		x += len;

	}

	PRINTF(YSM_VERBOSE_EXTRA,"\n%s\n",MSG_NETWORK_INFO3);

	YSM_TCPSock = YSM_Connect(YSM_USER.SRV_HostName, 0x0, YSM_USER.SRV_Port,
				atoi(YSM_USER.Proxy_host) ? 0x1 : 0x0, 1 );

	if (YSM_TCPSock < 0) 
                YSM_Error(ERROR_NETWORK);


	/* Generemos nuestro Seq random primario */
	srand((unsigned int)time(NULL));
	YSM_SeqNum = rand () % 0xffff;

	/* buf should contain de cookie by now */
	YSM_Init_LoginC (thetlv, cookie);

	YSM_Logged_In = TRUE;
	YSM_Redraw_Console = TRUE;

	PRINTF(YSM_VERBOSE_FUNCTIONAL,"\n%s\n\n",MSG_LOGIN_OK);

	return;

}


void
YSM_Init_LoginC ( TLV thetlv, char *buff)
{
	FLAP_Head head;
	char buf[4];
	char *paquete=0;
	int paqsize,newseq,tsize=0;


	memset(&head,'\0',sizeof(head));
	memset(buf,'\0',4);

	recv(YSM_TCPSock,(char *)&head,sizeof(head),0);
	recv(YSM_TCPSock,&buf[0],4,0);

	/* aca tambien el server nos manda el 0001 */
	if( !buf[0] && !buf[1] && !buf[2] && buf[3] == 1)
	{
		/* mandamos un solo TLV con la cookie */
		paqsize = sizeof(TLV) + 257; 
		paqsize += sizeof(FLAP_Head) + 4;

		paquete = YSM_Malloc(paqsize, __FILE__ , __LINE__);

		memset(paquete,'\0',paqsize);
		
		/* We Leave space for the Flap Head */
		tsize += sizeof(FLAP_Head);

		/* We copy the 0001 as reply  */
		memcpy(paquete+tsize,&buf,4);
		tsize += 4;
		
		/* TLV type 6 THE COOKIE! */
		/* (we alrady have the tlv from InitB) =) */
		memcpy(paquete+tsize,&thetlv,sizeof(TLV));
		tsize += sizeof(TLV);
		/* data of tlv...the cookie! =) */

		memcpy(paquete+tsize,buff,Chars_2_Wordb(thetlv.len));
		tsize += Chars_2_Wordb(thetlv.len);

		/* Flap HEAD -- Replace the first sizeof(FLAP_Head) bytes */
		/* with the new Flap HEADER. */
		
		newseq = Chars_2_Wordb(head.seq);
		newseq++;
		Word_2_Charsb(head.seq,newseq);

		/* Data Len means without the header file! */
		Word_2_Charsb(head.dlen,tsize-sizeof(FLAP_Head));
		memcpy(paquete,&head,sizeof(FLAP_Head));

		/* Cruzar dedos y mandar el paquete de Login -B (la cookie)- */
		YSM_WRITE(YSM_TCPSock,paquete,tsize);


		YSM_Free(paquete, __FILE__, __LINE__);
	
	}

	else
	{
		PRINTF(YSM_VERBOSE_DEBUG_1,
	"\nWeird, When we were going to send the cookie, we didnt receive\n");
		PRINTF(YSM_VERBOSE_DEBUG_1,
	"the 0001 from the server. So its an error, and we are quitting..\n");
		YSM_Error(ERROR_CRITICAL);
	}

	return;
}


/* 
YSM_UpdatePrivacy possible settings are:

0x1 : Allow all users to see you.
0x2 : Block all users from seeing you. (Even the visible)
0x3 : Block all users but the Visible list from seeing you.
0x4 : Block users on your deny list.
0x5 : Only allow users in your buddy list.
*/

void
YSM_UpdatePrivacy (int Setting)
{

int dlen=0, tsize =0;
char *data, item_type[2];
char YSMBuddy_ID[2];
char reqid[4];

	/* We increment the change count on our buddy list for future chgs */
 	YSM_Buddy_ChangeCount++;

	/* Just used if adding a Buddy */
	Word_2_Charsb(YSMBuddy_ID, YSM_PrivacyGroupID);


	dlen = 2;	/* Len (WORD) */
	dlen += 2 + 2; /* Group ID and Buddy ID */
	dlen += 2;	/* Type 0004 is changing Security Preferences */
	dlen += 2;	/* Extra len (WORD) */
	dlen += sizeof(TLV);	/* the 0xca TLV */
	dlen ++;	/* The Setting */

	data = YSM_Malloc(dlen, __FILE__, __LINE__);	

	memset(data, '\0', dlen);
	tsize = 0;

	tsize += 2;	/* len == 0 */
	tsize += 2;	/* GrpID == 0, Master Group! */

	memcpy(data+tsize,YSMBuddy_ID,2);
	tsize += 2;

	Word_2_Charsb(item_type,0x0004);
	memcpy(data+tsize,&item_type,2);	/* Type == 0x0004 */
	tsize += 2;

	/* Len is a fixed size (sizeof(TLV) == 4, + Flag == 1 )	*/
	Word_2_Charsb(item_type,0x0005); /* Len, reusing the variable */ 
	memcpy(data+tsize,&item_type,2);	/* Xtra len */
	tsize += 2;

	memset(reqid,0,4);
	reqid[1] = YSM_Buddy_ChangeCount;
	reqid[3] = 0x09;

	/* Now insert the Setting in its TLV 0xca */
	InsertTLV(&Setting, 0xca, data+tsize, 1);

	YSM_Send_SNAC( 0x13,
			0x09,
			0x0,
			0x0,
			data,
			dlen,
			YSM_SeqNum++, reqid);

	YSM_Free(data, __FILE__, __LINE__);
	
	return;
}

int
YSM_ChangeStatus (int NewStatus, int Flags)
{
	TLV thetlv;
	int len=0, index = 0, f_print;
	char *buf;


		len = sizeof(TLV) + 4;	/* tlv 0x6 (status) */
		len += sizeof(TLV) + 2;	/* tlv 0x8 (?)*/
		len += sizeof(TLV) + 0x25; /* tlv 0x0c */
		
		buf = YSM_Malloc(len, __FILE__, __LINE__);

		memset(buf,'\0',len);

		/* TLV 0x6 */
                Word_2_Charsb(thetlv.type,0x6);
                Word_2_Charsb(thetlv.len,0x4);

		memcpy(&buf[index],&thetlv,sizeof(TLV));
		index += sizeof(TLV);
                memcpy(&buf[index],&Flags,2);
		index += 2;
                Word_2_Charsb(&buf[index],NewStatus);
		index += 2;
		
		/* TLV 0x8 */
                Word_2_Charsb(thetlv.type,0x8);
                Word_2_Charsb(thetlv.len,0x2);

		memcpy(&buf[index],&thetlv,sizeof(TLV));
		index += sizeof(TLV);
		index += 2;	/* Data is 0x0000 */

		/* TLV 0xC  - Direct Connections - */
                Word_2_Charsb(thetlv.type,0x0c);
                Word_2_Charsb(thetlv.len,0x25);

		memcpy(&buf[index],&thetlv,sizeof(TLV));
		index += sizeof(TLV);
		index += 4;		/* IP Address	*/
		index += 4;		/* Our Port	*/

		buf[index] = 0x00;	/* DC flag  */
		/* 0x01 for FW, 0x04 for NORMAL */
		index ++;

		index++;
		buf[index] = 0x00;	/* YSM_PROTOCOL_VERSION; */
		index ++;
		
		index += 4;	/* Connection Cookie */
		/* TODO: This could be important, if we set a cookie	*/
		/* here, maybe its the cookie required by any client	*/
		/* to connect to us. So we could check if the client	*/
		/* connecting to us, ever connected to the icq server	*/
		/* (that way, a unique real client)			*/

		index += 2;	/* Empty WORD */
	
		index ++;	
		buf[index] = 0x50;
		index ++;

		index += 2;	/* Empty WORD */

		index ++;
		buf[index] = 0x03;
		index ++;
	
		/* YSM Fingerprint */
		f_print = FINGERPRINT_YSM_CLIENT;
		memcpy( &buf[index], &f_print, 4 );
		index += 4;

		index += 4;	/* versioning */
		
		f_print = FINGERPRINT_YSM_CLIENT_CRYPT;
		memcpy( &buf[index], &f_print, 4 );
		index += 4;

	
		/* 2 zero bytes */
		index += 2;
		
		YSM_Send_SNAC( 0x1,
			0x1E,
			0x0,
			0x0,
			buf,
			len,	
			YSM_SeqNum++, NULL);

		if(NewStatus == YSM_INVISIBLE)
			YSM_UpdatePrivacy (0x3);


		else if (YSM_USER.YSM_Status == YSM_INVISIBLE)
		{
		/* Were in Invisible and changing to something else */
		/* We choose 0x4 as default, since it blocks people */
		/* in the deny list..a common request huh 	    */
			YSM_UpdatePrivacy (0x4);
		}

		YSM_USER.YSM_Status = NewStatus;	

		YSM_Free (buf, __FILE__, __LINE__);

	return NewStatus;
}


void
YSM_Send_MessageA(int UIN, char *data, int dlen, char *Nick, int LogFlag)
{
	unsigned int a=0,tsize=0,paqlen=0,tlvlen=0,myicqlen=0,ret=0;
	char *paquete=0, *tlvpack=0, *data_conv = 0;
	char MsgFormat[2],tlvnewdlen[2],ICQStr[MAX_ICQNUM_LEN];
	char log_name[MAX_PATH], *log_data;
	time_t	log_time;
	int log_len = 0;

#ifdef YSM_USE_ICONV
	if( YSM_Iconv(	YSM_SETTING_CHARSET_LOCAL,
			YSM_SETTING_CHARSET_TRANS,
			data,
			&data_conv,
			YSM_ICONV_MAXLEN) < 0 )
#endif	
	{
		data_conv = YSM_Malloc(dlen+1, __FILE__, __LINE__);
		memcpy(&data_conv[0], data, dlen);
		data_conv[dlen] = 0;
	}

	/* los 13 son el header del msg-data-1 */
	tlvlen = 13 + dlen;

	memset(ICQStr,'\0',MAX_ICQNUM_LEN);

	snprintf(ICQStr,MAX_ICQNUM_LEN,"%d",UIN);

	/* el paquete lleva unas cosas propias + 2 tlv, el ultimo, */
	/* vacio de tipo 6. */
	/* lo que lleva es: 8 bytes + 1 word (2 bytes) + 1 byte de len */
	/* + el string sin 0 del uin */

	paqlen = tlvlen + sizeof(TLV) + 8 + 2 + 1;
	paqlen += strlen(ICQStr) + sizeof(TLV);

	paquete = YSM_Malloc(paqlen, __FILE__, __LINE__);

	memset(paquete,'\0',paqlen);

	memcpy(paquete,&SendMessageID,sizeof(SendMessageID));
	
	tsize += 8;		/* Message ID */

	Word_2_Charsb(MsgFormat, 0x1);

	memcpy(paquete+tsize,&MsgFormat,sizeof(MsgFormat));

	tsize += sizeof(MsgFormat);

	myicqlen = strlen(ICQStr);

	memcpy(paquete+tsize,&myicqlen,1);

	tsize++;

	/* Dont copy the ending 0! */
	memcpy(paquete+tsize,&ICQStr,myicqlen);

	tsize += myicqlen;

/* construimos el tlv magico */

	tlvpack = YSM_Malloc(tlvlen, __FILE__, __LINE__);

	Word_2_Charsb(tlvnewdlen,dlen+4);

	memset(tlvpack,'\0',tlvlen);
	memcpy(tlvpack,HeadMsgData1,sizeof(HeadMsgData1));

	memcpy(tlvpack+sizeof(HeadMsgData1),&tlvnewdlen,
							sizeof(tlvnewdlen));
	memcpy(tlvpack+sizeof(HeadMsgData1)+sizeof(tlvnewdlen)+4,
							data_conv,dlen);

	ret = InsertTLV(tlvpack,0x2,paquete+tsize,tlvlen);

	tsize += ret;

	ret = InsertTLV(0x0,0x6,paquete+tsize,0x0);

	tsize += ret;

	a = YSM_Send_SNAC( 0x4, 0x6, 0x0, 0x0, paquete, tsize,
							 YSM_SeqNum++, NULL);

	log_time = time(NULL);

	if ( YSM_SETTING_LOGALL ||  LogFlag )
	{
		log_len = MAX_DATA_LEN+MAX_SLAVE_NICK+MAX_UIN_LEN+2;
		log_data = YSM_Malloc(log_len, __FILE__, __LINE__);
		memset(log_name,'\0',MAX_PATH);
		memset(log_data,'\0',log_len);
		snprintf(log_name, MAX_PATH-1, "%d", UIN);

		snprintf( log_data,log_len,
			"<YOU> <@#> %s <@#> %s", data, ctime(&log_time) );

		/* ** NOTE ** Using the 'a' variable again here */
		for(a = 0; a < strlen(log_data); a++)
			if(log_data[a] == '\n') log_data[a] = ' ';

		log_data[strlen(log_data)] = '\n';

		YSM_DumpLogFile(log_name,log_data);
		YSM_Free(log_data, __FILE__, __LINE__);
	}
	

	YSM_Free(data_conv, __FILE__, __LINE__);			

	YSM_Free(tlvpack, __FILE__, __LINE__);	

	YSM_Free(paquete, __FILE__, __LINE__);


}

void
YSM_Send_MessageB (int UIN, char *data, int dlen,  char *Nick, int mType, char mFlags, int _reqid)
{

unsigned int	a=0,tsize=0,paqlen=0,tlvlen=0,myicqlen=0,ret=0,paqindex = 0;
char		*paquete=0, *tlvpack=0, *data_conv = 0;
char		MsgFormat[2],tlvnewdlen[2],ICQStr[MAX_ICQNUM_LEN];
char		m_len[2];
int		log_len = 0;


#ifdef YSM_USE_ICONV
        if( YSM_Iconv(  YSM_SETTING_CHARSET_TRANS,
                        YSM_SETTING_CHARSET_LOCAL,
                        data,
                        &data_conv,
                        YSM_ICONV_MAXLEN) < 0 )
#endif  
        {
                data_conv = YSM_Malloc(dlen+1, __FILE__, __LINE__);
                memcpy(&data_conv[0], data, dlen);
                data_conv[dlen] = 0;
       }

	/* header length */
	/* 2 (type) + 4 + 4 + 4 + 4 + 4 + 4 (16 bytes capabilities) */
	/* + 2 + 2 + 2 */

	tlvlen = 2 + 4 + 4 + 4 + 4 + 4 + 4 + 2 + 2 + 2;
	tlvlen += 2 + 2 + 2 + 2 + 2 + 2 + 4 + 4 + 4 + 4 + 2 + 4 + 1 + 2;
	tlvlen += 2 + 2 + 4 + 4 + 4;
	tlvlen += 1 + 1 + 2 + 2;
	tlvlen += 2 + dlen; /* word len + data */


	memset(ICQStr,'\0',MAX_ICQNUM_LEN);
        snprintf(ICQStr,MAX_ICQNUM_LEN,"%d",UIN);

        /* el paquete lleva unas cosas propias + 2 tlv, el ultimo, */
	/* vacio de tipo 6. */
        paqlen = tlvlen + sizeof(TLV) + 8 + 2 + 1 + strlen(ICQStr);
	paqlen += sizeof(TLV);

        paquete = YSM_Malloc(paqlen, __FILE__, __LINE__);
	memset(paquete,'\0',paqlen);

	memcpy(paquete,&SendMessageID,sizeof(SendMessageID));

	tsize += 8;             /* Message ID */

	/* type B , type 2 */
	Word_2_Charsb(MsgFormat, 0x2);

	memcpy(paquete+tsize,&MsgFormat,sizeof(MsgFormat));

	tsize += sizeof(MsgFormat);

	myicqlen = strlen(ICQStr);

	memcpy(paquete+tsize,&myicqlen,1);

	tsize++;

	memcpy(paquete+tsize,&ICQStr,myicqlen); /* Dont copy the ending 0! */

	tsize += myicqlen;

	/* construimos el tlv magico */

	tlvpack = YSM_Malloc(tlvlen, __FILE__, __LINE__);

	Word_2_Charsb(tlvnewdlen,dlen+4);

	memset(tlvpack,'\0',tlvlen);

	/* 2 + 24 bytes extra..capabilities, timestamps and 0's */
	paqindex = 26;

	tlvpack[paqindex+1] = 0x0A;     /* TLV 0x0A */
	paqindex += 2;

	tlvpack[paqindex+1] = 0x02;     /* len */
	paqindex += 2;

	tlvpack[paqindex+1] = 0x01; /* data */
	paqindex += 2;

	tlvpack[paqindex+1] = 0x0F;     /* TLV 0x0F */
	paqindex += 2;

	paqindex += 2;                          /* len = 0 */

	tlvpack[paqindex] = 0x27;       /* TLV 0x2711 */
	tlvpack[paqindex+1] = 0x11;
	paqindex += 2;

	tlvpack[paqindex+1] = 0x35 + dlen;      /* len */
	paqindex += 2;

	tlvpack[paqindex] = 0x1B; /* data, len of something */
	paqindex += 2;

	tlvpack[paqindex] = YSM_PROTOCOL_VERSION;
	paqindex += 2;


	paqindex += 16;         /* 4 * 4 byte fields */
	paqindex += 2;

	tlvpack[paqindex] = 0x03;
	paqindex += 4;

	paqindex ++;

	/* Cookie...? */
	paqindex += 2;

	tlvpack[paqindex] = 0x0E;
	paqindex += 2;

	/* Cookie again...? */
	paqindex += 2;

	paqindex += 12;

	tlvpack[paqindex] = mType;
	/* flags field * used * */
	tlvpack[paqindex+1] = mFlags;
	paqindex += 2;

	/* status code crap !*!?! */
	paqindex += 2;

	/* priority? ..cri cri */
	tlvpack[paqindex+1] = 0x01;
	paqindex += 2;

	/* Message Len , message was an LNTS */
	Word_2_Chars(m_len,dlen);
	memcpy(tlvpack+paqindex,&m_len,2);
	paqindex += 2;
	memcpy(tlvpack+paqindex,data_conv,dlen);

	ret = InsertTLV(tlvpack,0x5,paquete+tsize,tlvlen);

	tsize += ret;

	ret = InsertTLV(0x0,0x6,paquete+tsize,0x0);

	tsize += ret;

	a = YSM_Send_SNAC( 0x4, 0x6, 0x0, 0x0, paquete, tsize,
				YSM_SeqNum++, (char *)&_reqid); 


	YSM_Free(data_conv, __FILE__, __LINE__);

	YSM_Free(tlvpack, __FILE__, __LINE__);

	YSM_Free(paquete, __FILE__, __LINE__);

}

void
YSM_Send_MessageC(int UIN, char *data, int dlen,  char *Nick, int mType, char mFlags, int LogFlag)
{
	unsigned int a=0,tsize=0,paqlen=0,tlvlen=0,myicqlen=0,ret=0;
	char *paquete=0, *tlvpack=0, *data_conv = 0;
	char MsgFormat[2],tlvnewdlen[2],ICQStr[MAX_ICQNUM_LEN];
	char log_name[MAX_PATH], *log_data, m_len[2];
	time_t	log_time;
	int log_len = 0;

#ifdef YSM_USE_ICONV
	if( YSM_Iconv(	YSM_SETTING_CHARSET_TRANS,
			YSM_SETTING_CHARSET_LOCAL,
			data,
			&data_conv,
			YSM_ICONV_MAXLEN) < 0 )
#endif	
	{
		data_conv = YSM_Malloc(dlen+1, __FILE__, __LINE__);
		memcpy(&data_conv[0], data, dlen);
		data_conv[dlen] = 0;
	}

	/* 6 bytes del header */
	/* lo que lleva es: 6 bytes +  2 bytes de len + el string con el 0 */
	tlvlen = 6 + 2 + dlen + 1;

	memset(ICQStr,'\0',MAX_ICQNUM_LEN);

	snprintf(ICQStr,MAX_ICQNUM_LEN,"%d",UIN);

	/* el paquete lleva unas cosas propias + 2 tlv, el ultimo, vacio de tipo 6. */
	paqlen = tlvlen + sizeof(TLV) + 8 + 2 + 1 + strlen(ICQStr) + sizeof(TLV);

	paquete = YSM_Malloc(paqlen, __FILE__, __LINE__);

	memset(paquete,'\0',paqlen);

	memcpy(paquete,&SendMessageID,sizeof(SendMessageID));
	
	tsize += 8;		/* Message ID */
	
	/* we make this depending on whoever calls us since we may use this function
		for either sending common messages, contacts, whatever the user wants */

	Word_2_Charsb(MsgFormat, 0x4);

	memcpy(paquete+tsize,&MsgFormat,sizeof(MsgFormat));

	tsize += sizeof(MsgFormat);

	myicqlen = strlen(ICQStr);

	memcpy(paquete+tsize,&myicqlen,1);

	tsize++;
	
	memcpy(paquete+tsize,&ICQStr,myicqlen);		/* Dont copy the ending 0! */

	tsize += myicqlen;

/* construimos el tlv magico */

	tlvpack = YSM_Malloc(tlvlen, __FILE__, __LINE__);

	Word_2_Charsb(tlvnewdlen,dlen+4);

	memset(tlvpack,'\0',tlvlen);

	if(YSM_SpoofUIN != 0) 
		memcpy(tlvpack,&YSM_SpoofUIN,4);
	else
		memcpy(tlvpack,&YSM_USER.YSM_Uin,4);

	tlvpack[4] = mType;
	/* flags field * used * */
	tlvpack[5] = mFlags;
	/* Message Len , message was an LNTS */
	Word_2_Chars(m_len,dlen);
	memcpy(tlvpack+4+2,&m_len,2);
	memcpy(tlvpack+4+2+2,data_conv,dlen);

	ret = InsertTLV(tlvpack,0x5,paquete+tsize,tlvlen);

	tsize += ret;

	ret = InsertTLV(0x0,0x6,paquete+tsize,0x0);

	tsize += ret;

	a = YSM_Send_SNAC( 0x4, 0x6, 0x0, 0x0, paquete, tsize, YSM_SeqNum++,
									 NULL);
	log_time = time(NULL);

	if ( YSM_SETTING_LOGALL ||  LogFlag )
	{
		log_len = MAX_DATA_LEN+MAX_SLAVE_NICK+MAX_UIN_LEN+2;
		log_data = YSM_Malloc(log_len, __FILE__, __LINE__);
		memset(log_name,'\0',MAX_PATH);
		memset(log_data,'\0',log_len);
		snprintf(log_name, MAX_PATH-1, "%d", UIN);

		snprintf( log_data,log_len,
			"<YOU> <@#> %s <@#> %s", data, ctime(&log_time) );

		/* ** NOTE ** Using the 'a' variable again here */
		for(a = 0; a < strlen(log_data); a++)
			if(log_data[a] == '\n') log_data[a] = ' ';

		log_data[strlen(log_data)] = '\n';

		YSM_DumpLogFile(log_name,log_data);
		YSM_Free(log_data, __FILE__, __LINE__);
	}
	

	YSM_Free(data_conv, __FILE__, __LINE__);			

	YSM_Free(tlvpack, __FILE__, __LINE__);	

	YSM_Free(paquete, __FILE__, __LINE__);


}

void
YSM_Send_MessageDC (char *data, int dlen, WORD mtype)
{

char	*buffer = NULL;
int	buflen = 0, index = 0;

	buflen += 4;	/* Local UIN */
	buflen += 2;	/* TCP Protocol Version */
	buflen += 2;	/* Command. (0x07EE is for Message) */
	buflen += 2;	/* Unknown. 0x0000 */
	buflen += 4;	/* Local UIN ..again! damn u! */
	buflen += 2;	/* Message Type */
	buflen += 2;	/* Message Length */
	buflen += dlen;	/* Message */ 
	buflen += 4;	/* External IP ..damn u */
	buflen += 4;	/* Internal IP ..xor you! */
	buflen += 4;	/* Local port.. no NO. */
	buflen += 1;	/* TCP Capable flag. */
	buflen += 2;	/* Local Status */
	buflen += 2;	/* Message Command (0x0010 is normal message) */
	buflen += 4;	/* TCP DC Seq num */

	/* OK damn buffer from hell, get a space in my HEAP! */
	buffer = (char *)YSM_Malloc (buflen, __FILE__, __LINE__);

	memcpy(&buffer[index], &YSM_USER.YSM_Uin, 4);
	index += 4;

	index ++;
	buffer[index] = 0x07;
	index ++;

	buffer[index] = 0x07;
	buffer[index+1] = (char)0xEE;
	index += 2;	

	index += 2;			/* 0x0000 */

	memcpy(&buffer[index], &YSM_USER.YSM_Uin, 4);
	index += 4;

	memcpy(&buffer[index], &mtype, 2);
	index += 2;

	memcpy(&buffer[index], &dlen, 2);
	index += 2;

	memcpy(&buffer[index], data, dlen);
	index += dlen;

	index += 4;
	index += 4;
	index += 4;
	buffer[index] = 0x04;
	index += 1;
	index += 2;
	
	index ++;
	buffer[index] = 0x10;
	index ++;

	YSM_SeqDC --;	/* The Seqnum gets DECREMENTED every time */
	Word_2_Charsb(&buffer[index], YSM_SeqDC);

	YSM_WRITE(YSM_DCSock, &buffer[0], buflen);

	YSM_Free(buffer, __FILE__, __LINE__);
	return;
}


void
YSM_SendAuthRequest (int UIN, char *Nick, char *Message)
{

char	*paquete = NULL;
char	ICQStr[MAX_ICQNUM_LEN], MsgLen[2];
int	dlen = 0;

	memset(ICQStr,'\0',MAX_ICQNUM_LEN);
	snprintf(ICQStr,MAX_ICQNUM_LEN,"%d",UIN);

	if (Message == NULL)
		Message = YSM_DEFAULT_AUTHREQ_MESSAGE;

	dlen = 1;	/* Len of UIN */
	dlen += strlen(ICQStr);	/* UIN to Request */
	dlen += 2;	/* Len of Message (WORD) */
	dlen += strlen(Message);	/* Request Message */
	dlen += 2;	/* Extra Flags (Usually 0x0000) */

	paquete = YSM_Malloc(dlen, __FILE__, __LINE__);
	memset(paquete, 0, dlen);

	paquete[0] = strlen(ICQStr);
	memcpy(paquete+1, &ICQStr, strlen(ICQStr));

	Word_2_Charsb(MsgLen, strlen(Message));
	memcpy(paquete+1+strlen(ICQStr),MsgLen,2);
	memcpy(paquete+1+strlen(ICQStr)+2,Message,strlen(Message));	

	YSM_Send_SNAC( 0x13, 0x18, 0x0, 0x0, paquete, dlen, YSM_SeqNum++, NULL);

	if(Nick)
		PRINTF(YSM_VERBOSE_EXTRA,
		MSG_REQ_SENT1" "MSG_REQ_SENT2" %s. (%d).\n",Nick,UIN);								
	else
		PRINTF(YSM_VERBOSE_EXTRA,
		MSG_REQ_SENT1" %d.\n",UIN);

	YSM_Free(paquete, __FILE__, __LINE__);

	return;
}


void
YSM_SendAuthOK (int UIN, char *Nick)
{

char	*paquete = NULL;
char	ICQStr[MAX_ICQNUM_LEN]; 
int	dlen = 0;

	memset(ICQStr,'\0',MAX_ICQNUM_LEN);
	snprintf(ICQStr,MAX_ICQNUM_LEN,"%d",UIN);

	dlen = 1;	/* Len of UIN */
	dlen += strlen(ICQStr);	/* UIN to Request */
	dlen ++;	/* Flag response, 0x01 accept, 0x00 decline */
	dlen += 2;	/* Len of Message (WORD) */
	dlen += 0;	/* decline message, nothing */
	dlen += 2;	/* Extra Flags (Usually 0x0000) */

	paquete = YSM_Malloc(dlen, __FILE__, __LINE__);
	memset(paquete, 0, dlen);

	paquete[0] = strlen(ICQStr);
	memcpy(paquete+1, &ICQStr, strlen(ICQStr));
	/* Accept Auth Req */
	paquete[1+strlen(ICQStr)] = 0x01;
	/* Here should be the message len, but as its 0, leave zeros */
	/* same with message and Flags */
	YSM_Send_SNAC( 0x13, 0x1a, 0x0, 0x0, paquete, dlen, YSM_SeqNum++, NULL);

	if (!YSM_SETTING_AFK)
	{
		if(Nick)
			PRINTF(YSM_VERBOSE_EXTRA,
			MSG_AUTH_SENT1" "MSG_AUTH_SENT2" %s. (%d).\n",
								Nick,UIN);								
		else
			PRINTF(YSM_VERBOSE_EXTRA,
			MSG_AUTH_SENT1" %d.\n",UIN);
	}			


	YSM_Free(paquete, __FILE__, __LINE__);

	return;
}

void
YSM_SendContacts (void)
{
	unsigned int x,usize=0,ulen;
	char *data=0,tmp[MAX_ICQNUM_LEN];
	YSM_SLAVE *Firstnode = YSMSlaves_First;

		
	for ( x = 0; x < AmountSlaves ; x++ )
	{
		if(Firstnode != NULL)
		{
			memset(tmp,'\0',sizeof(tmp));
			snprintf(tmp,sizeof(tmp)-1,"%d",Firstnode->Uin);
			usize += strlen(tmp);
			usize++;		/* byte of len too */

			Firstnode = Firstnode->next;
		}
	}

	Firstnode = YSMSlaves_First;

	if( usize <= 0 ) return;

	data = YSM_Malloc(usize, __FILE__, __LINE__);
	
	for ( x = 0, usize=0; x < AmountSlaves ; x++ )
	{
		if(Firstnode != NULL)
		{
			memset(tmp,'\0',sizeof(tmp));
			snprintf(tmp,sizeof(tmp)-1,"%d",Firstnode->Uin);
			ulen = strlen(tmp);
			memcpy(data+usize,&ulen,1);
			usize++;
			memcpy(data+usize,&tmp,ulen);
			usize+=ulen;

			Firstnode = Firstnode->next;
		}

	}
	
	if (YSM_USER.YSM_Paranoid>2)			/* Don't send SHIT ;) */
	{
		memset(data,'\0',usize);
		usize=2;
	}

	YSM_Send_SNAC( 0x3,
			0x04,
			0x0,
			0x0,
			data,
			usize,
			YSM_SeqNum++,
			NULL);

	YSM_Free(data, __FILE__, __LINE__);


	return;
}



void
YSM_RemoveContact (YSM_SLAVE *Contact)
{
	char tmp[MAX_ICQNUM_LEN],*data;
	int dlen =0, ulen;
	
		snprintf(tmp,MAX_ICQNUM_LEN,"%d",Contact->Uin);

		ulen = strlen(tmp);
		dlen = ulen+2;
		data = YSM_Malloc(dlen, __FILE__, __LINE__);
		memset(data,'\0',dlen);

		memcpy(data,&ulen,1);
		memcpy(data+1,&tmp,ulen);
	
		YSM_Send_SNAC( 0x3,
				0x05,
				0x0,
				0x0,
				data,
				strlen(data),
				YSM_SeqNum++,
				NULL);


		/* Now remove from the server too */
		YSM_Buddy_DelSlave( Contact );

		YSM_Free(data, __FILE__, __LINE__);

		return;

}


/* If a buddy is stored in the server, change his/her			*/
/* type to our Ignore list so they don't fuck with us no M0re y0!	*/

void
YSM_Buddy_Ignore (YSM_SLAVE *buddy, int flag)
{
	if(flag)	/* Add to Ignore list */
	{
		buddy->BudType.IgnoreID = YSM_Buddy_AddItem (buddy,
						YSM_BUDDY_GROUPNAME,
						0x0,
						0x0,
						YSM_BUDDY_SLAVE_IGN,
						 0, 0, 0x08);
	}
	else		/* Remove from the Ignore list */
	{
		YSM_Buddy_AddItem (buddy,
				YSM_BUDDY_GROUPNAME,
				0x0,
				buddy->BudType.IgnoreID,
				YSM_BUDDY_SLAVE_IGN,
				 0, 0, 0x0a);

		/* Reset the Ignore Flag */
		buddy->BudType.IgnoreID = 0;
	}

	YSM_Buddy_RequestFinished ();

	return;
}


/* If a buddy is stored in the server, change his/her	*/
/* type to our block/invisible list so they wont see us	*/

void
YSM_Buddy_Invisible (YSM_SLAVE *buddy, int flag)
{
	if(flag)	/* Add to invisible list */
	{

		buddy->BudType.InvisibleID = YSM_Buddy_AddItem (
							buddy,
							YSM_BUDDY_GROUPNAME,
							0x0,
							0x0,
							YSM_BUDDY_SLAVE_INV,
							0, 0, 0x08);
	}
	else		/* Remove from the invisible list */
	{
		YSM_Buddy_AddItem (buddy,
				YSM_BUDDY_GROUPNAME,
				0x0,
				buddy->BudType.InvisibleID,
				YSM_BUDDY_SLAVE_INV,
				0, 0, 0x0a);

		/* Reset the Invisible Flag */
		buddy->BudType.InvisibleID = 0;
	}

	YSM_Buddy_RequestFinished ();

	return;
}


/* If a buddy is stored in the server, change his/her	*/
/* type to our Allow/Visible list so they see us when we drink 	*/
/* the magic potion */
void
YSM_Buddy_Visible (YSM_SLAVE *buddy, int flag)
{
	if(flag)	/* Add to the Visible list */
	{
		buddy->BudType.VisibleID = YSM_Buddy_AddItem (buddy,
						YSM_BUDDY_GROUPNAME,
						0x0,
						0x0, 
						YSM_BUDDY_SLAVE_VIS,
						0, 0, 0x08);
	}
	else		/* Remove from the Visible list */
	{
		YSM_Buddy_AddItem (buddy,
				YSM_BUDDY_GROUPNAME,
				0x0,
				buddy->BudType.VisibleID,
				YSM_BUDDY_SLAVE_VIS,
				0, 0, 0x0a);

		/* Reset the Visible Flag */
		buddy->BudType.VisibleID = 0;


	}

	YSM_Buddy_RequestFinished ();

	return;
}


void
YSM_Buddy_AddSlave (char *nick, char *uin, char *budID, char *grpID, char *type,  int fl)
{
	int uini;

	uini = atoi(uin);

	/* Do NOT add Numbers with stupid UIN #'s */
	if(!uini) return;

#ifdef  YSM_DEBUG
	PRINTF(YSM_VERBOSE_DEBUG_2,"\n[2]-- inside Rost_AddSlave");
#endif

#ifdef YSM_DEBUG
	PRINTF(YSM_VERBOSE_DEBUG_2,"\n[2]-- about to add %s with %d",nick,uini);
#endif
	if(YSM_AddSlavetoList (&YSMSlavesList, 
				nick,
				uini,
				NULL,
				Chars_2_Wordb(budID),
				Chars_2_Wordb(grpID),
				Chars_2_Wordb(type),
				fl))
	{
			AmountSlaves++;

#ifdef YSM_DEBUG
	PRINTF(YSM_VERBOSE_DEBUG_2,"\n[2]-- done.");

	PRINTF(YSM_VERBOSE_DEBUG_2,"\n[3]-- Saving slave to disk.");
#endif
	
	YSM_AddSlavetoDisk (nick, uini, NULL);

#ifdef YSM_DEBUG
	PRINTF(YSM_VERBOSE_DEBUG_2,"\n[4]-- done.");
#endif
	}

	return;
}


/* lets see if this works huh. Yeah, i was being told all the time */
/* about slaves being locally removed but not on the server side.. */
/* now, enjoy your last supper!, mauahahaaha..god, gotta leave drugs */

void
YSM_Buddy_DelSlave (YSM_SLAVE *poorone)
{

	PRINTF(YSM_VERBOSE_DEBUG_1,"\nRemoving from server: %s with budid: %x and groupd id: %x\n", poorone->NickName, poorone->BudType.BudID, poorone->BudType.grpID);

	YSM_Buddy_AddItem( poorone,
			YSM_BUDDY_GROUPNAME,
			poorone->BudType.grpID,
			poorone->BudType.BudID,
			YSM_BUDDY_SLAVE,
			0,			/* cmd */
			0,			/* auth */
			0x0a);			/* remove! */

	return;
}

void
YSM_Buddy_RequestModify (void)
{
	char reqid[4];

		memset(reqid,0,4);
		reqid[3] = 0x11;

		YSM_Send_SNAC( 0x13,
				0x11,
				0x0,
				0x0,
				NULL,
				0,
				YSM_SeqNum++, reqid);
}

void
YSM_Buddy_RequestFinished (void)
{

	char reqid[4];

		memset(reqid,0,4);
		reqid[3] = 0x12;


		YSM_Send_SNAC( 0x13,
				0x12,
				0x0,
				0x0,
				NULL,
				0,
				YSM_SeqNum++, reqid);
	
}

void
YSM_Buddy_Ack (FLAP_Head *head, SNAC_Head thesnac, char *buf)
{
		YSM_Send_SNAC( 0x13,
				0x07,
				0x0,
				0x0,
				NULL,
				0,
				YSM_SeqNum++, NULL);
	return;
}


/* This function goes through the list of slaves that have */
/* the downloaded flag on, searching for the biggest budID */
/* once it finds it, it increments the id by 1 and returns */

int
YSM_Buddy_GenNewID (void)
{

unsigned int	x;
int		newid = 0;
YSM_SLAVE	*rotating = YSMSlaves_First;

	for ( x = 0; x < AmountSlaves ; x++ )
	{
		if(rotating != NULL)
		{
			if(rotating->BudType.BudID > newid)
				newid = rotating->BudType.BudID;

			rotating = rotating->next;
		}
	}

	newid++;

	return newid;
}

/*
 hehe nice function huh :) well use is this way:

	For adding a Group:
		Item = 0x0, grpName = groupname
		grpID = groupID, budID = 0x0, type = YSM_BUDDY_GROUP
	For adding a Buddy:
		Iteme= YSM_SLAVE*, grpName = groupname
		grpID = groupID, budID = UIN(int), type = YSM_BUDDY_SLAVE

	the function returns the buddy ID.
*/
			
/* CMD if 0 means Add Item, if 1 means Notify Master. */
/* add_update 0x08 is add 0x0a is remove */

/* If a bID is not 0x0, it wont be generated */

int
YSM_Buddy_AddItem(YSM_SLAVE *Item, char *grpName, int grpID , int bID, int type, int cmd, int authawait, int add_update)
{

int dlen=0, tsize =0;
char *data, *data2 = NULL, grp_len[2], item_type[2], YSMBuddyGroup_ID[2];
char YSMBuddy_ID[2], StringUIN[MAX_UIN_LEN+1];
char *data_list = NULL, *name = NULL;
int *data_list_amount = NULL, budID = 0;
char reqid[4];


	/* We increment the change count on our buddy list for future chgs */
	YSM_Buddy_ChangeCount++;

	YSM_Buddy_RequestModify();

	if( type == YSM_BUDDY_GROUP )	
	{
		/* For (notifying master) */
		data_list = YSM_GroupID_List;
		data_list_amount = &YSM_GroupID_Amount;
		name = grpName;
	}
	else
	{
		memset(StringUIN,0,MAX_UIN_LEN+1);
		snprintf(StringUIN,MAX_UIN_LEN,"%d",Item->Uin);
		name = &StringUIN[0];

		/* For (notifying master) */
		data_list = YSM_GroupID_Users;
		data_list_amount = &YSM_GroupID_Users_Amount;
	}

	Word_2_Charsb(grp_len, strlen(name));

	Word_2_Charsb(YSMBuddyGroup_ID, grpID);

	/* We are creating this buddy for the first time, dont 
		generate a new random ID! for already created ids! */

	if(type != YSM_BUDDY_GROUP)
	{
		/* bID is a param to this function */
		/* Usually used for invisible, visible and ignore */
		if(!bID)
		{
			if(add_update == 0x08)
			{	
				budID = YSM_Buddy_GenNewID ();

				Item->BudType.BudID = budID;
			}
			else
				budID = Item->BudType.BudID;
		}
		else
			budID = bID;

	}

	
	/* Just used if adding a Buddy */
	Word_2_Charsb(YSMBuddy_ID, budID);

	switch(cmd)
	{
		case 0:		/* Called first time, add items */
		{

		dlen = 2; /* len WORD */
		dlen += strlen(name);

		dlen += 2 + 2; /* Group ID and Buddy ID */
		dlen += 2;	/* Type 0x0001 is Group */
		dlen += 2;	/* Extra len */

		if( type != YSM_BUDDY_GROUP)
		{
			dlen += sizeof(TLV) + strlen(Item->NickName);
			if(authawait) dlen += sizeof(TLV);
		}

		data = YSM_Malloc(dlen, __FILE__, __LINE__);
		memset(data,'\0',dlen);

		memcpy(data+tsize,&grp_len,2);
		tsize += 2;
		memcpy(data+tsize,name,strlen(name));
		tsize += strlen(name);
		
		memcpy(data+tsize,YSMBuddyGroup_ID,2);
		tsize += 2;

		switch(type)
		{
			case YSM_BUDDY_GROUP:
				tsize += 2;	 /* grp buddy ids are 0 */
				break;
			default:		/* Adding a Buddy */
				memcpy(data+tsize,&YSMBuddy_ID,2);	
				tsize += 2;
				break;
		}

		Word_2_Charsb(item_type,type);
		memcpy(data+tsize,&item_type,2);
		tsize += 2;

		memset(reqid,0,4);

		reqid[1] = YSM_Buddy_ChangeCount;
		reqid[3] = add_update;

		if( type == YSM_BUDDY_GROUP )
			memcpy(&YSM_Group_ReqID,reqid,4);

		else		/* which would be YSM_BUDDY_SLAVE or..etc */
		{	
			/* And now if we are adding a Buddy add on 
					Extra Data its Nickname */

			/* re using grp_len for xtra_len */
			if(!authawait)
				Word_2_Charsb(grp_len,
					strlen(Item->NickName)+sizeof(TLV));
			else
				Word_2_Charsb(grp_len,
				strlen(Item->NickName)+sizeof(TLV)+sizeof(TLV));
			

			memcpy(data+tsize,&grp_len,2);	/* Xtra len */
			tsize += 2;
			data2 = YSM_Malloc(sizeof(TLV) + strlen(Item->NickName),
						__FILE__, __LINE__);

			InsertTLV(Item->NickName,0x131,data2,
						strlen(Item->NickName));

			memcpy(data+tsize,data2,
					 strlen(Item->NickName)+sizeof(TLV));

			tsize += strlen(Item->NickName) + sizeof(TLV);
			YSM_Free(data2, __FILE__, __LINE__);

			if (authawait)
				InsertTLV(0,0x66,data+tsize,0);
			
			/* fill the slave's reqid, so we then know whos who */
			memcpy(&Item->ReqID,reqid,4);
		}


		YSM_Send_SNAC( 0x13,
				add_update,
				0x0,
				0x0,
				data,
				dlen,
				YSM_SeqNum++, reqid);
		YSM_Free(data, __FILE__, __LINE__);

		break;

		}

	case 0x1:
		{

		/* Generating change on Master Group */
		/* Either Master group of groups or Group of Buddys! */


		/*len(word) + string (0 bytes if GROUP or GrpName if BUDDY)*/
		dlen = 2;

		if(type != YSM_BUDDY_GROUP) dlen += strlen(grpName);
		dlen += 2 + 2; /* Group ID and Buddy ID */
		dlen += 2;	/* Type 0x0001 is Group */
		dlen += 2;	/* Extra len (just leave 0, should do) */
		/* TLV containing all groups */
		(*data_list_amount)++;	/* New GroupID ! */
		dlen += sizeof(TLV) + *(data_list_amount)*2;

		data = YSM_Malloc(dlen, __FILE__, __LINE__);
		memset(data,'\0',dlen);
		
		tsize = 0;


		switch(type)
		{
			case YSM_BUDDY_GROUP:		/* Group! */
				tsize += 2;	/* len == 0 */
				tsize += 2;	/* GrpID == 0, Master Group! */
				tsize += 2;	/* Buddy ID == 0, Im a group! */
				break;

			default:			/* Buddy! */
				Word_2_Charsb(grp_len, strlen(grpName));
				memcpy(data+tsize,&grp_len,2);	
				tsize += 2;
				memcpy(data+tsize,grpName,strlen(grpName));
				tsize += strlen(grpName);
				memcpy(data+tsize,YSMBuddyGroup_ID,2);
				tsize += 2;
				tsize += 2;
				break;



		}

		/*	For Both, a new Group or Buddy, the
			type must be 0001 since what we are
			changing here is in both cases a group		*/
				
		Word_2_Charsb(item_type,0x0001);
		memcpy(data+tsize,&item_type,2);	/* Type == 0x0001 */
		tsize += 2;


		/* re using grp_len for xtra_len */
		Word_2_Charsb(grp_len, *(data_list_amount)*2+sizeof(TLV));

		memcpy(data+tsize,&grp_len,2);	/* Xtra len */
		tsize += 2;

		data2 = YSM_Malloc(*(data_list_amount)*2+sizeof(TLV), 
					__FILE__, __LINE__);

		data_list = realloc(data_list, *(data_list_amount)*2);
		if(data_list == NULL)
				PRINTF(YSM_VERBOSE_BASE,
						"\nRealloc failed! Damn!");

		memset(reqid,0,4);
		reqid[1] = YSM_Buddy_ChangeCount;
		reqid[3] = add_update;


		/* add the new Group id if adding a group
				or user id if adding a user */

		if( type == YSM_BUDDY_GROUP )
			memcpy(data_list+((*(data_list_amount)-1)*2),
						 &YSMBuddyGroup_ID, 2);
		else
		{
			memcpy(data_list+((*(data_list_amount)-1)*2),
						 &YSMBuddy_ID, 2);
			/* fill the slave's reqid, so we then know whos who */
			memcpy(&Item->ReqID,reqid,4);
	
		}

		InsertTLV(data_list,0xc8,data2, *(data_list_amount)*2);
		memcpy(data+tsize,data2, (*(data_list_amount)*2)+sizeof(TLV));

		YSM_Free(data2, __FILE__, __LINE__);

		YSM_Send_SNAC( 0x13,
				add_update,
				0x0,
				0x0,
				data,
				dlen,
				YSM_SeqNum++, reqid);

		YSM_Free(data, __FILE__, __LINE__);

		break;
		}

		default:
			YSM_Error(ERROR_CODE);
			break;

	}

	return budID;

}

int
YSM_Buddy_ReadSlave (char *buf,int tsize)
{
	int size=0,ulen=0,nlen=0;
	char *uin=0,*nick=0,Nlen[2],xtralen[2],xtratlvtype[2];
	char budID[2], grpID[2], budtype[2];

	/* actually its a word, but its always the first byte (a len)*/
	size++;			
	ulen = buf[tsize+size];
	if (ulen <= 0 || ulen > MAX_UIN_LEN)
		return 0x666;
	size++;

	uin = YSM_Malloc(ulen+1, __FILE__, __LINE__);
	memset(uin,'\0',ulen+1);
	memcpy(uin,&buf[tsize+size],ulen);
	size += ulen;

	/* Group ID */
	memcpy(&grpID, &buf[tsize+size], 2);
	size += 2;
	/* Buddy ID */
	memcpy(&budID, &buf[tsize+size], 2);
	size += 2;
	/* There are different types of buddies */
	/* Some maybe be on our ignore list, some on our invisible list, etc */
	memcpy(&budtype, &buf[tsize+size], 2);
	size += 2;

	memset(&xtralen,0,2);
	memset(&xtratlvtype,0,2);
	memcpy(&xtralen,buf+size+tsize,2);

	/* We just care about the 0x131 which is the Nick of our slave. */
	/* 0x66 and other tlvs are ignored, why would we want em huh HUH =P */

	size += 2;

	if( Chars_2_Wordb(xtralen) != 0 )
	{
		memcpy(&xtratlvtype,buf+size+tsize,2);
	
		switch (Chars_2_Wordb(xtratlvtype))
		{
			/* Which means Extra Data Nick Incoming! */
			case 0x131:
					size += 2;
					memcpy(&Nlen,buf+size+tsize,2);
					size += 2;
					nlen = Chars_2_Wordb(Nlen);
					nick = YSM_Malloc(nlen+1, __FILE__,
								__LINE__);

					memset(nick, '\0',nlen+1);
					memcpy(nick, &buf[tsize+size],nlen);
					size += Chars_2_Wordb(xtralen) - 4;
					
					break;

			case 0x66:	/* Awaiting auth from this slave */
					size += Chars_2_Wordb(xtralen);
					break;

			default:
			/* Fine, no Nick found then */
					size += Chars_2_Wordb(xtralen) - 4;
					break;
		}
	}

	if( nlen != 0 )
	{
		if ( (nlen = YSM_ParseSlave (nick)) == 0)
			YSM_Free(nick, __FILE__, __LINE__);
	}

	if( !nlen )
	{
		/* God Damn! No nick for this slave! What shall we use?! */
		/* Fine god dammit! Lets use its UIN # as his nickname! */

		nlen = strlen(uin);
		nick = YSM_Malloc(nlen+1, __FILE__, __LINE__);
		memset(nick,'\0',nlen+1);
		memcpy(nick,uin,nlen);
	}


/*	debugging info  */
#ifdef YSM_DEBUG
	PRINTF(YSM_VERBOSE_DEBUG_2,"\nADDING %s with %s\n",nick,uin); 
#endif

	/* Last param , 1 == ONLINE slave (Stored on the srv) */
	YSM_Buddy_AddSlave (nick,uin,budID,grpID,budtype,1);

	YSM_Free (uin, __FILE__, __LINE__);	
	YSM_Free (nick, __FILE__, __LINE__);

	return size;
}

void
YSM_Incoming_BuddyChange (FLAP_Head *head, SNAC_Head thesnac, char *buf)
{

YSM_SLAVE *SlavesList = YSMSlaves_First;
char incomingreq[2];
int i=0;

	memcpy(&incomingreq,buf,2);

	/* Maybe its the ack for our group creation..*/
	/* If so.. */
	if(thesnac.ReqID == YSM_Group_ReqID)
	{
		YSM_Buddy_AddItem (0x0, YSM_BUDDY_GROUPNAME,
			YSM_BUDDY_GROUPID, 0x0, YSM_BUDDY_GROUP, 1, 0, 0x09);

		PRINTF(YSM_VERBOSE_EXTRA,"\n" MSG_BUDDY_GROUPCREATED "\n");
	
		/* Let it know it can close the contact list */
		YSM_Buddy_RequestFinished ();


		return;
	}

	
	for (i=1 ; SlavesList->next != 0; i++)
	{

		if(thesnac.ReqID == SlavesList->ReqID)
		{

			/* If its the Group added ack, just break */
				if(SlavesList->DownloadedFlag == TRUE)
						break;

			switch(Chars_2_Wordb(incomingreq))
			{

			case YSM_SRV_BUDDY_NOAUTH:
				
			/* Ok! Been acked. Notify the YSM group that 
			it's got a new user. */


				PRINTF(YSM_VERBOSE_FUNCTIONAL,
				BRIGHT_BLUE "\n" MSG_BUDDY_SAVING1 "%s"
						 MSG_BUDDY_SAVING2 "%d"
						 MSG_BUDDY_SAVING3,
							SlavesList->NickName, 
							SlavesList->Uin);

				YSM_Buddy_AddItem (SlavesList,
						YSM_BUDDY_GROUPNAME,
						YSM_BUDDY_GROUPID,
						0x0, /* new */
						YSM_BUDDY_SLAVE, 1, 0, 0x09);


			/* Set the -online- contact flag so we can then
				know who required auth and who did not */

				PRINTF(YSM_VERBOSE_FUNCTIONAL,
				MSG_BUDDY_SAVINGOK  "\n" NORMAL );

				SlavesList->DownloadedFlag = TRUE;

				break;

			case YSM_SRV_BUDDY_AUTH:
			/* This slave requires an online auth..ugh. */

			/* Let the user know he needs auth from the
				other part in order to add it in the list */

			PRINTF(YSM_VERBOSE_FUNCTIONAL,
			BRIGHT_BLUE "\n" MSG_BUDDY_SAVING1 "%s"
					 MSG_BUDDY_SAVING2 "%d"
					 MSG_BUDDY_SAVING3,
						SlavesList->NickName, 
						SlavesList->Uin);


			PRINTF(YSM_VERBOSE_FUNCTIONAL,
				MSG_BUDDY_SAVINGAUTH "\n" NORMAL
				MSG_BUDDY_SAVINGAUTH2
				MSG_BUDDY_SAVINGAUTH3 "\n");

			SlavesList->DownloadedFlag = 0x0a;

			break;

			case YSM_SRV_BUDDY_ERRADD:

			PRINTF(YSM_VERBOSE_FUNCTIONAL,
				MSG_BUDDY_SAVINGERROR "\n" NORMAL
				MSG_BUDDY_SAVINGERROR2 );

				SlavesList->DownloadedFlag = TRUE;

				break;

			/*	Shouldn't happend. Take same action as if
				a reply for a non-slave arrives, ignore! */
			
			default:
			/*
				Bleh, don't let the user know about this ;P
	
				PRINTF(YSM_VERBOSE_FUNCTIONAL,
				 MAGENTA " [WARNING]\n" NORMAL
				"Try Again!.\n");

				Just retry.
			*/
			PRINTF(YSM_VERBOSE_BASE, "\nDijo WARNING\n");
	
					YSM_Buddy_AddItem (SlavesList,
						YSM_BUDDY_GROUPNAME,
						YSM_BUDDY_GROUPID,
						0x0, /* new */
						YSM_BUDDY_SLAVE,
						 0, 0, 0x08);
				break;
			}	
	
		/* Let it know it can close the contact list */
		YSM_Buddy_RequestFinished ();

		}

		SlavesList = SlavesList->next;
	}

	return;
}

void
YSM_Incoming_BuddyList (FLAP_Head *head, SNAC_Head thesnac, char *buf, int buf_len)
{
	char groupid[2],grouptype[2],d_len[2],g_id[2],x;
	int tsize=0,len=0,len2=0,GrpSlaves=0,y=0;
	int r=0,maxdlen=0,g_amount=0;
	char chgcount[2];
	TLV thetlv;

	/* User may disable prompting from the config file */
	if(YSM_SETTING_ASK_DOWNLOAD)
	{
	/* The new DOWNLOADED_CONTACTS flag is for the situations
	when the server sends us more than one Roster packet, so
	we dont prompt the user twice. */
	if(!DOWNLOADED_CONTACTS)
	{	
		PRINTF(YSM_VERBOSE_BASE,
			"\n%s\n%s",MSG_ASK_DOWNLOAD1,MSG_ASK_DOWNLOAD2);
		x = getchar();
#ifdef WIN32
		getchar();
#endif	
		if(toupper(x) != 'Y')
		{
			DOWNLOADED_CONTACTS = TRUE;
			return;
		}

	}

	} 

	memset(&thetlv,'\0',sizeof(TLV));

	/* SSI protocol version (!?) */
	tsize++;

	/* Num of modifications by now (WE need this for future mods) */
	memset(chgcount,0,2);
	memcpy(chgcount,buf+tsize,2);
	YSM_Buddy_ChangeCount = Chars_2_Wordb(chgcount);
	tsize+=2;

	/* For future changes, we mark our next change already */
	YSM_Buddy_ChangeCount++;

	/* If there is now a 6 0 bytes field, then.. */
	/* (Usually comes with the first Roaster */

	if(!buf[tsize] && !buf[tsize+1] && !buf[tsize+2] &&
			!buf[tsize+3] && !buf[tsize+4] && !buf[tsize+5])
	{

		tsize += 6;

/* there is this first TLV(1) which we DONT want, so we will just */
/* skip its header and jump to its data where the tlv (c8) is (only one), */
/* then we read the len of the c8 tlv and begin from there. */

/* we still store its length in case theres a new TLV in it we dont know */
/* but we still have to skip its content */
		memcpy(&thetlv,buf+tsize,sizeof(TLV));
		len2 = Chars_2_Wordb(thetlv.len);
		tsize += sizeof(TLV);



	}	

	DOWNLOADED_CONTACTS = TRUE;

	maxdlen = buf_len - SNAC_HEAD_SIZE;

	while(0 != len2) {

	memset(&thetlv,'\0',sizeof(TLV));
	memcpy(&thetlv,buf+tsize,sizeof(TLV));
	len = Chars_2_Wordb(thetlv.len);

	/* The Groups listing did show up, skip it! dammit! */
	if(Chars_2_Wordb(thetlv.type) == 0xc8) {

		/*	Make a global allocated area where to store
			the existing GroupIDS */

			tsize += sizeof(TLV);

			YSM_GroupID_List = YSM_Malloc(len, __FILE__, __LINE__);
			YSM_GroupID_Amount = len/2;

			memset(YSM_GroupID_List,'\0',len);
			for(y=0;y<len;y+=2)
				memcpy(YSM_GroupID_List+y,&buf[tsize+y],2);
				
			tsize += len;

	}
	else tsize += (len  + sizeof(TLV));

	/* this should set len2 to 0..if theres no more data */
	len2 -= (sizeof(TLV) + len);

	}	

	/* DAMN! Parse the items and get to the GROUPS! */
	while( (tsize+4) < maxdlen )
	{
		memcpy(&d_len,buf+tsize,2);
		tsize += 2;
		tsize += Chars_2_Wordb(d_len);
		memcpy(g_id,buf+tsize,2);
		tsize += 2;	/* Group ID */

		/* Lets check if its a group what we found
		by copying the UserID (should be 0) and the type */
		memcpy(&groupid,buf+tsize,2);
		memcpy(&grouptype, buf+tsize+2, 2);

		if(!groupid[0] && !groupid[1] &&
			!grouptype[0] && grouptype[1] == 1)
		{
			tsize += 4;

			/* We are now standing on the len of the
			following data */
			memcpy(&d_len,buf+tsize,2);
			tsize += 2;

			if(Chars_2_Wordb(d_len) == 0)
			{
				/* Empty group, but check if its is
				OUR group so we dont make the mistake
				of creating it twice! */
				if(Chars_2_Wordb(g_id) == YSM_BUDDY_GROUPID)
				{
					YSM_GroupID_Users_Amount = 0;
				}
					
				continue;
			}

			memcpy(&thetlv,buf+tsize,sizeof(TLV));
			len = Chars_2_Wordb(thetlv.len);
			tsize += sizeof(TLV);

			switch(Chars_2_Wordb(thetlv.type))
			{
				/* Users ID */
			/* Use the amm of IDS for knowing the amm */
			/* of slaves in the group */	
				case 0xc8:
				{

			/* If its the YSM Group, we need the list of Buddy */
			/* Ids stored in our users list. */
				if(Chars_2_Wordb(g_id) == YSM_BUDDY_GROUPID)
				{
					if(len != 0)
					{
					YSM_GroupID_Users = YSM_Malloc(
								len,
								__FILE__,
								__LINE__);

					YSM_GroupID_Users_Amount = len/2;

					memset(YSM_GroupID_Users,'\0',len);
					for(y=0;y<len;y+=2)
						memcpy(YSM_GroupID_Users+y,
							&buf[tsize+y],2);
					}
					else
					{
					/* The Group exists, but its empty.
						Do NOT re-create the group! */
						YSM_GroupID_Users_Amount = 0;
					}
				}

					GrpSlaves = len/2;
					tsize += len;	
					break;
				}	

				default:
					GrpSlaves = 0;
					tsize += len;
					break;
			}

			for (y=0; y<GrpSlaves;y++)
			{
				r = YSM_Buddy_ReadSlave(buf,tsize);
				if(r == 0x666)
					break;
				
				else tsize +=r;

				g_amount ++;
				PRINTF(YSM_VERBOSE_DEBUG_2,"%d",tsize);
			}

		}		
		else
		{
			/* If it wasn't a group, it might be a slave */
			/* in a special status (visible, invisible, ignore) */

			if( Chars_2_Wordb(grouptype) == YSM_BUDDY_SLAVE_INV
			|| Chars_2_Wordb(grouptype) == YSM_BUDDY_SLAVE_IGN
			|| Chars_2_Wordb(grouptype) == YSM_BUDDY_SLAVE_VIS)
			{
				/* Make ReadSlave point to the beginning
					of the block			*/

				YSM_Buddy_ReadSlave(buf,
					(tsize-2-Chars_2_Wordb(d_len)-2));

				g_amount ++;
			}	/* Check if its our Privacy Settings */

			else if (Chars_2_Wordb(grouptype) == 0x0004) 
			{
				YSM_PrivacyGroupID = Chars_2_Wordb(groupid);

				/* Check the current setting. */
				/* If we left invisible, change the status */
				/* to invisible again. */
				/* If we WANT invisible, turn to invisible 2 */
				if(buf[tsize+4+2+sizeof(TLV)] == 0x2
				|| buf[tsize+4+2+sizeof(TLV)] == 0x3
				|| YSM_USER.YSM_Status == YSM_INVISIBLE)
				{
					YSM_ChangeStatus(YSM_INVISIBLE, 0x0020);
				}
			}
	
		tsize += 4;	/* User ID and Type */

		/* See if theres any Xtra data on this item */

		memcpy(&d_len,buf+tsize,2);
		tsize += 2;

		if(Chars_2_Wordb(d_len) != 0)
			tsize += Chars_2_Wordb(d_len);
		}
		
	}

/* Print some shocking message :) New slaves are always welcome. */
	PRINTF(YSM_VERBOSE_EXTRA,
		"\nd[O_o]b %d %s\n",g_amount,MSG_DOWNLOADED_SLAVES); 

#ifndef YSM_WITH_THREADS
	PRINTF(YSM_VERBOSE_EXTRA,
		MSG_BUDDY_BLOCKWARN "\n"
		MSG_BUDDY_BLOCKWARN2 "\n");
#endif

	YSM_Buddy_Ack (head,thesnac,buf);


	

	return;

}


void
YSM_IncomingMultiUse (FLAP_Head *head, SNAC_Head *thesnac, char *buf)
{

int		tsize=0;
char		BytesRem[2],Type[2],ReqID[2],SubID[2],Result;
/* offline message variables */
int		uin,mlen;
char		*message,MsgType,MsgFlags,Msglen[2]; 
char		o_month = 0, o_day = 0, o_hour = 0, o_minutes = 0;
YSM_SLAVE	*YSM_Query;

		/* its a TLV(1) at the very beggining, always. */
		tsize += 4;
		memcpy(&BytesRem,buf+tsize,2);
		tsize += 2;
		/* my UIN */
		tsize += 4;
		memcpy(&Type,buf+tsize,2);
		tsize += 2;
		memcpy(&ReqID,buf+tsize,2);
		tsize += 2;

		switch(Chars_2_Wordb(Type))
		{
			/* Information request response */
			case 0xda07:
				memcpy(&SubID,buf+tsize,2);
				tsize += 2;
				Result = buf[tsize];
				if(Result != 0x32 && Result != 0x14
							 && Result != 0x1E )
				{
					switch(Chars_2_Wordb(SubID))
					{

						/* Incoming MAIN info */
						case 0xC800:
						/* tsize points to Result */
							tsize++;
						/* Now it doesnt. */

						if( YSM_personal_infoid == thesnac->ReqID && YSM_personal_infoid != 0 ) 
						{
						YSM_IncomingMainInfo(buf,
								1,
								tsize);
						}
						else
						{
						YSM_IncomingMainInfo(buf,
								0,
								tsize);
						}
							break;
	
						/* incoming full info */
						case 0xDC00:

						if(!YSM_personal_infoid)
							YSM_IncomingHPInfo(buf,
								tsize+1);
					
							break;

						case 0xD200:

						if(!YSM_personal_infoid)
						{
						YSM_IncomingWorkInfo(buf,
								tsize+1);
						}

						/* Last data */	
						YSM_personal_infoid = 0;
							break;	

						case 0xA401:
						case 0xAE01:
							tsize++;
							YSM_IncomingSearch(buf,
									tsize);
							break;

						case 0x6400:

							PRINTF(
							YSM_VERBOSE_EXTRA,
							"\r"
							MSG_INFO_UPDATED "\n"
							);
							break;

						default:
							break;
					}

				}

				else
				{

					if(!YSM_personal_infoid)
						PRINTF(YSM_VERBOSE_FUNCTIONAL,
						"\n" MSG_SEARCH_FAILED "\n");
					else
					{
						PRINTF(YSM_VERBOSE_FUNCTIONAL,
						"\nYou don't have a nick!\n");
						YSM_personal_infoid = 0;
					}
				}

				break;	
		
			case 0x4100:
				memcpy(&uin,buf+tsize,4);
				tsize+=4;

				/* we wont care about the date of the */
				/* offline message yet, doing this code */
				/* quickly. */

				tsize +=2; /* WORD (year) */
				o_month = buf[tsize];
				tsize++;  /* Month */
				o_day = buf[tsize];
				tsize++; /* Day */
				o_hour = buf[tsize];
				tsize++; /* Hour */
				o_minutes = buf[tsize];
				tsize++; /* Minutes */
				MsgType = buf[tsize];
				tsize++;
				MsgFlags = buf[tsize];
				tsize++;
				memcpy(&Msglen,buf+tsize,2);
				tsize+=2;
				mlen = Chars_2_Word(Msglen);

				message = YSM_Malloc(mlen+1,
							__FILE__,
							__LINE__);
	
				memcpy(message,buf+tsize,mlen);
				tsize += mlen;

				YSM_Query = YSM_QuerySlaves(SLAVE_UIN,
						NULL,uin);

				YSM_AckOffline ();

				switch(MsgType)
				{
					case 0x01:

						if(YSM_Query) YSMSlaves_LastRead = YSMSlaves_TabSlave = YSM_Query;
						

			PRINTF(YSM_VERBOSE_FUNCTIONAL,
			"\n" MSG_NEW_OFFLINE "\n"
			"[date: %.2d/%.2d time: %.2d:%.2d (GMT):%s\n",
							o_day,
							o_month,
							o_hour,
							o_minutes,
							NORMAL);

					YSM_DisplayMsg (YSM_MESSAGE_NORMAL,
							uin,
							0x0,
							mlen, message,
							YSM_Query->NickName,
							!YSM_Query
							? 0x0
							: YSM_Query->LogFlag);

							break;
	
					case 0x04:	/* we wont yet */
							/* support this kind */
							/* of offline msg. */
							break;
		
					default:
							break;
				}	

				YSM_Free(message, __FILE__, __LINE__);
				break;
			
			case 0x4200:		/* end of offline msgs */
				break;
	
			default:
		
				break;
		}	

	YSM_Redraw_Console = TRUE;
	return;
}

void
YSM_IncomingSearch (char *buf, int tsize)
{
	char Len[2],*data;
	int ruin=0,len2;

		tsize+=2;	/* record LEN */
		memcpy(&ruin,buf+tsize,4);
		tsize+=4;

		memcpy(&Len,buf+tsize,2);
		tsize+=2;
		len2 = Chars_2_Word(Len);
		data = YSM_Malloc(len2+1, __FILE__, __LINE__);
		memset(data,'\0',len2+1);
		memcpy(data,buf+tsize,len2);

		PRINTF(YSM_VERBOSE_FUNCTIONAL,
			"\n%sUIN%s: %d",WHITE,NORMAL,ruin);
		PRINTF(YSM_VERBOSE_FUNCTIONAL,
			"\t%sNick%s: %s\n",WHITE,NORMAL,data);

		YSM_Free(data, __FILE__, __LINE__);

	return;
}


void
YSM_IncomingPersonal( FLAP_Head *head, SNAC_Head *thesnac, char *buf)
{
	return;
}

/* if FL is TRUE then its our own info query, copy what we need */
/* by now its just our nickname */

void
YSM_IncomingMainInfo (char *buf, int fl, int tsize)
{
	char Len[2],*data;
	int len2;

		memcpy(&Len,buf+tsize,2);
		tsize+=2;
		len2 = Chars_2_Word(Len);
		data = YSM_Malloc(len2+1, __FILE__, __LINE__);
		memset(data,'\0',len2+1);
		memcpy(data,buf+tsize,len2);

/* Ok the order is: Nick First Last Email */

/* 	
	If the request was for OUR information, then just get our nick and
	go away. 
*/
		if(fl)
		{
			if(strlen(data) > 1)
			strncpy(YSM_USER.YSM_info.NickName,
					 data, MAX_SLAVE_NICK-1);
			else
				YSM_USER.YSM_info.NickName[0] = '%';

		}
		else
		{
/* Print the Nick! */
			PRINTF(YSM_VERBOSE_FUNCTIONAL,
				"\n%sNick%s: %s",WHITE,NORMAL,data);
		}

		YSM_Free(data, __FILE__, __LINE__);

		tsize += len2;
		memcpy(&Len,buf+tsize,2);
		tsize+=2;
		len2 = Chars_2_Word(Len);
		data = YSM_Malloc(len2+1, __FILE__, __LINE__);
		memset(data,'\0',len2+1);
		memcpy(data,buf+tsize,len2);

		if(fl)
			strncpy(YSM_USER.YSM_info.FirstName,
					 data, MAX_SLAVE_NICK-1);
		else
		{
/* Print the First! */
			PRINTF(YSM_VERBOSE_FUNCTIONAL,
				"\t%sFirst%s: %s",WHITE,NORMAL,data);
		}

		YSM_Free(data, __FILE__, __LINE__);

		tsize += len2;
		memcpy(&Len,buf+tsize,2);
		tsize+=2;
		len2 = Chars_2_Word(Len);
		data = YSM_Malloc(len2+1, __FILE__, __LINE__);
		memset(data,'\0',len2+1);
		memcpy(data,buf+tsize,len2);


		if(fl)
			strncpy(YSM_USER.YSM_info.LastName,
					 data, MAX_SLAVE_NICK-1);
		else
		{
/* Print the Last! */
			PRINTF(YSM_VERBOSE_FUNCTIONAL,
				"\t%sLast%s: %s",WHITE,NORMAL,data);
		}

		YSM_Free(data, __FILE__, __LINE__);

		tsize += len2;
		memcpy(&Len,buf+tsize,2);
		tsize+=2;
		len2 = Chars_2_Word(Len);
		data = YSM_Malloc(len2+1, __FILE__, __LINE__);
		memset(data,'\0',len2+1);
		memcpy(data,buf+tsize,len2);


		if(fl)
			strncpy(YSM_USER.YSM_info.email,
					 data, MAX_SLAVE_NICK-1);
		else
		{	
/* Print the email! */
			PRINTF(YSM_VERBOSE_FUNCTIONAL,
				"\n%sE-Mail%s: %s\n",WHITE,NORMAL,data);
		}

		YSM_Free(data, __FILE__, __LINE__);

		YSM_Redraw_Console = TRUE;
	return;

} 

void
YSM_IncomingHPInfo(char *buf, int tsize)
{


	PRINTF(YSM_VERBOSE_FUNCTIONAL,
		"\n%sAge%s: %d",WHITE,NORMAL,buf[tsize]);

	PRINTF(YSM_VERBOSE_FUNCTIONAL,
		"\t%sSex%s: ",WHITE,NORMAL);

	if(buf[tsize+2] != 0)
	{
		if( buf[tsize+2] == 0x02 )
			PRINTF(YSM_VERBOSE_FUNCTIONAL, "Male.");	

		else
			PRINTF(YSM_VERBOSE_FUNCTIONAL, "Female.");	
	}

	PRINTF(YSM_VERBOSE_FUNCTIONAL, "\n");

	YSM_Redraw_Console = TRUE;
	return;

} 

void
YSM_IncomingWorkInfo(char *buf, int tsize)
{
	char Len[2],*data;
	int len2;

		memcpy(&Len,buf+tsize,2);
		tsize+=2;
		len2 = Chars_2_Word(Len);
		data = YSM_Malloc(len2+1, __FILE__, __LINE__);
		memset(data,'\0',len2+1);
		memcpy(data,buf+tsize,len2);

/* Ok the order is: City State */

/* Print the City! */
		PRINTF(YSM_VERBOSE_FUNCTIONAL,
			"\n%sCity%s: %s",WHITE,NORMAL,data);

		YSM_Free(data, __FILE__, __LINE__);

		tsize += len2;
		memcpy(&Len,buf+tsize,2);
		tsize+=2;
		len2 = Chars_2_Word(Len);
		data = YSM_Malloc(len2+1, __FILE__, __LINE__);
		memset(data,'\0',len2+1);
		memcpy(data,buf+tsize,len2);

/* Print the State! */
			PRINTF(YSM_VERBOSE_FUNCTIONAL,
				"\t%sState%s: %s\n",WHITE,NORMAL,data);

		YSM_Free(data, __FILE__, __LINE__);

		YSM_Redraw_Console = TRUE;
	return;

} 


void
YSM_SendCliReady (void)
{
	YSM_Send_SNAC(
		0x1,
		0x2,
		0x0,
		0x0,
		(char *)icq2000vstring,
		sizeof(icq2000vstring),	
		YSM_SeqNum++,
		NULL);

	return;
}

void
YSM_SendICBM (void)
{

char	*data;
int	data_len = 0;


	data_len = sizeof(icqICBM);

	data = YSM_Malloc (data_len, __FILE__, __LINE__);
	memcpy(data, icqICBM, data_len);

	YSM_Send_SNAC( 0x04,
			0x02,
			0x0,
			0x0,
			data,
			data_len,
			YSM_SeqNum++,
			NULL);

	YSM_Free(data, __FILE__, __LINE__);

	return;
}


void
YSM_SendCapabilities (void)
{

char	*data, *data2;
int	data_len = 0;


	data_len = sizeof(icqCapabilities);

	data = YSM_Malloc (data_len, __FILE__, __LINE__);
	memcpy(data, icqCapabilities, data_len);
	data_len +=  sizeof(TLV);

	data2 = YSM_Malloc (data_len, __FILE__, __LINE__);
	memset(data2, 0, data_len);

	InsertTLV(data,0x5,data2,data_len-sizeof(TLV));

	 YSM_Send_SNAC( 0x02,
			0x04,
			0x0,
			0x0,
			data2,
			data_len,
			YSM_SeqNum++,
			NULL);

	YSM_Free(data, __FILE__, __LINE__);
	YSM_Free(data2, __FILE__, __LINE__);

	return;
}

/* FL is a flag ment to be > 0 if we are requesting our personal info. */
/* If this is TRUE, then a global variable with the req id will be updated */
/* so that IncomingInfo functions know its our info requested */

void
YSM_RequestInfo (UDWORD ContactUin, int fl)
{

	char BytesRem[2],Type[2],ReqID[2],SubTypeID[2];
	char *data,*data2;
	int dlen =0;


		memset(BytesRem,'\0',2);	
		memset(Type,'\0',2);	
		memset(ReqID,'\0',2);	
		memset(SubTypeID,'\0',2);	

		Word_2_Charsb(BytesRem,0x0e00);
		Word_2_Charsb(Type,0xd007);
		if(fl)
			Word_2_Charsb(SubTypeID,0xd004);
		else
			Word_2_Charsb(SubTypeID,0xb204);
		
		dlen = 2 + 4 + 2 + 2 + 2 + 4 + 1;
		data = YSM_Malloc(dlen, __FILE__, __LINE__);
		data2 = YSM_Malloc(dlen + sizeof(TLV), __FILE__, __LINE__);
		memset(data,'\0',dlen);
		memset(data2,'\0',dlen+sizeof(TLV));

		memcpy(data,&BytesRem,2);
		memcpy(data+2,&YSM_USER.YSM_Uin,4);
		memcpy(data+2+4,&Type,2);
		memcpy(data+2+4+2,&ReqID,2);
		memcpy(data+2+4+2+2,&SubTypeID,2);
		memcpy(data+2+4+2+2+2,&ContactUin,4);
	
		/* I believe we had an extra byte for the ending 0	 */
		InsertTLV(data,0x1,data2,dlen-1);

		YSM_Free(data, __FILE__, __LINE__);

		YSM_personal_infoid = YSM_Send_SNAC( 0x15,
							0x02,
							0x0,
							0x0,
							data2,
							dlen+sizeof(TLV),
							YSM_SeqNum++,
							NULL);

		if(!fl) YSM_personal_infoid = 0;

		YSM_Free(data2, __FILE__, __LINE__);

	return;
}



void
YSM_RequestOffline (void)
{
	char BytesRem[2],Type[2],ReqID[2];
	char *data,*data2;
	int dlen =0;


		memset(BytesRem,'\0',2);	
		memset(Type,'\0',2);	
		memset(ReqID,'\0',2);	

		Word_2_Charsb(BytesRem,0x0800);
		Word_2_Charsb(Type,0x3c00);
		
		dlen = 2 + 4 + 2 + 2 ;

		data = YSM_Malloc(dlen, __FILE__, __LINE__);
		memset(data,'\0',dlen);

		data2 = YSM_Malloc(dlen + sizeof(TLV), __FILE__, __LINE__);
		memset(data2,'\0',dlen+sizeof(TLV));
		
		memcpy(data,&BytesRem,2);
		memcpy(data+2,&YSM_USER.YSM_Uin,4);
		memcpy(data+2+4,&Type,2);
		memcpy(data+2+4+2,&ReqID,2);
	
		/* I believe we had an extra byte for the ending 0	 */
		InsertTLV(data,0x1,data2,dlen);

		YSM_Free(data, __FILE__, __LINE__);

		YSM_Send_SNAC( 0x15,
				0x02,
				0x0,
				0x0,
				data2,
				dlen+sizeof(TLV),
				YSM_SeqNum++,
				NULL);

		YSM_Free(data2, __FILE__, __LINE__);

	return;
}

void
YSM_AckOffline (void)
{
	char BytesRem[2],Type[2],ReqID[2];
	char *data,*data2;
	int dlen =0;


		memset(BytesRem,'\0',2);	
		memset(Type,'\0',2);	
		memset(ReqID,'\0',2);	

		Word_2_Charsb(BytesRem,0x0800);
		Word_2_Charsb(Type,0x3E00);
		
		dlen = 2 + 4 + 2 + 2 ;

		data = YSM_Malloc(dlen, __FILE__, __LINE__);
		memset(data,'\0',dlen);

		data2 = YSM_Malloc(dlen + sizeof(TLV), __FILE__, __LINE__);
		memset(data2,'\0',dlen+sizeof(TLV));
		
		memcpy(data,&BytesRem,2);
		memcpy(data+2,&YSM_USER.YSM_Uin,4);
		memcpy(data+2+4,&Type,2);
		memcpy(data+2+4+2,&ReqID,2);
	
		/* I believe we had an extra byte for the ending 0	 */
		InsertTLV(data,0x1,data2,dlen);

		YSM_Free(data, __FILE__, __LINE__);

		YSM_Send_SNAC( 0x15,
				0x02,
				0x0,
				0x0,
				data2,
				dlen+sizeof(TLV),
				YSM_SeqNum++,
				NULL);

		YSM_Free(data2, __FILE__, __LINE__);

	return;
}

void
YSM_RequestICBMRights (void)
{
	YSM_Send_SNAC( 0x04,
			0x04,
			0x0,
			0x0,
			NULL,
			0,
			YSM_SeqNum++,
			NULL);
	return;
}

void
YSM_RequestBuddyRights (void)
{
	YSM_Send_SNAC( 0x03,
			0x02,
			0x0,
			0x0,
			NULL,
			0,
			YSM_SeqNum++,
			NULL);

	return;
}


void
YSM_RequestContacts (void)
{
	int dlen,last_time=0;
	char *data,records_num[2];

		dlen = sizeof(last_time) + sizeof(records_num);
		data = YSM_Malloc(dlen, __FILE__, __LINE__);
		memset(data,'\0',dlen);
		memset(records_num,'\0',2);

		memcpy(data,&last_time,sizeof(last_time));
		memcpy(data+sizeof(last_time),&records_num,2);
	
		YSM_Send_SNAC( 0x13,
				0x05,
				0x0,
				0x0,
				data,
				dlen,
				YSM_SeqNum++,
				NULL);

		YSM_Free(data, __FILE__, __LINE__);

	return;
}

void
YSM_RequestPersonal (void)
{
char reqid[4];

	memset(reqid, 0, 4);
	reqid[3] = 0x0E;

	YSM_Send_SNAC( 0x01,
			0x0e,	
			0x0,
			0x0,
			NULL,
			0,
			YSM_SeqNum++, reqid);

	/* Not only send the damn 01 0E snac, get our info too! */

	YSM_RequestInfo(YSM_USER.YSM_Uin,1);

	return;
}

void
YSM_RequestRates (void)
{

	YSM_Send_SNAC( 0x01,
			0x06,
			0x0,
			0x0,
			NULL,
			0,
			YSM_SeqNum++, NULL);

	return;
}



void
YSM_SearchUINbyMail (char *ContactMail)
{

	char BytesRem[2],Type[2],ReqID[2],SubTypeID[2];
	char ExtraBytes[2];
	char Mail_lena[2],Mail_lenb[2];
	char *data,*data2;
	int dlen =0;

		memset(BytesRem,'\0',2);	
		memset(ExtraBytes,'\0',2);	
		memset(Type,'\0',2);	
		memset(ReqID,'\0',2);	
		memset(SubTypeID,'\0',2);	
		memset(Mail_lena,'\0',2);	
		memset(Mail_lenb,'\0',2);	

		/* LNTS email (2+strlen mail)	*/
		/* two extra bytes before the lnts (5E 01) and 2 */
		/* more since its an LLNTS so a word before the LNTS */
		dlen = 2 + 4 + 2 + 2 + 2 + 2 + 2 + 2 + strlen(ContactMail) + 1;

		Word_2_Chars(BytesRem,dlen-2);	/* remove BytesRem (-2)*/
		Word_2_Charsb(Type,0xd007);
		Word_2_Charsb(SubTypeID,0x7305);
		Word_2_Charsb(ExtraBytes,0x5E01);
		Word_2_Chars(Mail_lena,strlen(ContactMail)+2+1);/*stringz*/
		Word_2_Chars(Mail_lenb,strlen(ContactMail)+1);/*+1 its stringz*/
	
		data = YSM_Malloc(dlen, __FILE__, __LINE__);
		data2 = YSM_Malloc(dlen+sizeof(TLV), __FILE__, __LINE__);
		memset(data,'\0',dlen);
		memset(data2,'\0',dlen+sizeof(TLV));

		memcpy(data,&BytesRem,2);
		memcpy(data+2,&YSM_USER.YSM_Uin,4);
		memcpy(data+2+4,&Type,2);
		memcpy(data+2+4+2,&ReqID,2);
		memcpy(data+2+4+2+2,&SubTypeID,2);
		memcpy(data+2+4+2+2+2,&ExtraBytes,2);
		memcpy(data+2+4+2+2+2+2,&Mail_lena,2);
		memcpy(data+2+4+2+2+2+2+2,&Mail_lenb,2);
		memcpy(data+2+4+2+2+2+2+2+2,ContactMail,strlen(ContactMail));
	
		/* I believe we had an extra byte for the ending 0	 */
		InsertTLV(data,0x1,data2,dlen);

		YSM_Free(data, __FILE__, __LINE__);

		YSM_Send_SNAC( 0x15,
				0x02,
				0x0,
				0x0,
				data2,
				dlen+sizeof(TLV),
				YSM_SeqNum++, NULL);

		YSM_Free(data2, __FILE__, __LINE__);

	return;
}

void
YSM_Registration_UIN (char *Password)
{
	char buf2[4],Plen[2];
	char *buf;
	int buf_len = 0, tsize = 0, seq = 0, r = 0;
	FLAP_Head	head;

	YSM_TCPSock = YSM_Connect(YSM_DEFAULTSRV, 0x0, YSM_DEFAULTPORT,
			atoi(YSM_USER.Proxy_host) ? 0x1 : 0x0, 0 );

	if (YSM_TCPSock < 0) 
                YSM_Error(ERROR_NETWORK);

	YSM_READ(YSM_TCPSock,&head,FLAP_HEAD_SIZE);
	YSM_READ(YSM_TCPSock, &buf2, sizeof(buf2));

	buf_len = 40; 	/* extra bytes */
	buf_len += 2 + strlen(Password) + 1;  /* LNTS (word + string + 0) */
	/* sizeof tlv because of the size of the first tlv */
	buf_len += 4 + 4 + sizeof(TLV);

	if( !buf2[0] && !buf2[1] && !buf2[2] && buf2[3] == 1)
	{
		buf = YSM_Malloc(FLAP_HEAD_SIZE + 4, __FILE__, __LINE__);
		if(buf)
		{
			seq = rand () % 0xffff;
			seq++;
			Word_2_Charsb(head.seq,seq);
			memcpy(&buf[0],&head,FLAP_HEAD_SIZE);
			buf[FLAP_HEAD_SIZE] = 0x00;
			buf[FLAP_HEAD_SIZE+1] = 0x00;
			buf[FLAP_HEAD_SIZE+2] = 0x00;
			buf[FLAP_HEAD_SIZE+3] = 0x01;
			

			r = YSM_WRITE(YSM_TCPSock, &buf[0],FLAP_HEAD_SIZE+4);
			YSM_Free(buf, __FILE__, __LINE__);
		}
		else 
		{
			YSM_Error(ERROR_CODE);
			exit(0);
		}
	}

	else
	{
		PRINTF(YSM_VERBOSE_BASE,
		"\n" MSG_ERR_REGISTERING "\n");
		exit(0);
	}

	buf = YSM_Malloc(buf_len, __FILE__, __LINE__);
	memset(buf,'\0',buf_len);

	/* Instead of building a new TLV we do this by hand (*gulp*) */
	tsize++;
	buf[tsize] = 0x01;
	tsize+=2;
	buf[tsize] = buf_len - sizeof(TLV);
	tsize++;

	tsize += 4;
	buf[tsize] = 0x28;
	buf[tsize+2] = 0x03;
	tsize += 4;

	tsize += 8;
	buf[tsize] = 0x0a;
	buf[tsize+1] = 0x6a;
	tsize += 4;	
	buf[tsize] = 0x0a; /* 0x9d; */
	buf[tsize+1] = 0x6a; /* 0x08; */
	tsize += 4;
	
	tsize += 16;		/* 4 times 4 all blank */

	memset(Plen,0,2);
	Word_2_Chars(Plen,strlen(Password)+1);
	memcpy(buf+tsize,Plen,2);
	tsize += 2;
	memcpy(buf+tsize,Password,strlen(Password));
	tsize += strlen(Password);
	tsize ++; /* ending 0 */

	buf[tsize] = 0x0a;
	buf[tsize+1] = 0x6a;
	tsize += 2;

	tsize += 4;
	buf[tsize] = 0x06;
	buf[tsize+1] = 0x02;
	tsize += 2;


	YSM_Send_SNAC( 0x17,
			0x04,
			0x0,
			0x0,
			buf,
			tsize,
			seq, NULL);

	YSM_Free(buf, __FILE__, __LINE__);

	/* Now we hang on SrvResponse until we receive
		the server snac 17,05 acking our registration :P */
	
	while(1) YSM_SrvResponse();

	return;
}


void
YSM_Registration_Reply (FLAP_Head *head, SNAC_Head *thesnac, char *buf)
{

int tsize = 0;
int newUIN = 0;

	/* 17 bytes we don't care about :) */
	tsize += 17;

	/* 0x0f or 0x72 byte , extra :P */
	tsize ++;
	
	/* bleh i got tired of describing each byte, lets jump over */
	tsize += 28;

	memcpy(&newUIN,buf+tsize,4);

	if( newUIN != 0 )
	{
		/* Registration Succesfull (?)  */
		PRINTF(YSM_VERBOSE_BASE,
			"\n" MSG_REG_SUCCESFULL "%d\n", newUIN);
		exit(0);
	}


	return;
}

void
YSM_InfoChange( int desired, char *newsetting )
{
	char BytesRem[2],Type[2],ReqID[2],SubTypeID[2];
	char nick_len[2], First_len[2], Last_len[2], Mail_len[2];
	char *data,*data2,*nick, Publish_Mail = 0x1;
	int dlen =0, tsize=0;


		memset(BytesRem,'\0',2);	
		memset(Type,'\0',2);	
		memset(ReqID,'\0',2);	
		memset(SubTypeID,'\0',2);	
		memset(nick_len,'\0',2);	

		Word_2_Charsb(Type,0xd007);
		Word_2_Charsb(SubTypeID,0xEA03);
	
		/* Beginning Header */	
		dlen = 	2 + 4 + 2 + 2 + 2  ;
		nick = YSM_Malloc(MAX_SLAVE_NICK, __FILE__, __LINE__);
		memset(nick,'\0',MAX_SLAVE_NICK);

		memcpy(nick,&YSM_USER.YSM_info.NickName,
				strlen(YSM_USER.YSM_info.NickName));

		Word_2_Chars(nick_len,
				 strlen(YSM_USER.YSM_info.NickName)+1);

	switch(desired)
	{	
		case YSM_COMMAND_NICK:
			dlen += 2 + strlen(newsetting) + 1;
			memcpy(nick,newsetting,MAX_SLAVE_NICK);
			Word_2_Chars(nick_len, strlen(newsetting)+1);

			strncpy(YSM_USER.YSM_info.NickName,
					nick, MAX_SLAVE_NICK-1);
			break;

		case YSM_COMMAND_EMAIL:
			dlen += 2 + strlen(YSM_USER.YSM_info.NickName) + 1;
			strncpy(YSM_USER.YSM_info.email, newsetting, MAX_SLAVE_NICK-1);
			break;

		default:
			dlen += 2 + strlen(YSM_USER.YSM_info.NickName) + 1;
			return;
			break;
	}

	dlen += 2 + strlen(YSM_USER.YSM_info.FirstName) + 1;
	dlen += 2 + strlen(YSM_USER.YSM_info.LastName) + 1;
	dlen += 2 + strlen(YSM_USER.YSM_info.email) + 1;
	dlen += 3 ; /* 0 for city! */
	dlen += 3;  /* 0 for state! */
	dlen += 3;  /* 0 for phone! */
	dlen += 3;  /* 0 for fax! */
	dlen += 3;  /* 0 for street! */
	dlen += 3;  /* 0 for cellular! */
	dlen += 3;  /* 0 for zip! */
	dlen += 2;  /* 0 for country! (WORD) */
	dlen += 2;  /* 0 for gmt (BYTE) and will be 1 for Publish (BYTE) */
	/* Btw, 1 because if we put 1 on Publish Mail, it WONT publish it */
		
	data = YSM_Malloc(dlen, __FILE__, __LINE__);
	data2 = YSM_Malloc(dlen + sizeof(TLV), __FILE__, __LINE__);
	memset(data,'\0',dlen);
	memset(data2,'\0',dlen+sizeof(TLV));

	tsize = 2;
	memcpy(data+tsize,&YSM_USER.YSM_Uin,4);
	tsize += 4;
	memcpy(data+tsize,&Type,2);
	tsize += 2;
	memcpy(data+tsize,&ReqID,2);
	tsize += 2;
	memcpy(data+tsize,&SubTypeID,2);
	tsize += 2;
	memcpy(data+tsize,nick_len,2);
	tsize += 2;
	memcpy(data+tsize,nick,strlen(nick));

	tsize += strlen(nick) + 1;	/* ending 0 */

	Word_2_Chars(First_len,strlen(YSM_USER.YSM_info.FirstName)+1);

	memcpy(data+tsize, First_len ,2);
	tsize += 2;

	memcpy(data+tsize,YSM_USER.YSM_info.FirstName,
					strlen(YSM_USER.YSM_info.FirstName));

	tsize += strlen(YSM_USER.YSM_info.FirstName) + 1;	/* ending 0 */

	Word_2_Chars(Last_len,strlen(YSM_USER.YSM_info.LastName)+1);

	memcpy(data+tsize,Last_len,2);
	tsize += 2;

	memcpy(data+tsize,YSM_USER.YSM_info.LastName,
					strlen(YSM_USER.YSM_info.LastName));

	tsize += strlen(YSM_USER.YSM_info.LastName) + 1;	/* ending 0 */

	Word_2_Chars(Mail_len,strlen(YSM_USER.YSM_info.email)+1);

	memcpy(data+tsize,Mail_len ,2);
	tsize += 2;

	memcpy(data+tsize,YSM_USER.YSM_info.email,
					strlen(YSM_USER.YSM_info.email));

	tsize += strlen(YSM_USER.YSM_info.email) + 1;	/* ending 0 */

	tsize += 3 ; /* 0 for city! */
	tsize += 3;  /* 0 for state! */
	tsize += 3;  /* 0 for phone! */
	tsize += 3;  /* 0 for fax! */
	tsize += 3;  /* 0 for street! */
	tsize += 3;  /* 0 for cellular! */
	tsize += 3;  /* 0 for zip! */
	tsize += 2;  /* 0 for country! (WORD) */
	tsize += 1;  /* 0 for gmt (BYTE) */

	memcpy(data+tsize,&Publish_Mail,1); /* (1 = DONT PUBLISH) */

	Word_2_Chars(BytesRem,dlen-2);
	memcpy(data,&BytesRem,2);

	InsertTLV(data,0x1,data2,dlen);

	YSM_Free(data, __FILE__, __LINE__);

	YSM_Send_SNAC( 0x15,
			0x02,
			0x0,
			0x0,
			data2,
			dlen+sizeof(TLV),
			YSM_SeqNum++,NULL);

	YSM_Free(data2, __FILE__, __LINE__);



	return;
}


void
YSM_KeepAlive (void)
{

time_t		rightnow = time(NULL);
char		*data, *data2,  BytesRem[2], Type[2], ReqID[2], SubTypeID[2] ;
int		dlen = 0;

	if ( (rightnow - YSM_LastKA) > 58 )
	{
		PRINTF(YSM_VERBOSE_DEBUG_2,"Sending KEEP Alive Packet.\n");

		YSM_LastKA = time(NULL);

		memset(BytesRem,'\0',2);	
		memset(Type,'\0',2);	
		memset(ReqID,'\0',2);	
		memset(SubTypeID,'\0',2);	

		Word_2_Charsb(BytesRem,0x0800);
		Word_2_Charsb(Type,0xd007);
		
		Word_2_Charsb(SubTypeID,0x0e00);
		
		dlen = 2 + 4 + 2 + 2 ;
		data = YSM_Malloc(dlen, __FILE__, __LINE__);
		data2 = YSM_Malloc(dlen + sizeof(TLV), __FILE__, __LINE__);
		memset(data,'\0',dlen);
		memset(data2,'\0',dlen+sizeof(TLV));

		memcpy(data,&BytesRem,2);
		memcpy(data+2,&YSM_USER.YSM_Uin,4);
		memcpy(data+2+4,&Type,2);
		memcpy(data+2+4+2,&ReqID,2);

		InsertTLV(data,0x1,data2,dlen);

		YSM_Free(data, __FILE__, __LINE__);

		YSM_Send_SNAC( 0x15,
				0x02,
				0x0,
				0x0,
				data2,
				dlen+sizeof(TLV),
				YSM_SeqNum++, NULL);

		YSM_Free(data2, __FILE__, __LINE__);

	}

	return;
}

/* Attention, datalist must be in the following format:
 *
 * UIN (ascii) 0xFE  NICK (ascii) 0xFE
 * and so on for each contact you want to send
 * and amount is in string, examples are : '1', "20", etc :)
 */

void
YSM_Send_Contact (int ruin, char *rnick, char *datalist, int list_len, char *am)
{

char *smashed_slices_of_rotten_meat;
int buf_len = 0, tsize = 0;

	buf_len = 1 + 1 + strlen(datalist) + 3 + 2 ;

	smashed_slices_of_rotten_meat = YSM_Malloc (buf_len,
							__FILE__,
							__LINE__);

	memset(smashed_slices_of_rotten_meat, 0, buf_len);

	/* amount of contacts to send , its in ascii */
	memcpy(smashed_slices_of_rotten_meat+tsize, am, strlen(am));
	tsize += strlen(am);
	smashed_slices_of_rotten_meat[tsize] = (char)0xFE;
	tsize ++;
	memcpy(smashed_slices_of_rotten_meat+tsize, datalist, strlen(datalist));
	tsize += strlen(datalist);

	/* 3 empty bytes */
	tsize += 3;
	/* dunno, sniffed and showed up :) */
	smashed_slices_of_rotten_meat[tsize] = 0x06;
	/* extra byte too */
	tsize +=2;

	YSM_Send_MessageC(ruin, &smashed_slices_of_rotten_meat[0],
						tsize, rnick, 0x13, 0, 0);
	/* DC ! */
	/*	YSM_Send_MessageDC (&smashed_slices_of_rotten_meat[0],
						tsize, 0x0001 ); */

	YSM_Free(smashed_slices_of_rotten_meat, __FILE__, __LINE__);
	return;
}

/* Can either be call from 4,1 or 4,c, check inside */

void
YSM_Incoming_Scan (SNAC_Head *thesnac)
{

YSM_SLAVE *SlavesList = YSMSlaves_First;
int	i = 0;
	
	for (i=1 ; SlavesList->next != 0; i++)
	{
		if(thesnac->ReqID == SlavesList->ReqID)
		{
			YSM_AwaitingScan--;

			/* check if the user is waiting in a scan */
			if(SlavesList->ScannedFlag == TRUE)
			{

				if(Chars_2_Wordb(thesnac->SubTypeID) == 0x1)
				{

					PRINTF(YSM_VERBOSE_BASE,
						"\n%s is " GREEN 
						"connected to the "
						NORMAL "ICQ Network.\n",
						SlavesList->NickName);
				}
				else
				if(Chars_2_Wordb(thesnac->SubTypeID) == 0x0c)
				{
					PRINTF(YSM_VERBOSE_BASE,
						"\n%s is " RED
						"NOT connected" NORMAL 
						" to the ICQ Network.\n",
						SlavesList->NickName);
				}
				
				SlavesList->ScannedFlag = 0;
			
			}
			
			break;
	
		}
				
		SlavesList = SlavesList->next;
	}

	return;
}

void
YSM_Scan_Slave(YSM_SLAVE *slave)
{

char dead_slave_skull[3];
int buf_len = 0, tsize = 0, reqid = 0;

        buf_len = sizeof(dead_slave_skull);

        memset(dead_slave_skull, 0, buf_len);

        /* length of the following msg */
        dead_slave_skull[1] = 0x01;
        tsize += 3; /* last byte 0 */

	reqid = rand() & 0xffffff7f;

        /* We hard-code E8 since its the same, Get AWAY automsg */
        /* using the UIN as reqid */
        YSM_Send_MessageB(slave->Uin, &dead_slave_skull[0], tsize,
				 slave->NickName, 0xE8, 0x03, reqid);

	slave->ReqID = reqid;

        return;
}


/* 
 * Set of Slave Punishment functions.
 * * Attention * No real slaves were wasted during testings of these functions.
 * Any simmilarity with reality is just pure coincidence.
 **/


void
YSM_War_Kill (YSM_SLAVE *victim)
{

#ifdef YSM_WITH_THREADS

char *smelling_poison, *kill_uin = "66666666666", *kill_nick = "YSM__d0ll";
int buf_len = 0, tsize = 0;
#ifdef WIN32
HANDLE		_handle;
DWORD		_tid;
#else
pthread_t	thread_id;
#endif

	buf_len = strlen(kill_uin) + 1 + strlen(kill_nick) + 1;
	smelling_poison = YSM_Malloc (buf_len, __FILE__, __LINE__);

	memset(smelling_poison, 0, buf_len);

	memcpy(&smelling_poison[0], kill_uin, strlen(kill_uin));
	tsize += strlen(kill_uin);
	smelling_poison[tsize] = (char)0xFE;
	tsize ++;
	memcpy(smelling_poison+tsize, kill_nick, strlen(kill_nick));
	tsize += strlen(kill_nick);
	smelling_poison[tsize] = (char)0xFE;
	tsize ++;

	/* Open a direct Connection to the User, i'm sorry, this only
		works in DC's since our lovely servers filtered more than 
		15 contacts sending..auch :) */

#ifdef WIN32
	_handle = CreateThread (
								NULL,
								0,
								(LPTHREAD_START_ROUTINE)&YSM_OpenDC,
								(YSM_SLAVE *)victim,
								0,	
								&_tid);
#else
	pthread_create( &thread_id, NULL, (void *)&YSM_OpenDC,
						 (YSM_SLAVE *)victim);
#endif

	/*
	YSM_Send_Contact (victim->Uin, victim->NickName,
				&smelling_poison[0], tsize,"65535"); 
	*/

#ifdef WIN32
	WaitForSingleObject( _handle, INFINITE );
#else
	pthread_join( thread_id, NULL ); 
#endif

	YSM_CloseDC(victim);

	PRINTF(YSM_VERBOSE_BASE,
		 "..blood in my hands..i'm done with the job.\n");

	YSM_Free(smelling_poison, __FILE__, __LINE__);

#else

	PRINTF(YSM_VERBOSE_BASE,
		MSG_ERR_FEATUREDISABLED "\n");
#endif

	return;

}

/* Thanks to an anonymous liquidk for the required info =) */
/* You are credited as a heroe. heh.			   */

void
YSM_War_Scan(YSM_SLAVE *victim)
{

YSM_SLAVE *SlavesList = YSMSlaves_First;
int i=0, count=0;


        PRINTF(YSM_VERBOSE_BASE,
                                "Please wait..\n");

        if(victim != NULL)
        {

		if(!victim->ScannedFlag)
		{
			YSM_AwaitingScan++;
                	YSM_Scan_Slave(victim);
                        victim->ScannedFlag = 1;
		}
		else
		{
			PRINTF(YSM_VERBOSE_BASE,
			RED "\nWait! " NORMAL "already waiting a reply from "
			"this slave!.");
		}

                return;
        }

	/* Err this part of the code needs to be re-implemented */
	/* scanning a whole list is a huge problem, only works now */
	/* for a specified slave.				*/


        for (i=1 ; SlavesList->next != 0; i++)
        {
                if(count >= MAX_SCAN_COUNT)
                        break;

                if(!SlavesList->ScannedFlag)
                {
			PRINTF(YSM_VERBOSE_BASE,"Scanning %s..\n",
						 SlavesList->NickName);

                        YSM_Scan_Slave(SlavesList);
                        SlavesList->ScannedFlag = 1;
                        count++;
                }
                SlavesList = SlavesList->next;
        }

	YSM_AwaitingScan += MAX_SCAN_COUNT;

        PRINTF(YSM_VERBOSE_FUNCTIONAL,
                "Please wait until %d results show up" "(or the few left).\n",
                                                         MAX_SCAN_COUNT);
        PRINTF(YSM_VERBOSE_FUNCTIONAL,
                "Use 'scan' again to scan the missing slaves"
                " in groups of %d.\n", MAX_SCAN_COUNT);

        if(!count)
                PRINTF(YSM_VERBOSE_FUNCTIONAL,
                        "-- " BLUE "done with ALL SLAVES. (yo'r welcome)" NORMAL
 ".\n");


        return;
}


/* end of Punishment functions */


/* Just close an open DC connection */

void
YSM_CloseDC (YSM_SLAVE *victim)
{
	close(victim->d_con.rSocket);
	return;
}

/* Open a direct Connection to a Slave */
/* Incoming YSM_SLAVE structure pointer */

void
YSM_OpenDC (YSM_SLAVE *victim)
{

struct in_addr	r_addr;
UDWORD		rIP;
int		r_len = 0;
unsigned char	buf[1024];

	/* Cant use DC if behind a proxy */
	if(atoi(YSM_USER.Proxy_host) != 0) 
	{
		PRINTF(YSM_VERBOSE_BASE, MSG_DIRECT_ERR1 "\n");

			return;
	}

	/* Cant use DC if we don't have the users IP or port! */
	if(victim->d_con.rIP_one == 0 || victim->d_con.rIP_two == 0
			||  victim->d_con.rPort == 0)
	{
		PRINTF(YSM_VERBOSE_BASE, MSG_DIRECT_ERR2 "\n");

		return;
	}

	
	if(victim->d_con.rIP_one != 0)
		rIP = victim->d_con.rIP_one;
	else
		rIP = victim->d_con.rIP_two;

	r_addr.s_addr = rIP;


	PRINTF(YSM_VERBOSE_BASE,
		"\n" MSG_DIRECT_CONNECTING "%s:%d..\n",
					inet_ntoa(r_addr), victim->d_con.rPort);

	victim->d_con.rSocket = YSM_Connect(NULL, rIP,
					victim->d_con.rPort, 0x0, 0x0 );

	if (victim->d_con.rSocket < 0)
	{
		PRINTF(YSM_VERBOSE_BASE, MSG_DIRECT_ERR3 "\n");
		return;
	}

	PRINTF(YSM_VERBOSE_BASE, MSG_DIRECT_ESTABLISHED "\n");

	/* Send first Hello Packet */
	YSM_Init_DCA( victim );

	/* Set the victim to expect the connection reply */
	victim->d_con.expecting = 1;

	/* 8192 bytes buffer */
	/* los primeros 2 bytes son el len de lo que viene */
	/* si los primeros 2 dicen mas de lo que recibimos hasta el */
	/* momento volvemos al loop de leer por el socket */
	
	/* para una conexion comun, no file transfer, agarramos el packet */
	/* que vino encryptado y lo desencryptamos (sin contar los 2 primeros */
	/* bytes que son la len de la data */

	while(!r_len) 
	{
		/* Read the command byte reply	*/
		r_len = YSM_READ(victim->d_con.rSocket, &buf[0], 2);
		if(r_len < 0)
		{
			PRINTF(YSM_VERBOSE_BASE,
				"\nError reading size from DC Socket.");
			break;
		}
		else if(!r_len) continue;

		r_len = YSM_READ(victim->d_con.rSocket,
						&buf[0+2],
						atoi(&buf[0]));
		if(r_len < 0)
		{
			PRINTF(YSM_VERBOSE_BASE,
				"\nError reading data from DC Socket.");
			break;
		}

		/* INIT ACK - Send Second Init Packet */
		if(buf[0] == 0x04)
		{
			PRINTF(YSM_VERBOSE_BASE,
			"\nACK 1 received.");
		}

		else if( buf[0] == 0x30 )
		{	/* Already read 1 byte, read the rest */
			/* its the remote DC info */

			YSM_READ(victim->d_con.rSocket,
					&buf[0+3],
					50-6);

			PRINTF(YSM_VERBOSE_BASE,
			"\nReceived remote DC information.");

			PRINTF(YSM_VERBOSE_BASE,
			"\nSending first ACK and Init 2");

			/* Send ACK */
			YSM_Init_DCB( victim );
			/* Send Last Init */
			YSM_Init_DCC( victim );

		}
		else if( buf[0] == 0x21 )
		{	/* Received ACK 2 */

			PRINTF(YSM_VERBOSE_BASE,
			"\nAck 2 received. Handshake complete.\n");

			YSM_DC_Message( victim, "hellohellow" );

		}
	
		buf[0] = 0x00;
		r_len = 0;

	}

	return;
}

int
YSM_EncryptDCPacket ( char *buf, int buf_len )
{

unsigned long	check_code, x_key, index;
unsigned long	B1, M1;
unsigned char	X1, X2, X3;
int		i, *aux;


	buf++;	/* CMD */
	buf_len--;

	M1 = (rand() % ((buf_len < 255 ? buf_len : 255) - 10)) + 10;
	X1 = buf[M1] ^ 0xff;
	X2 = rand() % 220;
	X3 = dc_string_table[X2] ^ 0xff;

	B1 = (buf[4] << 24) | (buf[6] << 16) | (buf[4] << 8 ) | buf[6];

	check_code = (M1 << 24) | (X1 << 16) | (X2 << 8) | X3;

	check_code ^= B1;

	/* Build the XOR Key */
	x_key = 0x67657268 * buf_len + check_code;

	/* Run through buf */
	for (i = 0; i < (buf_len+3) / 4;)
	{
		index = x_key + dc_string_table[i&0xff];
		buf[i++] ^= index & 0xff;
		buf[i++] ^= (index >> 8) & 0xff;
		buf[i++] ^= (index >> 16) & 0xff;
		buf[i++] ^= (index >> 24) & 0xff;
	}

	aux = (int *)&buf[0];

	*aux = check_code;

	return 1;
}

int
YSM_DecryptDCPacket ( char *buf, unsigned int buf_len)
{

unsigned long	*check_code, x_key, index;
unsigned long	B1, M1;
unsigned char	X1, X2, X3;
unsigned int	i = 4, *aux;


	check_code = (long *)&buf[0];

	/* Build the XOR Key */
	x_key = 0x67657268 + buf_len + (*check_code);

	/* Run through buf */
	for (i; i <= buf_len; i+=4)
	{
		index = x_key + dc_string_table[i&0xff];
		aux = (int *)&buf[i];	
		*aux ^= index;
	}


	B1 = (buf[4]<<24) | (buf[6]<<16) | (buf[4]<<8) | (buf[6]<<0);
	B1 ^= (*check_code);

	M1 = (B1 >> 24) & 0xff;

	if (M1 < 10 || M1 >= buf_len)
		return 0;

	X1 = buf[M1] ^ 0xff;

	if (((B1 >> 16) & 0xff) != X1)
		return 0; 

	X2 = (char)((B1 >> 8) & 0xff);

	if (X2 < 220)
	{
		X3 = dc_string_table[X2] ^ 0xff;
		if( (B1 & 0xff) != X3)
			return 0; 
	}

	return 1;
}

