/*	$Id: YSM_ICQv7.h,v 1.4 2002/07/08 04:23:36 rad2k Exp $	*/
/*
-======================== You Sick Me v7 ===========================-

                                   |                                           
           - ----------------------                                          
    _      |                       |             _________________/_     _    
   _\____________   ______         _ __________  |               /             
     \           | _)    /                     \ |              /              
      \          |_\_  _/_______________/_      \|            _/               
                 |) /______________    /         \            |pix.imp         
                   /   \         )/___/         \  /          |                
  _    _\______   /    /__  ____/       - -------\/___________|               
         ` |  /__/        \/                                                   
           |          _      _           _                  __ ________ _      
           |                  )) y( O u  (s(i  C k    m.( E))                  
           |                                                                  
          -- ---------------- ---- -----                                     
                                  |                                            
                                  |                                            
-========================== YSM_ICQv7.h =============================-


YSM (YouSickMe) ICQ Client. An Original Multi-Platform ICQ client.
Copyright (C) 2002 rad2k Argentina.

YSM is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

For Contact information read the AUTHORS file.

*/

#ifndef _YSMICQV7H_
#define _YSMICQV7H_

/*
Esto es asi:

El paquete es un FLAP, el header del paquete es la estructura FLAP_Head, y luego
inmediatamente despues de esa estructura vienen los datos del FLAP que pueden 
contener un SNAC. El Header del SNAC es la estructura SNAC_Head, e inmediatamente le sigue una variable de SNAC_DATA.

*/

#define FLAP_HEAD_SIZE 6	/* unaligned FLAP header size */
#define SNAC_HEAD_SIZE 10	/* unaligned SNAC header size */

#define YSM_PROTOCOL_VERSION	0x08

typedef struct {

	BYTE familyID[2];
	BYTE SubTypeID[2];
	BYTE Flags_a;
	BYTE Flags_b;
	DWORD ReqID;

} SNAC_Head;

typedef struct {

	BYTE cmd;
	BYTE channelID;
	BYTE seq[2];
	BYTE dlen[2];

} FLAP_Head;

typedef struct
{
        BYTE type[2];
        BYTE len[2];
} TLV;


static const UBYTE icq2000vstring[] =
{
  	0x00,0x01,0x00,0x03,0x01,0x10,0x02,0x8A,0x00,0x02,0x00,
	0x01,0x01,0x01,0x02,0x8A,0x00,0x03,0x00,0x01,0x01,0x10,
	0x02,0x8A,0x00,0x15,0x00,0x01,0x01,0x10,0x02,0x8A,0x00,
	0x04,0x00,0x01,0x01,0x10,0x02,0x8A,0x00,0x06,0x00,0x01,
	0x01,0x10,0x02,0x8A,0x00,0x09,0x00,0x01,0x01,0x10,0x02,
	0x8A,0x00,0x0A,0x00,0x01,0x01,0x10,0x02,0x8A,
};

static const UBYTE icq2001vstring[] =
{
  	0x00,0x01,0x00,0x03,0x01,0x10,0x04,0x7B,0x00,0x13,0x00,
	0x02,0x01,0x10,0x04,0x7B,0x00,0x02,0x00,0x01,0x01,0x01,
	0x04,0x7B,0x00,0x03,0x00,0x01,0x01,0x10,0x04,0x7B,0x00,
	0x15,0x00,0x01,0x01,0x10,0x04,0x7B,0x00,0x04,0x00,0x01,
	0x01,0x10,0x04,0x7B,0x00,0x06,0x00,0x01,0x01,0x10,0x04,
	0x7B,0x00,0x09,0x00,0x01,0x01,0x10,0x04,0x7B,0x00,0x0A,
	0x00,0x01,0x01,0x10,0x04,0x7B,0x00,0x0B,0x00,0x01,0x01,
	0x10,0x04,0x7B,
};

static const UBYTE icqCloneIdent[] =
{
        0x00,0x01,0x00,0x03,0x00,0x02,0x00,0x01,0x00,0x03,0x00,0x01,
	0x00,0x15,0x00,0x01,0x00,0x04,0x00,0x01,0x00,0x06,0x00,0x01,
	0x00,0x09,0x00,0x01,0x00,0x0A,0x00,0x01,
};


static const UBYTE icqCloneIdent_old[] =
{
	0x00,0x01,0x00,0x03,0x00,0x13,0x00,0x02,0x00,0x02,0x00,0x01,
	0x00,0x03,0x00,0x01,0x00,0x15,0x00,0x01,0x00,0x04,0x00,0x01,
	0x00,0x06,0x00,0x01,0x00,0x09,0x00,0x01,0x00,0x0A,0x00,0x01,
	0x00,0x0B,0x00,0x01,
};

static const UBYTE icqICBM[] =
{
	0x00,0x00,0x00,0x00,0x00,0x03,0x1F,0x40,0x03,0xE7,0x03,0xE7,
	0x00,0x00,0x00,0x00,
};

static const UBYTE icqCapabilities_old[] =
{
	0x09,0x46,0x13,0x49,0x4c,0x7f,0x11,0xd1,0x82,0x22,0x44,0x45,
	0x53,0x54,0x00,0x00,0x97,0xB1,0x27,0x51,0x24,0x3C,0x43,0x34,
	0xAD,0x22,0xD6,0xAB,0xF7,0x3F,0x14,0x92,0x2E,0x7A,0x64,0x75,
	0xFA,0xDF,0x4D,0xC8,0x88,0x6F,0xEA,0x35,0x95,0xFD,0xB6,0xDF,
	0x09,0x46,0x13,0x44,0x4C,0x7F,0x11,0xD1,0x82,0x22,0x44,0x45,
	0x53,0x54,0x00,0x00,
};

static const UBYTE icqCapabilities[] =
{
	0x09,0x46,0x13,0x49,0x4c,0x7f,0x11,0xd1,0x82,0x22,0x44,0x45,
	0x53,0x54,0x00,0x00,0x09,0x46,0x13,0x44,0x4C,0x7F,0x11,0xD1,
	0x82,0x22,0x44,0x45,0x53,0x54,0x00,0x00,
};

static const UBYTE HeadMsgData1[] = 
{
#ifndef WIN32
	0xde,0xad,0x00,0x01,0x01,0x01,0x01,
#else
	0xbe,0xef,0x00,0x01,0x01,0x01,0x01,
#endif

};

static const UBYTE Rates_Acknowledge[] =
{
	0x00,0x01,0x00,0x02,0x00,0x03,0x00,0x04,0x00,0x05,
};

static const UBYTE SendMessageID[] =
{
	0x52,0x99,0x5D,0x00,0x69,0x23,0x00,0x00,
};

static const UBYTE dc_string_table[] =
{
	"As part of this software beta version Mirabilis is "
	"granting a limited access to the ICQ network, "
	"servers, directories, listings, information and databases (\""
	"ICQ Services and Information\"). The "
	"ICQ Service and Information may databases (\""
	"ICQ Services and Information\"). The "
	"ICQ Service and Information may\0"
};

/* Definicion de los tipos de Mensaje */

#define AUTH_MESSAGE            0x0008
#define USER_ADDED_MESS         0x000C
#define AUTH_REQ_MESS           0x0006
#define URL_MESS                0x0004
#define WEB_MESS                0x000d
#define EMAIL_MESS              0x000e
#define MASS_MESS_MASK          0x8000
#define MRURL_MESS              0x8004
#define NORM_MESS               0x0001
#define MRNORM_MESS             0x8001
#define CONTACT_MESS            0x0013
#define MRCONTACT_MESS          0x8013


/* Definicion de los Canales de habla (?) JA! */

#define YSM_CHANNEL_NEWCON	0x01
#define YSM_CHANNEL_SNACDATA	0x02
#define YSM_CHANNEL_FLAPERR	0x03
#define YSM_CHANNEL_CLOSECONN	0x04
#define YSM_CHANNEL_CONNALIVE	0x05


/* Definicion de las familias de SNACs y Sub IDs en un arbol */

#define YSM_BASIC_SERVICE_SNAC	0x01
	#define YSM_CLI_SRV_ERROR	0x01
	#define YSM_CLIENT_ONLINE	0x02
	#define	YSM_SERVER_IS_READY	0x03 
	#define YSM_REQUEST_SERVICE	0x04
	#define YSM_SRV_REDIRECT	0x05
	#define YSM_RATE_INFO_REQ	0x06
	#define YSM_RATE_INFO_RESP	0x07
	#define YSM_RATE_INFO_ACK	0x08
	#define YSM_RATE_INFO_CHANGE	0x0a
	#define YSM_SERVER_PAUSE	0x0b
	#define YSM_SERVER_RESUME	0x0c
	#define YSM_SCREEN_INFO_REQ	0x0e
	#define YSM_SCREEN_INFO_RESP	0x0f
	#define YSM_STATUS_CHANGE_ACK	0x0f
	#define YSM_SERVER_EVIL_NOT	0x10
	#define YSM_SERVER_MIGRATE	0x12
	#define YSM_SERVER_MOTD		0x13
	#define YSM_SET_PRIVACY_FLAGS	0x14
	#define YSM_SERVER_KNOWN_URLS	0x15
	#define YSM_SERVER_NOT_OPER	0x16
	#define YSM_ICQ_CLIENT_NOTICE	0x17
	#define YSM_ACK_ICQ_CLIENT	0x18


#define YSM_LOCATION_SRVC_SNAC	0x02
#define YSM_BUDDY_LIST_SNAC	0x03
	#define YSM_CLI_SRV_ERRMESG	0x01
	#define YSM_CLI_REQ_RIGHTSINF	0x02
	#define YSM_SRV_RIGHTS_INFO	0x03
	#define YSM_CLI_ADD_BUDDY	0x04
	#define YSM_CLI_REMOVE_BUDDY	0x05
	#define YSM_CLI_WATCHER_QUERY	0x06
	#define YSM_SRV_WATCHER_RESP	0x07
	#define YSM_CLI_WATCHER_SUBREQ	0x08
	#define YSM_SRV_WATCHER_NOTICE	0x09
	#define YSM_SRV_REJECT_NOTICE	0x0a
	#define YSM_SRV_ONCOMING_BUD	0x0b
	#define YSM_SRV_OFFGOING_BUD	0x0c

#define YSM_MESSAGING_SNAC	0x04
	#define YSM_CLI_SRV_ERRORMSG	0x01
	#define YSM_ADD_ICBM_PARAM	0x02
	#define YSM_REMOVE_ICBM_PARAM	0x03
	#define YSM_REQUEST_PARAM_INFO	0x04
	#define YSM_PARAMETER_INFO	0x05
	#define YSM_MESSAGE_FROM_CLIENT	0x06
	#define YSM_MESSAGE_TO_CLIENT	0x07
	#define YSM_EVIL_REQUEST	0x08
	#define YSM_EVIL_REQ_REPLY	0x09
	#define YSM_SRV_MISSED_CALLS	0x0a
	#define YSM_CLIENT_ERROR	0x0b
	#define YSM_HOST_ACK		0x0c

#define YSM_ICQV8FUNC_SNAC	0x13
	#define YSM_CLI_REQ_ROSTER	0x05
	#define YSM_SRV_SEND_ROSTER	0x06
	#define YSM_SRV_CHANGE_ACK	0x0e
	#define	YSM_SRV_ROSTER_OK	0x0f

/* 	These are some extra definitions for uploading
	the contacts to the servers.	*/

	#define YSM_SRV_BUDDY_AUTH	0x0e
	#define YSM_SRV_BUDDY_NOAUTH	0x00
	#define YSM_SRV_BUDDY_ERRADD	0x0a


#define YSM_MULTIUSE_SNAC	0x15
	#define YSM_CLI_SEND_REQ	0x02
	#define YSM_SRV_SEND_RESP	0x03

#define YSM_REGISTRATION_SNAC	0x17
	#define YSM_CLI_SEND_REG	0x04
	#define YSM_SRV_REPLY_REG	0x05

#define YSM_ADVERTISEMENT_SNAC	0x05
#define YSM_INVITATION_C2C_SNAC	0x06
#define YSM_ADMINISTRATIVE_SNAC	0x07
#define YSM_POPUP_NOTICES_SNAC	0x08
#define YSM_BOS_SPECIFIC_SNAC	0x09
#define YSM_USER_LOOKUP_SNAC	0x0a
#define YSM_STATS_SNAC		0x0b
#define YSM_TRANSLATE_SNAC	0x0c
#define YSM_CHAT_NAVIGAT_SNAC	0x0d
#define YSM_CHAT_SNAC		0x0e
#define YSM_UNKNOWN_SNAC	0x45

/* Definicion de los Message TYPES */

#define YSM_TEXTMESSAGE	0x01
#define	YSM_CHATMESSAGE	0x02
#define YSM_FILEMESSAGE	0x03
#define YSM_URLMESSAGE	0x04
#define YSM_AUTHREQMSG	0x06
#define YSM_AUTHDENIEDMSG 0x07
#define YSM_AUTHGIVENMSG  0x08
#define YSM_ADDEDBYUSERMSG 0x0C
#define YSM_EMAILEXPRESSMSG 0x0E
#define YSM_INCOMINGCONTACTSMSG 0x13
#define YSM_CONTACTREQUESTMSG 0x1A
#define YSM_AUTOMESSAGEREQ 0xE?

#endif
