/*
-======================== You Sick Me v7 ===========================-

                                   |                                           
           - ----------------------                                          
    _      |                       |             _________________/_     _    
   _\____________   ______         _ __________  |               /             
     \           | _)    /                     \ |              /              
      \          |_\_  _/_______________/_      \|            _/               
                 |) /______________    /         \            |pix.imp         
                   /   \         )/___/         \  /          |                
  _    _\______   /    /__  ____/       - -------\/___________|               
         ` |  /__/        \/                                                   
           |          _      _           _                  __ ________ _      
           |                  )) y( O u  (s(i  C k    m.( E))                  
           |                                                                  
          -- ---------------- ---- -----                                     
                                  |                                            
                                  |                                            
-========================== YSM_Crypt.c ============================-

YSM (YouSickMe) ICQ Client. An Original Multi-Platform ICQ client.
Copyright (C) 2002 rad2k Argentina.

YSM is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

For Contact information read the AUTHORS file.

*/

#include "YSM.h"
#include "YSM_Crypt.h"

int
YSM_EncryptData( char *plain_data, int len, keyInstance *cipherKey)
{
struct	YSMCryptH C_head;
cipherInstance cipher;

	/* This will identify the incoming message as a crypted YSM message */
	C_head.id[0] = 0xde;
	C_head.id[1] = 0xaf;
	C_head.d_len = len;

	memcpy( &plain_data[0], &C_head, sizeof(C_head) );

	if(cipherKey == NULL) return -1;

	if (TRUE != cipherInit(&cipher, MODE_CBC, NULL)) {
		PRINTF(YSM_VERBOSE_BASE,"Cypher error: initializing!\n");
		return 0;
	}
	
	padEncrypt(&cipher, cipherKey, &plain_data[sizeof C_head], len, &plain_data[sizeof C_head]);

	return 1;
}

int
YSM_DecryptData( char *enc_data, keyInstance *cipherKey )
{
struct	YSMCryptH C_head;
cipherInstance cipher;


	memcpy( &C_head, &enc_data[0], sizeof(C_head) );

	if(C_head.id[0] != 0xde || C_head.id[1] != 0xaf) return 0;

	if(cipherKey == NULL) return -1;

	if (TRUE != cipherInit(&cipher, MODE_CBC, NULL)) {
		PRINTF(YSM_VERBOSE_BASE,"Cypher error!!!!\n");
		return -1;
	}
	
	padDecrypt(&cipher, cipherKey, &enc_data[sizeof C_head], C_head.d_len+16 - C_head.d_len%16, &enc_data[sizeof C_head]);
	enc_data[sizeof C_head+C_head.d_len]=0;

	return 1;
}
