/*
   cfft2.c
   FFT with strides.

   $Id$
 */

/*
 *     extension to swarztrauber fft routines to allow for
 *     multidimensional ffts
 *
 *     call cfft2(idir, c, istd, n, n2, ws)
 *
 *     idir    1 for forward transform (cfftf),
 *            -1 for backward transform (cfftb)
 *     c      the complex array to be transformed (in place)
 *     istd   the stride of the dimension of c to be transformed
 *            istd=1 means the first dimension of c is to be transformed,
 *            istd=len1 where len1 is the length of the first dimension
 *                      means to transform the second dimension
 *            istd=len1*len2 transforms the third dimension, and so on
 *     n      the length of the dimension to be transformed
 *     n2     the product of all dimension lengths after the dimension
 *            to be transformed -- the transform of length n will be
 *            repeated a total of istd*n2 times
 *     ws     the working array filled by cffti
 *            if istd=1, only 4*n+15 elements of storage will be used,
 *            as for cfftf or cfftb
 *            if istd>1, ws needs to have 6*n+15 elements of storage
 *            (as a working array for the dimension being transformed)
 */


extern void cfft2(long idir, double c[], long istd, long n, long n2,
		  double ws[]);

extern void cfftb1 (long n,double c[],double ch[],double wa[],long ifac[]);
extern void cfftf1 (long n,double c[],double ch[],double wa[],long ifac[]);



void cfft2(long idir, double c[], long istd, long n, long n2, double ws[])
{
  long j, i0, iw3, iw2, iw1, jw, nistd;

  if (n == 1) return;
  iw1 = n+n;
  iw2 = iw1+n+n;
  iw3 = iw2+15;
  istd *= 2;
  nistd = istd*n;
  for (; (n2--)>0 ; c+=nistd) {
    if (istd > 1) {
      for (i0=0 ; i0<istd ; i0+=2) {
        for (j=jw=0 ; j<nistd ; j+=istd,jw+=2) {
          ws[iw3+jw] = c[i0+j];
          ws[iw3+1+jw] = c[1+i0+j];
        }
        if (idir >= 0)
          cfftf1 (n,&ws[iw3],ws,&ws[iw1],(long *)&ws[iw2]);
        else
          cfftb1 (n,&ws[iw3],ws,&ws[iw1],(long *)&ws[iw2]);
        for (j=jw=0 ; j<nistd ; j+=istd,jw+=2) {
          c[i0+j] = ws[iw3+jw];
          c[1+i0+j] = ws[iw3+1+jw];
        }
      }
    } else {
      if (idir >= 0)
        cfftf1 (n,c,ws,&ws[iw1],(long *)&ws[iw2]);
      else
        cfftb1 (n,c,ws,&ws[iw1],(long *)&ws[iw2]);
    }
  }
  return;
}
