/******************************************************************************\
 * $Id: rcfileParser.h,v 1.1.1.1 2000/09/15 02:20:11 blais Exp $
 * $Date: 2000/09/15 02:20:11 $
 *
 * Copyright (C) 1999, 2000  Martin Blais <blais@iro.umontreal.ca>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *****************************************************************************/

#ifndef INCL_XXDIFF_RCFILEPARSER
#define INCL_XXDIFF_RCFILEPARSER

#ifdef XX_USE_RCFILE


/*==============================================================================
 * EXTERNAL DECLARATIONS
 *============================================================================*/

#ifndef INCL_XXDIFF_RESOURCES
#include <resources.h>
#endif

#ifndef INCL_XXDIFF_DEFS
#include <defs.h>
#endif

#ifndef INCL_STD_STRING
#include <string>
#define INCL_STD_STRING
#endif

#ifndef INCL_STD_MAP
#include <map>
#define INCL_STD_MAP
#endif


XX_NAMESPACE_BEGIN


/*==============================================================================
 * CLASS XxRcfileParser
 *============================================================================*/

// <summary> resource parser for rcfile </summary>

class XxRcfileParser : public XxResourcesParser {

public:

   /*----- member functions -----*/

   // Constructor.
   XxRcfileParser();

   // Destructor.
   virtual ~XxRcfileParser();

   // Query the database for the named resource.  Returns false is not present.
   // Otherwise return true and fills in the value string.
   virtual bool query( 
      XxResources::Resource resource,
      const char*           name,
      std::string&          value
   );

   // Adds a resource that has just been parsed.  Don't call this, this is used
   // by the lex/yacc parser.
   void addResource(
      const std::string& name,
      const std::string& content
   );

   // Adds text to the current resource being parsed.  Don't call this, this is
   // used by the lex/yacc parser.
   // <group>
   void clearValueText();
   void addValueText(
      const std::string& text
   );
   std::string& getValueText();
   // </group>

private:

   /*----- member functions -----*/

   // Run the generated parser.
   void parse( std::istream& input );

   // Push/pop the parser stack.
   // <group>
   void push();
   void pop();
   // </group>

   /*----- types and enumerations -----*/

   typedef std::map< std::string, ResValue, Rltstr > ResourceMap;

   /*----- data members -----*/

   ResourceMap 	_resources;
   std::string	_valueText;
};


XX_NAMESPACE_END

#endif

#endif
