/* need to parse removing the beginnig and end of a line, the reste we ekep */
%{
#define YYSTYPE std::string

#include <rcfileParser.y.h>

%}
WS          [ \t\r]+
QUO         ["]
QQUO        "\\\""
EOLCHAR     "\n"
COMMENT     "#"[^\n]*"\n"
LETTER      [a-zA-Z]
DIGIT       [0-9]
SYMBOL	    [_\-+/\.\*\&\%\>\<]
%option stack

%%
{QUO}({LETTER}|{SYMBOL}|{DIGIT}|{QQUO}|{WS}|:)*{QUO}	{ *yylval = yytext; return SWORD; }
({LETTER}|{SYMBOL}|{DIGIT}|{QQUO})*			{ *yylval = yytext; return WORD; }
":"				return SC;
{EOLCHAR}                       { yylineno++; return ENDOFLINE; }
{COMMENT}                       { yylineno++; } break;
{WS}				break;
%%
