/******************************************************************************\
 * $Id: builderDirs2Sep.cpp,v 1.1.1.1 2000/09/15 02:20:12 blais Exp $
 * $Date: 2000/09/15 02:20:12 $
 *
 * Copyright (C) 1999, 2000  Martin Blais <blais@iro.umontreal.ca>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *****************************************************************************/

/*==============================================================================
 * EXTERNAL DECLARATIONS
 *============================================================================*/

#include <builderDirs2Sep.h>
#include <exceptions.h>
#include <diffs.h>
#include <buffer.h>
#include <main.h>
#include <util.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sstream>
#include <unistd.h>
#include <iostream>
#include <sys/types.h>
#include <errno.h>

#undef XX_TRACE
#define XX_TRACE(x) 

XX_NAMESPACE_BEGIN

/*==============================================================================
 * PUBLIC FUNCTIONS
 *============================================================================*/

/*==============================================================================
 * CLASS XxBuilderDirs2Sep
 *============================================================================*/

//------------------------------------------------------------------------------
//
XxBuilderDirs2Sep::XxBuilderDirs2Sep() :
   XxBuilder()
{}

//------------------------------------------------------------------------------
//
XxBuilderDirs2Sep::~XxBuilderDirs2Sep()
{}

//------------------------------------------------------------------------------
//
std::auto_ptr<XxDiffs> XxBuilderDirs2Sep::process( 
   const char*     command,
   const XxBuffer* buffer1,
   const XxBuffer* buffer2
)
{
   std::ostringstream errors;

   int curHunk = 0;

   const XxBuffer* buffer[2];
   buffer[0] = buffer1;
   buffer[1] = buffer2;
   int fline[2];
   int nbLines[2];
   const char* text[2];
   uint len;
   for ( int no = 0; no < 2; ++no ) {
      fline[no] = 1;
      nbLines[no] = buffer[no]->getNbLines();
      text[no] = buffer[no]->getTextLine( fline[no], len );
   }

   XxLine::Type prevtype = XxLine::DIFFDEL_3;
   XxLine::Type type = XxLine::DIFFDEL_3;
   while ( fline[0] <= nbLines[0] || fline[1] <= nbLines[1] ) {

      XX_TRACE( "Comparing: " << text[0] << " and " << text[1] );
      int cmp;
      if ( fline[0] > nbLines[0] ) {
         cmp = +1;
      }
      else if ( fline[1] > nbLines[1] ) {
         cmp = -1;
      }
      else {
         cmp = strcmp( text[0], text[1] );
      }

      XxLine line( XxLine::SAME, 171717, 171717 ); // default const.
      if ( cmp == 0 ) {
         std::ostringstream oss;
         oss << command << " "
             << buffer[0]->getName() << "/" << text[0] 
             << " "
             << buffer[1]->getName() << "/" << text[1] 
//             << " > /dev/null" 
             << std::ends;
         XX_TRACE( oss.str() );
         // FIXME might need some / processing here.
         int wpidstat = XxUtil::interruptibleSystem( oss.str().c_str() );
         int status = WEXITSTATUS(wpidstat);
         XX_TRACE( "Status = " << status );
         if ( status == 0 ) {
            type = XxLine::SAME;
            line = XxLine( type, fline[0], fline[1] );
         }
         else if ( status == 1 ) {
            type = XxLine::DIFF_ALL;
            line = XxLine( type, fline[0], fline[1] );
         }
         else {
            errors << "Error diffing file " << text[0] << std::endl;

            // Fallback on something.
            type = XxLine::DIFF_ALL;
            line = XxLine( type, fline[0], fline[1] );
         }

         // FIXME compare actual files here.
         // set diff = true if the files are actually different.

         // Get next lines.
         for ( int no = 0; no < 2; ++no ) {
            ++fline[no];
            if ( fline[no] <= nbLines[no] ) {
               text[no] = buffer[no]->getTextLine( fline[no], len );
            }
         }
      }
      else {
         int no;
         if ( cmp < 0 ) {
            type = XxLine::INSERT_1;
            line = XxLine( type, fline[0], -1 );
            no = 0;
         }
         else {
            type = XxLine::INSERT_2;
            line = XxLine( type, -1, fline[1] );
            no = 1;
         }

         ++fline[no];
         if ( fline[no] <= nbLines[no] ) {
            text[no] = buffer[no]->getTextLine( fline[no], len );
         }
      }
         
      if ( type != prevtype ) {
         ++curHunk;
      }
      line.setHunkId( curHunk );
      XX_TRACE( "AddLine: " << line );
      _lines.push_back( line );

      prevtype = type;

   }

   XX_ASSERT( fline[0] > nbLines[0] );
   XX_ASSERT( fline[1] > nbLines[1] );

   // Save error text.
   _errors = errors.str();
   XX_TRACE( "Errors" << _errors );

   _status = _errors.empty();

   std::auto_ptr<XxDiffs> ap( new XxDiffs( _lines ) );
   XX_TRACE( ap->getNbLines() );
   return ap;
}

XX_NAMESPACE_END
