/*
 * Set control strings to change the attributes of xterm windows.
 * This was is for X10, and the kitchen-sink xterm, but it's been
 * scaled down for X11 R4.
 *
 * John Sellens
 * Math Faculty Computing Facility
 * University of Waterloo
 * jmsellens@watmath.waterloo.edu
 */

#define X11

#include <stdio.h>

#define	private	static
#define	CPNULL	((char *)NULL)
#define TITLE	(-1)	/* nargs value for title lines for help */


typedef struct command {
    char	*flag;
    int		nargs;
    char	*format;
    char	*descrip;
} command;

private	command	comlist[] = {
{ "Window Attributes",	TITLE, CPNULL, CPNULL },
#ifdef X10
    { "-name",	1,	"\033]0;%s\007",	"Change window name" },
#endif
#ifdef X11
    { "-name",	1,	"\033]0;%s\007",	"Change title and icon name" },
    { "-icon",	1,	"\033]1;%s\007",	"Change icon name" },
    { "-title",	1,	"\033]2;%s\007",	"Change window title" },
    { "-display",0,	"\033]51;\007",	"echo DISPLAY as keyboard input" },
    { "-displayfile",1,	"\033]51;%s\007",	"Write DISPLAY name to file" },
    { "-hostname",0,	"\033]52;\007",	"echo hostname as keyboard input" },
    { "-hostnamefile",1,"\033]52;%s\007",	"Write hostname to file" },
#endif
    { "-logfile",1,	"\033]46;%s\007",	"Change log file name" },
    { "-scinv",	0,	"\033[?5h",		"Use inverse video" },
    { "-noscinv",0,	"\033[?5l",		"Don't use inverse video" },
    { "-scalt",	0,	"\033[?47h",		"Use alternate screen" },
    { "-noscalt",0,	"\033[?47l",		"Use normal screen" },
#ifdef X10
{ "Status Lines",	TITLE, CPNULL, CPNULL },
    { "-slinv",	0,	"\033[?48h",		"Inverse video status line" },
    { "-noslinv",0,	"\033[?48l",		"Normal video status line" },
    { "-slerase",0,	"\033[?E",		"Erase status line" },
    { "-slreturn",0,	"\033[?F",		"Return from status line" },
    { "-slhide",0,	"\033[?H",		"Hide status line" },
    { "-slshow",0,	"\033[?S",		"Show status line" },
    { "-slcol",	1,	"\033[?%sT",		"Go to status line column" },
#endif
{ "Scrolling and Scroll Bars",	TITLE, CPNULL, CPNULL },
    { "-jump",	0,	"\033[?4l",		"Jump scroll" },
    { "-ooze",	0,	"\033[?4h",		"Slow scroll" },
#ifdef X10
    { "-save",	0,	"\033[?43h",		"Save lines off top" },
    { "-nosave",0,	"\033[?43l",		"Don't save lines off top" },
    { "-scroll",0,	"\033[?42h",		"Show Scrollbar" },
    { "-noscroll",0,	"\033[?42l",		"Hide Scrollbar" },
    { "-page",	0,	"\033[?49l",		"Page scroll mode" },
    { "-nopage",0,	"\033[?49h",		"No Page scroll (normal) mode"},
#endif
{ "Character Attributes",	TITLE, CPNULL, CPNULL },
    { "-normal",0,	"\033[0m",		"Normal characters" },
    { "-blink",	0,	"\033[1m",		"Blink (bold) characters" },
    { "-ul",	0,	"\033[4m",		"Underlined characters" },
    { "-bold",	0,	"\033[5m",		"Bold characters" },
    { "-inv",	0,	"\033[7m",		"Inverse video characters" },
#ifdef X10
{ "Size & Shape",	TITLE, CPNULL, CPNULL },
    { "-move",	2,	"\033[3;%s;%st",	"Move window (x y)" },
    { "-raise",	0,	"\033[5t",		"Raise window" },
    { "-lower",	0,	"\033[6t",		"Lower window" },
    { "-redraw",0,	"\033[7t",		"Redraw window" },
    { "-resize",2,	"\033[8;%s;%st",	"Resize window (rows cols)"},
    { "-resizep",2,	"\033[4;%s;%st",	"Resize window (w h pixels)"},
#endif
{ "Miscellaneous",	TITLE, CPNULL, CPNULL },
    { "-verb",	1,	"%s",			"Copy arg to window" },
#ifdef X10
    { "-font",	1,	"\033]47;%s\033",	"Change normal font" },
    { "-fontb",	1,	"\033]48;%s\033",	"Change bold font" },
#endif
#ifdef X11
    { "-font",	1,	"\033]50;%s\007",	"Change normal font" },
    { "-fontb",	1,	"\033]50;;%s\007",	"Change bold font" },
    { "-fonts",	2,	"\033]50;%s;%s\007",	"Change normal & bold fonts" },
#endif

    { CPNULL,	0,	CPNULL,			CPNULL }
};


private	char	*progname;
private	char	**argv;
private	int	argc;
private	int	arg;
private	char	*flag;


main( real_argc, real_argv )
int real_argc;
char *real_argv[];
{
    progname = real_argv[0];
    argc = real_argc;
    argv = real_argv;
    doit();
    exit( 0 );
}

char *
nextarg()
{
    if ( ++arg >= argc )
	usage("Missing argument(s) for '%s' flag", flag );
    return( argv[arg] );
}


doit()
{
    int i;
    char *arg1;
    if ( argc == 1 )
	usage( "at least one argument required" );
    for ( arg=1; arg<argc; arg++ ) {
	if ( strcmp( argv[arg], "-help" ) == 0 )
	    help();
	else {
	    for ( i=0; comlist[i].flag!=CPNULL; i++ ) {
		if ( comlist[i].nargs != TITLE &&
		    strcmp( argv[arg], comlist[i].flag ) == 0 ) {
		    flag = comlist[i].flag; /* so nextarg() can complain */
		    switch ( comlist[i].nargs ) {
			case 0:
			    printf( comlist[i].format );
			    break;
			case 1:
			    printf( comlist[i].format, nextarg() );
			    break;
			case 2:
			    /* order of evaluation not guaranteed in arg
			       lists, so ... */
			    arg1 = nextarg();
			    printf( comlist[i].format, arg1, nextarg() );
			    break;
			default:
			    fatal( "Internal error - can't handle %d args",
				comlist[i].nargs );
		    }
		    break;	/* go on to next argument */
		}
	    }
	    if ( comlist[i].flag == CPNULL )
		usage("Unknown argument: '%s'",argv[arg]);
	}
    }
}




help()
{
    int i;
    printf( "  Flag          #args  Description\n" );
    for ( i=0; comlist[i].flag!=CPNULL; i++ )
	if ( comlist[i].nargs == TITLE )
	    printf( "%s\n", comlist[i].flag );
	else
	    printf( "  %-14s%-7d%s\n", comlist[i].flag, comlist[i].nargs,
		comlist[i].descrip );
}




/* VARARGS1 */
usage( a, b, c, d, e, f )
char *a;
{
    error( a, b, c, d, e, f );
    error( "Use '-help' flag to get usage message" );
    exit( 1 );
}
    


/* VARARGS1 */
error( a, b, c, d, e, f )
char *a;
{
    fprintf( stderr, "%s: ", progname );
    fprintf( stderr, a, b, c, d, e, f );
    fputc( '\n', stderr );
}

/* VARARGS1 */
fatal( a, b, c, d, e, f )
char *a;
{
    error( a, b, c, d, e, f );
    exit( 1 );
}
