.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
flipflop - draws a grid of 3D squares that change positions
.SH SYNOPSIS
.B flipflop
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-count \fInumber\fP | \-free \fInumber\fP]
[\-size \fInumber\fP]
[\-size-x \fInumber\fP]
[\-size-y \fInumber\fP]
[\-spin \fInumber\fP]
[\-mode sticks | tiles]
[\-delay \fInumber\fP]
[\-wireframe]
[\-fps]
.SH DESCRIPTION
Flipflop draws a grid of 3D colored tiles that change positions with 
each other.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-count \fInumber\fP
Number of tiles on the board. A value of "0" means "default". The
default number of tiles depends on the size of the board and the mode:
95% of total tiles for "tiles" mode and 80% of total sticks for
"sticks" mode (e.g. 76 tiles or 64 sticks for a 9x9 board). 
.TP 8
.B \-free \fInumber\fP
Number of tiles missing from the board. See -count. 
.TP 8
.B \-size \fInumber\fP
Number of tiles on each side of the board. Takes precedence over
-size-x and -size-y. Default: 9.
.TP 8
.B \-size-x \fInumber\fP
Width (in tiles) of the board. Default: 9.
.TP 8
.B \-size-y \fInumber\fP
Length (in tiles) of the board. Default: 9.
.TP 8
.B \-spin \fInumber\fP
Angular velocity for the rotation of the board. 
.TP 8
.B \-mode sticks 
Draw hopping sticks instead of flipping tiles. 
.TP 8
.B \-mode tiles 
Draw flipping tiles. This is the default. 
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 20000 (0.02 seconds.).
.TP 8
.B \-fps | \-no-fps
Whether to show a frames-per-second display at the bottom of the screen.
.TP 8
.B \-wireframe
Only draw outlines.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2003 by Kevin Ogden.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Kevin Ogden <kogden1@hotmail.com>. Some additional code by Sergio
Gutierrez <sergut@gmail.com>. 
