.TH t3d 1 "Version 1.1" "Time 3D"
.SH NAME
t3d \- clock using flying balls to display the time
.SH SYNOPSIS
t3d [ \f2 options\f1 ]...
.SH DESCRIPTION
.PP
Time 3D is a clock. It uses flying balls to display the time. This
balls move and wobble around to give you the impression your
graphic workstation with its many XStones is doing something.
.PP
t3d uses mouse and keyboard to let you fly through the balls. Hit
.B S
to speed up, 
.B A
to slow down,
.B Z
to zoom in and
.B X
to zoom out.
Use the
.B left mouse button
to rotate to the left and the
.B right mouse button
to rotate the view to the right. Use the
.B middle mouse button
to change the optical axis and the moving direction.
.B 0
(zero) will stop you.
.B Q
quits.
.PP
.SH OPTIONS
.TP
.BI "-move " "factor"
Modifies the direction move of t3d. The clock looks 30 degrees*
.I factor
to the left and to the right periodically.
.TP
.BI "-wobble " "factor"
Modifies the wobbling (sounds nice :-) of t3d by multiplying the
default deformation of the clock with
.I factor.
.TP
.B -minutes
Shows one small ball for every minute, instead of one for every 2.5 minutes.
.TP
.BI "-mag " "factor"
Changes the magnification of t3d. By default, t3d draws a 200x200 image.
A .I factor
of 2 means, it will use a 400x400 image.
.TP
.BI "-cycle " "period"
Sets the moving cycle to
.I period
seconds. By default, this value is 10 seconds.
.TP
.BI "-wait " "microsec"
Inserts a wait after drawing one view of the clock. By default, t3d waits
40 ms after each drawing. This helps you to keep the performance loss
small.
.TP
.BI "-fast " "precalc_radius"
t3d uses bitmap copy to draw precalculated balls. You can specify the radius
in pixels up to which t3d should precalculate balls. t3d will set a useful
range by itself using the magnification when it is started.
.TP
.B -colcycle
Draws cyclic the color scale used for the balls in the background instead
of the normal black.
.TP
.BI "-rgb " "red green blue"
Selects the color in RGB color space of the lightning spot on the balls.
All the other colors used for balls or
.B -colcycle
are less intensive colors of the same hue and saturation. All values
in range of 0 to 1.
.TP
.BI "-hsv " "hue saturation value"
Selects the color in HSV color space.
.I hue
is in degrees from 0 to 360, all other values in range from 0 to 1. It gives
nice but rather unpredictable results, if you use a saturation of e.g. 2.
Try it at your own risk.
.TP
.BI "-hsvcycle " "speed"
Rotates the hue axis every 10 seconds*
.I speed.
.TP
.B -help
Prints a short usage message.

.PP
.SH AUTHOR
.PP
Bernd Paysan

Email: bernd.paysan@gmx.de

Hacked on by jwz@jwz.org for xscreensaver.

.SH ACKNOWLEDGEMENT
.PP
Acknowledgement to Georg Acher, who wrote the initial program displaying
balls.

.SH COPYING
.PP
Copy, modify, and distribute T3D either under GPL version 2 or newer, or
under the standard MIT/X license notice.

.SH DISCLAIMER
.PP
T3D is not related to T3D(tm), the massive parallel Alpha--based
supercomputer from Cray Research. T3D's name was invented in 1991,
years before the project at Cray Research started. There is no
relation from T3D to Cray's T3D, even the balls surrounding T3D on
some posters weren't an inspiration for T3D. I don't know anything
about the other way round.

The programming style of T3D isn't intented as example of good style,
but as example of how a fast prototyped demo may look like. T3D wasn't
created to be useful, it was created to be nice.

.SH KNOWN BUGS
.PP
There are no known bugs in T3D. Maybe there are bugs in X. Slight
changes in the T3D sources are known to show these bugs, e.g. if
you remove the (int) casting at the XFillArc x,y,w,h-coordinates...
