/*
 *  XScrabble - X version of the popular board game, for 1 to 4 players.
 *
 * This software comes with NO warranty whatsoever. I therefore take no
 * responsibility for any damages, losses or problems caused through use
 * or misuse of this program.
 *
 * I hereby grant permission for this program to be freely copied and
 * distributed by any means, provided no charge is made for it.
 *
 * Matthew Chapman, csuoq@csv.warwick.ac.uk
 *    Apr 1995.
 */

/* xutils.c - reuseable X functions */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <X11/Xaw/Simple.h>
#include <X11/xpm.h>
#include <stdio.h>

#include "xutils.h"

void load_file_pixmap(char *fname, Pixmap *xpm,Widget top)
{
    /* returns a Pixmap, loaded from the given filename, relative to the
       display of the given Widget. The closest colours are used. Exit
       is called given an error */

    int status;
    XpmAttributes attr;
    Pixmap mask;

    attr.valuemask = XpmReturnPixels | XpmCloseness;
    attr.closeness = CLOSENESS;

    status = XpmReadFileToPixmap(XtDisplay(top),
				 DefaultRootWindow(XtDisplay(top)),fname,xpm,
				 &mask,&attr);

    if (status != XpmSuccess)
	{
	    fprintf(stderr,"Pixmap error: %s\n",XpmGetErrorString(status));
	    if (status == XpmOpenFailed)
		fprintf(stderr,"Couldn't open file %s.\n",fname);
	    exit(1);
	}
}

void load_data_pixmap(char **dname, Pixmap *xpm,Widget top)
{
    /* returns a Pixmap, loaded from the given data, relative to the
       display of the given Widget. The closest colours are used. Exit
       is called given an error */

    int status;
    XpmAttributes attr;
    Pixmap mask;

    attr.valuemask = XpmReturnPixels | XpmCloseness;
    attr.closeness = CLOSENESS;
    status = XpmCreatePixmapFromData(XtDisplay(top),
				     DefaultRootWindow(XtDisplay(top)),dname,xpm,&mask,&attr);
    if (status != XpmSuccess)
	{	  
	    fprintf(stderr,"Pixmap error: %s\n",XpmGetErrorString(status));
	    exit(1);
	}
}

void set_icon_pixmap(char **dname,Widget top)
{
    /* sets the icon of the top level Widget to the Pixmap in the given
        filename. Exit is called given an error */
    Pixmap icon_pixmap;
    
    load_data_pixmap(dname,&icon_pixmap,top);
    XtVaSetValues(top,XtNiconPixmap,icon_pixmap, NULL);
}


extern void Quit();

void acceptQuitPre(Widget top)
{
    /* perform quit action on delete window signal - before XtRealizeWidget.
       Calls a function called Quit */

    XtActionsRec Actions[] = { {"quit",Quit } };
	
    XtAppAddActions(XtWidgetToApplicationContext(top),Actions,
		    XtNumber(Actions));
    XtOverrideTranslations(top,
			   XtParseTranslationTable("<Message>WM_PROTOCOLS: quit()\n"));
}

void acceptQuitPost(Widget top)
{
    /* perform quit action on delete window signal - after XtRealizeWidget */

    Atom wm_delete_window = XInternAtom(XtDisplay(top),"WM_DELETE_WINDOW",False);
    XSetWMProtocols(XtDisplay(top),XtWindow(top),&wm_delete_window,1);
}


void fit_on_screen(Widget top,Position *x,Position *y, int w, int h,
		   int horizB,int vertB)
{
    /* scales x and y to fit (w by h) window on screen, allowing for 
       borders of size horizB by vertB */

    Display *dpy = XtDisplay(top);
    int width=DisplayWidth(dpy,DefaultScreen(dpy));
    int height=DisplayHeight(dpy,DefaultScreen(dpy));

    if (*x>width-w-horizB)
	*x=width-w-horizB;
    if (*y>height-h-vertB)
	*y=height-h-vertB;
}

void SetBusy(Widget top)
{
    /* change the cursour to a busy symbol */
    XDefineCursor(XtDisplay(top),XtWindow(top),
		  XCreateFontCursor(XtDisplay(top),XC_watch));
    XFlush(XtDisplay(top));
}


void ClearBusy(Widget top)
{
    /* clear the busywait cursour back to normal */
    XDefineCursor(XtDisplay(top),XtWindow(top),
		  XCreateFontCursor(XtDisplay(top),XC_left_ptr));
    XFlush(XtDisplay(top));
}

