/*
 *  XScrabble - X version of the popular board game, for 1 to 4 players.
 *
 * This software comes with NO warranty whatsoever. I therefore take no
 * responsibility for any damages, losses or problems caused through use
 * or misuse of this program.
 *
 * I hereby grant permission for this program to be freely copied and
 * distributed by any means, provided no charge is made for it.
 *
 * Matthew Chapman, csuoq@csv.warwick.ac.uk
 *    Oct 1994.
 */

/* popup.c - functions for creating and managing the popups */

#include "scrab.h"
#include "globals.h"

extern char app_def_file[256];

/*********************************
 * Letter Scores and Frequencies *
 *********************************/

void LettValuesPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;lvdismiss[dnum]!=w; dnum++)
		;
	XtUnmapWidget(lvtop[dnum]);

	XtVaSetValues(menu_item[dnum][LETTVAL],XtNleftBitmap,None,NULL);
	menu_status[dnum][LETTVAL]= !menu_status[dnum][LETTVAL];
}

void CreateLettValuesPopup(int dnum)
{
	Widget lvform,lvmain,lvtitle;
        char lvlabel[1024], lvstr[1024], formatstr[80];
        int i,d;

	lvtop[dnum] = XtVaAppCreateShell("lvtop",app_def_file,
		applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
	lvform = XtVaCreateManagedWidget("lvform",formWidgetClass,lvtop[dnum],
		NULL);
	lvtitle = XtVaCreateManagedWidget("lvtitle",labelWidgetClass,lvform,
		NULL);
	lvmain = XtVaCreateManagedWidget("lvmain",labelWidgetClass,lvform,NULL);
	strcpy(lvlabel,"\n");
        strcat(lvlabel,PROMPT[LABLVMAIN]);
        strcat(lvlabel,"\n\n");

        d=(NUMLETTERS+1)/2;
        for (i=1 ; i<=d; i++)
	{
           sprintf(lvstr,"   %c     %2d   %2d          %c     %2d   %2d   \n",
              letterchar[i], letterscore[letterchar[i]], freq[letterchar[i]],
              letterchar[i+d], letterscore[letterchar[i+d]], freq[letterchar[i+d]]);
           strcat(lvlabel, lvstr);
	}
        
        sprintf(formatstr, "%s%d%s", "\n%s%", 26-strlen(PROMPT[LABJOKER]),
                "s%c     %2d   %2d\n\n");
        sprintf(lvstr, formatstr, PROMPT[LABJOKER], "",
            letterchar[0], letterscore[letterchar[0]], 
            freq[letterchar[0]]);
        strcat(lvlabel,lvstr);

        XtVaSetValues(lvmain,XtNlabel,&lvlabel,NULL);

	lvdismiss[dnum] = XtVaCreateManagedWidget("lvdismiss",commandWidgetClass,
		lvform,NULL);
	bg_pixmap(lvform);
	XtRealizeWidget(lvtop[dnum]);
	XtAddCallback(lvdismiss[dnum],XtNcallback,LettValuesPopdown,lvtop[dnum]);
}

void LettValuesPopup(int dnum)
{
	if (menu_status[dnum][LETTVAL]==False)
		/* popup is already up */
		XtUnmapWidget(lvtop[dnum]);
	else
		XtMapWidget(lvtop[dnum]);
}


/*******************
 * Rules Popup *
 *******************/

void RulesPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;rulesdismiss[dnum]!=w; dnum++) ;
	XtUnmapWidget(rulestop[dnum]);

	XtVaSetValues(menu_item[dnum][RULES],XtNleftBitmap,None,NULL);
	menu_status[dnum][RULES]= !menu_status[dnum][RULES];
}

void CreateRulesPopup(int dnum)
{
    Widget rulesform,rulestitle;

    rulestop[dnum] = XtVaAppCreateShell("rulesshell",app_def_file,
	applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
    rulesform = XtVaCreateManagedWidget("rulesform",formWidgetClass,
	rulestop[dnum],NULL);
    rulestitle = XtVaCreateManagedWidget("rulestitle",labelWidgetClass,
						rulesform,NULL);
    rulesmain[dnum] = XtVaCreateManagedWidget("rulesmain",asciiTextWidgetClass,
                rulesform,NULL);
    rulesdismiss[dnum] = XtVaCreateManagedWidget("rulesdismiss",
           commandWidgetClass, rulesform,NULL);
    XtVaSetValues(rulesmain[dnum], 
           XtNscrollVertical, XawtextScrollWhenNeeded, NULL);

    bg_pixmap(rulesform);
    bg_pixmap(rulestitle);
    XtRealizeWidget(rulestop[dnum]);
    XtAddCallback(rulesdismiss[dnum],XtNcallback,RulesPopdown,rulestop[dnum]);
}

void RulesPopup(int dnum)
{
    if (menu_status[dnum][RULES]==False)
	    XtUnmapWidget(rulestop[dnum]);
    else
      {
      FILE *fr;
      char linestr[255];
      char *rules_str;
      int  nlength = 10;

    	fr = fopen(app_data.rulesfile,"r");
	if (fr==NULL)
	{
		fprintf(stderr,"Couldn't open the game rules file %s\n",
			app_data.rulesfile);
                return;
        }

        rules_str = malloc(8);
        *rules_str = '\0';

	while (!feof(fr))
	{
		fgets(linestr, 255, fr);
                nlength += strlen(linestr)*sizeof(char);
                rules_str = realloc(rules_str, nlength);
                strcat(rules_str, linestr);
    	}  

        fclose(fr);
            
        XtVaSetValues(rulesmain[dnum], XtNstring, rules_str, NULL);
        free(rules_str);
	XtMapWidget(rulestop[dnum]);
      }
}

/*****************
 * Showbag Popup *
 *****************/

void ShowBagUpdate(Widget w, XtPointer client_data, XtPointer call_data)
{
   char numletters[30];

   char listbag[256] = "\n", descr[12];
   int i,j, dnum;

        for (dnum=0;showbagupdate[dnum]!=w; dnum++) ;

        for (i=0; i<27; i++) numletters[i] = 0;
        for (i=0; i <= bagptr; i++)
          {
          j = bag[i] - 'A';
          if (j<0) j = 26;
          numletters[j]++;
	  }
 
        for (j=0; j <= 26; j++)
 	   {
	   sprintf(descr, "  %c %2d  ", (j==26)? '*':('A'+j), numletters[j]);
           if ((j+1)%7 == 0) strcat(descr, "\n\n");
           strcat(listbag, descr);
	   }
        sprintf(descr, "  = %d\n\n", bagptr+1);
        strcat(listbag, descr);
          
        XtVaSetValues(showbagmain[dnum], XtNstring, listbag, 
               XtNscrollVertical, XawtextScrollWhenNeeded, NULL);
}

void ShowBagPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;showbagdismiss[dnum]!=w; dnum++) ;
	XtUnmapWidget(showbagtop[dnum]);

	XtVaSetValues(helpgame_item[dnum][BAG],XtNleftBitmap,None,NULL);
	helpgame_status[dnum][BAG]= !helpgame_status[dnum][BAG];
}

void CreateShowBagPopup(int dnum)
{
    Widget showbagform, showbagtitle;

    showbagtop[dnum] = XtVaAppCreateShell("showbagshell",app_def_file,
	applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
    showbagform = XtVaCreateManagedWidget("showbagform",formWidgetClass,
	showbagtop[dnum],NULL);
    showbagtitle = XtVaCreateManagedWidget("showbagtitle",labelWidgetClass,
						showbagform,NULL);
    showbagmain[dnum] = XtVaCreateManagedWidget("showbagmain",asciiTextWidgetClass,
                showbagform,NULL);
    showbagupdate[dnum] = XtVaCreateManagedWidget("showbagupdate",
           commandWidgetClass, showbagform,NULL);
    showbagdismiss[dnum] = XtVaCreateManagedWidget("showbagdismiss",
           commandWidgetClass, showbagform,NULL);

    bg_pixmap(showbagform);
    bg_pixmap(showbagtitle);
    XtRealizeWidget(showbagtop[dnum]);
    XtAddCallback(showbagupdate[dnum],XtNcallback,
           ShowBagUpdate,showbagtop[dnum]);
    XtAddCallback(showbagdismiss[dnum],XtNcallback,
           ShowBagPopdown,showbagtop[dnum]);
}

void ShowBagPopup(int dnum)
{
    if (helpgame_status[dnum][BAG]==False)
	    XtUnmapWidget(showbagtop[dnum]);
    else
      {
      ShowBagUpdate(showbagupdate[dnum], NULL, NULL);
      XtMapWidget(showbagtop[dnum]);
      }
}

/*******************
 * Selectbag Popup *
 *******************/

void SelectBagUpdate(Widget w, XtPointer client_data, XtPointer call_data)
{
   char numletters[30];

   char listbag[256] = "\n", descr[12];
   int i,j, dnum;

        for (dnum=0;selectbagupdate[dnum]!=w; dnum++) ;

        for (i=0; i<27; i++) numletters[i] = 0;
        for (i=0; i <= bagptr; i++)
          {
          j = bag[i] - 'A';
          if (j<0) j = 26;
          numletters[j]++;
	  }
 
        for (j=0; j <= 26; j++)
 	   {
	   sprintf(descr, "  %c %2d  ", (j==26)? '*':('A'+j), numletters[j]);
           if ((j+1)%7 == 0) strcat(descr, "\n\n");
           strcat(listbag, descr);
	   }
        sprintf(descr, "  = %d\n\n", bagptr+1);
        strcat(listbag, descr);
          
        XtVaSetValues(selectbagmain[dnum], XtNstring, listbag, 
               XtNscrollVertical, XawtextScrollWhenNeeded, NULL);
}

void SelectBagPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;selectbagdismiss[dnum]!=w; dnum++) ;
	XtUnmapWidget(selectbagtop[dnum]);

	XtVaSetValues(helpgame_item[dnum][MANUAL],XtNleftBitmap,None,NULL);
	helpgame_status[dnum][MANUAL]= !helpgame_status[dnum][MANUAL];
}

void CreateSelectBagPopup(int dnum)
{
    Widget selectbagform, selectbagtitle;

    selectbagtop[dnum] = XtVaAppCreateShell("selectbagshell",app_def_file,
	applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
    selectbagform = XtVaCreateManagedWidget("selectbagform",formWidgetClass,
	selectbagtop[dnum],NULL);
    selectbagtitle = XtVaCreateManagedWidget("selectbagtitle",labelWidgetClass,
						selectbagform,NULL);
    selectbagmain[dnum] = XtVaCreateManagedWidget("selectbagmain",asciiTextWidgetClass,
                selectbagform,NULL);
    selectbagupdate[dnum] = XtVaCreateManagedWidget("selectbagupdate",
           commandWidgetClass, selectbagform,NULL);
    selectbagdismiss[dnum] = XtVaCreateManagedWidget("selectbagdismiss",
           commandWidgetClass, selectbagform,NULL);

    bg_pixmap(selectbagform);
    bg_pixmap(selectbagtitle);
    XtRealizeWidget(selectbagtop[dnum]);
    XtAddCallback(selectbagupdate[dnum],XtNcallback,
           SelectBagUpdate,selectbagtop[dnum]);
    XtAddCallback(selectbagdismiss[dnum],XtNcallback,
           SelectBagPopdown,selectbagtop[dnum]);
}

void SelectBagPopup(int dnum)
{
    if (helpgame_status[dnum][MANUAL]==False)
	    XtUnmapWidget(selectbagtop[dnum]);
    else
      {
      SelectBagUpdate(selectbagupdate[dnum], NULL, NULL);
      XtMapWidget(selectbagtop[dnum]);
      }
}

/*******************
 * Checkword Popup *
 *******************/

void CheckwordUpdate(Widget w, XtPointer client_data, XtPointer call_data)
{
        int dnum, i;
	char *word;
        char upword[256];

	for (dnum=0;checkwordupdate[dnum]!=w; dnum++) ;

        XtVaGetValues(checkwordmain[dnum], XtNstring, &word, NULL);
        
        for(i=0; i<=strlen(word) && i<255; i++) upword[i] = toupper(word[i]);
        upword[255] = '0';

        XtVaSetValues(checkwordresult[dnum], XtNlabel, 
           wordsearch(upword)? PROMPT[VALIDWORD] : PROMPT[INVALIDWORD], NULL);
}

void CheckwordReset(Widget w, XtPointer client_data, XtPointer call_data)
{
        int dnum;
	char *word;
        char newword[256];
        int i, j = 0, ret = 0;
        Widget source;

	for (dnum=0; w != XawTextGetSource(checkwordmain[dnum]); dnum++) ;
        
        XtVaGetValues(checkwordmain[dnum], XtNstring, &word, NULL);

        for(i=0; i < strlen(word) ; i++)
	  {
          if (word[i]!=' ' && word[i]!='\n' && word[i]!='\t' && word[i]!='\r')
	    {
            newword[j] = word[i];
            if (j<254) j++;
	    }
          else
            ret = 1;
	  }

        newword[j] = '\0';

        if (ret) 
           {
	   XtVaSetValues(checkwordmain[dnum], XtNstring, newword, NULL);
           CheckwordUpdate(checkwordupdate[dnum], NULL, NULL);
	   }
}

void CheckwordPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;checkworddismiss[dnum]!=w; dnum++) ;
	XtUnmapWidget(checkwordtop[dnum]);

	XtVaSetValues(helpgame_item[dnum][CHECK],XtNleftBitmap,None,NULL);
	helpgame_status[dnum][CHECK]= !helpgame_status[dnum][CHECK];
}

void CreateCheckwordPopup(int dnum)
{
    Widget checkwordform,checkwordtitle,
           checkwordprompt,checkwordnote, checkwordsource;

    checkwordtop[dnum] = XtVaAppCreateShell("checkwordshell",app_def_file,
	applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
    checkwordform = XtVaCreateManagedWidget("checkwordform",formWidgetClass,
	checkwordtop[dnum],NULL);
    checkwordtitle = XtVaCreateManagedWidget("checkwordtitle",labelWidgetClass,
						checkwordform,NULL);
    checkwordprompt = XtVaCreateManagedWidget("checkwordprompt",labelWidgetClass,
                checkwordform,NULL);
    checkwordmain[dnum] = XtVaCreateManagedWidget("checkwordmain",asciiTextWidgetClass,
                checkwordform,NULL);
    checkwordnote = XtVaCreateManagedWidget("checkwordnote",labelWidgetClass,
                checkwordform,NULL);
    checkwordresult[dnum] = XtVaCreateManagedWidget("checkwordresult",labelWidgetClass,
                checkwordform,NULL);
    checkwordupdate[dnum] = XtVaCreateManagedWidget("checkwordupdate",
           commandWidgetClass, checkwordform,NULL);
    checkworddismiss[dnum] = XtVaCreateManagedWidget("checkworddismiss",
           commandWidgetClass, checkwordform,NULL);

    XtVaSetValues(checkwordmain[dnum], 
        XtNeditType, XawtextEdit, NULL);

    bg_pixmap(checkwordform);
    bg_pixmap(checkwordtitle);
    bg_pixmap(checkwordprompt);
    bg_pixmap(checkwordnote);
    bg_pixmap(checkwordresult[dnum]);
    XtRealizeWidget(checkwordtop[dnum]);
    XtAddCallback(checkwordupdate[dnum],XtNcallback,
           CheckwordUpdate,checkwordtop[dnum]);
    XtAddCallback(checkworddismiss[dnum],XtNcallback,
           CheckwordPopdown,checkwordtop[dnum]);
    checkwordsource = XawTextGetSource (checkwordmain[dnum]);
    XtAddCallback (checkwordsource, XtNcallback, CheckwordReset, (caddr_t) NULL);
}

void CheckwordPopup(int dnum)
{
    if (helpgame_status[dnum][CHECK]==False)
	    XtUnmapWidget(checkwordtop[dnum]);
    else
            {
            XtVaSetValues(checkwordresult[dnum],XtNlabel,"", NULL);
	    XtMapWidget(checkwordtop[dnum]);
            XtSetKeyboardFocus(checkwordtop[dnum],checkwordmain[dnum]);
	    }
}


/*******************
 * Placeword Popup *
 *******************/

void PlacewordUpdate(Widget w, XtPointer client_data, XtPointer call_data)
{
}

void PlacewordPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;placeworddismiss[dnum]!=w; dnum++) ;
	XtUnmapWidget(placewordtop[dnum]);

	XtVaSetValues(helpgame_item[dnum][PLACE],XtNleftBitmap,None,NULL);
	helpgame_status[dnum][PLACE]= !helpgame_status[dnum][PLACE];
}

void CreatePlacewordPopup(int dnum)
{
    Widget placewordform,placewordmain,placewordtitle;

    placewordtop[dnum] = XtVaAppCreateShell("placewordshell",app_def_file,
	applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
    placewordform = XtVaCreateManagedWidget("placewordform",formWidgetClass,
	placewordtop[dnum],NULL);
    placewordtitle = XtVaCreateManagedWidget("placewordtitle",labelWidgetClass,
						placewordform,NULL);
    placewordmain = XtVaCreateManagedWidget("placewordmain",asciiTextWidgetClass,
                placewordform,NULL);
    placewordupdate[dnum] = XtVaCreateManagedWidget("placewordupdate",
           commandWidgetClass, placewordform,NULL);
    placeworddismiss[dnum] = XtVaCreateManagedWidget("placeworddismiss",
           commandWidgetClass, placewordform,NULL);

    XtVaSetValues(placewordmain, XtNscrollVertical, XawtextScrollWhenNeeded, NULL);

    bg_pixmap(placewordform);
    bg_pixmap(placewordtitle);
    XtRealizeWidget(placewordtop[dnum]);
    XtAddCallback(placewordupdate[dnum],XtNcallback,
           PlacewordUpdate,placewordtop[dnum]);
    XtAddCallback(placeworddismiss[dnum],XtNcallback,
           PlacewordPopdown,placewordtop[dnum]);
}

void PlacewordPopup(int dnum)
{
    if (helpgame_status[dnum][PLACE]==False)
	    XtUnmapWidget(placewordtop[dnum]);
    else
            {
            PlacewordUpdate(placewordupdate[dnum], NULL, NULL);
	    XtMapWidget(placewordtop[dnum]);
	    }
}

/******************
 * Listword Popup *
 ******************/

void ListwordUpdate(Widget w, XtPointer client_data, XtPointer call_data)
{
}

void ListwordPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;listworddismiss[dnum]!=w; dnum++) ;
	XtUnmapWidget(listwordtop[dnum]);

	XtVaSetValues(helpgame_item[dnum][LIST],XtNleftBitmap,None,NULL);
	helpgame_status[dnum][LIST]= !helpgame_status[dnum][LIST];
}

void CreateListwordPopup(int dnum)
{
    Widget listwordform,listwordmain,listwordtitle;

    listwordtop[dnum] = XtVaAppCreateShell("listwordshell",app_def_file,
	applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
    listwordform = XtVaCreateManagedWidget("listwordform",formWidgetClass,
	listwordtop[dnum],NULL);
    listwordtitle = XtVaCreateManagedWidget("listwordtitle",labelWidgetClass,
						listwordform,NULL);
    listwordmain = XtVaCreateManagedWidget("listwordmain",asciiTextWidgetClass,
                listwordform,NULL);
    listwordupdate[dnum] = XtVaCreateManagedWidget("listwordupdate",
           commandWidgetClass, listwordform,NULL);
    listworddismiss[dnum] = XtVaCreateManagedWidget("listworddismiss",
           commandWidgetClass, listwordform,NULL);

    XtVaSetValues(listwordmain, XtNscrollVertical, XawtextScrollWhenNeeded, NULL);

    bg_pixmap(listwordform);
    bg_pixmap(listwordtitle);
    XtRealizeWidget(listwordtop[dnum]);
    XtAddCallback(listwordupdate[dnum],XtNcallback,
           ListwordUpdate,listwordtop[dnum]);
    XtAddCallback(listworddismiss[dnum],XtNcallback,
           ListwordPopdown,listwordtop[dnum]);
}

void ListwordPopup(int dnum)
{
    if (helpgame_status[dnum][LIST]==False)
	    XtUnmapWidget(listwordtop[dnum]);
    else
            {
            ListwordUpdate(listwordupdate[dnum], NULL, NULL);
	    XtMapWidget(listwordtop[dnum]);
	    }
}


/********************
 * Suggestion Popup *
 ********************/

void SuggestionUpdate(Widget w, XtPointer client_data, XtPointer call_data)
{
}

void SuggestionPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;suggestiondismiss[dnum]!=w; dnum++) ;
	XtUnmapWidget(suggestiontop[dnum]);

	XtVaSetValues(helpgame_item[dnum][SUGGESTION],XtNleftBitmap,None,NULL);
	helpgame_status[dnum][SUGGESTION]= !helpgame_status[dnum][SUGGESTION];
}

void CreateSuggestionPopup(int dnum)
{
    Widget suggestionform,suggestionmain,suggestiontitle;

    suggestiontop[dnum] = XtVaAppCreateShell("suggestionshell",app_def_file,
	applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
    suggestionform = XtVaCreateManagedWidget("suggestionform",formWidgetClass,
	suggestiontop[dnum],NULL);
    suggestiontitle = XtVaCreateManagedWidget("suggestiontitle",labelWidgetClass,
						suggestionform,NULL);
    suggestionmain = XtVaCreateManagedWidget("suggestionmain",asciiTextWidgetClass,
                suggestionform,NULL);
    suggestionupdate[dnum] = XtVaCreateManagedWidget("suggestionupdate",
           commandWidgetClass, suggestionform,NULL);
    suggestiondismiss[dnum] = XtVaCreateManagedWidget("suggestiondismiss",
           commandWidgetClass, suggestionform,NULL);

    XtVaSetValues(suggestionmain, XtNscrollVertical, XawtextScrollWhenNeeded, NULL);

    bg_pixmap(suggestionform);
    bg_pixmap(suggestiontitle);
    XtRealizeWidget(suggestiontop[dnum]);
    XtAddCallback(suggestionupdate[dnum],XtNcallback,
           SuggestionUpdate,suggestiontop[dnum]);
    XtAddCallback(suggestiondismiss[dnum],XtNcallback,
           SuggestionPopdown,suggestiontop[dnum]);
}

void SuggestionPopup(int dnum)
{
    if (helpgame_status[dnum][SUGGESTION]==False)
	    XtUnmapWidget(suggestiontop[dnum]);
    else
            {
            SuggestionUpdate(suggestionupdate[dnum], NULL, NULL);
	    XtMapWidget(suggestiontop[dnum]);
	    }
}

/*******************
 * Highscore Table *
 *******************/

void HiScoresPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;hi_dismiss[dnum]!=w; dnum++)
		;
	XtUnmapWidget(hi_scoretop[dnum]);

	XtVaSetValues(menu_item[dnum][HISCORES],XtNleftBitmap,None,NULL);
	menu_status[dnum][HISCORES]= !menu_status[dnum][HISCORES];
}

void CreateHiScoresPopup(int dnum)
{
    int j;
    Widget hi_scoref,hi_scoretitle;
    Widget subtitle[MAXPLAYERS];
    char txt[512],wname[6];

    /* only create popup if not computer player */
    /* if (type[dnum]==0) */
    {

	hi_scoretop[dnum] = XtVaAppCreateShell("hiscoreshell",app_def_file,
					       applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
	hi_scoref = XtVaCreateManagedWidget("hiscoreform",formWidgetClass,
					    hi_scoretop[dnum],NULL);
	hi_scoretitle = XtVaCreateManagedWidget("hiscoretitle",labelWidgetClass,
						hi_scoref,NULL);
	loadscores();
	for (j=0; j<MAXPLAYERS; j++)
	{
	    showscores(j+1,txt);
	    sprintf(wname,"sub%d",j);
	    subtitle[j]=XtVaCreateManagedWidget(wname,labelWidgetClass,
						hi_scoref,NULL);
	    hi_score_ent[dnum][j]=XtVaCreateManagedWidget("hiscoreent",
							  labelWidgetClass,hi_scoref,XtNfromVert,subtitle[j],NULL);
	    XtVaSetValues(hi_score_ent[dnum][j], XtNlabel, txt, NULL);
	    if (j%2==1)
	    {
		XtVaSetValues(subtitle[j],XtNfromHoriz,hi_score_ent[dnum][j-1],NULL);
		XtVaSetValues(hi_score_ent[dnum][j],XtNfromHoriz,hi_score_ent[dnum][j-1],NULL);
	    }
	    if (j>1)
		XtVaSetValues(subtitle[j],XtNfromVert,hi_score_ent[dnum][j-2],
			      XtNvertDistance,10,NULL);
	    else
		XtVaSetValues(subtitle[j],XtNfromVert,hi_scoretitle,NULL);
	}
	hi_dismiss[dnum] = XtVaCreateManagedWidget("hidismiss",commandWidgetClass,
						   hi_scoref,NULL);
	bg_pixmap(hi_scoref);
	bg_pixmap(hi_scoretitle);
	XtRealizeWidget(hi_scoretop[dnum]);
	XtAddCallback(hi_dismiss[dnum],XtNcallback,HiScoresPopdown,hi_scoretop[dnum]);
    }
}

void HiScoresPopup(int dnum)
{
    int j;
    char txt[512];

    /* only if not computer */
    /* if (type[dnum]==0) */
    {
	if (menu_status[dnum][HISCORES]==False)
	    /* popup is already up */
	    XtUnmapWidget(hi_scoretop[dnum]);
	else
	{
	    loadscores();
	    for (j=0; j<MAXPLAYERS; j++)
	    {
		showscores(j+1,txt);
		XtVaSetValues(hi_score_ent[dnum][j], XtNlabel, txt, NULL);
	    }
	    XtMapWidget(hi_scoretop[dnum]);
	}
    }
}

/*******************
 * Best plays list *
 *******************/

void BestgoPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;bestgodismiss[dnum]!=w; dnum++)
		;
	XtUnmapWidget(bestgotop[dnum]);

	XtVaSetValues(menu_item[dnum][BESTGOES],XtNleftBitmap,None,NULL);
	menu_status[dnum][BESTGOES]= !menu_status[dnum][BESTGOES];
}


void CreateBestgoPopup(int dnum)
{
	char txt[1000];
	Widget bestgoform,bestgotitle;
	
	bestgotop[dnum] = XtVaAppCreateShell("bestgoshell",app_def_file,
		applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
	bestgoform = XtVaCreateManagedWidget("bestgoform",formWidgetClass,
		bestgotop[dnum],NULL);
	bestgotitle = XtVaCreateManagedWidget("bestgotitle",labelWidgetClass,
		bestgoform,XtNborderWidth,0,NULL);
	bestgomain[dnum] = XtVaCreateManagedWidget("bestgomain",labelWidgetClass,
		bestgoform,XtNfromVert,bestgotitle,NULL);
	
	showgoscores(txt);
	XtVaSetValues(bestgomain[dnum],XtNlabel,txt,NULL);
	bestgodismiss[dnum] = XtVaCreateManagedWidget("bestgodismiss",commandWidgetClass,
		bestgoform,XtNfromVert,bestgomain[dnum],NULL);
	bg_pixmap(bestgoform);
	bg_pixmap(bestgotitle);
	XtRealizeWidget(bestgotop[dnum]);
	XtAddCallback(bestgodismiss[dnum],XtNcallback,BestgoPopdown,bestgotop[dnum]);
}

void BestgoPopup(int dnum)
{
	if (menu_status[dnum][BESTGOES]==False)
		/* popup is already up */
		XtUnmapWidget(bestgotop[dnum]);
	else
	{
		char txt[1000];
		showgoscores(txt);
		XtVaSetValues(bestgomain[dnum],XtNlabel,txt,NULL);
		XtMapWidget(bestgotop[dnum]);
	}
}

void UpdateBestgo()
{
	int j;
	
	for (j=0; j<num_players; j++)
		if (menu_status[j][BESTGOES]==True)
		{
			/* popup is up - update entry */
			char txt[1000];
			showgoscores(txt);
/*printf("updating for player %d\n",j);*/
			XtVaSetValues(bestgomain[j],XtNlabel,txt,NULL);
		}	
}

/*********
 * About *
 *********/

void AboutPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
    	int dnum;
	
	for (dnum=0;aboutdismiss[dnum]!=w; dnum++)
		;
	XtUnmapWidget(abouttop[dnum]);

	XtVaSetValues(menu_item[dnum][ABOUT],XtNleftBitmap,None,NULL);
	menu_status[dnum][ABOUT]= !menu_status[dnum][ABOUT];
}

void CreateAboutPopup(int dnum)
{
	Widget aboutbox,abouttitle,abouttext;

	abouttop[dnum] = XtVaAppCreateShell("abouttop",app_def_file,
		applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,
					    False,NULL);

	aboutbox = XtVaCreateManagedWidget("aboutbox",formWidgetClass,
					   abouttop[dnum],NULL);
	abouttitle = XtVaCreateManagedWidget("abouttitle",
					     labelWidgetClass,aboutbox,
					     XtNborderWidth,0,
					     NULL);

	abouttext = XtVaCreateManagedWidget("abouttext",labelWidgetClass,
					    aboutbox,XtNfromVert,abouttitle,
					    NULL);

	aboutdismiss[dnum] = XtVaCreateManagedWidget("aboutdismiss",
				          commandWidgetClass,aboutbox,
					  XtNfromVert,abouttext,NULL);
	bg_pixmap(aboutbox);
	bg_pixmap(abouttitle);

	XtRealizeWidget(abouttop[dnum]);
	XtAddCallback(aboutdismiss[dnum],XtNcallback,AboutPopdown,
		      abouttop[dnum]);
}

void AboutPopup(int dnum)
{
	if (menu_status[dnum][ABOUT]==False)
		/* popup is already up */
		XtUnmapWidget(abouttop[dnum]);
	else
		XtMapWidget(abouttop[dnum]);
}


/***********
 * The Key *
 ***********/

void KeyPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;keydismiss[dnum]!=w; dnum++)
		;
	XtUnmapWidget(keytop[dnum]);

	XtVaSetValues(menu_item[dnum][KEY],XtNleftBitmap,None,NULL);
	menu_status[dnum][KEY]= !menu_status[dnum][KEY];
}

void CreateKeyPopup(int dnum)
{
	Widget keybox,keytitle,keysq[4],keylb[4];
	int i;
	char wname[6];

	keytop[dnum] = XtVaAppCreateShell("keytop",app_def_file,
		applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);

	keybox = XtVaCreateManagedWidget("keybox",formWidgetClass,keytop[dnum],NULL);
	keytitle = XtVaCreateManagedWidget("keytitle",labelWidgetClass,keybox,
		NULL);

	for (i=0; i<4; i++)
	{
		sprintf(wname,"ksq%d",i);
		keysq[i] = XtVaCreateManagedWidget(wname, labelWidgetClass, keybox,
			XtNlabel," ",SETBG(colours[i+1]),NULL);
		sprintf(wname,"klb%d",i);
		keylb[i] = XtVaCreateManagedWidget(wname, labelWidgetClass, keybox,
			XtNfromHoriz,keysq[i],NULL);
		if (i>0)
		{
			XtVaSetValues(keysq[i],XtNfromVert,keysq[i-1],NULL);
			XtVaSetValues(keylb[i],XtNfromVert,keylb[i-1],NULL);
		}
	}
	keydismiss[dnum] = XtVaCreateManagedWidget("keydismiss",commandWidgetClass,
		keybox,NULL);
	bg_pixmap(keybox);

	XtRealizeWidget(keytop[dnum]);
	XtAddCallback(keydismiss[dnum],XtNcallback,KeyPopdown,keytop[dnum]);
}

void KeyPopup(int dnum)
{
	if (menu_status[dnum][KEY]==False)
		/* popup is already up */
		XtUnmapWidget(keytop[dnum]);
	else
		XtMapWidget(keytop[dnum]);
}
