/*
 *  XScrabble - X version of the popular board game, for 1 to 4 players.
 *
 * This software comes with NO warranty whatsoever. I therefore take no
 * responsibility for any damages, losses or problems caused through use
 * or misuse of this program.
 *
 * I hereby grant permission for this program to be freely copied and
 * distributed by any means, provided no charge is made for it.
 *
 * Matthew Chapman, csuoq@csv.warwick.ac.uk
 *    Mov 1994.
 */

/* mess.c - multiperson message system */

#include "scrab.h"
#include "globals.h"

#include <X11/Xaw/Text.h>
#include <X11/Xaw/TextSrc.h>

extern char app_def_file[256];

Widget messmain[MAXPLAYERS],messentry[MAXPLAYERS],messf[MAXPLAYERS];
Widget messdismiss[MAXPLAYERS],ping[MAXPLAYERS];
XawTextPosition pos=0;

void KeyRedirect(Widget w, XEvent *event,String *params,Cardinal num_params)
{
	int dnum;
	
	for (dnum=0; dpy[dnum] != XtDisplay(w); dnum++)
		;
    event->xany.window = XtWindow(messentry[dnum]);
    XtDispatchEvent(event);
}

void AddChar(Widget w, char *c)
{
	XawTextBlock txt;
	txt.firstPos=0;
	txt.format=FMT8BIT;
	txt.length=strlen(c);
	txt.ptr=c;
	XawTextReplace(w, pos, pos, &txt);
	pos+=txt.length;
	XawTextSetInsertionPoint(w,pos);
}

void DoMessage(Widget w,XExposeEvent *event,String *params,Cardinal *num_params)
{
	String line;
	int dnum,i;
	
	for (dnum=0; dpy[dnum] != XtDisplay(w); dnum++)
		;

	/* send message to all human players */
	XtVaGetValues(w,XtNstring,&line,NULL);
	if (strlen(line)>0)
		for (i=0; i<num_players; i++)
		    if (type[i]==0)
		    {
			AddChar(messmain[i],player[dnum].name);
			AddChar(messmain[i],": ");
			AddChar(messmain[i],line);
			AddChar(messmain[i],"\n");
		}
	XtVaSetValues(w,XtNstring,"",NULL);
}

void MessPopdown(Widget w, XtPointer client_data, XtPointer call_data)
{
	int dnum;
	
	for (dnum=0;messdismiss[dnum]!=w; dnum++)
		;

	XtUnmapWidget(messtop[dnum]);

	XtVaSetValues(menu_item[dnum][MESSAGE],XtNleftBitmap,None,NULL);
	menu_status[dnum][MESSAGE]= !menu_status[dnum][MESSAGE];
}

void Ping(Widget w, XtPointer client_data, XtPointer call_data)
{
	char mess[512];
	int dnum;
	
	for (dnum=0; ping[dnum]!=w; dnum++)
		;
			
	sprintf(mess,PROMPT[MESS_PING],player[dnum].name);
	MessageAll(mess);
}

void CreateMess(int dnum)
{
	static XtActionsRec actions[] = {
		{"DoMessage", (XtActionProc) DoMessage},
		{"KeyRedirect", (XtActionProc) KeyRedirect}
	};

	String trans1 = "#override\n\
		<Key>: KeyRedirect()";
	String trans2 = "#override\n\
		<Key>Return: DoMessage()\n\
		Ctrl<Key>R:  no-op()\n\
		Ctrl<Key>S:  no-op()\n\
		Meta<Key>I:  no-op()\n\
		<Key>Tab:    no-op()";

	messtop[dnum] = XtVaAppCreateShell("messtop",app_def_file,
		applicationShellWidgetClass,dpy[dnum],XtNmappedWhenManaged,False,NULL);
	messf[dnum] = XtVaCreateManagedWidget("messf",formWidgetClass,messtop[dnum],NULL);
	messdismiss[dnum] = XtVaCreateManagedWidget("messdimiss",
		commandWidgetClass,messf[dnum],XtNlabel,PROMPT[DISMISS],NULL);
	ping[dnum] = XtVaCreateManagedWidget("ping",
		commandWidgetClass,messf[dnum],XtNlabel,PROMPT[PING_ALL],XtNfromHoriz,
		messdismiss[dnum],NULL);
	messmain[dnum] = XtVaCreateManagedWidget("messmain",asciiTextWidgetClass,
		messf[dnum],XtNheight,200,XtNwidth,400,XtNstring,"",
		XtNtranslations,XtParseTranslationTable(trans1),
		XtNeditType,"edit",XtNscrollVertical,XawtextScrollWhenNeeded,
		XtNwrap,XawtextWrapWord,XtNfromVert,messdismiss[dnum],NULL);
	messentry[dnum] = XtVaCreateManagedWidget("messmain",asciiTextWidgetClass,messf[dnum],
		XtNfromVert,messmain[dnum],XtNwidth,400,XtNeditType,"edit",
		XtNtranslations,XtParseTranslationTable(trans2),
		XtNwrap,XawtextWrapLine,NULL);

	bg_pixmap(messf[dnum]);
	XtAppAddActions(app_context,actions,XtNumber(actions));
	XtRealizeWidget(messtop[dnum]);
	XtAddCallback(messdismiss[dnum],XtNcallback,MessPopdown,messtop[dnum]);
	XtAddCallback(ping[dnum],XtNcallback,Ping,messtop[dnum]);
}

void MessPopup(int dnum)
{
	if (menu_status[dnum][MESSAGE]==False)
		/* popup is already up */
		XtUnmapWidget(messtop[dnum]);
	else
		XtMapWidget(messtop[dnum]);
}
