#!/bin/perl -w
#$Id: postconf.pl,v 1.11 2001/04/29 03:05:24 rocky Exp $
# Copyright (C) 1998-2001 Rocky Bernstein
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Use perl 4 conventions: chop vs chomp, system(ln) vs symlink.
# Todo: Should use config.guess? 
print "Checking operating system and version...\n";
#$TARGET=`./config.guess`;
$os=`uname -s`; chop $os;
if ($os !~ /^AIX|^Linux|^SunOS|^NetBSD|^OpenBSD|^BSD/) {
    die "Sorry -- we only do AIX, Linux, Solaris, NetBSD, OpenBSD or BSDI right now.";
} 
$release=`uname -r`; chop $release;
if ($os =~ /SunOS/) {
  if ($release !~ /^5.[56]/) {
    if ($release !~ /^5.6/) {
      print "SPARC releases 2.5.1 and 2.6, 2.8 have been tested.\n";
      print "SPARC 2.7 and 2.6 x68 have been alleged to work\n";
      print "Good luck!\n";
    }
  }
} elsif ($os =~ /Linux/) {
  if ($release !~ /^2.0|2.2/) {
    print "Only releases 2.0 & 2.2 have been tested. Trying anyway.\n";
  }
} elsif ($os =~ /^BSD/) {
  $os="BSDI";	
  if ($release !~ /^2.1|^3.0/) {
    print "Only releases 2.1 and 3.0 have been tested. Trying anyway.\n";
  }
} 

print "Configuring for $os...\n";
# Okay, now just shut up and set it up.
foreach $file ("os.h", "xps.c", "sigmap.h", 
	       "loadavg.c", "loadavg.h")  {
    unlink "$file" if -f  $file;
    print "Linking $file...\n";
    #symlink "$os/$file", $file;      # If Perl 5 
    system("ln -s $os/$file $file");  # IW
}

# Remind users to look at platform-specific information; some folks
# will, no doubt, not pick up this information reading README or
# INSTALL.xps, if they in fact they even look at these. 

$install_hints = "$os/install-hints.txt";
if (-f $install_hints) {
    print "***** Please also read $install_hints... *****\n";
}
