/* $Id: icmp_timestamp.c,v 1.5 2001/07/21 18:55:39 fygrave Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "xprobe.h"


rpack_t *send_icmpts_req(struct sockaddr_in to) {

    int sndsock, rcvsock;
    int res;
    struct protoent *pe;
    struct sockaddr_in from;
    struct ip *ip, *rcv_ip;
    struct icmp *icmp, *rcv_icmp;
    unsigned char *pack, *recv_pack;
    int on = 1;
    int packlen;
    rpack_t *retval = NULL;

    if ((sndsock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0) { 
        perror("Can not open raw socket:");
        exit(1);
    }
    
    if ((pe = getprotobyname("icmp")) == NULL) {
        fprintf(stderr, "icmp: unknown protocol");
        exit(1);
    }
    
    if ((rcvsock = socket(AF_INET, SOCK_RAW, pe->p_proto)) < 0) {
        perror("icmp socket");
        exit(1);
    }
 
    if (setsockopt(sndsock, IPPROTO_IP, IP_HDRINCL, (char *)&on,
                   sizeof(on)) < 0) {
        perror("IP_HDRINCL");
        exit(1);
    }

    packlen = sizeof(struct ip) + sizeof(struct icmp) + DATA_SIZE;


    if((pack = (unsigned char *)calloc( packlen, 1)) == NULL) {
        perror("calloc");
        exit(1);
    }

    ip = (struct ip *)pack;
    icmp = (struct icmp *)(pack + sizeof(struct ip));
    make_ippkt(ip, IPPROTO_ICMP, interf.addr, to.sin_addr,
                packlen, 0, 0);
    
    icmp->icmp_type = ICMP_TSTAMP;
    icmp->icmp_code = 123;
    icmp->icmp_seq = rand();
    icmp->icmp_id = rand();
    icmp->icmp_cksum = in_cksum((unsigned short *)icmp,
                                DATA_SIZE + sizeof(struct icmp));
    if (icmp->icmp_cksum == 0)
        icmp->icmp_cksum = 0xffff;
    
    fprintf(stderr,"TEST: ICMP time stamp request to %s ",
                                            inet_ntoa(to.sin_addr));
    
   res = sendto(sndsock, (void *)pack, packlen,
                0, (struct sockaddr *)&to, sizeof(struct sockaddr));

   if (res <0) {
       perror("sendto:");
       close(sndsock);
       close(rcvsock);
       free(pack);
       return NULL;
   }
   fprintf(stderr,"[%d bytes] sent, waiting for reponse.\n", res);

   recv_pack=calloc(PACKBUF_SIZ+1, 1);
   res = wait_icmp(rcvsock, &from, recv_pack, PACKBUF_SIZ);
   
   if (res == 0 || res < 0 ) {
       if (res < 0) 
           perror("Receive error:");
       else    
           fprintf(stderr, "Receive timeout. Quitting..\n");

       close(sndsock);
       close(rcvsock);
       free(pack);
       free(recv_pack);
       return NULL;
   }

#ifdef DEBUG   
   fprintf(stderr,"Received %d bytes packet.\n", res);
#endif   
 
   rcv_ip = (struct ip *)recv_pack;
 /* sanity checks */

#ifdef DEBUG
    fprintf(stderr, "hlen: %d\nlen: %d\n", rcv_ip->ip_hl<<2, rcv_ip->ip_len);
#endif    
    
   if (res < sizeof(struct ip)      ||
       (rcv_ip->ip_hl << 2) > res ||
#ifdef __linux__
       ntohs(rcv_ip->ip_len)
#else       
       (rcv_ip->ip_len)
#endif       
       > res          ) {
       fprintf(stderr,"Received maliformed packet!\n");
       close(sndsock);
       close(rcvsock);
       free(pack);
       free(recv_pack);
       return NULL;
   }

   rcv_icmp = (struct icmp *)(recv_pack + (rcv_ip->ip_hl<<2));

#ifdef DEBUG
   fprintf(stderr,"type: %d code: %d\n", rcv_icmp->icmp_type, rcv_icmp->icmp_code);
#endif   

  if ((retval=calloc(sizeof(rpack_t), 1)) == NULL) {
       perror("calloc");
       exit(1);
   }

   retval->packsize = res;
   retval->pkt = recv_pack;
   retval->ip = rcv_ip;
   retval->icmp = rcv_icmp;
   retval->orig_pkt = NULL;
   
   close(sndsock);
   close(rcvsock);
   free(pack);
   return retval;

}


