/*
 * Copyright (c) 2001-2007 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/profile_xif.hh,v 1.6 2007/02/16 22:47:42 pavlin Exp $
 */

#ifndef __XRL_INTERFACES_PROFILE_XIF_HH__
#define __XRL_INTERFACES_PROFILE_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifProfile"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlProfileV0p1Client {
public:
    XrlProfileV0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlProfileV0p1Client() {}

    typedef XorpCallback1<void, const XrlError&>::RefPtr EnableCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable profiling
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param pname profile variable
     */
    bool send_enable(
	const char*	dst_xrl_target_name,
	const string&	pname,
	const EnableCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DisableCB;
    /**
     *  Send Xrl intended to:
     *
     *  Disable profiling
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param pname profile variable
     */
    bool send_disable(
	const char*	dst_xrl_target_name,
	const string&	pname,
	const DisableCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr GetEntriesCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get log entries.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param pname profile variable
     *
     *  @param instance_name to send the profiling info to.
     */
    bool send_get_entries(
	const char*	dst_xrl_target_name,
	const string&	pname,
	const string&	instance_name,
	const GetEntriesCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ClearCB;
    /**
     *  Send Xrl intended to:
     *
     *  Clear the profiling entries
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param pname profile variable
     */
    bool send_clear(
	const char*	dst_xrl_target_name,
	const string&	pname,
	const ClearCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const string*>::RefPtr ListCB;
    /**
     *  Send Xrl intended to:
     *
     *  List all the profiling variables registered with this target.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_list(
	const char*	dst_xrl_target_name,
	const ListCB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_enable(
	const XrlError&	e,
	XrlArgs*	a,
	EnableCB		cb
    );

    void unmarshall_disable(
	const XrlError&	e,
	XrlArgs*	a,
	DisableCB		cb
    );

    void unmarshall_get_entries(
	const XrlError&	e,
	XrlArgs*	a,
	GetEntriesCB		cb
    );

    void unmarshall_clear(
	const XrlError&	e,
	XrlArgs*	a,
	ClearCB		cb
    );

    void unmarshall_list(
	const XrlError&	e,
	XrlArgs*	a,
	ListCB		cb
    );

};

#endif /* __XRL_INTERFACES_PROFILE_XIF_HH__ */
