/*
 * Copyright (c) 2001-2006 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/rip_base.cc,v 1.26 2006/07/19 00:43:40 pavlin Exp $"


#include "rip_base.hh"


XrlRipTargetBase::XrlRipTargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlRipTargetBase::~XrlRipTargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlRipTargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlRipTargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_finder_event_observer_0_1_xrl_target_birth(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_birth");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_birth(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_birth", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_finder_event_observer_0_1_xrl_target_death(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_death");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_death(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_death", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_policy_backend_0_1_configure(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/configure");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_configure(
	    xa_inputs.get_uint32("filter"),
	    xa_inputs.get_string("conf"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/configure", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_policy_backend_0_1_reset(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/reset");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_reset(
	    xa_inputs.get_uint32("filter"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/reset", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_policy_backend_0_1_push_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/push_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_push_routes();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/push_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_policy_redist4_0_1_add_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "policy_redist4/0.1/add_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_redist4_0_1_add_route4(
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv4("nexthop"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_list("policytags"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_redist4/0.1/add_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_policy_redist4_0_1_delete_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "policy_redist4/0.1/delete_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_redist4_0_1_delete_route4(
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_redist4/0.1/delete_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_redist4_0_1_add_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 8) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(8), XORP_UINT_CAST(xa_inputs.size()), "redist4/0.1/add_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist4_0_1_add_route(
	    xa_inputs.get_ipv4net("dst"),
	    xa_inputs.get_ipv4("nexthop"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_uint32("admin_distance"),
	    xa_inputs.get_string("cookie"),
	    xa_inputs.get_string("protocol_origin"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist4/0.1/add_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_redist4_0_1_delete_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 8) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(8), XORP_UINT_CAST(xa_inputs.size()), "redist4/0.1/delete_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist4_0_1_delete_route(
	    xa_inputs.get_ipv4net("dst"),
	    xa_inputs.get_ipv4("nexthop"),
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_uint32("admin_distance"),
	    xa_inputs.get_string("cookie"),
	    xa_inputs.get_string("protocol_origin"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist4/0.1/delete_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_redist4_0_1_starting_route_dump(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "redist4/0.1/starting_route_dump");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist4_0_1_starting_route_dump(
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist4/0.1/starting_route_dump", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_redist4_0_1_finishing_route_dump(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "redist4/0.1/finishing_route_dump");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = redist4_0_1_finishing_route_dump(
	    xa_inputs.get_string("cookie"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "redist4/0.1/finishing_route_dump", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_add_rip_address(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/add_rip_address");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_add_rip_address(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/add_rip_address", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_remove_rip_address(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/remove_rip_address");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_remove_rip_address(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/remove_rip_address", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_rip_address_enabled(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_rip_address_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_rip_address_enabled(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_bool("enabled"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_rip_address_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_rip_address_enabled(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/rip_address_enabled");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool enabled;
    try {
	XrlCmdError e = rip_0_1_rip_address_enabled(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    enabled);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/rip_address_enabled", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("enabled", enabled);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_cost(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_cost");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_cost(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("cost"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_cost", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_cost(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/cost");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t cost;
    try {
	XrlCmdError e = rip_0_1_cost(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    cost);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/cost", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("cost", cost);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_horizon(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_horizon");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_horizon(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_string("horizon"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_horizon", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_horizon(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/horizon");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string horizon;
    try {
	XrlCmdError e = rip_0_1_horizon(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    horizon);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/horizon", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("horizon", horizon);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_passive(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_passive");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_passive(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_bool("passive"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_passive", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_passive(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/passive");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool passive;
    try {
	XrlCmdError e = rip_0_1_passive(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    passive);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/passive", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("passive", passive);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_accept_non_rip_requests(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_accept_non_rip_requests");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_accept_non_rip_requests(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_bool("accept"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_accept_non_rip_requests", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_accept_non_rip_requests(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/accept_non_rip_requests");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool accept;
    try {
	XrlCmdError e = rip_0_1_accept_non_rip_requests(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    accept);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/accept_non_rip_requests", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("accept", accept);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_accept_default_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_accept_default_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_accept_default_route(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_bool("accept"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_accept_default_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_accept_default_route(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/accept_default_route");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool accept;
    try {
	XrlCmdError e = rip_0_1_accept_default_route(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    accept);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/accept_default_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("accept", accept);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_advertise_default_route(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_advertise_default_route");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_advertise_default_route(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_bool("advertise"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_advertise_default_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_advertise_default_route(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/advertise_default_route");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool advertise;
    try {
	XrlCmdError e = rip_0_1_advertise_default_route(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    advertise);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/advertise_default_route", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("advertise", advertise);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_route_timeout(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_route_timeout");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_route_timeout(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("t_secs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_route_timeout", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_route_timeout(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/route_timeout");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t t_secs;
    try {
	XrlCmdError e = rip_0_1_route_timeout(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    t_secs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/route_timeout", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("t_secs", t_secs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_deletion_delay(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_deletion_delay");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_deletion_delay(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("t_secs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_deletion_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_deletion_delay(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/deletion_delay");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t t_secs;
    try {
	XrlCmdError e = rip_0_1_deletion_delay(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    t_secs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/deletion_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("t_secs", t_secs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_request_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_request_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_request_interval(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("t_secs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_request_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_request_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/request_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t t_secs;
    try {
	XrlCmdError e = rip_0_1_request_interval(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    t_secs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/request_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("t_secs", t_secs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_update_interval(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_update_interval");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_update_interval(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("t_secs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_update_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_update_interval(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/update_interval");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t t_secs;
    try {
	XrlCmdError e = rip_0_1_update_interval(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    t_secs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/update_interval", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("t_secs", t_secs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_update_jitter(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_update_jitter");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_update_jitter(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("t_jitter"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_update_jitter", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_update_jitter(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/update_jitter");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t t_jitter;
    try {
	XrlCmdError e = rip_0_1_update_jitter(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    t_jitter);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/update_jitter", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("t_jitter", t_jitter);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_triggered_update_delay(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_triggered_update_delay");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_triggered_update_delay(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("t_secs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_triggered_update_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_triggered_update_delay(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/triggered_update_delay");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t t_secs;
    try {
	XrlCmdError e = rip_0_1_triggered_update_delay(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    t_secs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/triggered_update_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("t_secs", t_secs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_triggered_update_jitter(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_triggered_update_jitter");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_triggered_update_jitter(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("t_jitter"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_triggered_update_jitter", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_triggered_update_jitter(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/triggered_update_jitter");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t t_jitter;
    try {
	XrlCmdError e = rip_0_1_triggered_update_jitter(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    t_jitter);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/triggered_update_jitter", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("t_jitter", t_jitter);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_interpacket_delay(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_interpacket_delay");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_interpacket_delay(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("t_msecs"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_interpacket_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_interpacket_delay(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/interpacket_delay");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t t_msecs;
    try {
	XrlCmdError e = rip_0_1_interpacket_delay(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    t_msecs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/interpacket_delay", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("t_msecs", t_msecs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_simple_authentication_key(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_simple_authentication_key");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_simple_authentication_key(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_string("password"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_simple_authentication_key", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_delete_simple_authentication_key(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/delete_simple_authentication_key");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_delete_simple_authentication_key(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/delete_simple_authentication_key", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_set_md5_authentication_key(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/set_md5_authentication_key");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_set_md5_authentication_key(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("key_id"),
	    xa_inputs.get_string("password"),
	    xa_inputs.get_string("start_time"),
	    xa_inputs.get_string("end_time"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/set_md5_authentication_key", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_delete_md5_authentication_key(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/delete_md5_authentication_key");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_delete_md5_authentication_key(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("key_id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/delete_md5_authentication_key", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_rip_address_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/rip_address_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string status;
    try {
	XrlCmdError e = rip_0_1_rip_address_status(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    status);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/rip_address_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_get_all_addresses(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/get_all_addresses");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList ifnames;
    XrlAtomList vifnames;
    XrlAtomList addrs;
    try {
	XrlCmdError e = rip_0_1_get_all_addresses(
	    ifnames,
	    vifnames,
	    addrs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/get_all_addresses", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("ifnames", ifnames);
	pxa_outputs->add("vifnames", vifnames);
	pxa_outputs->add("addrs", addrs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_get_counters(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/get_counters");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList counter_descriptions;
    XrlAtomList counter_values;
    try {
	XrlCmdError e = rip_0_1_get_counters(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    counter_descriptions,
	    counter_values);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/get_counters", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("counter_descriptions", counter_descriptions);
	pxa_outputs->add("counter_values", counter_values);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_get_peers(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/get_peers");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList peers;
    try {
	XrlCmdError e = rip_0_1_get_peers(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    peers);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/get_peers", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("peers", peers);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_get_all_peers(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/get_all_peers");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList peers;
    XrlAtomList ifnames;
    XrlAtomList vifnames;
    XrlAtomList addrs;
    try {
	XrlCmdError e = rip_0_1_get_all_peers(
	    peers,
	    ifnames,
	    vifnames,
	    addrs);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/get_all_peers", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("peers", peers);
	pxa_outputs->add("ifnames", ifnames);
	pxa_outputs->add("vifnames", vifnames);
	pxa_outputs->add("addrs", addrs);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_get_peer_counters(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/get_peer_counters");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    XrlAtomList counter_descriptions;
    XrlAtomList counter_values;
    uint32_t peer_last_active;
    try {
	XrlCmdError e = rip_0_1_get_peer_counters(
	    xa_inputs.get_string("ifname"),
	    xa_inputs.get_string("vifname"),
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_ipv4("peer"),
	    counter_descriptions,
	    counter_values,
	    peer_last_active);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/get_peer_counters", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("counter_descriptions", counter_descriptions);
	pxa_outputs->add("counter_values", counter_values);
	pxa_outputs->add("peer_last_active", peer_last_active);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_redist_protocol_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/redist_protocol_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_redist_protocol_routes(
	    xa_inputs.get_string("protocol_name"),
	    xa_inputs.get_uint32("cost"),
	    xa_inputs.get_uint32("tag"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/redist_protocol_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_rip_0_1_no_redist_protocol_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "rip/0.1/no_redist_protocol_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rip_0_1_no_redist_protocol_routes(
	    xa_inputs.get_string("protocol_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rip/0.1/no_redist_protocol_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_socket4_user_0_1_recv_event(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "socket4_user/0.1/recv_event");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_user_0_1_recv_event(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv4("src_host"),
	    xa_inputs.get_uint32("src_port"),
	    xa_inputs.get_binary("data"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4_user/0.1/recv_event", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_socket4_user_0_1_connect_event(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "socket4_user/0.1/connect_event");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool accept;
    try {
	XrlCmdError e = socket4_user_0_1_connect_event(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_ipv4("src_host"),
	    xa_inputs.get_uint32("src_port"),
	    xa_inputs.get_string("new_sockid"),
	    accept);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4_user/0.1/connect_event", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("accept", accept);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_socket4_user_0_1_error_event(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "socket4_user/0.1/error_event");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_user_0_1_error_event(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_string("error"),
	    xa_inputs.get_bool("fatal"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4_user/0.1/error_event", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlRipTargetBase::handle_socket4_user_0_1_close_event(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "socket4_user/0.1/close_event");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = socket4_user_0_1_close_event(
	    xa_inputs.get_string("sockid"),
	    xa_inputs.get_string("reason"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "socket4_user/0.1/close_event", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::XrlAtomNotFound& e) {
	XLOG_ERROR("Argument not found");
	return XrlCmdError::BAD_ARGS();
    }
    return XrlCmdError::OKAY();
}

void
XrlRipTargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlRipTargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlRipTargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlRipTargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlRipTargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_birth",
	    callback(this, &XrlRipTargetBase::handle_finder_event_observer_0_1_xrl_target_birth)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "finder_event_observer/0.1/xrl_target_birth");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_death",
	    callback(this, &XrlRipTargetBase::handle_finder_event_observer_0_1_xrl_target_death)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "finder_event_observer/0.1/xrl_target_death");
	}
	if (_cmds->add_handler("policy_backend/0.1/configure",
	    callback(this, &XrlRipTargetBase::handle_policy_backend_0_1_configure)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "policy_backend/0.1/configure");
	}
	if (_cmds->add_handler("policy_backend/0.1/reset",
	    callback(this, &XrlRipTargetBase::handle_policy_backend_0_1_reset)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "policy_backend/0.1/reset");
	}
	if (_cmds->add_handler("policy_backend/0.1/push_routes",
	    callback(this, &XrlRipTargetBase::handle_policy_backend_0_1_push_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "policy_backend/0.1/push_routes");
	}
	if (_cmds->add_handler("policy_redist4/0.1/add_route4",
	    callback(this, &XrlRipTargetBase::handle_policy_redist4_0_1_add_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "policy_redist4/0.1/add_route4");
	}
	if (_cmds->add_handler("policy_redist4/0.1/delete_route4",
	    callback(this, &XrlRipTargetBase::handle_policy_redist4_0_1_delete_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "policy_redist4/0.1/delete_route4");
	}
	if (_cmds->add_handler("redist4/0.1/add_route",
	    callback(this, &XrlRipTargetBase::handle_redist4_0_1_add_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "redist4/0.1/add_route");
	}
	if (_cmds->add_handler("redist4/0.1/delete_route",
	    callback(this, &XrlRipTargetBase::handle_redist4_0_1_delete_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "redist4/0.1/delete_route");
	}
	if (_cmds->add_handler("redist4/0.1/starting_route_dump",
	    callback(this, &XrlRipTargetBase::handle_redist4_0_1_starting_route_dump)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "redist4/0.1/starting_route_dump");
	}
	if (_cmds->add_handler("redist4/0.1/finishing_route_dump",
	    callback(this, &XrlRipTargetBase::handle_redist4_0_1_finishing_route_dump)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "redist4/0.1/finishing_route_dump");
	}
	if (_cmds->add_handler("rip/0.1/add_rip_address",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_add_rip_address)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/add_rip_address");
	}
	if (_cmds->add_handler("rip/0.1/remove_rip_address",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_remove_rip_address)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/remove_rip_address");
	}
	if (_cmds->add_handler("rip/0.1/set_rip_address_enabled",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_rip_address_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_rip_address_enabled");
	}
	if (_cmds->add_handler("rip/0.1/rip_address_enabled",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_rip_address_enabled)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/rip_address_enabled");
	}
	if (_cmds->add_handler("rip/0.1/set_cost",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_cost)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_cost");
	}
	if (_cmds->add_handler("rip/0.1/cost",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_cost)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/cost");
	}
	if (_cmds->add_handler("rip/0.1/set_horizon",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_horizon)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_horizon");
	}
	if (_cmds->add_handler("rip/0.1/horizon",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_horizon)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/horizon");
	}
	if (_cmds->add_handler("rip/0.1/set_passive",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_passive)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_passive");
	}
	if (_cmds->add_handler("rip/0.1/passive",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_passive)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/passive");
	}
	if (_cmds->add_handler("rip/0.1/set_accept_non_rip_requests",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_accept_non_rip_requests)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_accept_non_rip_requests");
	}
	if (_cmds->add_handler("rip/0.1/accept_non_rip_requests",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_accept_non_rip_requests)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/accept_non_rip_requests");
	}
	if (_cmds->add_handler("rip/0.1/set_accept_default_route",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_accept_default_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_accept_default_route");
	}
	if (_cmds->add_handler("rip/0.1/accept_default_route",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_accept_default_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/accept_default_route");
	}
	if (_cmds->add_handler("rip/0.1/set_advertise_default_route",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_advertise_default_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_advertise_default_route");
	}
	if (_cmds->add_handler("rip/0.1/advertise_default_route",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_advertise_default_route)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/advertise_default_route");
	}
	if (_cmds->add_handler("rip/0.1/set_route_timeout",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_route_timeout)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_route_timeout");
	}
	if (_cmds->add_handler("rip/0.1/route_timeout",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_route_timeout)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/route_timeout");
	}
	if (_cmds->add_handler("rip/0.1/set_deletion_delay",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_deletion_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_deletion_delay");
	}
	if (_cmds->add_handler("rip/0.1/deletion_delay",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_deletion_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/deletion_delay");
	}
	if (_cmds->add_handler("rip/0.1/set_request_interval",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_request_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_request_interval");
	}
	if (_cmds->add_handler("rip/0.1/request_interval",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_request_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/request_interval");
	}
	if (_cmds->add_handler("rip/0.1/set_update_interval",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_update_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_update_interval");
	}
	if (_cmds->add_handler("rip/0.1/update_interval",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_update_interval)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/update_interval");
	}
	if (_cmds->add_handler("rip/0.1/set_update_jitter",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_update_jitter)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_update_jitter");
	}
	if (_cmds->add_handler("rip/0.1/update_jitter",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_update_jitter)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/update_jitter");
	}
	if (_cmds->add_handler("rip/0.1/set_triggered_update_delay",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_triggered_update_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_triggered_update_delay");
	}
	if (_cmds->add_handler("rip/0.1/triggered_update_delay",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_triggered_update_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/triggered_update_delay");
	}
	if (_cmds->add_handler("rip/0.1/set_triggered_update_jitter",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_triggered_update_jitter)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_triggered_update_jitter");
	}
	if (_cmds->add_handler("rip/0.1/triggered_update_jitter",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_triggered_update_jitter)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/triggered_update_jitter");
	}
	if (_cmds->add_handler("rip/0.1/set_interpacket_delay",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_interpacket_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_interpacket_delay");
	}
	if (_cmds->add_handler("rip/0.1/interpacket_delay",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_interpacket_delay)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/interpacket_delay");
	}
	if (_cmds->add_handler("rip/0.1/set_simple_authentication_key",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_simple_authentication_key)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_simple_authentication_key");
	}
	if (_cmds->add_handler("rip/0.1/delete_simple_authentication_key",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_delete_simple_authentication_key)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/delete_simple_authentication_key");
	}
	if (_cmds->add_handler("rip/0.1/set_md5_authentication_key",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_set_md5_authentication_key)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/set_md5_authentication_key");
	}
	if (_cmds->add_handler("rip/0.1/delete_md5_authentication_key",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_delete_md5_authentication_key)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/delete_md5_authentication_key");
	}
	if (_cmds->add_handler("rip/0.1/rip_address_status",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_rip_address_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/rip_address_status");
	}
	if (_cmds->add_handler("rip/0.1/get_all_addresses",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_get_all_addresses)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/get_all_addresses");
	}
	if (_cmds->add_handler("rip/0.1/get_counters",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_get_counters)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/get_counters");
	}
	if (_cmds->add_handler("rip/0.1/get_peers",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_get_peers)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/get_peers");
	}
	if (_cmds->add_handler("rip/0.1/get_all_peers",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_get_all_peers)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/get_all_peers");
	}
	if (_cmds->add_handler("rip/0.1/get_peer_counters",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_get_peer_counters)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/get_peer_counters");
	}
	if (_cmds->add_handler("rip/0.1/redist_protocol_routes",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_redist_protocol_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/redist_protocol_routes");
	}
	if (_cmds->add_handler("rip/0.1/no_redist_protocol_routes",
	    callback(this, &XrlRipTargetBase::handle_rip_0_1_no_redist_protocol_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "rip/0.1/no_redist_protocol_routes");
	}
	if (_cmds->add_handler("socket4_user/0.1/recv_event",
	    callback(this, &XrlRipTargetBase::handle_socket4_user_0_1_recv_event)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "socket4_user/0.1/recv_event");
	}
	if (_cmds->add_handler("socket4_user/0.1/connect_event",
	    callback(this, &XrlRipTargetBase::handle_socket4_user_0_1_connect_event)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "socket4_user/0.1/connect_event");
	}
	if (_cmds->add_handler("socket4_user/0.1/error_event",
	    callback(this, &XrlRipTargetBase::handle_socket4_user_0_1_error_event)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "socket4_user/0.1/error_event");
	}
	if (_cmds->add_handler("socket4_user/0.1/close_event",
	    callback(this, &XrlRipTargetBase::handle_socket4_user_0_1_close_event)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "rip", "socket4_user/0.1/close_event");
	}
	_cmds->finalize();
}

void
XrlRipTargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_birth");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_death");
	_cmds->remove_handler("policy_backend/0.1/configure");
	_cmds->remove_handler("policy_backend/0.1/reset");
	_cmds->remove_handler("policy_backend/0.1/push_routes");
	_cmds->remove_handler("policy_redist4/0.1/add_route4");
	_cmds->remove_handler("policy_redist4/0.1/delete_route4");
	_cmds->remove_handler("redist4/0.1/add_route");
	_cmds->remove_handler("redist4/0.1/delete_route");
	_cmds->remove_handler("redist4/0.1/starting_route_dump");
	_cmds->remove_handler("redist4/0.1/finishing_route_dump");
	_cmds->remove_handler("rip/0.1/add_rip_address");
	_cmds->remove_handler("rip/0.1/remove_rip_address");
	_cmds->remove_handler("rip/0.1/set_rip_address_enabled");
	_cmds->remove_handler("rip/0.1/rip_address_enabled");
	_cmds->remove_handler("rip/0.1/set_cost");
	_cmds->remove_handler("rip/0.1/cost");
	_cmds->remove_handler("rip/0.1/set_horizon");
	_cmds->remove_handler("rip/0.1/horizon");
	_cmds->remove_handler("rip/0.1/set_passive");
	_cmds->remove_handler("rip/0.1/passive");
	_cmds->remove_handler("rip/0.1/set_accept_non_rip_requests");
	_cmds->remove_handler("rip/0.1/accept_non_rip_requests");
	_cmds->remove_handler("rip/0.1/set_accept_default_route");
	_cmds->remove_handler("rip/0.1/accept_default_route");
	_cmds->remove_handler("rip/0.1/set_advertise_default_route");
	_cmds->remove_handler("rip/0.1/advertise_default_route");
	_cmds->remove_handler("rip/0.1/set_route_timeout");
	_cmds->remove_handler("rip/0.1/route_timeout");
	_cmds->remove_handler("rip/0.1/set_deletion_delay");
	_cmds->remove_handler("rip/0.1/deletion_delay");
	_cmds->remove_handler("rip/0.1/set_request_interval");
	_cmds->remove_handler("rip/0.1/request_interval");
	_cmds->remove_handler("rip/0.1/set_update_interval");
	_cmds->remove_handler("rip/0.1/update_interval");
	_cmds->remove_handler("rip/0.1/set_update_jitter");
	_cmds->remove_handler("rip/0.1/update_jitter");
	_cmds->remove_handler("rip/0.1/set_triggered_update_delay");
	_cmds->remove_handler("rip/0.1/triggered_update_delay");
	_cmds->remove_handler("rip/0.1/set_triggered_update_jitter");
	_cmds->remove_handler("rip/0.1/triggered_update_jitter");
	_cmds->remove_handler("rip/0.1/set_interpacket_delay");
	_cmds->remove_handler("rip/0.1/interpacket_delay");
	_cmds->remove_handler("rip/0.1/set_simple_authentication_key");
	_cmds->remove_handler("rip/0.1/delete_simple_authentication_key");
	_cmds->remove_handler("rip/0.1/set_md5_authentication_key");
	_cmds->remove_handler("rip/0.1/delete_md5_authentication_key");
	_cmds->remove_handler("rip/0.1/rip_address_status");
	_cmds->remove_handler("rip/0.1/get_all_addresses");
	_cmds->remove_handler("rip/0.1/get_counters");
	_cmds->remove_handler("rip/0.1/get_peers");
	_cmds->remove_handler("rip/0.1/get_all_peers");
	_cmds->remove_handler("rip/0.1/get_peer_counters");
	_cmds->remove_handler("rip/0.1/redist_protocol_routes");
	_cmds->remove_handler("rip/0.1/no_redist_protocol_routes");
	_cmds->remove_handler("socket4_user/0.1/recv_event");
	_cmds->remove_handler("socket4_user/0.1/connect_event");
	_cmds->remove_handler("socket4_user/0.1/error_event");
	_cmds->remove_handler("socket4_user/0.1/close_event");
}
