/*
 * Copyright (c) 2001-2005 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/policy_xif.hh,v 1.3 2005/03/25 02:54:52 pavlin Exp $
 */

#ifndef __XRL_INTERFACES_POLICY_XIF_HH__
#define __XRL_INTERFACES_POLICY_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifPolicy"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlPolicyV0p1Client {
public:
    XrlPolicyV0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlPolicyV0p1Client() {}

    typedef XorpCallback1<void, const XrlError&>::RefPtr CreateTermCB;
    /**
     *  Send Xrl intended to:
     *
     *  Create a term in a policy. The term will be the last term in the policy
     *  statement.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param policy the name of the policy.
     *
     *  @param term the name of the term.
     */
    bool send_create_term(
	const char*	target_name,
	const string&	policy,
	const string&	term,
	const CreateTermCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteTermCB;
    /**
     *  Send Xrl intended to:
     *
     *  Delete a term in a policy.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param policy the name of the policy.
     *
     *  @param term the name of the term.
     */
    bool send_delete_term(
	const char*	target_name,
	const string&	policy,
	const string&	term,
	const DeleteTermCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr UpdateTermSourceCB;
    /**
     *  Send Xrl intended to:
     *
     *  Update the source/dest/action block of a term in a policy.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param policy the name of the policy.
     *
     *  @param term the name of the term. source/dest/action the un-parsed user
     *  configuration of the block.
     */
    bool send_update_term_source(
	const char*	target_name,
	const string&	policy,
	const string&	term,
	const string&	source,
	const UpdateTermSourceCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr UpdateTermDestCB;

    bool send_update_term_dest(
	const char*	target_name,
	const string&	policy,
	const string&	term,
	const string&	dest,
	const UpdateTermDestCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr UpdateTermActionCB;

    bool send_update_term_action(
	const char*	target_name,
	const string&	policy,
	const string&	term,
	const string&	action,
	const UpdateTermActionCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr CreatePolicyCB;
    /**
     *  Send Xrl intended to:
     *
     *  Create a policy.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param policy name of the policy.
     */
    bool send_create_policy(
	const char*	target_name,
	const string&	policy,
	const CreatePolicyCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeletePolicyCB;
    /**
     *  Send Xrl intended to:
     *
     *  Delete a policy.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param policy name of the policy.
     */
    bool send_delete_policy(
	const char*	target_name,
	const string&	policy,
	const DeletePolicyCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr CreateSetCB;
    /**
     *  Send Xrl intended to:
     *
     *  Create a set.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param set name of the set.
     */
    bool send_create_set(
	const char*	target_name,
	const string&	set,
	const CreateSetCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr UpdateSetCB;
    /**
     *  Send Xrl intended to:
     *
     *  Replace elements in a set.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param set name of the set.
     *
     *  @param elements comma delimited list of set elements.
     */
    bool send_update_set(
	const char*	target_name,
	const string&	set,
	const string&	elements,
	const UpdateSetCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DeleteSetCB;
    /**
     *  Send Xrl intended to:
     *
     *  Delete a set.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param set name of the set.
     */
    bool send_delete_set(
	const char*	target_name,
	const string&	set,
	const DeleteSetCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr DoneGlobalPolicyConfCB;
    /**
     *  Send Xrl intended to:
     *
     *  Commit the configuration.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_done_global_policy_conf(
	const char*	target_name,
	const DoneGlobalPolicyConfCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ImportCB;
    /**
     *  Send Xrl intended to:
     *
     *  Replace import/export policies for a protocol. Will normally cause a
     *  delayed commit.
     *
     *  @param tgt_name Xrl Target name
     *
     *  @param protocol protocol for which policies must be replaced.
     *
     *  @param policies comma separated list of policies.
     */
    bool send_import(
	const char*	target_name,
	const string&	protocol,
	const string&	policies,
	const ImportCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ExportCB;

    bool send_export(
	const char*	target_name,
	const string&	protocol,
	const string&	policies,
	const ExportCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const string*>::RefPtr GetConfCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get current configuration of all policies.
     *
     *  @param tgt_name Xrl Target name
     */
    bool send_get_conf(
	const char*	target_name,
	const GetConfCB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_create_term(
	const XrlError&	e,
	XrlArgs*	a,
	CreateTermCB		cb
    );

    void unmarshall_delete_term(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteTermCB		cb
    );

    void unmarshall_update_term_source(
	const XrlError&	e,
	XrlArgs*	a,
	UpdateTermSourceCB		cb
    );

    void unmarshall_update_term_dest(
	const XrlError&	e,
	XrlArgs*	a,
	UpdateTermDestCB		cb
    );

    void unmarshall_update_term_action(
	const XrlError&	e,
	XrlArgs*	a,
	UpdateTermActionCB		cb
    );

    void unmarshall_create_policy(
	const XrlError&	e,
	XrlArgs*	a,
	CreatePolicyCB		cb
    );

    void unmarshall_delete_policy(
	const XrlError&	e,
	XrlArgs*	a,
	DeletePolicyCB		cb
    );

    void unmarshall_create_set(
	const XrlError&	e,
	XrlArgs*	a,
	CreateSetCB		cb
    );

    void unmarshall_update_set(
	const XrlError&	e,
	XrlArgs*	a,
	UpdateSetCB		cb
    );

    void unmarshall_delete_set(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteSetCB		cb
    );

    void unmarshall_done_global_policy_conf(
	const XrlError&	e,
	XrlArgs*	a,
	DoneGlobalPolicyConfCB		cb
    );

    void unmarshall_import(
	const XrlError&	e,
	XrlArgs*	a,
	ImportCB		cb
    );

    void unmarshall_export(
	const XrlError&	e,
	XrlArgs*	a,
	ExportCB		cb
    );

    void unmarshall_get_conf(
	const XrlError&	e,
	XrlArgs*	a,
	GetConfCB		cb
    );

};

#endif /* __XRL_INTERFACES_POLICY_XIF_HH__ */
